/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;
import org.tigr.util.FloatMatrix;

public class LocusInfoDialog
extends JDialog {
    private LinearExpressionMapViewer lem;
    private ParameterPanel graphPanel;
    private InfoPanel infoPanel;
    private IData data;
    private Experiment experiment;
    private FloatMatrix meanMatrix;
    private Experiment fullExperiment;
    private FloatMatrix fullMatrix;
    private int locusIndex;
    private GraphViewer graph;
    private int[] replicates;
    private String locusName;
    private int numLoci;
    private int numSamples;
    private boolean isSelected;
    private JButton nextButton;
    private JButton prevButton;
    private JButton selectLocusButton;
    private String SELECT_LOCUS_BUTTON_TEXT = "Select";
    private String DESELECT_LOCUS_BUTTON_TEXT = "Deselect";
    private Icon selectIcon;
    private Icon deleteIcon;
    private Thread locusRunnerThread;
    private LocusRunner locusRunner;

    public LocusInfoDialog(JFrame parent, LinearExpressionMapViewer lem, String locusName, int locusIndex, Experiment experiment, Experiment fullExperiment, IData data, int[] replicates) {
        super((Frame)parent, "Locus Information: " + locusName);
        this.lem = lem;
        this.locusName = locusName;
        this.experiment = experiment;
        this.fullExperiment = fullExperiment;
        this.fullMatrix = fullExperiment.getMatrix();
        this.locusIndex = locusIndex;
        this.replicates = replicates;
        this.isSelected = lem.isLocusSelected(locusIndex);
        this.selectIcon = null;
        this.deleteIcon = null;
        this.meanMatrix = experiment.getMatrix();
        this.fullMatrix = fullExperiment.getMatrix();
        this.numLoci = this.meanMatrix.getRowDimension();
        this.data = data;
        this.numSamples = experiment.getNumberOfSamples();
        this.getContentPane().setLayout(new GridBagLayout());
        this.graph = this.createGraph();
        this.graphPanel = new ParameterPanel("Expression Graph");
        this.graphPanel.setLayout(new GridBagLayout());
        this.graphPanel.add((Component)this.graph, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.infoPanel = new InfoPanel();
        Listener listener = new Listener();
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.prevButton = new JButton("<<  Previous");
        this.prevButton.setFocusPainted(false);
        this.prevButton.setPreferredSize(new Dimension(120, 30));
        this.prevButton.setSize(120, 30);
        this.prevButton.setActionCommand("prev-locus-command");
        this.prevButton.addActionListener(listener);
        this.nextButton = new JButton("Next  >>");
        this.nextButton.setFocusPainted(false);
        this.nextButton.setPreferredSize(new Dimension(120, 30));
        this.nextButton.setSize(120, 30);
        this.nextButton.setActionCommand("next-locus-command");
        this.nextButton.addActionListener(listener);
        String buttonText = "Select";
        this.selectLocusButton = new JButton(buttonText, this.selectIcon);
        if (this.isSelected) {
            this.selectLocusButton.setText("Deselect");
            this.selectLocusButton.setIcon(this.deleteIcon);
        }
        this.selectLocusButton.setFocusPainted(false);
        this.selectLocusButton.setPreferredSize(new Dimension(120, 30));
        this.selectLocusButton.setSize(120, 30);
        this.selectLocusButton.setActionCommand("toggle-locus-selection-command");
        this.selectLocusButton.addActionListener(listener);
        this.selectLocusButton.setFocusPainted(false);
        JButton openCMRButton = new JButton("Gene Page");
        openCMRButton.setPreferredSize(new Dimension(120, 30));
        openCMRButton.setSize(120, 30);
        openCMRButton.setFocusPainted(false);
        openCMRButton.setActionCommand("open-web-command");
        openCMRButton.addActionListener(listener);
        this.validateButtons();
        buttonPanel.add((Component)this.prevButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 5, 3, 0), 0, 0));
        buttonPanel.add((Component)openCMRButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(3, 10, 3, 10), 0, 0));
        buttonPanel.add((Component)this.selectLocusButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(3, 0, 3, 10), 0, 0));
        buttonPanel.add((Component)this.nextButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(3, 0, 3, 5), 0, 0));
        this.getContentPane().add((Component)this.graphPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    private GraphViewer createGraph() {
        int i;
        String[] names = new String[this.numSamples];
        for (int i2 = 0; i2 < this.numSamples; ++i2) {
            names[i2] = this.data.getSampleName(i2);
        }
        float[] meanValues = this.meanMatrix.A[this.locusIndex];
        float[][] values = new float[this.replicates.length][];
        for (int i3 = 0; i3 < values.length; ++i3) {
            values[i3] = this.fullMatrix.A[this.replicates[i3]];
        }
        float[] maxAndMin = this.getMaxAndMin(meanValues, values);
        int upperY = (int)Math.ceil(maxAndMin[0] + 0.001f);
        int lowerY = (int)Math.floor(maxAndMin[1] - 0.001f);
        GraphViewer graph = new GraphViewer(null, 0, 425, 0, 300, 0.0, (double)this.numSamples, (double)lowerY, (double)upperY, 40, 40, 40, 40, "Expression of Locus: " + this.locusName, "Sample Number", "Log\u2082(Cy5 / Cy3)");
        graph.setXAxisValue((double)lowerY);
        graph.setShowCoordinates(true);
        Dimension size = new Dimension(250, 250);
        graph.setPreferredSize(size);
        graph.setSize(size);
        GraphTick tick = new GraphTick(0.0, 8, Color.black, 0, 0, "", Color.black);
        graph.addGraphElement((GraphElement)tick);
        graph.addGraphElement((GraphElement)new GraphLine(0.0, 0.0, (double)this.numSamples, 0.0, Color.black));
        for (i = 0; i < meanValues.length - 1; ++i) {
            tick = new GraphTick((double)(i + 1), 8, Color.black, 0, 0, String.valueOf(i + 1), Color.black);
            graph.addGraphElement((GraphElement)tick);
            if (!Float.isNaN(meanValues[i]) && !Float.isNaN(meanValues[i + 1])) {
                graph.addGraphElement((GraphElement)new GraphLine((double)(i + 1), (double)meanValues[i], (double)(i + 2), (double)meanValues[i + 1], Color.magenta));
            }
            if (Float.isNaN(meanValues[i])) continue;
            graph.addGraphElement((GraphElement)new GraphPoint((double)(i + 1), (double)meanValues[i], Color.blue, 5));
        }
        tick = new GraphTick((double)meanValues.length, 8, Color.black, 0, 0, String.valueOf(meanValues.length), Color.black);
        graph.addGraphElement((GraphElement)tick);
        if (!Float.isNaN(meanValues[meanValues.length - 1])) {
            graph.addGraphElement((GraphElement)new GraphPoint((double)meanValues.length, (double)meanValues[meanValues.length - 1], Color.blue, 5));
        }
        for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (Float.isNaN(values[i][j])) continue;
                graph.addGraphElement((GraphElement)new GraphPoint((double)(j + 1), (double)values[i][j], Color.blue, 2));
            }
        }
        for (i = lowerY; i <= upperY; ++i) {
            tick = i == 0 ? new GraphTick((double)i, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick((double)i, 8, Color.black, 1, 0, "" + i, Color.black);
            graph.addGraphElement((GraphElement)tick);
        }
        return graph;
    }

    public void showInfo() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
    }

    private float[] getMaxAndMin(float[] means, float[][] vals) {
        float[] maxAndMin = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        for (int i = 0; i < means.length; ++i) {
            if (!Float.isNaN(means[i]) && means[i] > maxAndMin[0]) {
                maxAndMin[0] = means[i];
            }
            if (!Float.isNaN(means[i]) && means[i] < maxAndMin[1]) {
                maxAndMin[1] = means[i];
            }
            for (int j = 0; j < vals.length; ++j) {
                if (!Float.isNaN(vals[j][i]) && vals[j][i] > maxAndMin[0]) {
                    maxAndMin[0] = vals[j][i];
                }
                if (Float.isNaN(vals[j][i]) || !(vals[j][i] < maxAndMin[1])) continue;
                maxAndMin[1] = vals[j][i];
            }
        }
        if (maxAndMin[0] == Float.NEGATIVE_INFINITY) {
            maxAndMin[0] = 0.0f;
        }
        if (maxAndMin[1] == Float.POSITIVE_INFINITY) {
            maxAndMin[1] = 0.0f;
        }
        return maxAndMin;
    }

    private void validateButtons() {
        this.prevButton.setEnabled(this.locusIndex != 0);
        this.nextButton.setEnabled(this.locusIndex != this.numLoci - 1);
        this.updateSelectionButton();
    }

    public void checkSelection() {
        this.isSelected = this.lem.isLocusSelected(this.locusIndex);
        this.updateSelectionButton();
    }

    public void updateSelectionButton() {
        if (!this.isSelected) {
            this.selectLocusButton.setText(this.SELECT_LOCUS_BUTTON_TEXT);
            this.selectLocusButton.setIcon(this.selectIcon);
        } else {
            this.selectLocusButton.setText(this.DESELECT_LOCUS_BUTTON_TEXT);
            this.selectLocusButton.setIcon(this.deleteIcon);
        }
    }

    private void updateGraphPanel() {
        GraphViewer graphViewer = this.createGraph();
        this.graphPanel.removeAll();
        this.graphPanel.add((Component)graphViewer, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.graphPanel.validate();
        this.graph = graphViewer;
    }

    private void getNextLocusInfo() {
        ++this.locusIndex;
        this.locusName = this.lem.getLocusName(this.locusIndex);
        this.setTitle("Locus Information: " + this.locusName);
        this.replicates = this.lem.getReplicatesArray(this.locusIndex);
        this.isSelected = this.lem.isLocusSelected(this.locusIndex);
        this.updateGraphPanel();
        this.infoPanel.updateContent();
        this.validateButtons();
    }

    private void getPreviousLocusInfo() {
        --this.locusIndex;
        this.locusName = this.lem.getLocusName(this.locusIndex);
        this.setTitle("Locus Information: " + this.locusName);
        this.replicates = this.lem.getReplicatesArray(this.locusIndex);
        this.isSelected = this.lem.isLocusSelected(this.locusIndex);
        this.updateGraphPanel();
        this.infoPanel.updateContent();
        this.validateButtons();
    }

    private void linkToURL() {
        this.lem.linkToURL(this.locusIndex);
    }

    public class Listener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("next-locus-command")) {
                LocusInfoDialog.this.getNextLocusInfo();
            } else if (command.equals("prev-locus-command")) {
                LocusInfoDialog.this.getPreviousLocusInfo();
            } else if (command.equals("toggle-locus-selection-command")) {
                LocusInfoDialog.this.lem.toggleSelectedLocus(LocusInfoDialog.this.locusIndex);
                LocusInfoDialog.this.isSelected = !LocusInfoDialog.this.isSelected;
            } else if (command.equals("open-web-command")) {
                LocusInfoDialog.this.linkToURL();
            }
        }

        @Override
        public void windowClosing(WindowEvent we) {
            LocusInfoDialog.this.lem.removeInfoViewer(LocusInfoDialog.this);
        }
    }

    public class LocusRunner
    implements Runnable {
        private boolean advance;
        private long napTime = 3000L;

        public LocusRunner(boolean advance, long napTime) {
            this.advance = advance;
            this.napTime = napTime;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.napTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.advance) {
                    LocusInfoDialog.this.getNextLocusInfo();
                    continue;
                }
                LocusInfoDialog.this.getPreviousLocusInfo();
            }
        }
    }

    public class InfoPanel
    extends JPanel {
        private JTextPane textPane;
        private JScrollPane pane;

        public InfoPanel() {
            this.setLayout(new GridBagLayout());
            String text = this.createContent();
            this.textPane = new JTextPane();
            this.textPane.setContentType("text/html");
            this.textPane.setEditable(false);
            this.textPane.setText(text);
            this.textPane.setFont(new Font("Arial", 0, 10));
            this.textPane.setMargin(new Insets(10, 15, 10, 15));
            this.textPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
            this.pane = new JScrollPane(this.textPane);
            this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setPreferredSize(new Dimension(250, 300));
            this.textPane.setCaretPosition(0);
        }

        public void updateContent() {
            String newText = this.createContent();
            this.textPane.setText(newText);
            this.textPane.setCaretPosition(0);
            this.pane.validate();
        }

        private String createContent() {
            int i;
            int i2;
            String[] fieldNames = LocusInfoDialog.this.data.getFieldNames();
            int numSamples = LocusInfoDialog.this.meanMatrix.getColumnDimension();
            int rowCount = fieldNames.length + 2;
            float[] sd = new float[numSamples];
            int[] validN = new int[numSamples];
            this.getSDs(sd, validN);
            String text = "<html><body face=arial bgcolor = \"#FFFFCC\"><h1>Locus: " + LocusInfoDialog.this.locusName + "</h1>";
            text = text + "<h2>Expression Data</h2>";
            text = text + "<table border=3>";
            text = text + "<tr><td nowrap><b>Sample Number</b></td>";
            for (int i3 = 0; i3 < numSamples; ++i3) {
                text = text + "<td nowrap><b>" + String.valueOf(i3 + 1) + "</b></td>";
            }
            text = text + "</tr>";
            Vector sampleFields = LocusInfoDialog.this.data.getSampleAnnotationFieldNames();
            String fieldName = (String)sampleFields.get(0);
            text = text + "<tr><td nowrap><b>Sample Name</b></td>";
            for (i2 = 0; i2 < numSamples; ++i2) {
                text = text + "<td nowrap><b>" + LocusInfoDialog.this.data.getSampleAnnotation(i2, fieldName) + "</b></td>";
            }
            text = text + "</tr>";
            for (i2 = 1; i2 < sampleFields.size(); ++i2) {
                fieldName = (String)sampleFields.get(i2);
                text = text + "<tr><td nowrap><b>" + fieldName + "</b></td>";
                for (int j = 0; j < numSamples; ++j) {
                    text = text + "<td nowrap>" + LocusInfoDialog.this.data.getSampleAnnotation(j, fieldName) + "</td>";
                }
                text = text + "</tr>";
            }
            text = text + "<tr><td nowrap><b>Locus Reps/Slide</b></td>";
            for (i2 = 0; i2 < numSamples; ++i2) {
                text = text + "<td nowrap>" + String.valueOf(LocusInfoDialog.this.replicates.length) + "</td>";
            }
            text = text + "</tr><tr><td nowrap><b>Rep. Values/Slide</b></td>";
            for (i2 = 0; i2 < numSamples; ++i2) {
                text = text + "<td nowrap>" + String.valueOf(validN[i2]) + "</td>";
            }
            text = text + "</tr><tr><td nowrap><b>Mean</b></td>";
            for (i = 0; i < numSamples; ++i) {
                float value = ((LocusInfoDialog)LocusInfoDialog.this).meanMatrix.A[LocusInfoDialog.this.locusIndex][i];
                text = !Float.isNaN(value) ? text + "<td nowrap>" + value + "</td>" : text + "<td nowrap> -- </td>";
            }
            text = text + "</tr><tr><td nowrap><b>SD</b></td>";
            for (i = 0; i < numSamples; ++i) {
                float value = sd[i];
                text = Float.isNaN(value) || validN[i] == 1 ? text + "<td nowrap> -- </td>" : text + "<td nowrap>" + value + "</td>";
            }
            text = text + "</tr></table>";
            text = text + "<h2>Annotation</h2>";
            text = text + "<table border = 3>";
            if (LocusInfoDialog.this.replicates.length > 1) {
                text = text + "<th></th><th colspan=" + String.valueOf(LocusInfoDialog.this.replicates.length + 1) + "><b>Locus Replicates<b></th>";
            }
            for (int row = 0; row < fieldNames.length + 1; ++row) {
                text = text + "<tr>";
                text = row == 0 ? text + "<td nowrap><b>UID</b></td>" : text + "<td nowrap><b>" + fieldNames[row - 1] + "</b></td>";
                for (int rep = 0; rep < LocusInfoDialog.this.replicates.length; ++rep) {
                    text = row == 0 ? text + "<td nowrap>" + LocusInfoDialog.this.data.getSlideDataElement(0, LocusInfoDialog.this.fullExperiment.getGeneIndexMappedToData(LocusInfoDialog.this.replicates[rep])).getUID() + "</td>" : text + "<td>" + LocusInfoDialog.this.data.getElementAttribute(LocusInfoDialog.this.fullExperiment.getGeneIndexMappedToData(LocusInfoDialog.this.replicates[rep]), row - 1) + "</td>";
                }
                text = text + "</tr>";
            }
            text = text + "</table>";
            text = text + "</body></html>";
            return text;
        }

        private void getSDs(float[] sd, int[] validNArray) {
            int numSamples = LocusInfoDialog.this.meanMatrix.getColumnDimension();
            float[] means = ((LocusInfoDialog)LocusInfoDialog.this).meanMatrix.A[LocusInfoDialog.this.locusIndex];
            for (int sample = 0; sample < numSamples; ++sample) {
                int validN = 0;
                for (int rep = 0; rep < LocusInfoDialog.this.replicates.length; ++rep) {
                    float value = LocusInfoDialog.this.fullMatrix.get(LocusInfoDialog.this.replicates[rep], sample);
                    if (Float.isNaN(value)) continue;
                    int n = sample;
                    sd[n] = (float)((double)sd[n] + Math.pow(value - means[sample], 2.0));
                    ++validN;
                }
                validNArray[sample] = validN;
                sd[sample] = validN == 0 ? Float.NaN : (validN == 1 ? 0.0f : (float)Math.sqrt(sd[sample] / (float)(validN - 1)));
            }
        }
    }
}

