/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMColorRangeSelector;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMHeader;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMRangeSelectionDialog;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMSelectionEditor;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMThumbNail;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMViewerAttributeDialog;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LocusInfoDialog;
import org.tigr.util.FloatMatrix;

public class LinearExpressionMapViewer
extends JPanel
implements IViewer {
    private Experiment experiment;
    private Experiment fullExperiment;
    private String[] sortedLocusIDs;
    private int[] start;
    private int[] end;
    private int[][] replicates;
    private boolean[] isForward;
    private int[] strata;
    private String locusIDFieldName;
    private int maxStrata;
    private LEMHeader header;
    private int numberOfSamples;
    private int locusCount;
    private int bpPerPixel = 50;
    private IFramework framework;
    private IData data;
    private boolean fixedLengthArrows = true;
    private boolean showOpenAreas = false;
    private int[] x = new int[8];
    private int[] y = new int[8];
    private int minArrowLength = 15;
    private int maxArrowLength = 100;
    private int currArrowLength = 25;
    private int minArrowHead = 10;
    private int arrowWidth = 10;
    private int currArrowHead;
    private int currArrowShank;
    private int wingWidth = 5;
    private int maxIntergenicLength = 100;
    private int columnSpacing = 40;
    private int maxPixelCoord = 0;
    private int[] coordStarts;
    private int[] coordEnds;
    private int[] annYPos;
    private int currX;
    private int currY;
    private int X_ORIGIN = 20;
    private int Y_ORIGIN = 7;
    private int DEFAULT_COLUMN_SPACING = 30;
    private int DEFAULT_STRATA_SPACING = 20;
    private int INTERGENIC_ESTIMATE = 5;
    private int CONTIG_ARROW_Y_SPACING = 2;
    private int NONCONTIG_ARROW_Y_SPACING = 10;
    private int COORD_LEFT_MARGIN = 25;
    private int COORD_SEPARATOR_MARGIN = 10;
    private int LEFT_LOCUS_MARGIN = 20;
    private int RIGHT_LOCUS_MARGIN = 30;
    private int RIGHT_MARGIN = 10;
    private int fullAnnotationWidth;
    private int locusMaxWidth;
    private int startMaxWidth;
    private int endMaxWidth;
    private int annotationWidth;
    private int viewerWidth;
    private int fieldIndex = 0;
    private int colorMode;
    public static final int COLOR_MODE_GRADIENT = 0;
    public static final int COLOR_MODE_2_BIN = 1;
    public static final int COLOR_MODE_4_BIN = 2;
    private BufferedImage posColorImage;
    private BufferedImage negColorImage;
    private boolean useDoubleGradient = true;
    private float minValue = -3.0f;
    private float maxValue = 3.0f;
    private float midValue = 0.0f;
    private Color lowestColor = new Color(10, 159, 1);
    private Color lowerColor = new Color(187, 240, 181);
    private Color midPointColor = Color.white;
    private Color higherColor = new Color(243, 169, 160);
    private Color highestColor = Color.red;
    private Color missingColor = new Color(128, 128, 128);
    private float cutoff1 = -3.0f;
    private float cutoff2 = -1.0f;
    private float midBinValue = 0.0f;
    private float cutoff3 = 1.0f;
    private float cutoff4 = 3.0f;
    private boolean highlighted = false;
    private int highlightStart;
    private int highlightEnd;
    private int highlightedIndex;
    private int[][] boundingRanges;
    private int boundryCount = 20;
    private int clipY1;
    private int clipY2;
    private Vector activeInfoDialogs;
    private LEMThumbNail thumbnail;
    private Vector selectedIndicesVector;
    private LEMSelectionEditor selectionEditor;
    private boolean[] selected;
    private JPopupMenu menu;
    private boolean showAllReplicates = false;
    private int maxNumReps;
    private int maxEndBaseLocation;
    private int replicateSpacing = 22;
    private float replicateLengthFraction = 0.6f;
    private int exptID;

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{new Integer(this.exptID), this.fullExperiment.getMatrix(), this.experiment.getMatrix(), this.fullExperiment.getColumns(), this.fullExperiment.getRows(), this.experiment.getColumns(), this.experiment.getRows(), this.sortedLocusIDs, this.start, this.end, this.replicates, this.isForward, this.strata, new String(""), this.locusIDFieldName});
    }

    public LinearExpressionMapViewer(Integer exptID, FloatMatrix fullExptFloatMatrix, FloatMatrix redExptFloatMatrix, int[] fullCols, int[] fullRows, int[] redCols, int[] redRows, String[] sortedLocusIDs, int[] sortedStartArray, int[] sortedEndArray, int[][] replicates, boolean[] isForward, int[] strata, String chrID, String locusIDFieldName) {
        this(new Experiment(fullCols, fullRows, exptID.intValue(), fullExptFloatMatrix), new Experiment(redCols, redRows, 0, redExptFloatMatrix), sortedLocusIDs, sortedStartArray, sortedEndArray, replicates, isForward, strata, chrID, locusIDFieldName);
    }

    public LinearExpressionMapViewer(Experiment fullExperiment, Experiment reducedExperiment, String[] sortedLocusIDs, int[] sortedStartArray, int[] sortedEndArray, int[][] replicates, boolean[] isForward, int[] strata, String chrID, String locusIDFieldName) {
        int i;
        this.fullExperiment = fullExperiment;
        this.experiment = reducedExperiment;
        this.numberOfSamples = this.experiment.getNumberOfSamples();
        this.sortedLocusIDs = sortedLocusIDs;
        this.start = sortedStartArray;
        this.end = sortedEndArray;
        this.replicates = replicates;
        this.isForward = isForward;
        this.strata = strata;
        this.locusIDFieldName = locusIDFieldName;
        this.locusCount = sortedLocusIDs.length;
        this.boundryCount = this.locusCount / 50;
        this.activeInfoDialogs = new Vector();
        this.selectedIndicesVector = new Vector();
        this.selected = new boolean[this.locusCount];
        this.maxNumReps = 0;
        for (i = 0; i < replicates.length; ++i) {
            this.maxNumReps = Math.max(this.maxNumReps, replicates[i].length);
        }
        if (sortedEndArray[sortedEndArray.length - 1] / this.bpPerPixel > 10000) {
            this.bpPerPixel = sortedEndArray[sortedEndArray.length - 1] / 10000;
        } else if (sortedEndArray[sortedEndArray.length - 1] / this.bpPerPixel < 500) {
            this.bpPerPixel = sortedEndArray[sortedEndArray.length - 1] / 500;
        }
        if (this.bpPerPixel == 0) {
            this.bpPerPixel = 1;
        }
        this.coordStarts = new int[this.start.length];
        this.coordEnds = new int[this.end.length];
        this.annYPos = new int[sortedLocusIDs.length];
        this.boundingRanges = new int[this.boundryCount][4];
        this.updateCoords();
        this.maxStrata = 0;
        this.maxEndBaseLocation = 0;
        for (i = 0; i < strata.length; ++i) {
            if (strata[i] > this.maxStrata) {
                this.maxStrata = strata[i];
            }
            if (this.maxEndBaseLocation >= this.end[this.end.length - i - 1]) continue;
            this.maxEndBaseLocation = this.end[this.end.length - i - 1];
        }
        this.updateColumnSpacing();
        this.setBackground(Color.white);
        this.negColorImage = this.createGradient(this.lowestColor, this.midPointColor);
        this.posColorImage = this.createGradient(this.midPointColor, this.highestColor);
        this.updateLocusAnnotationWidth();
        this.colorMode = 0;
        this.header = new LEMHeader(this.experiment);
        this.header.setLeftInset(this.X_ORIGIN);
        this.header.setArrowWingWidth(this.wingWidth);
        this.header.setArrowWidth(this.arrowWidth);
        LEMListener listener = new LEMListener();
        this.createPopupMenu(listener);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public LinearExpressionMapViewer(Integer exptID, Integer numberOfSamples, String[] sortedLocusIDs, int[] sortedStartArray, int[] sortedEndArray, int[][] replicates, boolean[] isForward, int[] strata, String chrID, String locusIDFieldName) {
        int i;
        this.exptID = exptID;
        this.numberOfSamples = numberOfSamples;
        this.sortedLocusIDs = sortedLocusIDs;
        this.start = sortedStartArray;
        this.end = sortedEndArray;
        this.replicates = replicates;
        this.isForward = isForward;
        this.strata = strata;
        this.locusIDFieldName = locusIDFieldName;
        this.locusCount = sortedLocusIDs.length;
        this.boundryCount = this.locusCount / 50;
        this.activeInfoDialogs = new Vector();
        this.selectedIndicesVector = new Vector();
        this.selected = new boolean[this.locusCount];
        this.maxNumReps = 0;
        for (i = 0; i < replicates.length; ++i) {
            this.maxNumReps = Math.max(this.maxNumReps, replicates[i].length);
        }
        if (sortedEndArray[sortedEndArray.length - 1] / this.bpPerPixel > 10000) {
            this.bpPerPixel = sortedEndArray[sortedEndArray.length - 1] / 10000;
        } else if (sortedEndArray[sortedEndArray.length - 1] / this.bpPerPixel < 500) {
            this.bpPerPixel = sortedEndArray[sortedEndArray.length - 1] / 500;
        }
        if (this.bpPerPixel == 0) {
            this.bpPerPixel = 1;
        }
        this.coordStarts = new int[this.start.length];
        this.coordEnds = new int[this.end.length];
        this.annYPos = new int[sortedLocusIDs.length];
        this.boundingRanges = new int[this.boundryCount][4];
        this.updateCoords();
        this.maxStrata = 0;
        this.maxEndBaseLocation = 0;
        for (i = 0; i < strata.length; ++i) {
            if (strata[i] > this.maxStrata) {
                this.maxStrata = strata[i];
            }
            if (this.maxEndBaseLocation >= this.end[this.end.length - i - 1]) continue;
            this.maxEndBaseLocation = this.end[this.end.length - i - 1];
        }
        this.updateColumnSpacing();
        this.setBackground(Color.white);
        this.negColorImage = this.createGradient(this.lowestColor, this.midPointColor);
        this.posColorImage = this.createGradient(this.midPointColor, this.highestColor);
        this.updateLocusAnnotationWidth();
        this.colorMode = 0;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(Experiment e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Font font = g.getFont();
        Font boldFont = new Font(font.getFontName(), 1, font.getSize());
        FontMetrics fm = g.getFontMetrics();
        Graphics2D g2 = (Graphics2D)g;
        Container obj = this.getParent();
        Rectangle visRect = ((JViewport)obj).getViewRect();
        if (visRect != null) {
            this.clipY1 = visRect.y;
            this.clipY2 = this.clipY1 + visRect.height;
        } else {
            visRect = g.getClipBounds();
            if (visRect != null) {
                this.clipY1 = visRect.y;
                this.clipY2 = this.clipY1 + visRect.height;
            } else {
                this.clipY1 = 0;
                this.clipY2 = this.getHeight();
            }
        }
        int[] bounds = this.getBoundingIndices(visRect.y, visRect.y + visRect.height);
        g.setColor(Color.blue);
        if (!this.showAllReplicates) {
            this.currX = this.X_ORIGIN + this.arrowWidth / 2 + this.wingWidth;
            this.currY = this.Y_ORIGIN;
            if (this.highlighted) {
                Composite composite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                if (this.fixedLengthArrows) {
                    g2.fillRect(0, this.highlightStart, visRect.width, this.highlightEnd - this.highlightStart);
                } else {
                    g2.setColor(Color.blue);
                    g2.fillRect(0, this.highlightStart, this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2 + this.COORD_LEFT_MARGIN / 2, this.highlightEnd - this.highlightStart);
                    g2.setColor(Color.black);
                    g2.fillRect(this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2 + this.COORD_LEFT_MARGIN / 2, this.annYPos[this.highlightedIndex] - fm.getHeight(), this.viewerWidth - this.columnSpacing * this.numberOfSamples, 20);
                }
                g2.setComposite(composite);
            }
            for (int j = 0; j < this.numberOfSamples; ++j) {
                if (visRect.y < 10) {
                    g2.fillRoundRect(this.currX - 5, 0, 10, 5, 3, 3);
                }
                g.drawLine(this.currX, visRect.y, this.currX, visRect.y + visRect.height);
                this.currX += this.columnSpacing;
            }
            for (int i = bounds[0]; i <= bounds[1]; ++i) {
                if (this.selected[i]) {
                    Color color = g.getColor();
                    g.setColor(Color.red);
                    g.fillRoundRect(4, this.coordStarts[i] + 2, 8, this.coordEnds[i] - this.coordStarts[i] - 4, 2, 1);
                    g.setColor(Color.black);
                    g.drawRoundRect(4, this.coordStarts[i] + 2, 8, this.coordEnds[i] - this.coordStarts[i] - 4, 2, 2);
                    g.setColor(color);
                }
                this.currX = this.X_ORIGIN + this.arrowWidth / 2 + this.wingWidth;
                if (!this.fixedLengthArrows) {
                    this.currX += this.strata[i] * this.DEFAULT_STRATA_SPACING;
                }
                for (int j = 0; j < this.numberOfSamples; ++j) {
                    this.renderArrow(g2, this.experiment.get(i, j), this.currX, this.coordStarts[i], this.coordEnds[i], this.isForward[i], this.highlighted && i == this.highlightedIndex);
                    this.currX += this.columnSpacing;
                }
                if (!this.fixedLengthArrows) {
                    this.currX += (this.maxStrata - this.strata[i]) * this.DEFAULT_STRATA_SPACING;
                }
                if (!this.selected[i]) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.red);
                }
                this.renderAnnotation(g, i, this.currX, font, boldFont);
            }
            if (!this.fixedLengthArrows && this.highlighted) {
                this.blockSelectedTextArea(g2, this.currX, font);
                if (!this.selected[this.highlightedIndex]) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color.red);
                }
                this.renderAnnotation(g, this.highlightedIndex, this.currX, font, boldFont);
            }
        } else {
            int j;
            this.currX = this.X_ORIGIN + this.arrowWidth / 2 + this.wingWidth;
            this.currY = this.Y_ORIGIN;
            int repYIndent = (this.currArrowLength - (int)((float)this.currArrowLength * this.replicateLengthFraction)) / 2;
            Composite composite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Color color = g.getColor();
            g.setColor(Color.yellow);
            for (j = 0; j < this.numberOfSamples; ++j) {
                if (j % 2 == 0) {
                    g.fillRect(this.currX - this.wingWidth - this.arrowWidth / 2 - 5, visRect.y, this.columnSpacing, visRect.y + visRect.height);
                }
                this.currX += this.columnSpacing;
            }
            g.setColor(color);
            g2.setComposite(composite);
            this.currX = this.X_ORIGIN + this.arrowWidth / 2 + this.wingWidth;
            for (j = 0; j < this.numberOfSamples; ++j) {
                if (visRect.y < 10) {
                    g2.fillRoundRect(this.currX - 5, 0, 10, 5, 3, 3);
                }
                g.drawLine(this.currX, visRect.y, this.currX, visRect.y + visRect.height);
                this.currX += this.columnSpacing;
            }
            if (this.highlighted) {
                composite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                if (this.fixedLengthArrows) {
                    g2.fillRect(0, this.highlightStart, visRect.width, this.highlightEnd - this.highlightStart);
                } else {
                    g2.fillRect(0, this.highlightStart, this.columnSpacing * this.numberOfSamples, this.highlightEnd - this.highlightStart);
                    g2.fillRect(this.columnSpacing * this.numberOfSamples, this.annYPos[this.highlightedIndex] - fm.getHeight(), visRect.width - this.columnSpacing * this.numberOfSamples, fm.getHeight() + fm.getDescent());
                }
                g2.setComposite(composite);
            }
            for (int i = bounds[0]; i <= bounds[1]; ++i) {
                this.currX = this.X_ORIGIN + this.arrowWidth / 2 + this.wingWidth;
                for (int j2 = 0; j2 < this.numberOfSamples; ++j2) {
                    this.renderArrow(g2, this.experiment.get(i, j2), this.currX, this.coordStarts[i], this.coordEnds[i], this.isForward[i], false);
                    for (int k = 0; k < this.replicates[i].length; ++k) {
                        this.renderArrow(g2, this.fullExperiment.get(this.replicates[i][k], j2), this.currX + (k + 1) * this.replicateSpacing, this.coordStarts[i] + repYIndent, this.coordEnds[i] - repYIndent, this.isForward[i], false);
                    }
                    this.currX += this.columnSpacing;
                }
                this.currX += this.maxNumReps * this.replicateSpacing;
                g.setColor(Color.black);
                this.renderAnnotation(g, i, this.currX, font, boldFont);
                if (!this.selected[i]) continue;
                color = g.getColor();
                g.setColor(Color.red);
                g.fillRoundRect(4, this.coordStarts[i] + 2, 8, this.coordEnds[i] - this.coordStarts[i] - 4, 2, 1);
                g.setColor(Color.black);
                g.drawRoundRect(4, this.coordStarts[i] + 2, 8, this.coordEnds[i] - this.coordStarts[i] - 4, 2, 2);
                g.setColor(color);
            }
        }
    }

    private void renderAnnotation(Graphics g, int i, int currX, Font font, Font boldFont) {
        if (this.isForward[i]) {
            g.drawString(String.valueOf(this.start[i]), currX - this.columnSpacing + this.COORD_LEFT_MARGIN, this.annYPos[i]);
            g.drawString(String.valueOf(this.end[i]), currX - this.columnSpacing + this.COORD_LEFT_MARGIN + this.startMaxWidth + this.COORD_SEPARATOR_MARGIN, this.annYPos[i]);
        } else {
            g.drawString(String.valueOf(this.end[i]), currX - this.columnSpacing + this.COORD_LEFT_MARGIN, this.annYPos[i]);
            g.drawString(String.valueOf(this.start[i]), currX - this.columnSpacing + this.COORD_LEFT_MARGIN + this.startMaxWidth + this.COORD_SEPARATOR_MARGIN, this.annYPos[i]);
        }
        g.setFont(boldFont);
        g.drawString(this.sortedLocusIDs[i], currX - this.columnSpacing + this.COORD_LEFT_MARGIN + this.startMaxWidth + this.COORD_SEPARATOR_MARGIN + this.endMaxWidth + this.LEFT_LOCUS_MARGIN, this.annYPos[i]);
        g.setFont(font);
        g.drawString(this.data.getElementAttribute(this.fullExperiment.getGeneIndexMappedToData(this.replicates[i][0]), this.fieldIndex), currX - this.columnSpacing + this.COORD_LEFT_MARGIN + this.startMaxWidth + this.COORD_SEPARATOR_MARGIN + this.endMaxWidth + this.LEFT_LOCUS_MARGIN + this.locusMaxWidth + this.RIGHT_LOCUS_MARGIN, this.annYPos[i]);
    }

    private void blockSelectedTextArea(Graphics2D g2, int currX, Font font) {
        FontMetrics fm = g2.getFontMetrics();
        Color color = g2.getColor();
        g2.setColor(Color.white);
        g2.fillRect(this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2 + this.COORD_LEFT_MARGIN / 2, this.annYPos[this.highlightedIndex] - fm.getHeight(), this.viewerWidth - this.columnSpacing * this.numberOfSamples, 20);
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2.setColor(Color.black);
        g2.fillRect(this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2 + this.COORD_LEFT_MARGIN / 2, this.annYPos[this.highlightedIndex] - fm.getHeight(), this.viewerWidth - this.columnSpacing * this.numberOfSamples, 20);
        g2.setComposite(composite);
        g2.drawRect(this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2 + this.COORD_LEFT_MARGIN / 2, this.annYPos[this.highlightedIndex] - fm.getHeight(), this.viewerWidth - this.columnSpacing * this.numberOfSamples, 20);
        g2.setColor(color);
    }

    private void updateColumnSpacing() {
        this.columnSpacing = this.fixedLengthArrows && !this.showAllReplicates ? this.DEFAULT_COLUMN_SPACING : this.DEFAULT_STRATA_SPACING * this.maxStrata + this.DEFAULT_COLUMN_SPACING;
        if (this.showAllReplicates) {
            this.columnSpacing = this.DEFAULT_COLUMN_SPACING + this.maxNumReps * this.replicateSpacing;
        }
    }

    public void renderArrow(Graphics2D g, float value, int xCenter, int yStart, int yEnd, boolean forward, boolean highlighted) {
        Color startColor = g.getColor();
        this.currArrowHead = this.minArrowHead;
        this.currArrowShank = yEnd - yStart - this.currArrowHead;
        g.setColor(this.getColor(value));
        if (forward) {
            this.x[0] = xCenter;
            this.y[0] = yStart;
            this.x[1] = xCenter + this.arrowWidth / 2;
            this.y[1] = yStart;
            this.x[2] = xCenter + this.arrowWidth / 2;
            this.y[2] = yStart + this.currArrowShank;
            this.x[3] = xCenter + this.arrowWidth / 2 + this.wingWidth;
            this.y[3] = yStart + this.currArrowShank;
            this.x[4] = xCenter;
            this.y[4] = yStart + this.currArrowShank + this.currArrowHead;
            this.x[5] = xCenter - this.arrowWidth / 2 - this.wingWidth;
            this.y[5] = yStart + this.currArrowShank;
            this.x[6] = xCenter - this.arrowWidth / 2;
            this.y[6] = yStart + this.currArrowShank;
            this.x[7] = xCenter - this.arrowWidth / 2;
            this.y[7] = yStart;
        } else {
            this.x[0] = xCenter;
            this.y[0] = yEnd;
            this.x[1] = xCenter + this.arrowWidth / 2;
            this.y[1] = yEnd;
            this.x[2] = xCenter + this.arrowWidth / 2;
            this.y[2] = yEnd - this.currArrowShank;
            this.x[3] = xCenter + this.arrowWidth / 2 + this.wingWidth;
            this.y[3] = yEnd - this.currArrowShank;
            this.x[4] = xCenter;
            this.y[4] = yEnd - this.currArrowShank - this.currArrowHead;
            this.x[5] = xCenter - this.arrowWidth / 2 - this.wingWidth;
            this.y[5] = yEnd - this.currArrowShank;
            this.x[6] = xCenter - this.arrowWidth / 2;
            this.y[6] = yEnd - this.currArrowShank;
            this.x[7] = xCenter - this.arrowWidth / 2;
            this.y[7] = yEnd;
        }
        g.fillPolygon(this.x, this.y, 8);
        g.setColor(Color.BLACK);
        g.drawPolygon(this.x, this.y, 8);
        if (!this.fixedLengthArrows) {
            if (highlighted) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.white);
            }
            g.fillOval(xCenter - 1, (yStart + yEnd) / 2 - 1, 4, 4);
            g.setColor(Color.black);
            g.drawOval(xCenter - 2, (yStart + yEnd) / 2 - 2, 4, 4);
        }
        g.setColor(startColor);
    }

    private void updateCoords() {
        int currY = this.Y_ORIGIN;
        int fontAscent = 0;
        Graphics g = this.getGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            fontAscent = fm.getAscent();
        }
        this.maxPixelCoord = 0;
        if (this.fixedLengthArrows && !this.showOpenAreas) {
            for (int i = 0; i < this.coordStarts.length; ++i) {
                this.coordStarts[i] = currY;
                this.coordEnds[i] = currY + this.currArrowLength;
                currY = this.coordEnds[i] + this.CONTIG_ARROW_Y_SPACING;
                this.annYPos[i] = this.coordStarts[i] + (this.coordEnds[i] - this.coordStarts[i]) / 2 + fontAscent / 2;
                this.maxPixelCoord = Math.max(this.maxPixelCoord, this.coordEnds[i]);
            }
        } else if (this.fixedLengthArrows && this.showOpenAreas) {
            this.coordStarts[0] = currY;
            this.coordEnds[0] = currY + this.currArrowLength;
            this.annYPos[0] = this.coordStarts[0] + (this.coordEnds[0] - this.coordStarts[0]) / 2;
            currY = this.coordEnds[0];
            for (int i = 1; i < this.coordStarts.length; ++i) {
                if (this.start[i] - this.end[i - 1] > this.INTERGENIC_ESTIMATE) {
                    this.coordStarts[i] = currY + this.NONCONTIG_ARROW_Y_SPACING;
                    currY = this.coordStarts[i];
                } else {
                    this.coordStarts[i] = currY;
                }
                this.coordEnds[i] = currY + this.currArrowLength;
                currY = this.coordEnds[i] + this.CONTIG_ARROW_Y_SPACING;
                this.annYPos[i] = this.coordStarts[i] + (this.coordEnds[i] - this.coordStarts[i]) / 2 + fontAscent / 2;
                this.maxPixelCoord = Math.max(this.maxPixelCoord, this.coordEnds[i]);
            }
        } else if (!this.fixedLengthArrows && this.showOpenAreas) {
            int offSet = 0;
            for (int i = 0; i < this.coordStarts.length; ++i) {
                int intergenicLength;
                this.coordStarts[i] = offSet + this.start[i] / this.bpPerPixel + this.Y_ORIGIN;
                this.coordEnds[i] = offSet + this.end[i] / this.bpPerPixel + this.Y_ORIGIN;
                if (this.coordEnds[i] - this.coordStarts[i] < this.minArrowLength) {
                    int oldEnd = this.coordEnds[i];
                    this.coordEnds[i] = this.coordStarts[i] + this.minArrowLength;
                    offSet += this.minArrowLength - (oldEnd - this.coordStarts[i]);
                }
                if (i > 0 && (intergenicLength = this.coordStarts[i] - this.coordEnds[i - 1]) > this.maxIntergenicLength) {
                    int n = i;
                    this.coordStarts[n] = this.coordStarts[n] - (intergenicLength - this.maxIntergenicLength);
                    int n2 = i;
                    this.coordEnds[n2] = this.coordEnds[n2] - (intergenicLength - this.maxIntergenicLength);
                    offSet -= intergenicLength - this.maxIntergenicLength;
                }
                this.annYPos[i] = this.coordStarts[i] + (this.coordEnds[i] - this.coordStarts[i]) / 2 + fontAscent / 2;
                this.maxPixelCoord = Math.max(this.maxPixelCoord, this.coordEnds[i]);
            }
        } else if (!this.fixedLengthArrows && !this.showOpenAreas) {
            for (int i = 0; i < this.coordStarts.length; ++i) {
                this.coordStarts[i] = currY;
                this.coordEnds[i] = currY + (this.end[i] - this.start[i]) / this.bpPerPixel;
                if (this.coordEnds[i] - this.coordStarts[i] < this.minArrowLength) {
                    this.coordEnds[i] = this.coordStarts[i] + this.minArrowLength;
                    currY += this.minArrowLength + this.CONTIG_ARROW_Y_SPACING;
                } else {
                    currY += this.coordEnds[i] - this.coordStarts[i] + this.CONTIG_ARROW_Y_SPACING;
                }
                this.annYPos[i] = this.coordStarts[i] + (this.coordEnds[i] - this.coordStarts[i]) / 2 + fontAscent / 2;
                this.maxPixelCoord = Math.max(this.maxPixelCoord, this.coordEnds[i]);
            }
        }
        this.viewerWidth = this.X_ORIGIN + this.columnSpacing * this.numberOfSamples - this.arrowWidth / 2 - this.wingWidth + this.fullAnnotationWidth;
        this.setPreferredSize(new Dimension(this.viewerWidth, this.maxPixelCoord + 5));
        this.setSize(this.viewerWidth, this.maxPixelCoord + 5);
        this.setBoundingRanges();
        if (this.thumbnail != null) {
            this.thumbnail.updateCoords(this.coordStarts, this.coordEnds, this.maxPixelCoord);
        }
    }

    private void setBoundingRanges() {
        int chunkSize = (int)Math.ceil((float)(this.maxPixelCoord + 5) / (float)this.boundryCount);
        for (int boundry = 0; boundry < this.boundingRanges.length; ++boundry) {
            this.boundingRanges[boundry][0] = chunkSize * boundry;
            this.boundingRanges[boundry][1] = chunkSize * (boundry + 1);
            int[] range = this.getLociCoverage(chunkSize * boundry, chunkSize * (boundry + 1));
            this.boundingRanges[boundry][2] = range[0];
            this.boundingRanges[boundry][3] = range[1];
        }
    }

    private int[] getLociCoverage(int y1, int y2) {
        int[] lowHigh = new int[]{this.findNextLowestStart(y1), this.findNextHighestStart(y2)};
        return lowHigh;
    }

    public int findIndex(int coord, int index, int start, int end) {
        if (start == end) {
            return start;
        }
        if (this.coordStarts[index] > coord) {
            return this.findIndex(coord, start, (index - start) / 2 + start, index);
        }
        return this.findIndex(coord, index, (end - index) / 2 + start, end);
    }

    public int[] getStartValues() {
        return this.start;
    }

    public FloatMatrix getLocusMeanMatrix() {
        return this.experiment.getMatrix();
    }

    public int[] getEndValues() {
        return this.end;
    }

    public boolean[] getDirectionArray() {
        return this.isForward;
    }

    public String[] getLocusIDArray() {
        return this.sortedLocusIDs;
    }

    public int[] getStrata() {
        return this.strata;
    }

    public int getMaxStrata() {
        return this.maxStrata;
    }

    public boolean isLocusSelected(int locusIndex) {
        return this.selected[locusIndex];
    }

    public boolean areArrowLengthsFixed() {
        return this.fixedLengthArrows;
    }

    public String getLocusID(int index) {
        return this.sortedLocusIDs[index];
    }

    public int getStart(int index) {
        return this.start[index];
    }

    public int getEnd(int index) {
        return this.end[index];
    }

    public int getNumReplicates(int index) {
        return this.replicates[index].length;
    }

    public int[] getSelectedIndices() {
        if (this.selectedIndicesVector.size() == 0) {
            return new int[0];
        }
        int[] indices = new int[this.selectedIndicesVector.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)this.selectedIndicesVector.get(i);
        }
        return indices;
    }

    private void storeSelectedLociSpotsToCluster() {
        int[] locusIndices = this.getSelectedIndices();
        if (locusIndices.length == 0) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are no loci selected.  Shift+Left Click to select.", "Empty Locus Selection List", 1);
            return;
        }
        int spotCount = 0;
        for (int i = 0; i < locusIndices.length; ++i) {
            spotCount += this.replicates[locusIndices[i]].length;
        }
        int[] spotIndices = new int[spotCount];
        int cnt = 0;
        for (int i = 0; i < locusIndices.length; ++i) {
            for (int j = 0; j < this.replicates[locusIndices[i]].length; ++j) {
                spotIndices[cnt] = this.replicates[locusIndices[i]][j];
                ++cnt;
            }
        }
        this.framework.storeSubCluster(spotIndices, this.fullExperiment, 0);
    }

    private void saveSelectedLociSpots() {
        int[] indices = this.getSelectedIndices();
        if (indices.length == 0) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are no loci selected.  Shift+Left Click to select.", "Empty Locus Selection List", 1);
            return;
        }
        this.saveSpotsForLocusList(indices);
    }

    public void saveSpotsForLocusList(int[] locusIndices) {
        int spotCount = 0;
        for (int i = 0; i < locusIndices.length; ++i) {
            spotCount += this.replicates[locusIndices[i]].length;
        }
        int[] spotIndices = new int[spotCount];
        int cnt = 0;
        for (int i = 0; i < locusIndices.length; ++i) {
            for (int j = 0; j < this.replicates[locusIndices[i]].length; ++j) {
                spotIndices[cnt] = this.replicates[locusIndices[i]][j];
                ++cnt;
            }
        }
        try {
            ExperimentUtil.saveExperiment((Frame)this.framework.getFrame(), (Experiment)this.fullExperiment, (IData)this.data, (int[])spotIndices);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Cannot save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    private void saveLocusMatrix() {
        JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"data"));
        if (chooser.showSaveDialog(this.framework.getFrame()) == 0) {
            try {
                int i;
                File file = chooser.getSelectedFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                Vector sampleFieldNames = this.data.getSampleAnnotationFieldNames();
                String headerLine = this.locusIDFieldName + "\tSpots/Locus\t" + "5' End\t" + "3' End\t";
                for (i = 0; i < this.numberOfSamples; ++i) {
                    headerLine = headerLine + this.data.getSampleAnnotation(i, (String)sampleFieldNames.get(0));
                    headerLine = i < this.numberOfSamples - 1 ? headerLine + "\t" : headerLine + "\n";
                }
                bw.write(headerLine);
                if (sampleFieldNames.size() > 0) {
                    for (i = 1; i < sampleFieldNames.size(); ++i) {
                        String fieldName = (String)sampleFieldNames.get(i);
                        headerLine = "\t\t\t" + fieldName + "\t";
                        for (int j = 0; j < this.numberOfSamples; ++j) {
                            headerLine = headerLine + this.data.getSampleAnnotation(j, fieldName);
                            headerLine = j < this.numberOfSamples - 1 ? headerLine + "\t" : headerLine + "\n";
                        }
                        bw.write(headerLine);
                    }
                }
                for (int i2 = 0; i2 < this.sortedLocusIDs.length; ++i2) {
                    int threePrime;
                    int fivePrime;
                    String line = this.sortedLocusIDs[i2] + "\t" + String.valueOf(this.replicates[i2].length) + "\t";
                    if (this.isForward[i2]) {
                        fivePrime = this.start[i2];
                        threePrime = this.end[i2];
                    } else {
                        fivePrime = this.end[i2];
                        threePrime = this.start[i2];
                    }
                    line = line + String.valueOf(fivePrime) + "\t" + String.valueOf(threePrime) + "\t";
                    for (int j = 0; j < this.numberOfSamples; ++j) {
                        line = line + String.valueOf(this.experiment.get(i2, j));
                        line = j < this.numberOfSamples - 1 ? line + "\t" : line + "\n";
                    }
                    bw.write(line);
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Cannot save loci!", ioe.toString(), 0);
                ioe.printStackTrace();
            }
        }
    }

    public void saveSelectedLoci() {
        int[] indices = this.getSelectedIndices();
        if (indices.length == 0) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "There are no loci selected.  Shift+Left Click to select.", "Empty Locus Selection List", 1);
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)this.selectedIndicesVector.get(i);
        }
        this.saveLocusList(indices);
    }

    public void saveLocusList(int[] locusIndices) {
        JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"data"));
        if (chooser.showSaveDialog(this.framework.getFrame()) == 0) {
            try {
                int i;
                File file = chooser.getSelectedFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                Vector sampleFieldNames = this.data.getSampleAnnotationFieldNames();
                String headerLine = this.locusIDFieldName + "\tSpots/Locus\t" + "5' End\t" + "3' End\t";
                for (i = 0; i < this.numberOfSamples; ++i) {
                    headerLine = headerLine + this.data.getSampleAnnotation(i, (String)sampleFieldNames.get(0));
                    headerLine = i < this.numberOfSamples - 1 ? headerLine + "\t" : headerLine + "\n";
                }
                bw.write(headerLine);
                if (sampleFieldNames.size() > 0) {
                    for (i = 1; i < sampleFieldNames.size(); ++i) {
                        String fieldName = (String)sampleFieldNames.get(i);
                        headerLine = "\t\t\t" + fieldName + "\t";
                        for (int j = 0; j < this.numberOfSamples; ++j) {
                            headerLine = headerLine + this.data.getSampleAnnotation(j, fieldName);
                            headerLine = j < this.numberOfSamples - 1 ? headerLine + "\t" : headerLine + "\n";
                        }
                        bw.write(headerLine);
                    }
                }
                for (int i2 = 0; i2 < locusIndices.length; ++i2) {
                    int threePrime;
                    int fivePrime;
                    String line = this.sortedLocusIDs[locusIndices[i2]] + "\t" + String.valueOf(this.replicates[locusIndices[i2]].length) + "\t";
                    if (this.isForward[i2]) {
                        fivePrime = this.start[i2];
                        threePrime = this.end[i2];
                    } else {
                        fivePrime = this.end[i2];
                        threePrime = this.start[i2];
                    }
                    line = line + String.valueOf(fivePrime) + "\t" + String.valueOf(threePrime) + "\t";
                    for (int j = 0; j < this.numberOfSamples; ++j) {
                        line = line + String.valueOf(this.experiment.get(locusIndices[i2], j));
                        line = j < this.numberOfSamples - 1 ? line + "\t" : line + "\n";
                    }
                    bw.write(line);
                }
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.framework.getFrame(), "Cannot save loci!", ioe.toString(), 0);
                ioe.printStackTrace();
            }
        }
    }

    public void linkToURL(int index) {
        JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this);
        ExperimentUtil.linkToURL((JFrame)frame, (Experiment)this.fullExperiment, (IData)this.data, (int)this.fullExperiment.getGeneIndexMappedToData(this.replicates[index][0]), (String)this.locusIDFieldName, (int[])ExperimentUtil.lastSelectedAnnotationIndices);
    }

    public String getLocusName(int index) {
        if (index > this.sortedLocusIDs.length - 1) {
            return this.sortedLocusIDs[0];
        }
        if (index < 0) {
            return this.sortedLocusIDs[this.sortedLocusIDs.length - 1];
        }
        return this.sortedLocusIDs[index];
    }

    public int[] getReplicatesArray(int index) {
        if (index > this.replicates.length - 1) {
            return this.replicates[0];
        }
        if (index < 0) {
            return this.replicates[this.replicates.length - 1];
        }
        return this.replicates[index];
    }

    public void setViewerSettings(Properties props) {
        this.fixedLengthArrows = Boolean.valueOf(props.getProperty("fixed-arrows"));
        if (this.fixedLengthArrows) {
            this.currArrowLength = Integer.parseInt(props.getProperty("fixed-arrow-length"));
        } else {
            this.bpPerPixel = Integer.parseInt(props.getProperty("scaling-factor"));
            this.minArrowLength = Integer.parseInt(props.getProperty("min-arrow-length"));
            this.maxArrowLength = Integer.parseInt(props.getProperty("max-arrow-length"));
        }
        boolean bl = this.showOpenAreas = Boolean.valueOf(props.getProperty("fixed-open")) == false;
        if (this.showOpenAreas) {
            this.maxIntergenicLength = Integer.parseInt(props.getProperty("max-open-length"));
        }
        this.showAllReplicates = Boolean.valueOf(props.getProperty("show-replicates"));
        this.updateViewer();
    }

    private boolean isOpen(int coord) {
        int index = 0;
        while (index < this.start.length && this.start[index] < coord) {
            if (this.start[index] >= coord || this.end[index] <= coord) continue;
            return true;
        }
        return false;
    }

    private void setColorBinPolicy(int mode) {
        this.colorMode = mode;
        this.header.setColorBinPolicy(mode);
        this.header.repaint();
        this.repaint();
        if (this.thumbnail != null && this.thumbnail.isVisible()) {
            this.thumbnail.repaint();
        }
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.updateLocusAnnotationWidth();
        this.updateCoords();
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        int index = this.fieldIndex;
        this.fieldIndex = menu.getLabelIndex();
        if (index != this.fieldIndex) {
            this.updateLocusAnnotationWidth();
        }
        this.header.setData(this.data);
        this.header.setColumnSpacing(this.columnSpacing);
        this.header.updateSizes(this.viewerWidth, this.columnSpacing);
        if (this.selectionEditor == null) {
            this.selectionEditor = new LEMSelectionEditor((JFrame)framework.getFrame(), this, this.selectedIndicesVector);
        }
    }

    public void onDataChanged(IData data) {
        this.header.setData(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.maxValue = menu.getMaxRatioScale();
        this.minValue = menu.getMinRatioScale();
        this.midValue = menu.getMidRatioValue();
        this.posColorImage = menu.getPositiveGradientImage();
        this.negColorImage = menu.getNegativeGradientImage();
        this.useDoubleGradient = menu.getUseDoubleGradient();
        int index = this.fieldIndex;
        this.fieldIndex = menu.getLabelIndex();
        if (index != this.fieldIndex) {
            this.updateLocusAnnotationWidth();
        }
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setUseDoubleGradient(this.useDoubleGradient);
        this.header.setValues(this.minValue, this.midValue, this.maxValue);
        this.repaint();
        if (this.thumbnail != null && this.thumbnail.isVisible()) {
            this.thumbnail.repaint();
        }
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    private void updateLocusAnnotationWidth() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        if (fm == null) {
            return;
        }
        int currLocusWidth = 0;
        int currStartWidth = 0;
        int currEndWidth = 0;
        int currAnnWidth = 0;
        int maxLocusWidth = 0;
        int maxStartWidth = 0;
        int maxEndWidth = 0;
        int maxAnnWidth = 0;
        for (int i = 0; i < this.locusCount; ++i) {
            currLocusWidth = fm.stringWidth(this.sortedLocusIDs[i]);
            if (currLocusWidth > maxLocusWidth) {
                maxLocusWidth = currLocusWidth;
            }
            if ((currStartWidth = fm.stringWidth(this.isForward[i] ? String.valueOf(this.start[i]) : String.valueOf(this.end[i]))) > maxStartWidth) {
                maxStartWidth = currStartWidth;
            }
            if ((currEndWidth = fm.stringWidth(this.isForward[i] ? String.valueOf(this.end[i]) : String.valueOf(this.start[i]))) > maxEndWidth) {
                maxEndWidth = currEndWidth;
            }
            if ((currAnnWidth = fm.stringWidth(this.data.getElementAttribute(this.fullExperiment.getGeneIndexMappedToData(this.replicates[i][0]), this.fieldIndex))) <= maxAnnWidth) continue;
            maxAnnWidth = currAnnWidth;
        }
        this.startMaxWidth = maxStartWidth;
        this.endMaxWidth = maxEndWidth;
        this.locusMaxWidth = maxLocusWidth;
        this.annotationWidth = maxAnnWidth;
        this.fullAnnotationWidth = this.COORD_LEFT_MARGIN + this.startMaxWidth + this.COORD_SEPARATOR_MARGIN + this.endMaxWidth + this.LEFT_LOCUS_MARGIN + this.locusMaxWidth + this.RIGHT_LOCUS_MARGIN + this.annotationWidth;
    }

    public Color getColor(float value) {
        Color color;
        if (Float.isNaN(value)) {
            return this.missingColor;
        }
        int rgb = 0;
        if (this.colorMode == 0) {
            if (this.useDoubleGradient) {
                float maximum = value < this.midValue ? this.minValue : this.maxValue;
                int colorIndex = (int)(255.0f * (value - this.midValue) / (maximum - this.midValue));
                if (colorIndex < 0) {
                    colorIndex = -colorIndex;
                }
                colorIndex = colorIndex > 255 ? 255 : colorIndex;
                rgb = value < this.midValue ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
            } else {
                float span = this.maxValue - this.minValue;
                int colorIndex = value <= this.minValue ? 0 : (value >= this.maxValue ? 255 : (int)((value - this.minValue) / span * 255.0f));
                rgb = this.posColorImage.getRGB(colorIndex, 0);
            }
            color = new Color(rgb);
        } else {
            color = this.colorMode == 1 ? (value <= this.cutoff1 ? this.lowestColor : (value >= this.cutoff4 ? this.highestColor : this.midPointColor)) : (value < this.cutoff1 ? this.lowestColor : (value >= this.cutoff4 ? this.highestColor : (value >= this.cutoff3 ? this.higherColor : (value < this.cutoff2 ? this.lowerColor : this.midPointColor))));
        }
        return color;
    }

    protected BufferedImage createGradient(Color c1, Color c2) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics = image.createGraphics();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, c1, 255.0f, 0.0f, c2);
        graphics.setPaint(gp);
        graphics.drawRect(0, 0, 255, 1);
        return image;
    }

    private void updateViewer() {
        this.updateColumnSpacing();
        this.updateCoords();
        this.header.setColumnSpacing(this.columnSpacing);
        this.header.updateSizes(this.getWidth(), this.columnSpacing);
        this.repaint();
        this.header.repaint();
        if (this.thumbnail != null && this.thumbnail.isVisible()) {
            this.thumbnail.setIsFixedLength(this.fixedLengthArrows);
            this.thumbnail.repaint();
        }
    }

    private void setScaleLoci() {
        this.fixedLengthArrows = !this.fixedLengthArrows;
        this.updateViewer();
    }

    private void setScaleIntergenic() {
        this.showOpenAreas = !this.showOpenAreas;
        this.updateViewer();
    }

    private void shadeLoci(int x, int y) {
        if (x > this.X_ORIGIN && x < this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2) {
            this.highlightedIndex = this.findNearestArrowMidPoint(y);
            if (this.highlightedIndex != -1) {
                this.setStatusText(this.highlightedIndex);
                this.highlightStart = this.coordStarts[this.highlightedIndex];
                this.highlightEnd = this.coordEnds[this.highlightedIndex];
                this.highlighted = true;
                this.repaint();
            } else {
                this.setStatusText(-1);
                this.highlighted = false;
                this.repaint();
            }
        } else {
            this.setStatusText(-1);
            this.highlighted = false;
            this.repaint();
        }
    }

    private void setStatusText(int index) {
        if (index == -1) {
            this.framework.setStatusText(" TIGR MultiExperiment Viewer");
        } else {
            this.framework.setStatusText(" " + this.locusIDFieldName + ": " + this.sortedLocusIDs[this.highlightedIndex]);
        }
    }

    private int findNearestArrowMidPoint(int yCoord) {
        int minDeltaIndex = -1;
        int delta = Integer.MAX_VALUE;
        int[] bounds = this.getBoundingIndices(yCoord, yCoord);
        if (bounds[1] - bounds[0] <= 0) {
            return minDeltaIndex;
        }
        for (int i = bounds[0]; i <= bounds[1]; ++i) {
            if (this.coordStarts[i] > yCoord || this.coordEnds[i] < yCoord || delta <= Math.abs(yCoord - (this.coordEnds[i] + this.coordStarts[i]) / 2)) continue;
            minDeltaIndex = i;
            delta = Math.abs(yCoord - (this.coordEnds[i] + this.coordStarts[i]) / 2);
        }
        return minDeltaIndex;
    }

    private void setBinColorRanges() {
        LEMColorRangeSelector selector = new LEMColorRangeSelector((JFrame)this.framework.getFrame(), this, this.lowestColor, this.lowerColor, this.higherColor, this.highestColor, this.cutoff1, this.cutoff2, this.midBinValue, this.cutoff3, this.cutoff4);
        selector.showModal();
    }

    public void setBinLimitsAndColors(float c1, float c2, float mid, float c3, float c4, Color color1, Color color2, Color color3, Color color4) {
        this.cutoff1 = c1;
        this.cutoff2 = c2;
        this.midBinValue = mid;
        this.cutoff3 = c3;
        this.cutoff4 = c4;
        this.lowestColor = color1;
        this.lowerColor = color2;
        this.midPointColor = Color.white;
        this.higherColor = color3;
        this.highestColor = color4;
        this.header.setBinColors(this.lowestColor, this.lowerColor, this.higherColor, this.highestColor);
        this.header.setBinCutoffs(this.cutoff1, this.cutoff2, this.midBinValue, this.cutoff3, this.cutoff4);
        this.header.repaint();
        this.repaint();
        if (this.thumbnail != null && this.thumbnail.isVisible()) {
            this.thumbnail.repaint();
        }
    }

    private void showInfo(int x, int y) {
        int index;
        if (x > this.X_ORIGIN && x < this.columnSpacing * this.numberOfSamples && (index = this.findNearestArrowMidPoint(y)) != -1) {
            this.launchInfo(index);
        }
    }

    private void launchInfo(int index) {
        LocusInfoDialog info = new LocusInfoDialog((JFrame)this.framework.getFrame(), this, this.sortedLocusIDs[index], index, this.experiment, this.fullExperiment, this.framework.getData(), this.replicates[index]);
        this.activeInfoDialogs.add(info);
        info.showInfo();
    }

    public void removeInfoViewer(LocusInfoDialog info) {
        this.activeInfoDialogs.remove(info);
    }

    private void showThumbnail() {
        if (this.thumbnail != null) {
            this.thumbnail.dispose();
            this.thumbnail = null;
        }
        this.thumbnail = new LEMThumbNail(this.framework, this, this.coordStarts, this.coordEnds, this.experiment.getMatrix(), this.cutoff4, this.cutoff1, this.highestColor, this.lowestColor, this.midPointColor, this.maxPixelCoord, this.clipY1, this.clipY2, this.locusIDFieldName);
        this.thumbnail.showThumbnail();
    }

    public int[] getYClipBounds() {
        int[] yBounds = new int[]{this.clipY1, this.clipY2};
        return yBounds;
    }

    private int findNextLowestStart(int y) {
        int i;
        int index = 0;
        for (i = 0; i < this.coordStarts.length; ++i) {
            if (this.coordStarts[i] <= y && this.coordEnds[i] >= y) {
                return i;
            }
            if (this.coordStarts[i] <= y) continue;
            if (i > 0) {
                return i - 1;
            }
            return 0;
        }
        if (i >= this.coordStarts.length) {
            return this.coordStarts.length - 1;
        }
        return index;
    }

    private int findNextHighestStart(int y) {
        int i;
        int index = 0;
        for (i = this.coordStarts.length - 1; i >= 0; --i) {
            if (this.coordStarts[i] <= y && this.coordEnds[i] >= y) {
                return i;
            }
            if (this.coordStarts[i] >= y) continue;
            if (i < this.coordStarts.length - 1) {
                return i + 1;
            }
            return this.coordStarts.length - 1;
        }
        if (i < 0) {
            return 1;
        }
        return index;
    }

    private int[] getBoundingIndices(int y1, int y2) {
        int[] bounds = new int[]{0, this.coordStarts.length - 1};
        boolean setHigh = false;
        boolean setLow = false;
        for (int i = 0; i < this.boundingRanges.length; ++i) {
            if (!setLow && y1 >= this.boundingRanges[i][0] && y1 < this.boundingRanges[i][1]) {
                bounds[0] = this.boundingRanges[i][2];
                setLow = true;
            }
            if (!setHigh && y2 >= this.boundingRanges[i][0] && y2 < this.boundingRanges[i][1]) {
                bounds[1] = this.boundingRanges[i][3];
                setHigh = true;
            }
            if (!setHigh || !setLow) continue;
            return bounds;
        }
        return bounds;
    }

    public int jumpToLocus(String locus) {
        int loc = -1;
        for (int i = 0; i < this.sortedLocusIDs.length; ++i) {
            if (!locus.equals(this.sortedLocusIDs[i])) continue;
            loc = this.annYPos[i] - 15;
            if (loc < 0) {
                loc = 0;
            }
            this.shadeLoci(this.X_ORIGIN, loc);
            this.framework.setContentLocation(0, loc);
            return loc;
        }
        return loc;
    }

    public int jumpToLocation(int bp) {
        int loc = -1;
        for (int i = 0; i < this.start.length - 1; ++i) {
            if (bp < this.start[i] || bp > this.start[i + 1]) continue;
            if (bp >= this.start[i] && bp <= this.end[i]) {
                loc = this.annYPos[i] - 15;
                if (loc < 0) {
                    loc = 0;
                }
                this.shadeLoci(this.X_ORIGIN, this.annYPos[i]);
                this.framework.setContentLocation(0, loc);
                return loc;
            }
            loc = this.annYPos[i] - 15;
            if (loc < 0) {
                loc = 0;
            }
            this.shadeLoci(this.X_ORIGIN, this.annYPos[i]);
            this.shadeLoci(this.X_ORIGIN, this.annYPos[i + 1]);
            this.framework.setContentLocation(0, loc);
            return loc;
        }
        return loc;
    }

    private void showSelectionList() {
        if (!this.selectionEditor.isVisible()) {
            this.selectionEditor.showDialog();
        } else {
            this.selectionEditor.centerDialog();
        }
    }

    public void selectLocus(int x, int yCoord) {
        if (x > this.X_ORIGIN - this.wingWidth - this.arrowWidth / 2 && x < this.columnSpacing * this.numberOfSamples + this.wingWidth + this.arrowWidth / 2) {
            int index = this.findNearestArrowMidPoint(yCoord);
            if (index == -1) {
                return;
            }
            boolean bl = this.selected[index] = !this.selected[index];
            if (this.selected[index]) {
                this.selectedIndicesVector.add(new Integer(index));
                this.selectionEditor.fireLocusAdded();
            } else {
                this.selectedIndicesVector.remove(new Integer(index));
                this.selectionEditor.fireLocusRemoved();
            }
            this.updateInfoViewers();
            this.repaint();
        }
    }

    public boolean selectBaseRange() {
        boolean selectionMade = false;
        LEMRangeSelectionDialog dialog = new LEMRangeSelectionDialog((JFrame)this.framework.getFrame(), this.start[0], this.maxEndBaseLocation);
        if (dialog.showModal() == 0) {
            int startBase = dialog.getLowerLimit();
            int endBase = dialog.getUpperLimit();
            int loc = 0;
            Vector<Integer> indices = new Vector<Integer>();
            for (loc = 0; loc < this.start.length; ++loc) {
                if (!this.haveOverLap(loc, startBase, endBase)) continue;
                indices.add(new Integer(loc));
            }
            for (int i = 0; i < indices.size(); ++i) {
                loc = (Integer)indices.get(i);
                if (this.selected[loc]) continue;
                this.selected[loc] = true;
                this.selectedIndicesVector.add(indices.get(i));
                this.selectionEditor.fireLocusAdded();
            }
            if (indices.size() > 0) {
                selectionMade = true;
            }
            this.updateInfoViewers();
            this.repaint();
        }
        return selectionMade;
    }

    private boolean haveOverLap(int locusIndex, int startBase, int endBase) {
        return this.start[locusIndex] >= startBase && this.start[locusIndex] <= endBase || this.end[locusIndex] >= startBase && this.end[locusIndex] <= endBase || startBase >= this.start[locusIndex] && startBase <= this.end[locusIndex];
    }

    private void updateInfoViewers() {
        for (int i = 0; i < this.activeInfoDialogs.size(); ++i) {
            ((LocusInfoDialog)this.activeInfoDialogs.get(i)).checkSelection();
        }
    }

    public void toggleSelectedLocus(int locusIndex) {
        boolean bl = this.selected[locusIndex] = !this.selected[locusIndex];
        if (!this.selected[locusIndex]) {
            this.selectedIndicesVector.remove(new Integer(locusIndex));
            this.selectionEditor.fireLocusRemoved();
        } else {
            this.selectedIndicesVector.add(new Integer(locusIndex));
            this.selectionEditor.fireLocusAdded();
        }
        this.updateInfoViewers();
        this.repaint();
    }

    private void customizeSettings() {
        LEMViewerAttributeDialog dialog = new LEMViewerAttributeDialog(this.framework.getFrame(), this, this.fixedLengthArrows, !this.showOpenAreas, this.currArrowLength, this.minArrowLength, this.maxArrowLength, this.maxIntergenicLength, this.bpPerPixel, this.showAllReplicates);
        dialog.showModal();
    }

    private void createPopupMenu(LEMListener listener) {
        this.menu = new JPopupMenu();
        ButtonGroup bg = new ButtonGroup();
        JMenuItem customizeItem = new JMenuItem("Customize Viewer");
        customizeItem.setActionCommand("customize-viewer-command");
        customizeItem.addActionListener(listener);
        JMenu colorMenu = new JMenu("Color Scale Options");
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Gradient Mode", true);
        item.setActionCommand("gradient-color-mode");
        item.addActionListener(listener);
        bg.add(item);
        colorMenu.add(item);
        item = new JCheckBoxMenuItem("3 Bin Mode", false);
        item.setActionCommand("3-bin-mode");
        item.addActionListener(listener);
        bg.add(item);
        colorMenu.add(item);
        item = new JCheckBoxMenuItem("5 Bin Mode", false);
        item.setActionCommand("5-bin-mode");
        item.addActionListener(listener);
        bg.add(item);
        colorMenu.add(item);
        colorMenu.addSeparator();
        JMenuItem colorItem = new JMenuItem("Bin Colors and Limits");
        colorItem.setActionCommand("bin-color-range-command");
        colorItem.addActionListener(listener);
        colorMenu.add(colorItem);
        JMenuItem navItem = new JMenuItem("LEM Navigation");
        navItem.setActionCommand("show-thumbnail-command");
        navItem.addActionListener(listener);
        JMenuItem showSelectionListItem = new JMenuItem("Locus Selection Manager");
        showSelectionListItem.setActionCommand("show-selection-list-command");
        showSelectionListItem.addActionListener(listener);
        JMenuItem storeMenuItem = new JMenuItem("Store Selected Loci (as cluster)");
        storeMenuItem.setActionCommand("store-cluster-command");
        storeMenuItem.addActionListener(listener);
        JMenuItem saveSelectedLociItem = new JMenuItem("Save Selected Loci (Locus Detail)");
        saveSelectedLociItem.setActionCommand("save-selected-loci-command");
        saveSelectedLociItem.addActionListener(listener);
        JMenuItem saveSelectedLociSpotsItem = new JMenuItem("Save Selected Loci (Spot Detail)");
        saveSelectedLociSpotsItem.setActionCommand("save-selected-loci-spots-command");
        saveSelectedLociSpotsItem.addActionListener(listener);
        JMenuItem saveMatrixItem = new JMenuItem("Save All Loci");
        saveMatrixItem.setActionCommand("save-matrix-command");
        saveMatrixItem.addActionListener(listener);
        this.menu.add(navItem);
        this.menu.addSeparator();
        this.menu.add(customizeItem);
        this.menu.add(colorMenu);
        this.menu.addSeparator();
        this.menu.add(showSelectionListItem);
        this.menu.addSeparator();
        this.menu.add(storeMenuItem);
        this.menu.addSeparator();
        this.menu.add(saveSelectedLociItem);
        this.menu.add(saveSelectedLociSpotsItem);
        this.menu.add(saveMatrixItem);
    }

    private void showPopup(int x, int y) {
        this.menu.show(this, x, y);
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public class LEMListener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("gradient-color-mode")) {
                LinearExpressionMapViewer.this.setColorBinPolicy(0);
            } else if (command.equals("3-bin-mode")) {
                LinearExpressionMapViewer.this.setColorBinPolicy(1);
            } else if (command.equals("5-bin-mode")) {
                LinearExpressionMapViewer.this.setColorBinPolicy(2);
            } else if (command.equals("scale-loci-command")) {
                LinearExpressionMapViewer.this.setScaleLoci();
            } else if (command.equals("scale-open-command")) {
                LinearExpressionMapViewer.this.setScaleIntergenic();
            } else if (command.equals("show-thumbnail-command")) {
                LinearExpressionMapViewer.this.showThumbnail();
            } else if (command.equals("bin-color-range-command")) {
                LinearExpressionMapViewer.this.setBinColorRanges();
            } else if (command.equals("show-selection-list-command")) {
                LinearExpressionMapViewer.this.showSelectionList();
            } else if (command.equals("customize-viewer-command")) {
                LinearExpressionMapViewer.this.customizeSettings();
            } else if (command.equals("save-matrix-command")) {
                LinearExpressionMapViewer.this.saveLocusMatrix();
            } else if (command.equals("store-cluster-command")) {
                LinearExpressionMapViewer.this.storeSelectedLociSpotsToCluster();
            } else if (command.equals("save-selected-loci-command")) {
                LinearExpressionMapViewer.this.saveSelectedLoci();
            } else if (command.equals("save-selected-loci-spots-command")) {
                LinearExpressionMapViewer.this.saveSelectedLociSpots();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LinearExpressionMapViewer.this.showPopup(me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LinearExpressionMapViewer.this.showPopup(me.getX(), me.getY());
            } else if (MouseEvent.getModifiersExText(me.getModifiersEx()).equalsIgnoreCase("Shift")) {
                LinearExpressionMapViewer.this.selectLocus(me.getX(), me.getY());
            } else {
                LinearExpressionMapViewer.this.showInfo(me.getX(), me.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (!LinearExpressionMapViewer.this.menu.isVisible() || LinearExpressionMapViewer.this.thumbnail != null && !LinearExpressionMapViewer.this.thumbnail.isVisible()) {
                LinearExpressionMapViewer.this.highlighted = false;
                LinearExpressionMapViewer.this.repaint();
            }
            LinearExpressionMapViewer.this.setStatusText(-1);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            LinearExpressionMapViewer.this.shadeLoci(me.getX(), me.getY());
        }

        @Override
        public void mouseDragged(MouseEvent me) {
        }
    }
}

