/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.lem.GraphScaleCustomizationDialog;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMGraphViewer;

public class LinearExpressionGraphViewer
extends JPanel
implements IViewer {
    private JSplitPane splitPane;
    private Graph graph;
    private SampleTable table;
    private IData idata;
    private int numberOfSamples;
    private boolean overlay = false;
    private IFramework framework;
    private JPopupMenu popup;
    private boolean showRefLine = false;
    private int exptID = 0;
    String chrID;
    String[] sortedLocusIDs;
    int[] sortedStartArray;
    int[] sortedEndArray;
    Experiment fullExperiment;
    Experiment reducedExperiment;
    int[][] replicates;
    String locusIDFieldName;

    public LinearExpressionGraphViewer(Experiment fullExperiment, Experiment reducedExperiment, String[] sortedLocusIDs, int[] sortedStartArray, int[] sortedEndArray, int[][] replicates, String chrID, String locusIDFieldName) {
        super(new GridBagLayout());
        this.numberOfSamples = fullExperiment.getNumberOfSamples();
        this.splitPane = new JSplitPane(0, this.graph, this.table);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerLocation(0.7);
        Listener listener = new Listener();
        this.popup = this.contructMenu(listener);
        this.chrID = chrID;
        this.sortedLocusIDs = sortedLocusIDs;
        this.sortedStartArray = sortedStartArray;
        this.sortedEndArray = sortedEndArray;
        this.replicates = replicates;
        this.locusIDFieldName = locusIDFieldName;
        this.fullExperiment = fullExperiment;
        this.reducedExperiment = reducedExperiment;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.fullExperiment, this.reducedExperiment, this.sortedLocusIDs, this.sortedStartArray, this.sortedEndArray, this.replicates, this.chrID, this.locusIDFieldName});
    }

    private void updateViewerModeView() {
        this.removeAll();
        if (this.overlay) {
            this.add((Component)this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.graph.getGraphComponent().enableDiscreteValueOverlay(false);
            this.graph.getGraphComponent().enableOffsetLinesMode(false);
            this.graph.validateView();
            this.splitPane.validate();
            this.splitPane.setDividerLocation(0.7);
            this.repaint();
        } else {
            this.graph.removeGraphComponent();
            this.add((Component)this.graph.getGraphComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.graph.getGraphComponent().refreshGraph();
        }
    }

    private void customizeGraph() {
        Hashtable props = this.graph.getGraphComponent().getGraphProperties();
        GraphScaleCustomizationDialog dialog = new GraphScaleCustomizationDialog((JFrame)this.framework.getFrame(), true, props);
        if (dialog.showModal() == 0) {
            LEMGraphViewer lemGraph = this.graph.getGraphComponent();
            int yRangeMode = dialog.getYRangeMode();
            lemGraph.setYAxisRangeMode(yRangeMode);
            if (yRangeMode == 1) {
                lemGraph.setYRange(dialog.getYMin(), dialog.getYMax());
                lemGraph.setTicInterval(dialog.getYTicInterval());
            }
            lemGraph.setShowXAxis(dialog.showXAxisLine());
            lemGraph.setXAxisStroke(dialog.getXAxisStyle());
            lemGraph.setXAxisColor(dialog.getXAxisColor());
            lemGraph.setXAxisCrossPoint(dialog.getXAxisCrossPoint());
            lemGraph.enableOffsetLinesMode(dialog.isOffsetLinesModeSelected());
            lemGraph.setOffsetLinesMidpoint(dialog.getOffsetMidpoint());
            lemGraph.setOffsetLinesMin(dialog.getOffsetMin());
            lemGraph.setOffsetLinesMax(dialog.getOffsetMax());
            lemGraph.enableDiscreteValueOverlay(dialog.getShowOverlay());
            lemGraph.refreshGraph();
        }
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        if (this.graph == null) {
            this.graph = new Graph(this.fullExperiment, this.reducedExperiment.getMatrix().A, this.chrID, this.sortedLocusIDs, this.sortedStartArray, this.sortedEndArray);
            this.graph.getGraphComponent().addMouseListener(new Listener());
            this.graph.getGraphComponent().enableOverlay(this.overlay);
            this.splitPane.setTopComponent(this.graph);
        }
        return this.graph.getGraphComponent().getHeaderComponent();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.idata = framework.getData();
        if (this.table == null) {
            this.table = new SampleTable();
            this.splitPane.setBottomComponent(this.table);
        }
        if (this.graph == null) {
            this.graph = new Graph(this.fullExperiment, this.reducedExperiment.getMatrix().A, this.chrID, this.sortedLocusIDs, this.sortedStartArray, this.sortedEndArray);
            this.graph.setSampleLineColors(this.table.lineColorVector);
            this.graph.setSampleMarkerColors(this.table.markerColorVector);
            this.graph.getGraphComponent().addMouseListener(new Listener());
            this.graph.getGraphComponent().enableOverlay(this.overlay);
            this.splitPane.setTopComponent(this.graph);
        }
        this.graph.setSampleLineColors(this.table.lineColorVector);
        this.graph.setSampleMarkerColors(this.table.markerColorVector);
        this.updateViewerModeView();
        this.graph.onSelected(framework);
    }

    public void onDataChanged(IData data) {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.graph.getGraphComponent().onMenuChanged(menu);
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    private JPopupMenu contructMenu(Listener listener) {
        JPopupMenu menu = new JPopupMenu();
        JMenu submenu = new JMenu("Viewer Mode");
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem buttonItem = new JRadioButtonMenuItem("Tile Graphs", true);
        buttonItem.setFocusPainted(false);
        buttonItem.setActionCommand("tile-mode-command");
        buttonItem.addActionListener(listener);
        bg.add(buttonItem);
        submenu.add(buttonItem);
        buttonItem = new JRadioButtonMenuItem("Overlay Graphs");
        buttonItem.setFocusPainted(false);
        buttonItem.setActionCommand("overlay-mode-command");
        buttonItem.addActionListener(listener);
        bg.add(buttonItem);
        submenu.add(buttonItem);
        menu.add(submenu);
        JMenuItem item = new JMenuItem("Customize Graph");
        item.setFocusPainted(false);
        item.setActionCommand("customize-graph-range-command");
        item.addActionListener(listener);
        menu.addSeparator();
        menu.add(item);
        JCheckBoxMenuItem box = new JCheckBoxMenuItem("Show Locus Reference Line", false);
        box.setFocusPainted(false);
        box.setActionCommand("show-reference-line-command");
        box.addActionListener(listener);
        menu.add(box);
        item = new JMenuItem("Zoom Out (reset X range)");
        item.setFocusPainted(false);
        item.setActionCommand("reset-x-range-command");
        item.addActionListener(listener);
        menu.addSeparator();
        menu.add(item);
        return menu;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public class Listener
    extends MouseAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("overlay-mode-command")) {
                LinearExpressionGraphViewer.this.overlay = true;
                LinearExpressionGraphViewer.this.graph.getGraphComponent().enableOverlay(LinearExpressionGraphViewer.this.overlay);
                LinearExpressionGraphViewer.this.splitPane.validate();
                LinearExpressionGraphViewer.this.table.setSelectedRows(0, 0);
                LinearExpressionGraphViewer.this.graph.setGraphsToDisplay(LinearExpressionGraphViewer.this.table.getSelectedRows());
                LinearExpressionGraphViewer.this.updateViewerModeView();
                LinearExpressionGraphViewer.this.framework.refreshCurrentViewer();
                LinearExpressionGraphViewer.this.framework.getFrame().validate();
                LinearExpressionGraphViewer.this.framework.getFrame().repaint();
            } else if (command.equals("tile-mode-command")) {
                LinearExpressionGraphViewer.this.overlay = false;
                LinearExpressionGraphViewer.this.graph.getGraphComponent().enableOverlay(LinearExpressionGraphViewer.this.overlay);
                LinearExpressionGraphViewer.this.updateViewerModeView();
                LinearExpressionGraphViewer.this.framework.refreshCurrentViewer();
                LinearExpressionGraphViewer.this.framework.getFrame().validate();
                LinearExpressionGraphViewer.this.framework.getFrame().repaint();
            } else if (command.equals("customize-graph-range-command")) {
                LinearExpressionGraphViewer.this.customizeGraph();
            } else if (command.equals("show-reference-line-command")) {
                LinearExpressionGraphViewer.this.showRefLine = !LinearExpressionGraphViewer.this.showRefLine;
                LinearExpressionGraphViewer.this.graph.getGraphComponent().toggleReferenceLine();
            } else if (command.equals("reset-x-range-command")) {
                LinearExpressionGraphViewer.this.graph.getGraphComponent().resetXRange();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LinearExpressionGraphViewer.this.popup.show(LinearExpressionGraphViewer.this.graph.getGraphComponent(), me.getX(), me.getY());
                return;
            }
            int column = LinearExpressionGraphViewer.this.table.getSelectedRows()[0];
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                LinearExpressionGraphViewer.this.popup.show(LinearExpressionGraphViewer.this.graph.getGraphComponent(), me.getX(), me.getY());
            }
        }
    }

    public class TableListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent me) {
            LinearExpressionGraphViewer.this.graph.setGraphsToDisplay(LinearExpressionGraphViewer.this.table.getSelectedRows());
            LinearExpressionGraphViewer.this.table.processMouseEvent(me);
        }
    }

    public class Graph
    extends JPanel {
        private LEMGraphViewer graph;
        private JScrollBar horizGraphBar;
        private boolean compressX;
        JScrollPane pane;

        public Graph(Experiment fullExp, float[][] data, String title, String[] locusNames, int[] start, int[] end) {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            Hashtable initProps = this.getInitialProperties();
            this.graph = new LEMGraphViewer(fullExp, data, title, initProps, locusNames, start, end);
            this.pane = new JScrollPane(this.graph);
            this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            int[] indices = new int[]{0};
            this.setGraphsToDisplay(indices);
            this.setBackground(Color.green);
        }

        private Hashtable getInitialProperties() {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("is-overlay-mode", new Boolean(false));
            props.put("y-range-mode", new Integer(0));
            props.put("y-axis-symetry", new Boolean(false));
            props.put("show-x-axis", new Boolean(true));
            props.put("x-axis-color", Color.lightGray);
            props.put("x-axis-stroke", new BasicStroke(1.0f));
            props.put("offset-lines-mode", new Boolean(true));
            props.put("offset-graph-midpoint", new Float(0.0f));
            props.put("offset-graph-min", new Float(0.0f));
            props.put("offset-graph-max", new Float(0.0f));
            props.put("show-discrete-overlay", new Boolean(false));
            return props;
        }

        public void setSampleLineColors(Vector lineColors) {
            this.graph.setSampleLineColors(lineColors);
        }

        public void setSampleMarkerColors(Vector markerColors) {
            this.graph.setSampleMarkerColors(markerColors);
        }

        public void setGraphsToDisplay(int[] selectedGraphs) {
            this.graph.setGraphsToDisplay(selectedGraphs);
        }

        public void onSelected(IFramework framework) {
            this.graph.onSelected(framework);
        }

        public LEMGraphViewer getGraphComponent() {
            return this.graph;
        }

        public void validateView() {
            this.pane.setViewportView(this.graph);
            this.validate();
        }

        public void removeGraphComponent() {
            this.pane.remove(this.graph);
        }
    }

    public class SampleTable
    extends JPanel {
        protected JTable table;
        protected SampleTableModel model;
        protected JScrollPane pane;
        protected Vector lineColorVector;
        protected Vector markerColorVector;
        protected int numberOfLineColors;
        protected int numberOfMarkerColors;
        private int ROW_HEIGHT;
        private int VISIBLE_ROWS;

        public SampleTable() {
            super(new GridBagLayout());
            this.ROW_HEIGHT = 20;
            this.VISIBLE_ROWS = 8;
            this.lineColorVector = new Vector();
            this.lineColorVector.add(Color.lightGray);
            this.lineColorVector.add(Color.pink);
            this.lineColorVector.add(new Color(108, 108, 255));
            this.lineColorVector.add(new Color(128, 180, 128));
            this.lineColorVector.add(new Color(201, 70, 20));
            this.lineColorVector.add(new Color(77, 140, 149));
            this.lineColorVector.add(new Color(173, 52, 131));
            this.numberOfLineColors = this.lineColorVector.size();
            this.markerColorVector = new Vector();
            this.markerColorVector.add(Color.blue);
            this.markerColorVector.add(Color.black);
            this.markerColorVector.add(new Color(92, 74, 145));
            this.markerColorVector.add(Color.gray);
            this.markerColorVector.add(new Color(7, 120, 67));
            this.numberOfMarkerColors = this.markerColorVector.size();
            Vector headerNames = LinearExpressionGraphViewer.this.idata.getSampleAnnotationFieldNames();
            int numSampleAnnFields = headerNames.size();
            headerNames.add("Key");
            headerNames.add("Line Color");
            headerNames.add("Marker Color");
            Object[][] data = new Object[LinearExpressionGraphViewer.this.numberOfSamples][headerNames.size()];
            Vector<Object> newLineColorVector = new Vector<Object>();
            Vector<Object> newMarkerColorVector = new Vector<Object>();
            this.table = new JTable();
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[0].length; ++j) {
                    if (j < numSampleAnnFields) {
                        data[i][j] = LinearExpressionGraphViewer.this.idata.getSampleAnnotation(i, (String)headerNames.get(j));
                        continue;
                    }
                    if (j == data[0].length - 2) {
                        data[i][j] = (Color)this.lineColorVector.get(i % this.numberOfLineColors);
                        newLineColorVector.add(data[i][j]);
                        continue;
                    }
                    if (j == data[0].length - 1) {
                        data[i][j] = (Color)this.markerColorVector.get(i % this.numberOfMarkerColors);
                        newMarkerColorVector.add(data[i][j]);
                        continue;
                    }
                    if (j != data[0].length - 3) continue;
                    data[i][j] = new LinePreview((Color)this.markerColorVector.get(i % this.numberOfMarkerColors), (Color)this.lineColorVector.get(i % this.numberOfLineColors), this.table.getSelectionBackground());
                }
            }
            this.lineColorVector = newLineColorVector;
            this.markerColorVector = newMarkerColorVector;
            this.model = new SampleTableModel(data, headerNames);
            this.table = new JTable(this.model);
            this.table.setRowHeight(20);
            LEGTableCellRenderer renderer = new LEGTableCellRenderer();
            this.table.setDefaultRenderer(Color.class, renderer);
            this.table.setDefaultRenderer(LinePreview.class, renderer);
            this.table.addMouseListener(new TableListener());
            this.pane = new JScrollPane(this.table);
            this.pane.setColumnHeaderView(this.table.getTableHeader());
            this.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.table.getSelectionModel().setSelectionInterval(0, 0);
            Dimension dim = new Dimension(400, Math.min(this.VISIBLE_ROWS * this.ROW_HEIGHT, data.length * this.ROW_HEIGHT));
            this.setPreferredSize(dim);
            this.setSize(dim);
        }

        @Override
        public void processMouseEvent(MouseEvent me) {
            if (me.isPopupTrigger()) {
                return;
            }
            int row = this.table.getSelectedRow();
            int col = this.table.getSelectedColumn();
            if (col >= this.table.getColumnCount() - 2) {
                Color color = JColorChooser.showDialog(LinearExpressionGraphViewer.this, "Color Selection", (Color)this.table.getValueAt(row, col));
                if (color != null) {
                    this.table.setValueAt(color, row, col);
                    this.getPreviewPanel(row).setColors(this.getLineColor(row), this.getMarkerColor(col));
                    if (col == this.table.getColumnCount() - 2) {
                        this.lineColorVector.setElementAt(color, row);
                        LinearExpressionGraphViewer.this.graph.setSampleLineColors(this.lineColorVector);
                    } else {
                        this.markerColorVector.setElementAt(color, row);
                        LinearExpressionGraphViewer.this.graph.setSampleMarkerColors(this.markerColorVector);
                    }
                    LinearExpressionGraphViewer.this.graph.getGraphComponent().repaint();
                }
                this.table.repaint();
            }
        }

        private Color getLineColor(int row) {
            return (Color)this.table.getValueAt(row, this.table.getColumnCount() - 2);
        }

        private Color getMarkerColor(int row) {
            return (Color)this.table.getValueAt(row, this.table.getColumnCount() - 1);
        }

        private LinePreview getPreviewPanel(int row) {
            return (LinePreview)this.table.getValueAt(row, this.table.getColumnCount() - 3);
        }

        public int[] getSelectedRows() {
            return this.table.getSelectedRows();
        }

        public void setSelectedRows(int start, int end) {
            this.table.getSelectionModel().setSelectionInterval(start, end);
            this.table.repaint();
        }

        public class LinePreview
        extends JPanel {
            private Color markerColor;
            private Color lineColor;
            private Color backgroundColor;
            private Color selectedBackgroundColor;
            private int x1;
            private int x2;
            private int y;
            private boolean selected;

            public LinePreview(Color marker, Color line, Color selBackgroundColor) {
                this.markerColor = marker;
                this.lineColor = line;
                this.setBackground(Color.white);
                this.backgroundColor = Color.white;
                this.selectedBackgroundColor = selBackgroundColor;
                this.setPreferredSize(new Dimension(90, 25));
                this.x1 = 10;
                this.x2 = 10;
                this.y = 10;
            }

            public void setMarkerColor(Color color) {
                this.markerColor = color;
            }

            public void setLineColor(Color color) {
                this.lineColor = color;
            }

            public void setColors(Color c1, Color c2) {
                this.lineColor = c1;
                this.markerColor = c2;
            }

            public void setSelected(boolean selected) {
                this.selected = selected;
            }

            @Override
            public void paint(Graphics g) {
                if (!this.selected) {
                    this.setBackground(this.backgroundColor);
                } else {
                    this.setBackground(this.selectedBackgroundColor);
                }
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Dimension dim = this.getSize();
                g.setColor(this.lineColor);
                g.drawLine(this.x1, this.y, dim.width - this.x2, this.y);
                g.drawLine(this.x1, this.y + 1, dim.width - this.x2, this.y + 1);
                g.setColor(this.markerColor);
                g.fillOval(this.x1, this.y - 1, 4, 4);
                g.fillOval(dim.width - this.x2, this.y - 1, 4, 4);
            }
        }

        public class LEGTableCellRenderer
        implements TableCellRenderer {
            private JPanel panel = new JPanel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof LinePreview) {
                    ((LinePreview)value).setSelected(isSelected);
                    return (LinePreview)value;
                }
                if (value instanceof Color) {
                    this.panel.setBackground((Color)value);
                    return this.panel;
                }
                return null;
            }
        }

        public class SampleTableModel
        extends AbstractTableModel {
            private Object[][] data;
            private Vector headerNames;

            public SampleTableModel(Object[][] data, Vector header) {
                this.data = data;
                this.headerNames = header;
            }

            @Override
            public int getColumnCount() {
                if (this.data.length == 0) {
                    return 0;
                }
                return this.data[0].length;
            }

            @Override
            public int getRowCount() {
                return this.data.length;
            }

            @Override
            public String getColumnName(int col) {
                return (String)this.headerNames.get(col);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return this.data[rowIndex][columnIndex];
            }

            @Override
            public void setValueAt(Object obj, int row, int col) {
                this.data[row][col] = obj;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col >= SampleTable.this.table.getColumnCount() - 2;
            }

            public Class getColumnClass(int col) {
                if (col == this.headerNames.size() - 3) {
                    return LinePreview.class;
                }
                if (col >= this.headerNames.size() - 2) {
                    return Color.class;
                }
                return String.class;
            }
        }
    }
}

