/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;

public class LEMViewerAttributeDialog
extends AlgorithmDialog {
    private LinearExpressionMapViewer lem;
    private boolean isFixedArrowLength;
    private boolean isFixedOpenLength;
    private int fixedArrowLength;
    private int bpPerPixel;
    private int minArrowLength;
    private int maxArrowLength;
    private int maxOpenLength;
    private boolean showReps;
    private JRadioButton fixedArrowButton;
    private JRadioButton scaledArrowButton;
    private JLabel minArrowLabel;
    private JTextField minArrowField;
    private JLabel maxArrowLabel;
    private JTextField maxArrowField;
    private JLabel fixedArrowLabel;
    private JTextField fixedArrowField;
    private JLabel basePairScaleLabel;
    private JTextField basePairScaleField;
    private JCheckBox fixedOpenBox;
    private JLabel maxOpenLabel;
    private JTextField maxOpenField;
    private JCheckBox showReplicatesBox;

    public LEMViewerAttributeDialog(Frame parent, LinearExpressionMapViewer lem, boolean isFixedArrowLength, boolean isFixedOpenLength, int fixedArrowLength, int minArrowLength, int maxArrowLength, int maxOpenLength, int bpPerPixel, boolean showReps) {
        super(parent, "Customize LEM Viewer", true);
        this.lem = lem;
        this.isFixedArrowLength = isFixedArrowLength;
        this.isFixedOpenLength = isFixedOpenLength;
        this.fixedArrowLength = fixedArrowLength;
        this.minArrowLength = minArrowLength;
        this.maxArrowLength = maxArrowLength;
        this.maxOpenLength = maxOpenLength;
        this.bpPerPixel = bpPerPixel;
        this.showReps = showReps;
        Listener listener = new Listener();
        ParameterPanel arrowPanel = new ParameterPanel("Locus Arrow Dimensions");
        arrowPanel.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        this.fixedArrowButton = this.createRadioButton("Use Fixed Arrow Length", "fixed-arrow-length", listener, this.isFixedArrowLength, bg);
        this.fixedArrowLabel = new JLabel("Fixed Arrow Length (pixels, >= 15))");
        this.fixedArrowField = new JTextField(String.valueOf(this.fixedArrowLength), 10);
        Dimension dim = new Dimension(60, 22);
        this.fixedArrowField.setPreferredSize(dim);
        this.fixedArrowField.setSize(dim);
        this.scaledArrowButton = this.createRadioButton("Use Scaled Arrow Length", "scale-arrow-command", listener, !this.isFixedArrowLength, bg);
        this.basePairScaleLabel = new JLabel("Scaling Factor (bases/pixel)");
        this.basePairScaleField = new JTextField(String.valueOf(this.bpPerPixel));
        this.basePairScaleField.setPreferredSize(dim);
        this.basePairScaleField.setSize(dim);
        this.minArrowLabel = new JLabel("Minimum Scaled Arrow Length (>=15)");
        this.minArrowField = new JTextField(String.valueOf(this.minArrowLength));
        this.minArrowField.setPreferredSize(dim);
        this.minArrowField.setSize(dim);
        this.maxArrowLabel = new JLabel("Maximum Scaled Arrow Length");
        this.maxArrowField = new JTextField(String.valueOf(this.maxArrowLength));
        this.maxArrowField.setPreferredSize(dim);
        this.maxArrowField.setSize(dim);
        if (this.fixedArrowButton.isSelected()) {
            this.minArrowField.setEnabled(false);
            this.minArrowLabel.setEnabled(false);
            this.maxArrowField.setEnabled(false);
            this.maxArrowLabel.setEnabled(false);
            this.basePairScaleLabel.setEnabled(false);
            this.basePairScaleField.setEnabled(false);
        } else {
            this.fixedArrowField.setEnabled(false);
        }
        arrowPanel.add((Component)this.fixedArrowButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        arrowPanel.add((Component)this.fixedArrowLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 0), 0, 0));
        arrowPanel.add((Component)this.fixedArrowField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 40), 0, 0));
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(150, 2));
        sep.setSize(150, 2);
        arrowPanel.add((Component)sep, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 15, 0, 15), 0, 0));
        arrowPanel.add((Component)this.scaledArrowButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        arrowPanel.add((Component)this.basePairScaleLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        arrowPanel.add((Component)this.basePairScaleField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 40), 0, 0));
        arrowPanel.add((Component)this.minArrowLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        arrowPanel.add((Component)this.minArrowField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 40), 0, 0));
        arrowPanel.add((Component)this.maxArrowLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        arrowPanel.add((Component)this.maxArrowField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 40), 0, 0));
        ParameterPanel openPanel = new ParameterPanel("Intergenic or Unsampled Region Dimensions");
        openPanel.setLayout(new GridBagLayout());
        this.fixedOpenBox = this.createCheckBox("Use Fixed Intergenic Length (1 pixel)", "fixed-open-length", listener, this.isFixedOpenLength);
        this.maxOpenLabel = new JLabel("Max Intergenic (or unsampled) Length");
        this.maxOpenField = new JTextField(String.valueOf(this.maxOpenLength));
        this.maxOpenField.setPreferredSize(dim);
        this.maxOpenField.setSize(dim);
        boolean fixedOpen = this.fixedOpenBox.isSelected();
        this.maxOpenField.setEnabled(!fixedOpen);
        this.maxOpenLabel.setEnabled(!fixedOpen);
        openPanel.add((Component)this.fixedOpenBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        openPanel.add((Component)this.maxOpenLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 0), 0, 0));
        openPanel.add((Component)this.maxOpenField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 40), 0, 0));
        ParameterPanel repPanel = new ParameterPanel("Locus Replicate Rendering");
        repPanel.setLayout(new GridBagLayout());
        String label = "<html><body>This option will display an arrow";
        label = label + " for each of the spots related to the locus.<br>";
        label = label + "Because of the complex structure, arrow lengths and intergenic lengths <br>will be fixed when this option is selected.</body><html>";
        JLabel repLabel = new JLabel(label);
        this.showReplicatesBox = this.createCheckBox("Show Locus Replicates (representative spots)", "show-reps-command", listener, showReps);
        repPanel.add((Component)repLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        repPanel.add((Component)this.showReplicatesBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        panel.add((Component)arrowPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)openPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)repPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.reconfigureButtons(listener);
        this.addContent(panel);
        this.setActionListeners(listener);
        this.pack();
    }

    public void showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
    }

    public int getFixedArrowLength() {
        return Integer.parseInt(this.fixedArrowField.getText());
    }

    public int getMinArrowLength() {
        return Integer.parseInt(this.minArrowField.getText());
    }

    public int getMaxArrowLength() {
        return Integer.parseInt(this.maxArrowField.getText());
    }

    public int getScalingFactor() {
        return Integer.parseInt(this.basePairScaleField.getText());
    }

    public int getMaxIntergenicLength() {
        return Integer.parseInt(this.maxOpenField.getText());
    }

    public boolean areArrowsFixed() {
        return this.fixedArrowButton.isSelected();
    }

    public boolean areOpenAreasFixed() {
        return this.fixedOpenBox.isSelected();
    }

    public boolean showAllReplicates() {
        return this.showReplicatesBox.isSelected();
    }

    private void previewSettings() {
        if (!this.validateValues()) {
            return;
        }
        System.out.println("preview method, fixed arrows = " + this.fixedArrowButton.isSelected());
        System.out.println("preview method, fixed arrows, methodCall = " + this.areArrowsFixed());
        Properties props = new Properties();
        props.setProperty("fixed-arrows", String.valueOf(this.areArrowsFixed()));
        props.setProperty("fixed-arrow-length", String.valueOf(this.getFixedArrowLength()));
        props.setProperty("scaling-factor", String.valueOf(this.getScalingFactor()));
        props.setProperty("min-arrow-length", String.valueOf(this.getMinArrowLength()));
        props.setProperty("max-arrow-length", String.valueOf(this.getMaxArrowLength()));
        props.setProperty("fixed-open", String.valueOf(this.areOpenAreasFixed()));
        props.setProperty("max-open-length", String.valueOf(this.getMaxIntergenicLength()));
        props.setProperty("show-replicates", String.valueOf(this.showAllReplicates()));
        this.lem.setViewerSettings(props);
    }

    private void reconfigureButtons(Listener listener) {
        JButton previewButton = new JButton("Preview");
        previewButton.setBorder(BorderFactory.createBevelBorder(0));
        previewButton.setFocusPainted(false);
        previewButton.setActionCommand("preview-command");
        previewButton.addActionListener(listener);
        Dimension dim = new Dimension(65, 30);
        previewButton.setPreferredSize(dim);
        previewButton.setSize(dim);
        this.okButton.setText("Apply");
        Component[] comp = this.buttonPanel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            this.buttonPanel.remove(comp[i]);
        }
        this.buttonPanel.add(comp[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[1], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 10, 2, 0), 0, 0));
        this.buttonPanel.add((Component)previewButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[2], new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[3], new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[4], new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
    }

    private boolean validateValues() {
        int val;
        boolean valid;
        block17: {
            valid = true;
            int level = 0;
            if (this.areArrowsFixed()) {
                try {
                    val = Integer.parseInt(this.fixedArrowField.getText());
                    if (val < 15) {
                        JOptionPane.showMessageDialog(this, "The Fixed Arrow Length should be >= 15 pixels. Please try again.", "Invalid Entry", 0);
                        this.fixedArrowField.grabFocus();
                        this.fixedArrowField.selectAll();
                        return false;
                    }
                    break block17;
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, "The Fixed Arrow Length value format is not a valid entry. Please try again.", "Invalid Entry", 0);
                    this.fixedArrowField.grabFocus();
                    this.fixedArrowField.selectAll();
                    return false;
                }
            }
            try {
                val = Integer.parseInt(this.basePairScaleField.getText());
                if (val < 1) {
                    JOptionPane.showMessageDialog(this, "The Scaling Factor should be > 1 base/pixel. Please try again.", "Invalid Entry", 0);
                    this.basePairScaleField.grabFocus();
                    this.basePairScaleField.selectAll();
                    return false;
                }
                ++level;
                int minVal = Integer.parseInt(this.minArrowField.getText());
                ++level;
                int maxVal = Integer.parseInt(this.maxArrowField.getText());
                ++level;
                if (minVal < 15 || maxVal < 15 || maxVal <= minVal) {
                    JOptionPane.showMessageDialog(this, "The min and max values are invalid. (Valid Range: 15 <= min < max). Please try again.", "Invalid Entry", 0);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                String fieldName = "";
                if (level == 0) {
                    fieldName = "The Scaling Factor ";
                    this.basePairScaleField.grabFocus();
                    this.basePairScaleField.selectAll();
                } else if (level == 1) {
                    fieldName = "The Minium Arrow Length ";
                    this.minArrowField.grabFocus();
                    this.minArrowField.selectAll();
                } else if (level == 2) {
                    fieldName = "The Maximum Arrow Length ";
                    this.maxArrowField.grabFocus();
                    this.maxArrowField.selectAll();
                }
                JOptionPane.showMessageDialog(this, fieldName + "value format is not a valid entry. Please try again.", "Invalid Entry", 0);
                return false;
            }
        }
        if (!this.fixedOpenBox.isSelected()) {
            try {
                val = Integer.parseInt(this.maxOpenField.getText());
                if (val <= 0) {
                    JOptionPane.showMessageDialog(this, "Maximum Intergenic Length must be > 0. Please try again.", "Invalid Entry", 0);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "Maximum Intergenic Length value format is not a valid entry. Please try again.", "Invalid Entry", 0);
                this.maxOpenField.grabFocus();
                this.maxOpenField.selectAll();
                return false;
            }
        }
        return valid;
    }

    private JCheckBox createCheckBox(String text, String command, Listener listener, boolean selected) {
        JCheckBox box = new JCheckBox(text, selected);
        box.setOpaque(false);
        box.setFocusPainted(false);
        box.setActionCommand(command);
        box.addActionListener(listener);
        return box;
    }

    private JRadioButton createRadioButton(String text, String command, Listener listener, boolean selected, ButtonGroup bg) {
        JRadioButton button = new JRadioButton(text, selected);
        bg.add(button);
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setActionCommand(command);
        button.addActionListener(listener);
        return button;
    }

    private void validateControls() {
        boolean showReplicates = this.showAllReplicates();
        if (showReplicates) {
            this.fixedArrowButton.setSelected(true);
            this.fixedOpenBox.setSelected(true);
        }
        boolean enable = this.fixedArrowButton.isSelected();
        this.fixedArrowLabel.setEnabled(enable);
        this.fixedArrowField.setEnabled(enable);
        this.minArrowLabel.setEnabled(!enable);
        this.minArrowField.setEnabled(!enable);
        this.maxArrowLabel.setEnabled(!enable);
        this.maxArrowField.setEnabled(!enable);
        this.basePairScaleLabel.setEnabled(!enable);
        this.basePairScaleField.setEnabled(!enable);
        enable = this.fixedOpenBox.isSelected();
        this.maxOpenField.setEnabled(!enable);
        this.maxOpenLabel.setEnabled(!enable);
    }

    private void resetControls() {
        this.fixedArrowButton.setSelected(this.isFixedArrowLength);
        this.fixedArrowField.setText(String.valueOf(this.fixedArrowLength));
        this.basePairScaleField.setText(String.valueOf(this.bpPerPixel));
        this.minArrowField.setText(String.valueOf(this.minArrowLength));
        this.maxArrowField.setText(String.valueOf(this.maxArrowLength));
        this.fixedOpenBox.setSelected(this.isFixedOpenLength);
        this.maxOpenField.setText(String.valueOf(this.fixedArrowLength));
        this.showReplicatesBox.setSelected(this.showReps);
    }

    public class Listener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            LEMViewerAttributeDialog.this.validateControls();
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                LEMViewerAttributeDialog.this.previewSettings();
                LEMViewerAttributeDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                LEMViewerAttributeDialog.this.resetControls();
                LEMViewerAttributeDialog.this.previewSettings();
            } else if (command.equals("preview-command")) {
                LEMViewerAttributeDialog.this.previewSettings();
            } else if (command.equals("cancel-command")) {
                LEMViewerAttributeDialog.this.resetControls();
                LEMViewerAttributeDialog.this.previewSettings();
                LEMViewerAttributeDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(LEMViewerAttributeDialog.this, "LEM Customization Dialog");
            }
        }

        @Override
        public void windowClosed(WindowEvent we) {
            LEMViewerAttributeDialog.this.resetControls();
            LEMViewerAttributeDialog.this.previewSettings();
            LEMViewerAttributeDialog.this.dispose();
        }
    }
}

