/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;
import org.tigr.util.FloatMatrix;

public class LEMThumbNail
extends JDialog {
    private IFramework framework;
    private Canvas canvas;
    private ControlPanel navPanel;
    private JScrollPane pane;
    private LinearExpressionMapViewer parent;
    private int initHeight = 500;
    private int initWidth = 200;
    private int navInitWidth = 200;
    private int navInitHeight = 200;
    private int maxY = 0;
    private int[] startValues;
    private int[] endValues;
    private boolean[] isForward;
    private String[] locusIDs;
    private int[] strata;
    private int maxStrata;
    private boolean isFixedLength;
    public static final int TOP_WINDOW = 0;
    public static final int PREV_WINDOW = 1;
    public static final int NEXT_WINDOW = 2;
    public static final int END_WINDOW = 3;

    public LEMThumbNail(IFramework framework, LinearExpressionMapViewer parent, int[] startCoords, int[] endCoords, FloatMatrix fm, float upperThr, float lowerThr, Color upperColor, Color lowerColor, Color midColor, int parentHeight, int mainViewY1, int mainViewY2, String locusIDFieldName) {
        super(framework.getFrame(), "LEM Explorer", false);
        this.framework = framework;
        this.parent = parent;
        this.startValues = parent.getStartValues();
        this.endValues = parent.getEndValues();
        this.isForward = parent.getDirectionArray();
        this.locusIDs = parent.getLocusIDArray();
        this.strata = parent.getStrata();
        this.maxStrata = parent.getMaxStrata();
        this.isFixedLength = parent.areArrowLengthsFixed();
        Listener listener = new Listener();
        this.canvas = new Canvas(startCoords, endCoords, fm, parentHeight, mainViewY1, mainViewY2, listener);
        this.navPanel = new ControlPanel(listener, locusIDFieldName);
        this.pane = new JScrollPane();
        this.pane.setViewportView(this.canvas);
        Point parentLoc = parent.getParent().getLocationOnScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int h = Math.min(this.initHeight, screenSize.height - parentLoc.y);
        this.setSizes(this.initWidth, h < 400 ? 400 : h);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        Dimension dim = new Dimension(this.initWidth, 50);
        controlPanel.setPreferredSize(dim);
        controlPanel.setSize(dim);
        JButton syncButton = new JButton("Update Overlay Window");
        syncButton.setFocusPainted(false);
        syncButton.setBorder(BorderFactory.createBevelBorder(0));
        syncButton.setActionCommand("sync-view-overlay-command");
        syncButton.addActionListener(listener);
        syncButton.setPreferredSize(new Dimension(150, 30));
        syncButton.setSize(150, 30);
        controlPanel.add((Component)syncButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        mainPanel.add((Component)this.pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        mainPanel.add((Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.05, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        mainPanel.add((Component)this.navPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.05, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.navPanel.tabs.setSelectedIndex(1);
        this.pack();
        this.navPanel.tabs.setSelectedIndex(0);
    }

    public void showThumbnail() {
        Point parentLoc = this.parent.getParent().getLocationOnScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (parentLoc != null && parentLoc.x - this.getWidth() > 0 && parentLoc.y > 0) {
            this.setLocation(parentLoc.x - this.getWidth(), parentLoc.y - this.parent.getHeaderComponent().getHeight());
        } else {
            this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        }
        this.show();
    }

    public void hideThumbnail() {
        this.dispose();
    }

    public void setIsFixedLength(boolean fixed) {
        this.isFixedLength = fixed;
    }

    private void setSizes(int w, int h) {
        this.setSize(w, h);
        this.pane.setSize(w, h - this.navInitHeight);
        this.pane.setPreferredSize(new Dimension(w, h - this.navInitHeight));
        this.canvas.setSize(w, this.locusIDs.length + 1);
        this.canvas.setPreferredSize(new Dimension(w, this.locusIDs.length));
    }

    public void updateCoords(int[] start, int[] end, int parentHeight) {
        this.canvas.updateCoords(start, end, parentHeight);
    }

    private void jumpToLocation(int y) {
        if (y > this.maxY || !this.parent.isVisible()) {
            return;
        }
        int[] yClipBounds = this.parent.getYClipBounds();
        float loc = Math.min(this.canvas.start[y], this.canvas.end[y]);
        this.framework.setContentLocation(0, (int)loc);
        this.canvas.viewerY1 = y;
        this.canvas.viewerY2 = y + Math.round((float)this.maxY * ((float)(yClipBounds[1] - yClipBounds[0]) / (float)this.canvas.parentHeight));
        this.canvas.repaint();
    }

    private void jumpToMainViewerLocation(int y) {
        int[] yClipBounds = this.parent.getYClipBounds();
        if (yClipBounds[1] - yClipBounds[0] > this.canvas.parentHeight) {
            return;
        }
        this.framework.setContentLocation(0, y);
        this.canvas.viewerY1 = (int)((float)this.maxY * ((float)y / (float)this.canvas.parentHeight));
        this.canvas.viewerY2 = this.canvas.viewerY1 + Math.round((float)this.maxY * ((float)(yClipBounds[1] - yClipBounds[0]) / (float)this.canvas.parentHeight));
        this.canvas.repaint();
    }

    private void scrollPaneToStart() {
        this.pane.getViewport().setViewPosition(new Point(0, 0));
        this.pane.validate();
    }

    private void scrollPaneToEnd() {
        this.pane.getViewport().setViewPosition(new Point(0, this.canvas.getHeight() - (this.canvas.viewerY2 - this.canvas.viewerY2)));
        this.pane.validate();
    }

    private void windowJump(int mode) {
        int[] yClipBounds = this.parent.getYClipBounds();
        switch (mode) {
            case 0: {
                this.jumpToMainViewerLocation(0);
                this.scrollPaneToStart();
                break;
            }
            case 2: {
                if (yClipBounds[1] >= this.canvas.parentHeight) {
                    this.jumpToLocation(0);
                    break;
                }
                this.jumpToMainViewerLocation(yClipBounds[1]);
                break;
            }
            case 1: {
                if (yClipBounds[0] < yClipBounds[1] - yClipBounds[0]) {
                    this.windowJump(3);
                    break;
                }
                this.jumpToMainViewerLocation(2 * yClipBounds[0] - yClipBounds[1]);
                break;
            }
            case 3: {
                this.jumpToMainViewerLocation(this.canvas.parentHeight - (yClipBounds[1] - yClipBounds[0]));
                this.scrollPaneToEnd();
            }
        }
    }

    private void jumpToBasePairLocataion() {
        int loc = this.navPanel.getSelectedLocation();
        if (loc < 0) {
            JOptionPane.showMessageDialog(this, "Improper BP location value.", "Format Error", 0);
            return;
        }
        int[] yClipBounds = this.parent.getYClipBounds();
        int viewerY = this.parent.jumpToLocation(loc);
        if (viewerY >= 0) {
            int y = Math.round((float)this.maxY * ((float)viewerY / (float)this.canvas.parentHeight));
            this.canvas.viewerY1 = y;
            this.canvas.viewerY2 = y + Math.round((float)this.maxY * ((float)(yClipBounds[1] - yClipBounds[0]) / (float)this.canvas.parentHeight));
            this.canvas.repaint();
        }
    }

    private void jumpToLocusLocation() {
        String locusID = this.navPanel.getLocusID();
        int[] yClipBounds = this.parent.getYClipBounds();
        int viewerY = this.parent.jumpToLocus(locusID);
        if (viewerY >= 0) {
            int y = Math.round((float)this.maxY * ((float)viewerY / (float)this.canvas.parentHeight));
            this.canvas.viewerY1 = y;
            this.canvas.viewerY2 = y + Math.round((float)this.maxY * ((float)(yClipBounds[1] - yClipBounds[0]) / (float)this.canvas.parentHeight));
            this.canvas.repaint();
        }
    }

    private void syncOverlayPosition() {
        int[] yClipBounds = this.parent.getYClipBounds();
        this.canvas.viewerY1 = Math.round((float)yClipBounds[0] * ((float)this.maxY / (float)this.canvas.parentHeight));
        this.canvas.viewerY2 = this.canvas.viewerY1 + Math.round((float)this.maxY * ((float)(yClipBounds[1] - yClipBounds[0]) / (float)this.canvas.parentHeight));
        this.canvas.repaint();
    }

    public class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        @Override
        public void mouseClicked(MouseEvent me) {
            LEMThumbNail.this.jumpToLocation(me.getY());
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            LEMThumbNail.this.canvas.cursorOnTop = true;
        }

        @Override
        public void mouseExited(MouseEvent me) {
            LEMThumbNail.this.canvas.cursorOnTop = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            LEMThumbNail.this.canvas.cursorY = e.getY();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("sync-view-overlay-command")) {
                LEMThumbNail.this.syncOverlayPosition();
            } else if (command.equals("jump-to-top-command")) {
                LEMThumbNail.this.windowJump(0);
            } else if (command.equals("jump-to-next-command")) {
                LEMThumbNail.this.windowJump(2);
            } else if (command.equals("jump-to-previous-command")) {
                LEMThumbNail.this.windowJump(1);
            } else if (command.equals("jump-to-end-command")) {
                LEMThumbNail.this.windowJump(3);
            } else if (command.equals("jump-to-location-command")) {
                LEMThumbNail.this.jumpToBasePairLocataion();
            } else if (command.equals("jump-to-id-command")) {
                LEMThumbNail.this.jumpToLocusLocation();
            }
        }
    }

    public class ControlPanel
    extends JPanel {
        private JTextField idField;
        private JTextField locField;
        JTabbedPane tabs = new JTabbedPane();

        public ControlPanel(Listener listener, String locusIDFieldName) {
            Dimension dim = new Dimension(LEMThumbNail.this.navInitWidth, LEMThumbNail.this.navInitHeight);
            this.tabs.setPreferredSize(dim);
            this.tabs.setSize(dim);
            ParameterPanel windowPanel = new ParameterPanel("Navigate by Window Steps");
            windowPanel.setLayout(new GridBagLayout());
            windowPanel.setPreferredSize(dim);
            windowPanel.setSize(dim);
            JButton prevWindowButton = new JButton("Prev.", GUIFactory.getIcon("nav_arrow_up.gif"));
            prevWindowButton.setHorizontalTextPosition(2);
            prevWindowButton.setFocusPainted(false);
            prevWindowButton.setActionCommand("jump-to-previous-command");
            prevWindowButton.addActionListener(listener);
            JButton nextWindowButton = new JButton("Next", GUIFactory.getIcon("nav_arrow_down.gif"));
            nextWindowButton.setHorizontalTextPosition(2);
            nextWindowButton.setFocusPainted(false);
            nextWindowButton.setActionCommand("jump-to-next-command");
            nextWindowButton.addActionListener(listener);
            JButton topWindowButton = new JButton("Start", GUIFactory.getIcon("nav_arrow_top.gif"));
            topWindowButton.setHorizontalTextPosition(2);
            topWindowButton.setFocusPainted(false);
            topWindowButton.setActionCommand("jump-to-top-command");
            topWindowButton.addActionListener(listener);
            JButton bottomWindowButton = new JButton("End", GUIFactory.getIcon("nav_arrow_end.gif"));
            bottomWindowButton.setHorizontalTextPosition(2);
            bottomWindowButton.setFocusPainted(false);
            bottomWindowButton.setActionCommand("jump-to-end-command");
            bottomWindowButton.addActionListener(listener);
            windowPanel.add((Component)topWindowButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
            windowPanel.add((Component)prevWindowButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            windowPanel.add((Component)bottomWindowButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            windowPanel.add((Component)nextWindowButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.tabs.add("Window Stepping", windowPanel);
            ParameterPanel idPanel = new ParameterPanel("Gene ID Navigation");
            idPanel.setLayout(new GridBagLayout());
            idPanel.setPreferredSize(dim);
            idPanel.setSize(dim);
            JLabel geneIDLabel = new JLabel("Enter Gene ID:");
            JLabel geneIDFieldLabel = new JLabel("(" + locusIDFieldName + ")");
            this.idField = new JTextField();
            JButton idGOButton = new JButton("Find Gene");
            idGOButton.setFocusPainted(false);
            idGOButton.setActionCommand("jump-to-id-command");
            idGOButton.setPreferredSize(new Dimension(120, 30));
            idGOButton.setSize(120, 30);
            idGOButton.addActionListener(listener);
            idPanel.add((Component)geneIDLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            idPanel.add((Component)this.idField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            idPanel.add((Component)geneIDFieldLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
            idPanel.add((Component)idGOButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tabs.add("Gene Locator", idPanel);
            ParameterPanel locPanel = new ParameterPanel("Location Navigation");
            locPanel.setLayout(new GridBagLayout());
            locPanel.setPreferredSize(dim);
            locPanel.setSize(dim);
            JLabel locLabel = new JLabel("Base Pair Location:");
            this.locField = new JTextField();
            JButton locButton = new JButton("Find Location");
            locButton.setFocusPainted(false);
            locButton.setActionCommand("jump-to-location-command");
            locButton.setPreferredSize(new Dimension(120, 30));
            locButton.setSize(120, 30);
            locButton.addActionListener(listener);
            locPanel.add((Component)locLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            locPanel.add((Component)this.locField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            locPanel.add((Component)locButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.tabs.add("Base Locator", locPanel);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String getLocusID() {
            return this.idField.getText();
        }

        public int getSelectedLocation() {
            int location = -1;
            try {
                location = Integer.parseInt(this.locField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return location;
        }
    }

    public class Canvas
    extends JPanel {
        private int[] start;
        private int[] end;
        private FloatMatrix matrix;
        private int numSamples;
        private int parentHeight;
        private int currHeight;
        private int cursorY;
        private boolean cursorOnTop = false;
        private int viewerY1 = 0;
        private int viewerY2 = 0;

        public Canvas(int[] startCoords, int[] endCoords, FloatMatrix fm, int parentHeight, int y1, int y2, Listener listener) {
            this.start = startCoords;
            this.end = endCoords;
            this.matrix = fm;
            this.parentHeight = parentHeight;
            this.numSamples = fm.getColumnDimension();
            LEMThumbNail.this.initHeight = fm.getRowDimension();
            this.viewerY1 = (int)((float)LEMThumbNail.this.initHeight * ((float)y1 / (float)parentHeight));
            this.viewerY2 = (int)((float)LEMThumbNail.this.initHeight * ((float)y2 / (float)parentHeight));
            this.setBackground(Color.white);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseMotionListener(listener);
            this.addMouseListener(listener);
        }

        @Override
        public String getToolTipText() {
            if (this.cursorY >= 0 && this.cursorY < this.start.length) {
                return LEMThumbNail.this.locusIDs[this.cursorY] + ", " + String.valueOf(LEMThumbNail.this.startValues[this.cursorY] + ", " + String.valueOf(LEMThumbNail.this.endValues[this.cursorY]));
            }
            return null;
        }

        public void updateCoords(int[] start, int[] end, int parentHeight) {
            this.start = start;
            this.end = end;
            this.parentHeight = parentHeight;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.currHeight = this.getHeight();
            int currWidth = this.getWidth();
            float convFactor = (float)this.currHeight / (float)this.parentHeight;
            int xStep = !LEMThumbNail.this.isFixedLength ? currWidth / (this.numSamples * (LEMThumbNail.this.maxStrata + 1)) : currWidth / this.numSamples;
            int elementInset = 0;
            int elementWidth = 0;
            if (xStep > 5) {
                elementInset = xStep / 4;
                elementWidth = xStep - elementInset;
            }
            int currY = 0;
            int deltaY = 0;
            for (int i = 0; i < this.start.length; ++i) {
                int currX = 0;
                deltaY = 1;
                if (!LEMThumbNail.this.isFixedLength) {
                    currX += LEMThumbNail.this.strata[i] * xStep;
                }
                for (int j = 0; j < this.numSamples; ++j) {
                    g.setColor(LEMThumbNail.this.parent.getColor(this.matrix.get(i, j)));
                    if (elementWidth > 0) {
                        g.fillRect(currX + elementInset, currY, elementWidth, deltaY);
                    } else {
                        g.fillRect(currX, currY, xStep, deltaY);
                    }
                    if (!LEMThumbNail.this.isFixedLength) {
                        currX += xStep * (LEMThumbNail.this.maxStrata + 1);
                        continue;
                    }
                    currX += xStep;
                }
                currY += deltaY;
            }
            LEMThumbNail.this.maxY = currY;
            g.setColor(Color.blue);
            g.drawRect(0, this.viewerY1, currWidth, this.viewerY2 - this.viewerY1);
            g.drawRect(1, this.viewerY1 + 1, currWidth - 2, this.viewerY2 - this.viewerY1 - 2);
        }
    }
}

