/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.graph.GraphViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class LEMSelectionEditor
extends AlgorithmDialog {
    private JTable selectionList;
    private LinearExpressionMapViewer lem;
    private SelectionTableModel model;
    private JTable table;
    private JMenu saveSelectedMenu;
    private JMenu fileMenu;
    private JPanel mainpanel;
    private JTextPane infoPane;
    private ParameterPanel locusTablePanel;
    private String infoText;
    private IData data;
    private int numSamples;
    private Vector selectedIndices;
    private FloatMatrix meanMatrix;
    private JCheckBoxMenuItem coloredLociBox;
    private JMenuItem hideGraphItem;
    private boolean showGraph;
    private LocusGraph locusGraph;

    public LEMSelectionEditor(JFrame frame, LinearExpressionMapViewer lem, Vector selectedIndices) {
        super(frame, "LEM Locus Selection List", false);
        this.lem = lem;
        this.meanMatrix = lem.getLocusMeanMatrix();
        this.numSamples = lem.getExperiment().getNumberOfSamples();
        this.selectedIndices = selectedIndices;
        this.showGraph = true;
        this.infoPane = new JTextPane();
        this.infoPane.setContentType("text/html");
        this.infoPane.setEditable(false);
        this.infoPane.setBackground(Color.white);
        this.infoPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.infoText = "<html><body><font size = 5><b><u><center>Locus Selection List</center></u></b></font>";
        this.infoText = this.infoText + "<center>Use <b>shift-left-click</b> on a locus arrow to add to the list.<br></center>";
        this.infoText = this.infoText + "</body></html>";
        this.infoPane.setText(this.infoText);
        this.infoPane.setMargin(new Insets(5, 20, 5, 20));
        Dimension dim = new Dimension(200, 80);
        this.infoPane.setPreferredSize(dim);
        this.infoPane.setSize(dim);
        JMenuBar menu = new JMenuBar();
        Listener listener = new Listener();
        this.fileMenu = new JMenu("File");
        this.saveSelectedMenu = new JMenu("Save Selected Loci");
        JMenuItem item = new JMenuItem("Locus Level Detail");
        item.setActionCommand("save-selected-loci-detail-command");
        item.addActionListener(listener);
        this.saveSelectedMenu.add(item);
        item = new JMenuItem("Spot Level Detail");
        item.setActionCommand("save-selected-spot-detail-command");
        item.addActionListener(listener);
        this.saveSelectedMenu.add(item);
        this.fileMenu.add(this.saveSelectedMenu);
        JMenu saveAllMenu = new JMenu("Save All Loci");
        item = new JMenuItem("Locus Level Detail");
        item.setActionCommand("save-all-loci-detail-command");
        item.addActionListener(listener);
        saveAllMenu.add(item);
        item = new JMenuItem("Spot Level Detail");
        item.setActionCommand("save-all-spot-detail-command");
        item.addActionListener(listener);
        saveAllMenu.add(item);
        this.fileMenu.add(saveAllMenu);
        JMenu selectMenu = new JMenu("Select");
        item = new JMenuItem("Locus List Selection");
        item.setActionCommand("loci-list-selection-command");
        item.addActionListener(listener);
        selectMenu.add(item);
        item = new JMenuItem("Base Range Selection");
        item.setActionCommand("base-range-selection-command");
        item.addActionListener(listener);
        selectMenu.add(item);
        JMenu viewerMenu = new JMenu("Graph Options");
        this.hideGraphItem = new JMenuItem("Hide Locus Graph");
        this.hideGraphItem.setActionCommand("toggle-hide-graph-command");
        this.hideGraphItem.addActionListener(listener);
        viewerMenu.add(this.hideGraphItem);
        this.coloredLociBox = new JCheckBoxMenuItem("Multi-colored Graphs", false);
        this.coloredLociBox.setActionCommand("toggle-multi-colored-graphs");
        this.coloredLociBox.addActionListener(listener);
        viewerMenu.add(this.coloredLociBox);
        menu.add(this.fileMenu);
        menu.add(selectMenu);
        menu.add(viewerMenu);
        menu.setBorder(BorderFactory.createLineBorder(Color.black));
        menu.setMinimumSize(new Dimension(100, 20));
        menu.setMaximumSize(new Dimension(1000, 20));
        LEMSelectionEditor dialog = this;
        this.table = new JTable();
        this.table.addMouseListener(listener);
        this.table.addKeyListener(listener);
        Vector<String> headerVector = new Vector<String>();
        headerVector.add("Locus");
        headerVector.add("5'");
        headerVector.add("3'");
        headerVector.add("# spots/locus");
        this.model = new SelectionTableModel(selectedIndices, headerVector);
        this.table.setModel(this.model);
        JScrollPane pane = new JScrollPane(this.table);
        dim = new Dimension(550, 150);
        pane.setPreferredSize(dim);
        pane.setSize(dim);
        this.mainpanel = new JPanel();
        this.mainpanel.setLayout(new GridBagLayout());
        this.locusTablePanel = new ParameterPanel("Selected Loci");
        this.locusTablePanel.setLayout(new GridBagLayout());
        dim.height = 200;
        this.locusTablePanel.setPreferredSize(dim);
        this.locusTablePanel.setSize(dim);
        this.locusTablePanel.add((Component)pane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainpanel.add((Component)menu, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainpanel.add((Component)this.infoPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.locusGraph = new LocusGraph();
        this.mainpanel.add((Component)this.locusGraph, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainpanel.add((Component)this.locusTablePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.setText("Close");
        this.resetButton.setText("Remove Selected");
        dim = new Dimension(120, 30);
        this.resetButton.setPreferredSize(dim);
        this.resetButton.setSize(dim);
        this.cancelButton.setText("Clear All");
        this.cancelButton.setPreferredSize(dim);
        this.cancelButton.setSize(dim);
        this.validateMenuItemsAndButtons();
        this.addContent(this.mainpanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
    }

    public void updateSelectionText() {
        this.infoText = "<html><body><font size = 5><b><u><center>Locus Selection List</center></u></b></font>";
        this.infoText = this.infoText + "<center>Use <b>shift-left-click</b> on a locus arrow to add to the list.<br>";
        this.infoText = this.infoText + "Number of Loci in the List: <b>" + this.model.getRowCount() + "</b></center></body></html>";
        this.infoPane.setText(this.infoText);
        this.infoPane.setCaretPosition(0);
    }

    private void validateMenuItemsAndButtons() {
        boolean isNotEmpty = this.table.getRowCount() > 0;
        this.fileMenu.setEnabled(isNotEmpty);
        this.resetButton.setEnabled(isNotEmpty);
        this.cancelButton.setEnabled(isNotEmpty);
        int[] selRows = this.table.getSelectedRows();
        this.saveSelectedMenu.setEnabled(selRows != null && selRows.length > 0);
    }

    public void showDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.validateMenuItemsAndButtons();
        this.updateSelectionText();
        this.show();
    }

    public void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
    }

    public void fireLocusAdded() {
        this.model.sortByMinLocation();
        this.model.fireRowInserted();
        this.validateMenuItemsAndButtons();
        this.updateSelectionText();
        this.locusGraph.refresh();
    }

    public void fireLocusRemoved() {
        this.model.sortByMinLocation();
        this.model.fireRowDeleted();
        this.validateMenuItemsAndButtons();
        this.updateSelectionText();
        this.locusGraph.refresh();
    }

    public void removeSelectedLoci() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        this.model.removeSelectedRows(rows);
        this.lem.repaint();
    }

    public boolean clearAll() {
        boolean cleared = false;
        if (JOptionPane.showConfirmDialog(this, "Are you sure you are ready to clear the list?", "Clear All Selected Loci", 0) == 0) {
            this.model.removeAllRows();
            cleared = true;
            this.lem.repaint();
        }
        return cleared;
    }

    private int[] getSelectedLocusIndices() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return new int[0];
        }
        return this.model.getLocusIndices(rows);
    }

    public void saveSelectedLoci() {
        this.lem.saveLocusList(this.getSelectedLocusIndices());
    }

    public void saveSelectedSpotDetail() {
        this.lem.saveSpotsForLocusList(this.getSelectedLocusIndices());
    }

    public void saveAllLoci() {
        this.lem.saveLocusList(this.model.getAllLocusIndices());
    }

    public void saveAllSpotDetai() {
        this.lem.saveSpotsForLocusList(this.model.getAllLocusIndices());
    }

    public void baseRangeSelection() {
        if (this.lem.selectBaseRange()) {
            this.locusGraph.refresh();
        }
    }

    private void toggleLocusGraph() {
        this.showGraph = !this.showGraph;
        this.coloredLociBox.setEnabled(this.showGraph);
        int componentCount = this.mainPanel.getComponentCount();
        if (!this.showGraph) {
            this.hideGraphItem.setText("Show Locus Graph");
            this.mainpanel.remove(this.locusTablePanel);
            this.mainpanel.remove(this.locusGraph);
            this.mainpanel.add((Component)this.locusTablePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.hideGraphItem.setText("Hide Locus Graph");
            this.mainpanel.remove(this.locusTablePanel);
            this.locusGraph.refresh();
            this.mainpanel.add((Component)this.locusGraph, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.mainpanel.add((Component)this.locusTablePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.validate();
        this.pack();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    MouseListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                LEMSelectionEditor.this.dispose();
            } else if (command.equals("cancel-command")) {
                if (LEMSelectionEditor.this.clearAll()) {
                    LEMSelectionEditor.this.validateMenuItemsAndButtons();
                    LEMSelectionEditor.this.locusGraph.refresh();
                }
            } else if (command.equals("reset-command")) {
                LEMSelectionEditor.this.removeSelectedLoci();
                LEMSelectionEditor.this.validateMenuItemsAndButtons();
                LEMSelectionEditor.this.locusGraph.refresh();
            } else if (!command.equals("info-command")) {
                if (command.equals("save-selected-spot-detail-command")) {
                    LEMSelectionEditor.this.saveSelectedSpotDetail();
                } else if (command.equals("save-selected-loci-detail-command")) {
                    LEMSelectionEditor.this.saveSelectedLoci();
                } else if (command.equals("save-all-loci-detail-command")) {
                    LEMSelectionEditor.this.saveAllLoci();
                } else if (command.equals("save-all-spot-detail-command")) {
                    LEMSelectionEditor.this.saveAllSpotDetai();
                } else if (!command.equals("loci-list-selection-command")) {
                    if (command.equals("base-range-selection-command")) {
                        LEMSelectionEditor.this.baseRangeSelection();
                    } else if (command.equals("toggle-multi-colored-graphs")) {
                        LEMSelectionEditor.this.locusGraph.toggleMultiColored();
                    } else if (command.equals("toggle-hide-graph-command")) {
                        LEMSelectionEditor.this.toggleLocusGraph();
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LEMSelectionEditor.this.validateMenuItemsAndButtons();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LEMSelectionEditor.this.validateMenuItemsAndButtons();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LEMSelectionEditor.this.validateMenuItemsAndButtons();
            LEMSelectionEditor.this.locusGraph.refresh();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                LEMSelectionEditor.this.locusGraph.refresh();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class LocusGraph
    extends JPanel {
        private GraphViewer graph;
        private Vector lineColorVector;
        private int numberOfLineColors;
        private boolean multiColored;
        private KeyPanel key;
        private JScrollPane keyPane;

        public LocusGraph() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.multiColored = false;
            this.lineColorVector = new Vector();
            this.lineColorVector.add(Color.magenta);
            this.lineColorVector.add(new Color(0, 143, 0));
            this.lineColorVector.add(Color.cyan);
            this.lineColorVector.add(Color.blue);
            this.lineColorVector.add(Color.red);
            this.lineColorVector.add(Color.black);
            this.lineColorVector.add(Color.pink);
            this.lineColorVector.add(Color.gray);
            this.lineColorVector.add(Color.green);
            this.numberOfLineColors = this.lineColorVector.size();
            this.graph = this.createGraphViewer();
            this.add((Component)this.graph, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.key = new KeyPanel();
            this.keyPane = new JScrollPane(this.key);
            Dimension dim = new Dimension(180, 150);
            this.keyPane.setPreferredSize(dim);
            this.keyPane.setSize(dim);
        }

        public void createNewGraph() {
            GraphViewer newGraph = this.createGraphViewer();
            this.removeAll();
            if (this.multiColored) {
                this.key.updateSize();
                this.add((Component)newGraph, new GridBagConstraints(0, 0, 1, 1, 0.7, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.keyPane, new GridBagConstraints(1, 0, 1, 1, 0.3, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.add((Component)newGraph, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.graph = newGraph;
            this.validate();
        }

        public void refresh() {
            this.createNewGraph();
            this.key.updateSize();
        }

        public void toggleMultiColored() {
            this.multiColored = !this.multiColored;
            this.refresh();
        }

        public Color getLineColor(int index) {
            return (Color)this.lineColorVector.get(index % this.numberOfLineColors);
        }

        private GraphViewer createGraphViewer() {
            int i;
            Color lineColor = Color.magenta;
            String[] names = new String[LEMSelectionEditor.this.numSamples];
            int[] rows = LEMSelectionEditor.this.table.getSelectedRows();
            int[] indices = LEMSelectionEditor.this.model.getLocusIndices(LEMSelectionEditor.this.table.getSelectedRows());
            float[] maxAndMin = this.getMaxAndMin(LEMSelectionEditor.this.meanMatrix, indices);
            int upperY = (int)Math.ceil(maxAndMin[0] + 0.001f);
            int lowerY = (int)Math.floor(maxAndMin[1] - 0.001f);
            GraphViewer graph = new GraphViewer(null, 0, 425, 0, 300, 0.0, (double)LEMSelectionEditor.this.numSamples, (double)lowerY, (double)upperY, 40, 40, 40, 40, "Mean Locus Expression", "Sample Number", "Log\u2082(Cy5 / Cy3)");
            graph.setXAxisValue((double)lowerY);
            graph.setShowCoordinates(true);
            Dimension size = new Dimension(250, 250);
            graph.setPreferredSize(size);
            graph.setSize(size);
            GraphTick tick = new GraphTick(0.0, 8, Color.black, 0, 0, "", Color.black);
            graph.addGraphElement((GraphElement)tick);
            graph.addGraphElement((GraphElement)new GraphLine(0.0, 0.0, (double)LEMSelectionEditor.this.numSamples, 0.0, Color.black));
            for (i = 0; i < LEMSelectionEditor.this.numSamples - 1; ++i) {
                tick = new GraphTick((double)(i + 1), 8, Color.black, 0, 0, String.valueOf(i + 1), Color.black);
                graph.addGraphElement((GraphElement)tick);
            }
            tick = new GraphTick((double)LEMSelectionEditor.this.numSamples, 8, Color.black, 0, 0, String.valueOf(LEMSelectionEditor.this.numSamples), Color.black);
            graph.addGraphElement((GraphElement)tick);
            for (int locus = 0; locus < indices.length; ++locus) {
                int locusIndex = indices[locus];
                lineColor = (Color)this.lineColorVector.get(locus % this.numberOfLineColors);
                for (int i2 = 0; i2 < LEMSelectionEditor.this.numSamples - 1; ++i2) {
                    if (!Float.isNaN(((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2]) && !Float.isNaN(((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2 + 1])) {
                        if (this.multiColored) {
                            graph.addGraphElement((GraphElement)new GraphLine((double)(i2 + 1), (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2], (double)(i2 + 2), (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2 + 1], lineColor));
                        } else {
                            graph.addGraphElement((GraphElement)new GraphLine((double)(i2 + 1), (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2], (double)(i2 + 2), (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2 + 1], Color.magenta));
                        }
                    }
                    if (Float.isNaN(((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2])) continue;
                    graph.addGraphElement((GraphElement)new GraphPoint((double)(i2 + 1), (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][i2], Color.blue, 5));
                }
                if (Float.isNaN(((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][LEMSelectionEditor.this.numSamples - 1])) continue;
                graph.addGraphElement((GraphElement)new GraphPoint((double)LEMSelectionEditor.this.numSamples, (double)((LEMSelectionEditor)LEMSelectionEditor.this).meanMatrix.A[indices[locus]][LEMSelectionEditor.this.numSamples - 1], Color.blue, 5));
            }
            for (i = lowerY; i <= upperY; ++i) {
                tick = i == 0 ? new GraphTick((double)i, 8, Color.black, 1, 0, "0", Color.black) : new GraphTick((double)i, 8, Color.black, 1, 0, "" + i, Color.black);
                graph.addGraphElement((GraphElement)tick);
            }
            return graph;
        }

        private float[] getMaxAndMin(FloatMatrix meanMatrix, int[] indices) {
            float[] maxAndMin = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                for (int j = 0; j < meanMatrix.A[index].length; ++j) {
                    if (Float.isNaN(meanMatrix.A[index][j])) continue;
                    maxAndMin[0] = Math.max(maxAndMin[0], meanMatrix.A[index][j]);
                    maxAndMin[1] = Math.min(maxAndMin[1], meanMatrix.A[index][j]);
                }
            }
            if (maxAndMin[0] == Float.NEGATIVE_INFINITY) {
                maxAndMin[0] = 0.0f;
            }
            if (maxAndMin[1] == Float.POSITIVE_INFINITY) {
                maxAndMin[1] = 0.0f;
            }
            return maxAndMin;
        }

        public class KeyPanel
        extends JPanel {
            private JScrollPane pane;
            private int maxIDWidth;

            public KeyPanel() {
                this.setBackground(Color.white);
            }

            public void updateSize() {
                int[] indices = LEMSelectionEditor.this.table.getSelectedRows();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                if (fm == null) {
                    return;
                }
                int h = (int)((double)fm.getHeight() * 1.5) * indices.length;
                h = Math.max(LEMSelectionEditor.this.locusGraph.getHeight(), h);
                int stringWidth = 0;
                for (int i = 0; i < indices.length; ++i) {
                    stringWidth = Math.max(stringWidth, fm.stringWidth((String)LEMSelectionEditor.this.model.getValueAt(indices[i], 0)));
                }
                int w = stringWidth + 75;
                this.setPreferredSize(new Dimension(w, h));
                this.setSize(w, h);
            }

            @Override
            public void paint(Graphics g) {
                int h;
                super.paint(g);
                FontMetrics fm = g.getFontMetrics();
                int offset = h = (int)((double)fm.getHeight() * 1.5);
                int[] indices = LEMSelectionEditor.this.table.getSelectedRows();
                for (int i = 0; i < indices.length; ++i) {
                    String id = (String)LEMSelectionEditor.this.table.getValueAt(indices[i], 0);
                    g.setColor(LocusGraph.this.getLineColor(i));
                    g.drawLine(7, offset - 3, 55, offset - 3);
                    g.setColor(Color.blue);
                    g.fillRect(5, offset - 5, 5, 5);
                    g.fillRect(55, offset - 5, 5, 5);
                    g.setColor(Color.black);
                    g.drawString(id, 75, offset);
                    offset += h;
                }
            }
        }
    }

    public class SelectionTableModel
    extends AbstractTableModel {
        private Vector indices;
        private Vector headerNames;
        private int[] sortedIndices;

        public SelectionTableModel(Vector data, Vector header) {
            this.indices = data;
            this.headerNames = header;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return LEMSelectionEditor.this.lem.getLocusID(this.getLocusIndex(row));
            }
            if (col == 1) {
                return new Integer(LEMSelectionEditor.this.lem.getStart(this.getLocusIndex(row)));
            }
            if (col == 2) {
                return new Integer(LEMSelectionEditor.this.lem.getEnd(this.getLocusIndex(row)));
            }
            return new Integer(LEMSelectionEditor.this.lem.getNumReplicates(this.getLocusIndex(row)));
        }

        private int getLocusIndex(int row) {
            row = this.sortedIndices[row];
            return (Integer)this.indices.get(row);
        }

        public int[] getLocusIndices(int[] rows) {
            int[] locusIndices = new int[rows.length];
            for (int i = 0; i < locusIndices.length; ++i) {
                locusIndices[i] = this.getLocusIndex(rows[i]);
            }
            return locusIndices;
        }

        public int[] getAllLocusIndices() {
            int[] locusIndices = new int[this.getRowCount()];
            for (int i = 0; i < locusIndices.length; ++i) {
                locusIndices[i] = this.getLocusIndex(i);
            }
            return locusIndices;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.indices.size();
        }

        @Override
        public String getColumnName(int col) {
            return (String)this.headerNames.get(col);
        }

        public void fireRowInserted() {
            this.fireTableRowsInserted(this.indices.size() - 1, this.indices.size() - 1);
        }

        public void fireRowDeleted() {
            if (this.indices.size() > 0) {
                this.fireTableRowsDeleted(this.indices.size() - 1, this.indices.size() - 1);
            } else {
                this.fireTableRowsDeleted(-1, -1);
            }
        }

        public void removeSelectedRows(int[] rows) {
            int i;
            Object[] objs = new Object[rows.length];
            for (i = 0; i < rows.length; ++i) {
                objs[i] = this.indices.get(this.sortedIndices[rows[i]]);
            }
            for (i = 0; i < rows.length; ++i) {
                LEMSelectionEditor.this.lem.toggleSelectedLocus((Integer)objs[i]);
                this.fireRowDeleted();
            }
            this.sortByMinLocation();
        }

        public void removeAllRows() {
            int[] rows = new int[this.indices.size()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = i;
            }
            this.removeSelectedRows(rows);
            this.sortByMinLocation();
        }

        public void sortByMinLocation() {
            float[] minCoord = new float[this.getRowCount()];
            if (minCoord.length == 0) {
                this.sortedIndices = new int[0];
                return;
            }
            for (int row = 0; row < minCoord.length; ++row) {
                minCoord[row] = Math.min(LEMSelectionEditor.this.lem.getStart((Integer)this.indices.get(row)), LEMSelectionEditor.this.lem.getEnd((Integer)this.indices.get(row)));
            }
            QSort qsort = new QSort(minCoord);
            this.sortedIndices = qsort.getOrigIndx();
        }
    }
}

