/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;

public class LEMRangeSelectionDialog
extends AlgorithmDialog {
    private int result = 2;
    private JTextField lowField;
    private JTextField highField;
    private int upperCoord;

    public LEMRangeSelectionDialog(JFrame frame, int lowerLimit, int upperLimit) {
        super(frame, "Locus Range Selection", true);
        this.upperCoord = upperLimit;
        JLabel rangeLabel = new JLabel("Base Range Limits in Viewer:  [" + String.valueOf(lowerLimit) + ", " + String.valueOf(upperLimit) + "]");
        JLabel lowLabel = new JLabel("Lower Base Location Limit: ");
        this.lowField = new JTextField(12);
        Dimension dim = new Dimension(140, 20);
        this.lowField.setPreferredSize(dim);
        this.lowField.setSize(dim);
        JLabel highLabel = new JLabel("Higher Base Location Limit: ");
        this.highField = new JTextField(12);
        this.highField.setPreferredSize(dim);
        this.highField.setSize(dim);
        ParameterPanel panel = new ParameterPanel("Base Location Limits");
        panel.setLayout(new GridBagLayout());
        panel.add((Component)rangeLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 15, 0), 0, 0));
        panel.add((Component)lowLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 15, 0), 0, 0));
        panel.add((Component)this.lowField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 15, 0), 0, 0));
        panel.add((Component)highLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
        panel.add((Component)this.highField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 20, 0), 0, 0));
        this.addContent(panel);
        this.setActionListeners(new Listener());
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getLowerLimit() {
        return Integer.parseInt(this.lowField.getText());
    }

    public int getUpperLimit() {
        return Integer.parseInt(this.highField.getText());
    }

    private boolean validateValues() {
        boolean valid = true;
        try {
            int v1 = Integer.parseInt(this.lowField.getText());
            int v2 = Integer.parseInt(this.highField.getText());
            if (v2 <= v1) {
                valid = false;
                JOptionPane.showMessageDialog(this, "Range error: Upper Limit must be greater than lower limit.  Please check the entries.", "Range Error", 0);
            } else if (v1 > this.upperCoord) {
                valid = false;
                JOptionPane.showMessageDialog(this, "Range error: The lower limit is off of the supplied base range.  Please check the entries.", "Range Error", 0);
            } else if (v1 < 0 || v2 < 0) {
                valid = false;
                JOptionPane.showMessageDialog(this, "Range error: Values should be >= 0.  Please check the entries.", "Range Error", 0);
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "The entered values must be integer values.  Please check the entries.", "Number Format Problem", 0);
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        LEMRangeSelectionDialog dialog = new LEMRangeSelectionDialog(new JFrame(), 154, 12345);
        dialog.showModal();
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (LEMRangeSelectionDialog.this.validateValues()) {
                    LEMRangeSelectionDialog.this.result = 0;
                    LEMRangeSelectionDialog.this.dispose();
                }
            } else if (command.equals("cancel-command")) {
                LEMRangeSelectionDialog.this.result = 2;
                LEMRangeSelectionDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                LEMRangeSelectionDialog.this.lowField.setText("");
                LEMRangeSelectionDialog.this.highField.setText("");
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

