/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class LEMInitDialog
extends AlgorithmDialog {
    private int result = 2;
    private JCheckBox fileInput;
    private JCheckBox multipleChr;
    private JComboBox locusBox;
    private JComboBox startBox;
    private JComboBox endBox;
    private JComboBox chrBox;
    private JLabel chrLabel;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel coorInfoLabel;

    public LEMInitDialog(Frame parent, String[] fieldNames) {
        super(parent, "Linear Expression Map", true);
        EventListener listener = new EventListener();
        JLabel locusLabel = new JLabel("Select Locus Identifier Field");
        this.locusBox = new JComboBox<String>(fieldNames);
        ParameterPanel geneIDPanel = new ParameterPanel("Locus Identifier Selection");
        geneIDPanel.setLayout(new GridBagLayout());
        geneIDPanel.add((Component)locusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 15, 0), 0, 0));
        geneIDPanel.add((Component)this.locusBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 15, 15, 0), 0, 0));
        this.fileInput = new JCheckBox("Use Coordinate File", false);
        this.fileInput.setOpaque(false);
        this.fileInput.setFocusPainted(false);
        this.fileInput.setHorizontalAlignment(0);
        this.fileInput.setActionCommand("use-coord-file-command");
        this.fileInput.addActionListener(listener);
        JLabel fileInputLabel = new JLabel("<html><body>(Hit the \"i\" button (lower left corner) for <b>File Format Information</b>)</body></html>)");
        fileInputLabel.setHorizontalAlignment(0);
        String text = "<html>Coordinate information can be supplied via a file input or<br>via information in the annotation loaded into MeV.  If using a coordinates<br>file please refer to the help page by hitting the information button (lower left).<br>If using coordinate information in the MeV annoation please indicate the appropriate<br>annotation fields for coordinate parameters.<html>";
        JLabel textLabel = new JLabel(text);
        this.multipleChr = new JCheckBox("Multiple Chromosomes or Plasmids", false);
        this.multipleChr.setOpaque(false);
        this.multipleChr.setFocusPainted(false);
        this.multipleChr.setHorizontalAlignment(0);
        this.multipleChr.setActionCommand("multiple-chr-command");
        this.multipleChr.addActionListener(listener);
        this.chrLabel = new JLabel("Select Chromosome ID Field");
        this.chrLabel.setEnabled(false);
        this.chrLabel.setHorizontalAlignment(0);
        this.chrBox = new JComboBox<String>(fieldNames);
        this.chrBox.setEnabled(false);
        this.startLabel = new JLabel("Select Start Coordinate (5' End) Field");
        this.startBox = new JComboBox<String>(fieldNames);
        this.endLabel = new JLabel("Select End Coordinate (3' End) Field");
        this.endBox = new JComboBox<String>(fieldNames);
        ParameterPanel coordPanel = new ParameterPanel("Coordinate Data Selections");
        coordPanel.setLayout(new GridBagLayout());
        coordPanel.add((Component)this.fileInput, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        coordPanel.add((Component)fileInputLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        JSeparator sep = new JSeparator(0);
        sep.setPreferredSize(new Dimension(300, 2));
        sep.setSize(100, 2);
        coordPanel.add((Component)sep, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordPanel.add((Component)this.multipleChr, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        coordPanel.add((Component)this.chrLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 40, 15, 0), 0, 0));
        coordPanel.add((Component)this.chrBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 15, 40), 0, 0));
        JSeparator sep1 = new JSeparator(0);
        sep1.setPreferredSize(new Dimension(300, 2));
        sep1.setSize(100, 2);
        coordPanel.add((Component)sep1, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        coordPanel.add((Component)this.startLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 0, new Insets(20, 40, 0, 10), 0, 0));
        coordPanel.add((Component)this.startBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(20, 0, 0, 40), 0, 0));
        coordPanel.add((Component)this.endLabel, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 40, 25, 10), 0, 0));
        coordPanel.add((Component)this.endBox, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 25, 40), 0, 0));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        mainPanel.add((Component)geneIDPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)coordPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(mainPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public String getLocusField() {
        return (String)this.locusBox.getSelectedItem();
    }

    public boolean useFileInput() {
        return this.fileInput.isSelected();
    }

    public boolean hasMultipleChr() {
        return this.multipleChr.isSelected();
    }

    public String getChrIDField() {
        return (String)this.chrBox.getSelectedItem();
    }

    public String getStartField() {
        return (String)this.startBox.getSelectedItem();
    }

    public String getEndField() {
        return (String)this.endBox.getSelectedItem();
    }

    private void fireUseFileInputState() {
        boolean enable;
        boolean bl = enable = !this.fileInput.isSelected();
        if (enable && this.multipleChr.isSelected()) {
            this.chrLabel.setEnabled(true);
            this.chrBox.setEnabled(true);
        } else if (!enable) {
            this.chrLabel.setEnabled(false);
            this.chrBox.setEnabled(false);
        }
        this.startLabel.setEnabled(enable);
        this.startBox.setEnabled(enable);
        this.endLabel.setEnabled(enable);
        this.endBox.setEnabled(enable);
    }

    private void fireMultipleChrState() {
        boolean enable = this.multipleChr.isSelected();
        if (this.fileInput.isSelected()) {
            this.chrLabel.setEnabled(false);
            this.chrBox.setEnabled(false);
        } else {
            this.chrLabel.setEnabled(enable);
            this.chrBox.setEnabled(enable);
        }
    }

    private void resetControls() {
        this.locusBox.setSelectedIndex(0);
        this.fileInput.setSelected(false);
        this.fireUseFileInputState();
        this.chrBox.setSelectedIndex(0);
        this.multipleChr.setSelected(false);
        this.fireMultipleChrState();
        this.startBox.setSelectedIndex(0);
        this.endBox.setSelectedIndex(0);
    }

    public static void main(String[] args) {
        String[] fields = new String[]{"Locus", "Chr#", "Start", "End"};
        LEMInitDialog dialog = new LEMInitDialog(new Frame(), fields);
        dialog.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                LEMInitDialog.this.result = 0;
                LEMInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                LEMInitDialog.this.result = 2;
                LEMInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                LEMInitDialog.this.resetControls();
            } else if (command.equals("use-coord-file-command")) {
                LEMInitDialog.this.fireUseFileInputState();
            } else if (command.equals("multiple-chr-command")) {
                LEMInitDialog.this.fireMultipleChrState();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(LEMInitDialog.this, "LEM Initialization Dialog");
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LEMInitDialog.this.result = -1;
            LEMInitDialog.this.dispose();
        }
    }
}

