/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class LEMInfoViewer
extends ViewerAdapter {
    private JComponent header;
    private JTextPane content;
    private JLabel label;

    public LEMInfoViewer(String locusField, String startField, String endField, boolean hasMultipleChr, String chrField, boolean useFileInput, String coordFileName, int totSpotCount, int lemSpotCount, int numberOfMappedSpots, String[] chrNames, int[] mappingCounts, int[] locusCounts) {
        this.header = this.createHeader();
        this.content = this.createContent(locusField, startField, endField, hasMultipleChr, chrField, useFileInput, coordFileName, totSpotCount, lemSpotCount, numberOfMappedSpots, chrNames, mappingCounts, locusCounts);
        this.setMaxWidth(this.content, this.header);
    }

    public LEMInfoViewer(JComponent content, JComponent header) {
        this.content = (JTextPane)content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' color='#000080'><h1>LEM Construction Summary<h1></font></body></html>"), gbc);
        return panel;
    }

    private JTextPane createContent(String locusField, String startField, String endField, boolean hasMultipleChr, String chrField, boolean useFileInput, String coordFileName, int totSpotCount, int lemSpotCount, int numberOfMappedSpots, String[] chrNames, int[] mappingCounts, int[] locusCounts) {
        JTextPane area = new JTextPane();
        area.setContentType("text/html");
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        Font font = new Font("Serif", 0, 10);
        area.setFont(font);
        String text = "<html><body><font face=\"sanserif\">";
        text = text + "<h2>Parameters</h2>";
        text = text + "<b>Locus ID Annotation Field:</b>" + locusField + "<br>";
        text = text + "<b>Use Coordinate File:</b>" + (useFileInput ? "Yes" : "No") + "<br>";
        if (useFileInput) {
            text = text + "<b>Coordinate File:</b>" + coordFileName + "<br>";
        }
        text = text + "<b>Multiple Chromosomes Indicated:</b>" + (hasMultipleChr ? "Yes" : "No") + "<br>";
        if (!useFileInput) {
            if (hasMultipleChr) {
                text = text + "<b>Chromosome ID Annotation Field:</b>" + chrField + "<br>";
            }
            text = text + "<b>5' End Annotation Field:</b>" + startField + "<br>";
            text = text + "<b>3' End Annotation Field:</b>" + endField + "<br>";
        }
        text = text + "<h2>Global Mapping Information</h2>";
        if (totSpotCount != lemSpotCount) {
            text = text + "<b>Number of Spots Loaded in MeV: </b>" + String.valueOf(totSpotCount) + "<br>";
            text = text + "<b>Number of Spots Entering LEM (after filtering): </b>" + String.valueOf(lemSpotCount) + "<br>";
        } else {
            text = text + "<b>Number of Spots Entering LEM: </b>" + String.valueOf(lemSpotCount) + "<br>";
        }
        text = text + "<b>Number of Spots Mapped to Loci: </b>" + String.valueOf(numberOfMappedSpots) + "<br>";
        text = text + "<b>Fraction of Spots Mapped to Loci: </b>" + String.valueOf((float)numberOfMappedSpots / (float)lemSpotCount) + "<br>";
        text = text + "<b>Number of Unique Chromosome IDs: </b>" + String.valueOf(locusCounts.length) + "<br>";
        text = text + "<h2>Chromosomal Mapping Information</h2>";
        for (int i = 0; i < chrNames.length; ++i) {
            text = text + "<b>Chromosome ID:</b>" + chrNames[i] + "<br>";
            text = text + "<b>Number of Unique Locus IDs Found:</b>" + String.valueOf(locusCounts[i]) + "<br>";
            text = text + "<b>Number of Spots Mapped to Loci on Chromosome:</b>" + String.valueOf(mappingCounts[i]) + "<br><br>";
        }
        text = text + "</font></body></html>";
        area.setText(text);
        area.setCaretPosition(0);
        this.label = new JLabel(text);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

