/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;

public class LEMHeader
extends JPanel {
    private static final int RECT_HEIGHT = 15;
    private static final int COLOR_BAR_HEIGHT = 10;
    private int MIN_WIDTH = 180;
    private Experiment experiment;
    private IData data;
    private int[] samplesOrder;
    private int columnSpacing;
    private int arrowWidth;
    private int wingWidth;
    private boolean isAntiAliasing = true;
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private Insets insets = new Insets(0, 10, 0, 0);
    private int colorMode = 0;
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    private Color c1 = new Color(10, 159, 1);
    private Color c2 = new Color(187, 240, 181);
    private Color midColor = Color.white;
    private Color c3 = new Color(243, 169, 160);
    private Color c4 = Color.red;
    private float cutoff1 = -3.0f;
    private float cutoff2 = -1.0f;
    private float binMidValue = 0.0f;
    private float cutoff3 = 1.0f;
    private float cutoff4 = 3.0f;
    private boolean useDoubleGradient = true;

    public LEMHeader(Experiment experiment) {
        this(experiment, null);
    }

    public LEMHeader(Experiment experiment, int[] samplesOrder) {
        this.experiment = experiment;
        this.samplesOrder = samplesOrder == null ? LEMHeader.createSamplesOrder(experiment) : samplesOrder;
        this.setBackground(Color.white);
    }

    public JComponent getContentComponent() {
        return this;
    }

    private static int[] createSamplesOrder(Experiment experiment) {
        int[] order = new int[experiment.getNumberOfSamples()];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        return order;
    }

    public void setData(IData data) {
        this.data = data;
    }

    public void setValues(float minValue, float midValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.midValue = midValue;
    }

    public void setColorBinPolicy(int binOption) {
        this.colorMode = binOption;
    }

    public void setBinColors(Color c1, Color c2, Color c3, Color c4) {
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.c4 = c4;
    }

    public void setBinCutoffs(float c1, float c2, float mid, float c3, float c4) {
        this.cutoff1 = c1;
        this.cutoff2 = c2;
        this.binMidValue = mid;
        this.cutoff3 = c3;
        this.cutoff4 = c4;
    }

    public void setArrowWidth(int arrowWidth) {
        this.arrowWidth = arrowWidth;
    }

    public void setArrowWingWidth(int arrowWingWidth) {
        this.wingWidth = arrowWingWidth;
    }

    public void setValues(float minValue, float maxValue) {
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public void setNegAndPosColorImages(BufferedImage neg, BufferedImage pos) {
        this.negColorImage = neg;
        this.posColorImage = pos;
    }

    public void setUseDoubleGradient(boolean useDouble) {
        this.useDoubleGradient = useDouble;
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    public void setLeftInset(int leftMargin) {
        this.insets.left = leftMargin;
    }

    private int getColorBarHeight() {
        for (int sample = 0; sample < this.samplesOrder.length; ++sample) {
            if (this.data.getExperimentColor(this.experiment.getSampleIndex(this.samplesOrder[sample])) == null) continue;
            return 10;
        }
        return 0;
    }

    public void setColumnSpacing(int width) {
        this.columnSpacing = width;
        if (width > 12) {
            width = 12;
        }
        this.setFont(new Font("monospaced", 0, width));
    }

    public void updateSizes(int contentWidth, int columnSpacing) {
        if (this.data == null) {
            return;
        }
        this.setColumnSpacing(columnSpacing);
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        int size = this.experiment.getNumberOfSamples();
        for (int feature = 0; feature < size; ++feature) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(feature));
            maxHeight = Math.max(maxHeight, hfm.stringWidth(name));
        }
        maxHeight += 15 + hfm.getHeight() + 10;
        maxHeight += this.getColorBarHeight();
        if (contentWidth < this.MIN_WIDTH) {
            contentWidth = this.MIN_WIDTH;
        }
        this.setSize(contentWidth, maxHeight);
        this.setPreferredSize(new Dimension(contentWidth, maxHeight));
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.data == null) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(g);
    }

    private void drawHeader(Graphics2D g) {
        int samples = this.experiment.getNumberOfSamples();
        if (samples == 0) {
            return;
        }
        int width = samples * this.columnSpacing;
        if (width < this.MIN_WIDTH) {
            width = this.MIN_WIDTH;
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        if (this.colorMode == 0) {
            if (this.useDoubleGradient) {
                g.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
                g.drawImage(this.posColorImage, (int)((float)width / 2.0f + (float)this.insets.left), 0, (int)((double)width / 2.0), 15, null);
            } else {
                g.drawImage(this.posColorImage, this.insets.left, 0, width, 15, null);
            }
            g.setColor(Color.black);
            g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
            int textWidth = hfm.stringWidth(String.valueOf(this.midValue));
            if (this.useDoubleGradient) {
                g.drawString(String.valueOf(this.midValue), (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, 15 + fHeight);
            }
            textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
            g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        } else if (this.colorMode == 1) {
            g.setColor(this.c1);
            g.fillRect(this.insets.left, 0, (int)((float)width / 4.0f), 15);
            g.setColor(this.midColor);
            g.fillRect(this.insets.left + (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.fillRect(this.insets.left + 2 * (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.setColor(this.c4);
            g.fillRect(this.insets.left + 3 * (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.setColor(Color.black);
            g.drawRect(this.insets.left, 0, (int)((float)width / 4.0f), 15);
            g.drawRect(this.insets.left + (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.drawRect(this.insets.left + 2 * (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.drawRect(this.insets.left + 3 * (int)((float)width / 4.0f), 0, (int)((float)width / 4.0f), 15);
            g.drawString(String.valueOf(this.cutoff1), this.insets.left + (int)((float)width / 4.0f) - hfm.stringWidth(String.valueOf(this.cutoff1)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.binMidValue), this.insets.left + 2 * (int)((float)width / 4.0f) - hfm.stringWidth(String.valueOf(this.binMidValue)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.cutoff4), this.insets.left + 3 * (int)((float)width / 4.0f) - hfm.stringWidth(String.valueOf(this.cutoff4)) / 2, 15 + fHeight);
        } else if (this.colorMode == 2) {
            g.setColor(this.c1);
            g.fillRect(this.insets.left, 0, (int)((float)width / 6.0f), 15);
            g.setColor(this.c2);
            g.fillRect(this.insets.left + (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.setColor(this.midColor);
            g.fillRect(this.insets.left + 2 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.fillRect(this.insets.left + 3 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.setColor(this.c3);
            g.fillRect(this.insets.left + 4 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.setColor(this.c4);
            g.fillRect(this.insets.left + 5 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.setColor(Color.black);
            g.drawRect(this.insets.left, 0, (int)((float)width / 6.0f), 15);
            g.drawRect(this.insets.left + (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.drawRect(this.insets.left + 2 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.drawRect(this.insets.left + 3 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.drawRect(this.insets.left + 4 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.drawRect(this.insets.left + 5 * (int)((float)width / 6.0f), 0, (int)((float)width / 6.0f), 15);
            g.drawString(String.valueOf(this.cutoff1), this.insets.left + (int)((float)width / 6.0f) - hfm.stringWidth(String.valueOf(this.cutoff1)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.cutoff2), this.insets.left + 2 * (int)((float)width / 6.0f) - hfm.stringWidth(String.valueOf(this.cutoff2)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.binMidValue), this.insets.left + 3 * (int)((float)width / 6.0f) - hfm.stringWidth(String.valueOf(this.binMidValue)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.cutoff3), this.insets.left + 4 * (int)((float)width / 6.0f) - hfm.stringWidth(String.valueOf(this.cutoff3)) / 2, 15 + fHeight);
            g.drawString(String.valueOf(this.cutoff4), this.insets.left + 5 * (int)((float)width / 6.0f) - hfm.stringWidth(String.valueOf(this.cutoff4)) / 2, 15 + fHeight);
        }
        int h = -this.getSize().height + 5;
        boolean hasColorBar = false;
        if (this.getColorBarHeight() > 0) {
            h += 10;
            hasColorBar = true;
        }
        g.rotate(-1.5707963267948966);
        int currX = this.insets.left + this.arrowWidth / 2 + this.wingWidth + descent;
        for (int sample = 0; sample < samples; ++sample) {
            String name = this.data.getSampleName(this.experiment.getSampleIndex(this.samplesOrder[sample]));
            g.drawString(name, h, currX);
            currX += this.columnSpacing;
        }
        g.rotate(1.5707963267948966);
        if (hasColorBar) {
            for (int sample = 0; sample < samples; ++sample) {
                Color color = this.data.getExperimentColor(this.experiment.getSampleIndex(this.samplesOrder[sample]));
                if (color != null) {
                    g.setColor(color);
                } else {
                    g.setColor(Color.white);
                }
                g.fillRect(sample * this.columnSpacing + this.insets.left, this.getSize().height - 10 - 2, this.columnSpacing, 10);
            }
        }
    }
}

