/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMGraphHeader;

public class LEMGraphViewer
extends JPanel
implements IViewer {
    protected LEMGraphHeader header;
    protected Experiment experiment;
    protected IFramework framework;
    protected IDisplayMenu displayMenu;
    protected IData data;
    protected int clusterIndex;
    protected int yRangeOption;
    protected float[][] means;
    protected String[] locusNames;
    protected int[] start;
    protected int[] end;
    protected float minValue;
    protected float maxValue;
    protected float midValue = 0.0f;
    protected float ticInterval;
    protected boolean drawReferenceBlock = true;
    protected int xref = 0;
    protected int yref = 0;
    protected int currLocusIndex;
    protected boolean showRefLine = false;
    protected boolean[] showSample;
    protected Color[] sampleColors;
    protected boolean showLocusInfo = false;
    protected boolean shadeLocusRanges;
    protected Vector sampleLineColors;
    protected Vector sampleMarkerColors;
    protected String title;
    protected int numberOfSamples;
    protected boolean overlay = false;
    protected FontMetrics fm;
    protected int MIN_GRAPH_WIDTH = 400;
    protected int yRangeMode;
    protected boolean useSymetricYRange;
    protected boolean showXAxis = true;
    protected BasicStroke xAxisStroke;
    protected Color xAxisColor = Color.lightGray;
    protected float xAxisCrossPoint = 0.0f;
    protected Vector yLabels;
    protected int xGraphInset = 40;
    protected boolean xGraphInsetInitialized = false;
    protected boolean offsetLinesMode = true;
    protected Color posColor = Color.red;
    protected Color negColor = Color.green;
    protected float offsetGraphMidpoint = 0.0f;
    protected boolean showOverlay = false;
    protected float upperCutoff;
    protected float lowerCutoff;
    protected float neutralPoint = 0.0f;
    protected boolean cursorOn = false;
    boolean inDragMode = false;
    protected int startIndex;
    protected int endIndex;
    protected int dragStartX;
    protected int dragStopX;
    private int exptID = 0;

    public LEMGraphViewer() {
    }

    public LEMGraphViewer(Experiment experiment, float[][] data, String title, Hashtable properties, String[] locusNames, int[] start, int[] end) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.numberOfSamples = this.experiment.getNumberOfSamples();
        this.means = data;
        this.showSample = new boolean[experiment.getNumberOfSamples()];
        this.title = title;
        this.locusNames = locusNames;
        this.start = start;
        this.end = end;
        this.header = new LEMGraphHeader();
        this.startIndex = 0;
        this.endIndex = data.length - 1;
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 1, 10));
        this.yRangeMode = (Integer)properties.get("y-range-mode");
        this.useSymetricYRange = (Boolean)properties.get("y-axis-symetry");
        this.showXAxis = (Boolean)properties.get("show-x-axis");
        this.xAxisColor = (Color)properties.get("x-axis-color");
        this.xAxisStroke = (BasicStroke)properties.get("x-axis-stroke");
        this.overlay = (Boolean)properties.get("is-overlay-mode");
        this.offsetLinesMode = (Boolean)properties.get("offset-lines-mode");
        this.neutralPoint = this.offsetGraphMidpoint = ((Float)properties.get("offset-graph-midpoint")).floatValue();
        this.lowerCutoff = ((Float)properties.get("offset-graph-min")).floatValue();
        this.upperCutoff = ((Float)properties.get("offset-graph-max")).floatValue();
        this.showOverlay = (Boolean)properties.get("show-discrete-overlay");
        this.constructYAxisLabels();
        GraphListener listener = new GraphListener();
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public Expression getExpression() {
        return null;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.numberOfSamples = this.experiment.getNumberOfSamples();
        this.showSample = new boolean[this.experiment.getNumberOfSamples()];
        this.header = new LEMGraphHeader();
        this.startIndex = 0;
        this.endIndex = this.means.length - 1;
        GraphListener listener = new GraphListener();
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public void setMeans(float[][] means) {
        this.means = means;
    }

    public void enableOverlay(boolean overlayEnabled) {
        this.overlay = overlayEnabled;
        if (!this.overlay) {
            this.setSize(this.MIN_GRAPH_WIDTH, this.numberOfSamples * 190 + 40);
            this.setPreferredSize(new Dimension(this.getWidth(), this.numberOfSamples * 190 + 40));
        } else {
            this.setSize(this.MIN_GRAPH_WIDTH, 400);
            this.setPreferredSize(new Dimension(this.getWidth(), 400));
        }
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.displayMenu = framework.getDisplayMenu();
        this.setData(framework.getData());
        if (this.yRangeMode == 0) {
            this.maxValue = framework.getDisplayMenu().getMaxRatioScale();
            this.minValue = framework.getDisplayMenu().getMinRatioScale();
        }
        this.refreshGraph();
    }

    public void setData(IData data) {
        this.data = data;
    }

    public int[] getCluster() {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public void refreshGraph() {
        this.constructYAxisLabels();
        this.repaint();
    }

    public void setYAxisRangeMode(int mode) {
        this.yRangeMode = mode;
        if (mode == 0) {
            this.maxValue = this.displayMenu.getMaxRatioScale();
            this.minValue = this.displayMenu.getMinRatioScale();
            this.refreshGraph();
        }
    }

    private void updateYRangeAutoScale() {
        if (this.useSymetricYRange) {
            this.maxValue = this.experiment.getMaxAbsValue();
            this.minValue = this.maxValue * -1.0f;
        } else {
            float[] minAndMax = this.experiment.getMinAndMax();
            this.minValue = minAndMax[0];
            this.maxValue = minAndMax[1];
        }
    }

    public void setYRange(float min, float max) {
        this.minValue = min;
        this.maxValue = max;
    }

    public void setTicInterval(float ticInterval) {
        this.ticInterval = ticInterval;
    }

    public void setShowXAxis(boolean showXAxis) {
        this.showXAxis = showXAxis;
    }

    public void setXAxisStroke(BasicStroke stroke) {
        this.xAxisStroke = stroke;
    }

    public void setXAxisCrossPoint(float xAxisCrossPoint) {
        this.xAxisCrossPoint = xAxisCrossPoint;
    }

    public void setXAxisColor(Color axisColor) {
        this.xAxisColor = axisColor;
    }

    public void setYAxisSymetry(boolean isSymetric) {
        this.useSymetricYRange = isSymetric;
    }

    public void enableOffsetLinesMode(boolean enable) {
        this.offsetLinesMode = enable;
    }

    public void setOffsetLinesMidpoint(float val) {
        this.offsetGraphMidpoint = val;
    }

    public void setOffsetLinesMin(float val) {
        this.lowerCutoff = val;
    }

    public void setOffsetLinesMax(float val) {
        this.upperCutoff = val;
    }

    public void enableDiscreteValueOverlay(boolean enable) {
        this.showOverlay = enable;
    }

    public void toggleReferenceLine() {
        boolean bl = this.showRefLine = !this.showRefLine;
        if (this.showRefLine) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.repaint();
    }

    public void setCurrentGraph(int index) {
        this.clearGraphs();
        this.showSample[index] = true;
    }

    public void setGraphsToDisplay(int[] graphIndexList) {
        this.clearGraphs();
        for (int i = 0; i < graphIndexList.length; ++i) {
            this.showSample[graphIndexList[i]] = true;
        }
        this.repaint();
    }

    public void resetXRange() {
        this.startIndex = 0;
        this.endIndex = this.means.length - 1;
        this.header.resetLimits();
        this.repaint();
    }

    public Hashtable getGraphProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("is-overlay-mode", new Boolean(this.overlay));
        props.put("y-range-mode", new Integer(this.yRangeMode));
        props.put("y-axis-min", new Float(this.minValue));
        props.put("y-axis-max", new Float(this.maxValue));
        props.put("y-axis-tic-interval", new Float(this.ticInterval));
        props.put("y-axis-symetry", new Boolean(this.useSymetricYRange));
        props.put("show-x-axis", new Boolean(this.showXAxis));
        props.put("x-axis-color", this.xAxisColor);
        props.put("x-axis-stroke", this.xAxisStroke);
        props.put("x-axis-cross-point", new Float(this.xAxisCrossPoint));
        props.put("offset-lines-mode", new Boolean(this.offsetLinesMode));
        props.put("offset-graph-midpoint", new Float(this.offsetGraphMidpoint));
        props.put("offset-graph-min", new Float(this.lowerCutoff));
        props.put("offset-graph-max", new Float(this.upperCutoff));
        props.put("show-discrete-overlay", new Boolean(this.showOverlay));
        return props;
    }

    public void clearGraphs() {
        for (int i = 0; i < this.showSample.length; ++i) {
            this.showSample[i] = false;
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public IData getData() {
        return this.data;
    }

    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(new Font("Monospaced", 1, 18));
        this.fm = g.getFontMetrics();
        if (!this.xGraphInsetInitialized) {
            this.setXGraphInset();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.overlay) {
            this.overlayPaint(g);
        } else {
            this.multiGraphPaint(g);
        }
    }

    public void overlayPaint(Graphics g) {
        Rectangle rect = new Rectangle(this.xGraphInset, 40, this.getWidth() - this.xGraphInset - 40, this.getHeight() - 50);
        Rectangle clipRect = ((JViewport)this.getParent()).getViewRect();
        g.setColor(Color.black);
        g.drawString(this.title, this.getWidth() / 2 - this.fm.stringWidth(this.title) / 2, rect.y - 15);
        this.paint((Graphics2D)g, rect, true, true, clipRect);
    }

    public void multiGraphPaint(Graphics g) {
        int yOffset = 40;
        int yGraphH = 150;
        Rectangle clipRect = ((JViewport)this.getParent().getParent()).getViewRect();
        Container c = this.getParent();
        for (int plot = 0; plot < this.numberOfSamples; ++plot) {
            this.setCurrentGraph(plot);
            Rectangle rect = new Rectangle(this.xGraphInset, plot * (yGraphH + 40) + 40, this.getWidth() - this.xGraphInset - 40, yGraphH);
            g.setColor(Color.black);
            g.drawString(this.data.getSampleName(plot) + " -- " + this.title, this.xGraphInset + this.getWidth() / 2 - this.fm.stringWidth(this.data.getSampleName(plot) + " -- " + this.title) / 2, rect.y - 15);
            if (!clipRect.intersects(rect)) continue;
            this.paint((Graphics2D)g, rect, true, true, clipRect);
        }
    }

    public void setSampleLineColors(Vector lineColors) {
        this.sampleLineColors = lineColors;
    }

    public void setSampleMarkerColors(Vector markerColors) {
        this.sampleMarkerColors = markerColors;
    }

    public void paint(Graphics2D g, Rectangle rect, boolean drawMarks, boolean applyClip, Rectangle originalClip) {
        int left = rect.x;
        int top = rect.y;
        int width = rect.width;
        int height = rect.height;
        if (width < 5 || height < 5) {
            return;
        }
        int numberOfSamples = this.experiment.getNumberOfSamples();
        float factor = (float)height / (this.maxValue - this.minValue);
        int zeroValue = top + Math.round(factor * (this.maxValue - 0.0f));
        float stepX = (float)width / (float)(this.endIndex - this.startIndex - 1);
        int stepsY = (int)this.maxValue + 1;
        float sValue = 0.0f;
        Color lineColor = Color.gray;
        Color markerColor = Color.blue;
        int clipX = Math.max(rect.x - 2, originalClip.x);
        int clipY = Math.max(rect.y, originalClip.y);
        int clipRectWidth = Math.min(rect.width + 5, originalClip.width - Math.max(0, rect.x - 2 - originalClip.x));
        int clipRectHeight = Math.min(rect.height + rect.y - clipY, originalClip.y + originalClip.height - clipY);
        if (applyClip) {
            g.setClip(clipX, clipY, clipRectWidth, clipRectHeight);
        }
        Graphics2D g2 = g;
        Composite defaultComp = g2.getComposite();
        AlphaComposite overlayComp = AlphaComposite.getInstance(3, 0.5f);
        Stroke defaultStroke = g2.getStroke();
        BasicStroke overlayStroke = new BasicStroke(2.0f);
        g2.setComposite(defaultComp);
        g2.setColor(Color.black);
        boolean x1 = false;
        boolean x2 = false;
        float prevY = this.offsetGraphMidpoint;
        float currY = this.offsetGraphMidpoint;
        for (int sample = 0; sample < numberOfSamples; ++sample) {
            float fValue;
            int gene;
            if (this.overlay) {
                lineColor = (Color)this.sampleLineColors.get(sample);
                markerColor = (Color)this.sampleMarkerColors.get(sample);
            }
            if (!this.showSample[sample]) continue;
            if (!this.offsetLinesMode) {
                for (gene = this.startIndex; gene < this.endIndex - 1; ++gene) {
                    fValue = this.means[gene][sample];
                    sValue = this.means[gene + 1][sample];
                    if (Float.isNaN(fValue)) continue;
                    g.setColor(lineColor);
                    if (!Float.isNaN(sValue)) {
                        g.drawLine(left + Math.round((float)(gene - this.startIndex) * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(gene - this.startIndex + 1) * stepX), zeroValue - Math.round(sValue * factor));
                        if (this.showOverlay) {
                            prevY = this.drawOverlayLine(g2, prevY, sValue, left + Math.round((float)(gene - this.startIndex) * stepX), left + Math.round((float)(gene - this.startIndex + 1) * stepX), factor, zeroValue, defaultStroke, overlayStroke, overlayComp, defaultComp);
                        }
                    }
                    g.setColor(markerColor);
                    g.fillOval(left + Math.round((float)(gene - this.startIndex) * stepX) - 2, zeroValue - Math.round(fValue * factor) - 2, 4, 4);
                }
                if (Float.isNaN(sValue) || this.startIndex <= this.endIndex - 1) continue;
                g.fillOval(left + Math.round((float)(this.endIndex - this.startIndex - 1) * stepX) - 1, zeroValue - Math.round(sValue * factor) - 2, 4, 4);
                continue;
            }
            for (gene = this.startIndex; gene < this.endIndex; ++gene) {
                fValue = this.means[gene][sample];
                sValue = gene + 1 < this.means.length ? this.means[gene + 1][sample] : Float.NaN;
                if (Float.isNaN(fValue)) continue;
                g.setColor(lineColor);
                if (fValue >= this.upperCutoff) {
                    g.setColor(this.posColor);
                } else if (fValue <= this.lowerCutoff) {
                    g.setColor(this.negColor);
                } else {
                    g.setColor(Color.black);
                }
                g.drawLine(left + Math.round((float)(gene - this.startIndex) * stepX), zeroValue - Math.round(fValue * factor), left + Math.round((float)(gene - this.startIndex) * stepX), zeroValue - Math.round(this.offsetGraphMidpoint * factor));
                g.setColor(Color.darkGray);
                g.fillOval(left + Math.round((float)(gene - this.startIndex) * stepX) - 2, zeroValue - Math.round(fValue * factor) - 2, 4, 4);
                if (!this.showOverlay || Float.isNaN(sValue)) continue;
                prevY = this.drawOverlayLine(g2, prevY, sValue, left + Math.round((float)(gene - this.startIndex) * stepX), left + Math.round((float)(gene - this.startIndex + 1) * stepX), factor, zeroValue, defaultStroke, overlayStroke, overlayComp, defaultComp);
            }
        }
        g2.setStroke(defaultStroke);
        g2.setComposite(defaultComp);
        if (applyClip) {
            g.setClip(originalClip);
        }
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        for (int i = 0; i < this.yLabels.size(); ++i) {
            String str = (String)this.yLabels.get(i);
            float val = Float.parseFloat(str);
            int strWidth = this.fm.stringWidth(str);
            g.drawString(str, left - 10 - strWidth, zeroValue + 5 - Math.round(val * factor));
            g.drawLine(left - 5, zeroValue - Math.round(val * factor), left, zeroValue - Math.round(val * factor));
        }
        if (this.showXAxis) {
            Stroke stroke = g.getStroke();
            Color initColor = g.getColor();
            g.setStroke(this.xAxisStroke);
            g.setColor(this.xAxisColor);
            g.drawLine(clipX, zeroValue - Math.round(this.xAxisCrossPoint * factor), clipRectWidth + clipX, zeroValue - Math.round(this.xAxisCrossPoint * factor));
            g.setColor(initColor);
            g.setStroke(stroke);
        }
        if (this.inDragMode) {
            g.setColor(new Color(244, 250, 152));
            g.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g.fillRect(Math.max(left + 1, Math.min(this.dragStartX, this.dragStopX)), top, Math.max(this.dragStopX - this.dragStartX - 1, this.dragStartX - this.dragStopX), height);
            g.setComposite(defaultComp);
        }
        if (this.showRefLine && this.drawReferenceBlock && this.xref >= left && this.xref <= left + width) {
            if (rect.contains(this.xref, this.yref)) {
                g.setFont(new Font("Monospaced", 1, 12));
                this.fm = g.getFontMetrics();
                g.setComposite(AlphaComposite.getInstance(3, 0.8f));
                g.setColor(new Color(209, 213, 254));
                int boxWidth = Math.max(this.fm.stringWidth(this.locusNames[this.currLocusIndex]), Math.max(this.fm.stringWidth(String.valueOf(this.start[this.currLocusIndex])), this.fm.stringWidth(String.valueOf(this.start[this.currLocusIndex])))) + 10;
                int boxHeight = 3 * this.fm.getHeight() + 2;
                int boxX = this.xref;
                int boxY = this.yref - boxHeight;
                if (left + width < this.xref + boxWidth) {
                    boxX = this.xref - boxWidth;
                }
                if (top > this.yref - boxHeight) {
                    boxY = this.yref;
                }
                g.fillRect(boxX, boxY, boxWidth, boxHeight);
                g.setColor(Color.black);
                g.setComposite(defaultComp);
                g.drawString(this.locusNames[this.currLocusIndex], boxX + 5, boxY - 2 + this.fm.getHeight());
                g.drawString(String.valueOf(this.start[this.currLocusIndex]), boxX + 5, boxY - 2 + 2 * this.fm.getHeight());
                g.drawString(String.valueOf(this.end[this.currLocusIndex]), boxX + 5, boxY - 2 + 3 * this.fm.getHeight());
                g.setFont(new Font("Monospaced", 1, 18));
                this.fm = g.getFontMetrics();
            }
            g.setColor(Color.blue);
            g.setComposite(defaultComp);
            g.drawLine(this.xref, top, this.xref, top + height);
        }
    }

    public float drawOverlayLine(Graphics2D g, float prevY, float currY, int prevX, int currX, float factor, int zeroValue, Stroke defaultStroke, BasicStroke overlayStroke, Composite transparentComp, Composite solidComp) {
        Color color = g.getColor();
        g.setColor(Color.black);
        g.setComposite(solidComp);
        g.setStroke(overlayStroke);
        currY = currY >= this.upperCutoff ? this.upperCutoff : (currY <= this.lowerCutoff ? this.lowerCutoff : this.neutralPoint);
        if (currY == prevY) {
            g.drawLine(prevX, zeroValue - Math.round(prevY * factor), currX, zeroValue - Math.round(currY * factor));
        } else if (prevY == this.neutralPoint) {
            g.drawLine(prevX, zeroValue - Math.round(prevY * factor), currX, zeroValue - Math.round(prevY * factor));
            g.drawLine(currX, zeroValue - Math.round(prevY * factor), currX, zeroValue - Math.round(currY * factor));
        } else if (currY == this.neutralPoint) {
            g.drawLine(prevX, zeroValue - Math.round(prevY * factor), prevX, zeroValue - Math.round(this.neutralPoint * factor));
            g.drawLine(prevX, zeroValue - Math.round(this.neutralPoint * factor), currX, zeroValue - Math.round(this.neutralPoint * factor));
        } else {
            g.drawLine(prevX, zeroValue - Math.round(prevY * factor), prevX, zeroValue - Math.round(this.neutralPoint * factor));
            g.drawLine(prevX, zeroValue - Math.round(this.neutralPoint * factor), currX, zeroValue - Math.round(this.neutralPoint * factor));
            g.drawLine(currX, zeroValue - Math.round(this.neutralPoint * factor), currX, zeroValue - Math.round(currY * factor));
        }
        g.setColor(color);
        g.setStroke(defaultStroke);
        g.setComposite(transparentComp);
        return currY;
    }

    private void constructYAxisLabels() {
        float val;
        this.yLabels = new Vector();
        int yInset = 40;
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(1);
        if (this.yRangeMode == 1) {
            String str;
            for (val = this.minValue; val < this.maxValue; val += this.ticInterval) {
                str = format.format(val);
                this.yLabels.add(str);
            }
            str = format.format(this.maxValue);
            this.yLabels.add(str);
        } else {
            int stepsY;
            float yRange = this.maxValue - this.minValue;
            if (yRange <= 8.0f && yRange >= 4.0f) {
                stepsY = (int)yRange + 1;
                this.ticInterval = 1.0f;
            } else if (yRange < 4.0f) {
                stepsY = (int)((double)yRange / 0.5);
                this.ticInterval = 0.5f;
            } else {
                stepsY = 11;
                this.ticInterval = yRange / 10.0f;
            }
            val = this.minValue;
            for (int i = 0; i < stepsY; ++i) {
                String str = format.format(val);
                val += this.ticInterval;
                this.yLabels.add(str);
            }
        }
        this.setXGraphInset();
    }

    private void setXGraphInset() {
        if (this.fm != null) {
            this.xGraphInsetInitialized = true;
            this.xGraphInset = 0;
            for (int i = 0; i < this.yLabels.size(); ++i) {
                this.xGraphInset = Math.max(this.xGraphInset, this.fm.stringWidth((String)this.yLabels.get(i)));
            }
            this.xGraphInset += 20;
        }
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public void onDataChanged(IData data) {
        this.setData(data);
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.displayMenu = menu;
        if (this.yRangeMode == 0) {
            this.maxValue = menu.getMaxRatioScale();
            this.minValue = menu.getMinRatioScale();
            this.refreshGraph();
        }
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private float calculateMaxValue(int[] probes) {
        float max = 0.0f;
        int samples = this.experiment.getNumberOfSamples();
        for (int sample = 0; sample < samples; ++sample) {
            for (int probe = 0; probe < probes.length; ++probe) {
                float value = this.experiment.get(probes[probe], sample);
                if (Float.isNaN(value)) continue;
                max = Math.max(max, Math.abs(value));
            }
        }
        return max;
    }

    protected int getNamesWidth(FontMetrics metrics) {
        int maxWidth = 0;
        for (int i = 0; i < this.experiment.getNumberOfSamples(); ++i) {
            maxWidth = Math.max(maxWidth, metrics.stringWidth(this.data.getSampleName(this.experiment.getSampleIndex(i))));
        }
        return maxWidth;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public class GraphListener
    extends MouseAdapter
    implements MouseMotionListener {
        int x = 0;
        int y = 0;

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.getModifiers() != 16) {
                return;
            }
            if (LEMGraphViewer.this.inDragMode) {
                int initialStart = LEMGraphViewer.this.startIndex;
                LEMGraphViewer.this.startIndex += Math.round((float)(LEMGraphViewer.this.endIndex - LEMGraphViewer.this.startIndex - 1) * (((float)Math.min(LEMGraphViewer.this.dragStartX, LEMGraphViewer.this.dragStopX) - 40.0f) / ((float)LEMGraphViewer.this.getWidth() - 80.0f)));
                LEMGraphViewer.this.endIndex = initialStart + Math.round((float)(LEMGraphViewer.this.endIndex - initialStart) * (((float)Math.max(LEMGraphViewer.this.dragStopX, LEMGraphViewer.this.dragStartX) - 40.0f) / ((float)LEMGraphViewer.this.getWidth() - 80.0f)));
                LEMGraphViewer.this.startIndex = Math.min(LEMGraphViewer.this.startIndex, LEMGraphViewer.this.endIndex);
                LEMGraphViewer.this.endIndex = Math.max(LEMGraphViewer.this.startIndex, LEMGraphViewer.this.endIndex);
                if (LEMGraphViewer.this.startIndex < 0) {
                    LEMGraphViewer.this.startIndex = 0;
                }
                if (LEMGraphViewer.this.endIndex > LEMGraphViewer.this.means.length - 1) {
                    LEMGraphViewer.this.endIndex = LEMGraphViewer.this.means.length - 1;
                }
                LEMGraphViewer.this.header.setLimits((float)LEMGraphViewer.this.startIndex / (float)LEMGraphViewer.this.means.length, (float)LEMGraphViewer.this.endIndex / (float)LEMGraphViewer.this.means.length);
            }
            LEMGraphViewer.this.inDragMode = false;
            LEMGraphViewer.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (me.getModifiers() != 16) {
                return;
            }
            if (!LEMGraphViewer.this.inDragMode) {
                LEMGraphViewer.this.dragStartX = me.getX();
            }
            LEMGraphViewer.this.dragStopX = me.getX();
            if (LEMGraphViewer.this.dragStopX < 40) {
                LEMGraphViewer.this.dragStopX = 41;
            }
            if (LEMGraphViewer.this.dragStopX > LEMGraphViewer.this.getWidth() - 40) {
                LEMGraphViewer.this.dragStopX = LEMGraphViewer.this.getWidth() - 39;
            }
            LEMGraphViewer.this.inDragMode = true;
            this.mouseMoved(me);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            int newX = me.getX();
            int newY = me.getY();
            int refX = newX;
            if (LEMGraphViewer.this.inDragMode) {
                LEMGraphViewer.this.cursorOn = true;
                if (newX < 40) {
                    newX = 41;
                }
                if (newX > LEMGraphViewer.this.getWidth() - 40) {
                    newX = LEMGraphViewer.this.getWidth() - 39;
                }
                LEMGraphViewer.this.xref = newX;
                LEMGraphViewer.this.yref = newY;
                LEMGraphViewer.this.currLocusIndex = LEMGraphViewer.this.startIndex + Math.round((float)(LEMGraphViewer.this.endIndex - LEMGraphViewer.this.startIndex - 1) * (((float)newX - 40.0f) / ((float)LEMGraphViewer.this.getWidth() - 80.0f)));
                LEMGraphViewer.this.repaint();
            }
            int numberOfSamples = LEMGraphViewer.this.experiment.getNumberOfSamples();
            if (refX < 40 || refX > LEMGraphViewer.this.getWidth() - 40 || numberOfSamples <= 1) {
                LEMGraphViewer.this.drawReferenceBlock = false;
                LEMGraphViewer.this.repaint();
                return;
            }
            LEMGraphViewer.this.drawReferenceBlock = true;
            LEMGraphViewer.this.currLocusIndex = LEMGraphViewer.this.startIndex + Math.round((float)(LEMGraphViewer.this.endIndex - LEMGraphViewer.this.startIndex - 1) * (((float)newX - 40.0f) / ((float)LEMGraphViewer.this.getWidth() - 80.0f)));
            LEMGraphViewer.this.xref = newX;
            LEMGraphViewer.this.yref = newY;
            LEMGraphViewer.this.repaint();
        }
    }
}

