/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JPanel;

public class LEMGraphHeader
extends JPanel {
    private float leftLimit;
    private float rightLimit;
    private String title;
    private int h;
    private int w;
    private int thinBarH;
    private int thickBarH;
    private int goalPostW;
    private FontMetrics fm;
    private Insets insets;

    public LEMGraphHeader() {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.title = "Current Viewer Range";
        this.leftLimit = 0.0f;
        this.rightLimit = 1.0f;
        Font font = this.getFont();
        this.thinBarH = 3;
        this.thickBarH = 10;
        this.goalPostW = 3;
        this.insets = new Insets(10, 40, 10, 40);
        if (font != null) {
            this.w = 50;
            this.fm = this.getFontMetrics(font);
            this.h = this.fm.getHeight() + this.insets.top + this.insets.bottom + this.thickBarH;
            this.setPreferredSize(new Dimension(this.w, this.h));
        }
    }

    public void setLimits(float left, float right) {
        this.leftLimit = left;
        this.rightLimit = right;
        this.repaint();
    }

    public void resetLimits() {
        this.leftLimit = 0.0f;
        this.rightLimit = 1.0f;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.fm == null) {
            this.fm = g2.getFontMetrics();
        }
        this.h = this.getHeight();
        this.w = this.getWidth();
        g2.setColor(Color.blue);
        g2.fillRect(this.insets.left, this.insets.top, this.goalPostW, this.h - this.insets.top - this.insets.bottom);
        g2.fillRect(this.w - this.insets.right, this.insets.top, this.goalPostW, this.h - this.insets.top - this.insets.bottom);
        g2.fillRect(this.insets.left, this.h / 2 - this.thinBarH / 2, this.w - this.insets.left - this.insets.right, this.thinBarH);
        g2.setColor(Color.gray);
        Composite origComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2.fillRect(this.insets.left + (int)((float)(this.w - this.insets.left - this.insets.right) * this.leftLimit), this.h / 2 - this.thickBarH / 2, (int)((float)(this.w - this.insets.left - this.insets.right) * (this.rightLimit - this.leftLimit)), this.thickBarH);
        g2.setComposite(origComposite);
        g2.setColor(Color.blue);
        g2.drawRect(this.insets.left + (int)((float)(this.w - this.insets.left - this.insets.right) * this.leftLimit), this.h / 2 - this.thickBarH / 2, (int)((float)(this.w - this.insets.left - this.insets.right) * (this.rightLimit - this.leftLimit)), this.thickBarH);
    }
}

