/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HTMLMessageFileChooser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LEMInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.util.FloatMatrix;

public class LEMGUI
implements IClusterGUI {
    private Algorithm algorithm;
    private Logger logger;
    private boolean stop = false;
    private String singleChrName = "Single Chromosome";
    private IFramework framework;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        DefaultMutableTreeNode unMappedTableNode;
        int i;
        String[] chrList;
        String[] endList;
        String[] startList;
        this.framework = framework;
        IData idata = framework.getData();
        Experiment experiment = idata.getExperiment();
        FloatMatrix matrix = experiment.getMatrix();
        int[] origIndices = experiment.getRowMappingArrayCopy();
        DefaultMutableTreeNode algNode = new DefaultMutableTreeNode("LEM");
        LEMInitDialog dialog = new LEMInitDialog(framework.getFrame(), framework.getData().getFieldNames());
        if (dialog.showModal() != 0) {
            return null;
        }
        Listener listener = new Listener();
        this.logger = new Logger(framework.getFrame(), "LEM Processing", listener);
        AlgorithmData data = new AlgorithmData();
        String locusField = dialog.getLocusField();
        String startField = "5' End";
        String endField = "3' End";
        String chrField = null;
        String fileName = "None";
        boolean hasMultipleChr = dialog.hasMultipleChr();
        this.logger.show();
        this.logger.append("LEM Processing\n");
        this.logger.append("Retrieving Locus List\n");
        String[] locusList = idata.getAnnotationList(locusField, origIndices);
        boolean[] mappedSpots = new boolean[origIndices.length];
        boolean locusInfoCount = false;
        boolean incompleteCount = false;
        int globalIncompleteCount = 0;
        int totalNumberOfMappedSpots = 0;
        Hashtable<String, DefaultMutableTreeNode> lemResultHash = new Hashtable<String, DefaultMutableTreeNode>();
        if (hasMultipleChr) {
            chrField = dialog.getChrIDField();
        }
        if (dialog.useFileInput()) {
            String[] info = null;
            locusField = "Locus ID";
            String msg = "<html><body><h1><center>Select Chromosomal Location File</center></h1><hr size = 3>";
            msg = msg + "Please select a file to supply information containing chromosomal coordinates for your array.";
            msg = msg + "<br><br>The file format should be tab delimited text with:<br><br><center><b> gene_id | [chromosome ID] | 5'-end | 3'-end</b></center>";
            msg = msg + "</body></html>";
            HTMLMessageFileChooser chooser = new HTMLMessageFileChooser(framework.getFrame(), "Select Chromosomal Location File", msg, TMEV.getDataPath(), true);
            if (chooser.showModal() != 0) return null;
            Hashtable<String, String[]> hash = new Hashtable<String, String[]>();
            this.logger.append("Reading Coordinate File: " + chooser.getSelectedFile().getName() + "\n");
            fileName = chooser.getSelectedFile().getName();
            try {
                String line;
                BufferedReader bfr = new BufferedReader(new FileReader(chooser.getSelectedFile()));
                StringSplitter ss = new StringSplitter('\t');
                boolean cnt = false;
                while ((line = bfr.readLine()) != null) {
                    ss.init(line);
                    String locus = ss.nextToken();
                    info = !hasMultipleChr ? new String[]{this.singleChrName, ss.nextToken(), ss.nextToken()} : new String[]{ss.nextToken(), ss.nextToken(), ss.nextToken()};
                    hash.put(locus, info);
                }
            }
            catch (FileNotFoundException ioe) {
                JOptionPane.showMessageDialog(framework.getFrame(), "File Not Found Error using input file: " + fileName, "Error", 0);
                return null;
            }
            catch (IOException fnfe) {
                JOptionPane.showMessageDialog(framework.getFrame(), "I/O Error using input file: " + fileName, "Error", 0);
                return null;
            }
            catch (NoSuchElementException nsee) {
                JOptionPane.showMessageDialog(framework.getFrame(), "File Parsing Error: " + fileName, "Error", 0);
                return null;
            }
            startList = new String[locusList.length];
            endList = new String[locusList.length];
            chrList = new String[locusList.length];
            for (i = 0; i < locusList.length; ++i) {
                info = (String[])hash.get(locusList[i]);
                if (info != null) {
                    chrList[i] = info[0];
                    startList[i] = info[1];
                    endList[i] = info[2];
                    continue;
                }
                chrList[i] = "";
                startList[i] = "";
                endList[i] = "";
            }
        } else {
            chrField = dialog.getChrIDField();
            startField = dialog.getStartField();
            endField = dialog.getEndField();
            chrList = idata.getAnnotationList(chrField, origIndices);
            startList = idata.getAnnotationList(startField, origIndices);
            endList = idata.getAnnotationList(endField, origIndices);
        }
        for (int i2 = 0; i2 < origIndices.length; ++i2) {
            origIndices[i2] = i2;
        }
        Hashtable<String, Vector[]> chrHash = new Hashtable<String, Vector[]>();
        Vector<String> chrNames = new Vector<String>();
        Object[] chrKeys = new String[1];
        if (hasMultipleChr) {
            for (i = 0; i < chrList.length; ++i) {
                if (chrList[i].equals("")) continue;
                if (chrHash.containsKey(chrList[i])) {
                    Vector[] chrData = (Vector[])chrHash.get(chrList[i]);
                    chrData[0].add(locusList[i]);
                    chrData[1].add(startList[i]);
                    chrData[2].add(endList[i]);
                    chrData[3].add(new Integer(origIndices[i]));
                    continue;
                }
                chrNames.add(chrList[i]);
                Vector[] chrData = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector()};
                chrData[0].add(locusList[i]);
                chrData[1].add(startList[i]);
                chrData[2].add(endList[i]);
                chrData[3].add(new Integer(origIndices[i]));
                chrHash.put(chrList[i], chrData);
            }
        } else {
            String singleChrName = "Chromosome";
            chrNames.add(singleChrName);
            chrKeys[0] = singleChrName;
            Vector[] chrData = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector()};
            for (int i3 = 0; i3 < locusList.length; ++i3) {
                chrData[0].add(locusList[i3]);
                chrData[1].add(startList[i3]);
                chrData[2].add(endList[i3]);
                chrData[3].add(new Integer(origIndices[i3]));
            }
            chrHash.put(singleChrName, chrData);
        }
        if (startList.length != endList.length) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Coordinate information is incomplete.  Some coordinates are not paired (one 3' per 5')", "Coordinate Information Error", 0);
            return null;
        }
        int[] startArray = new int[startList.length];
        int[] endArray = new int[endList.length];
        int[] chrLocusCount = new int[chrNames.size()];
        int[] mappingData = new int[chrNames.size()];
        int[] locusCounts = new int[chrNames.size()];
        Hashtable<String, Integer> mappingDataTable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> locusCountsTable = new Hashtable<String, Integer>();
        for (int chr = 0; chr < chrNames.size(); ++chr) {
            DefaultMutableTreeNode legNode;
            DefaultMutableTreeNode node;
            String chrName = (String)chrNames.get(chr);
            if (chrName.equals("")) continue;
            Vector[] chrData = (Vector[])chrHash.get(chrName);
            int locusCount = chrData[0].size();
            String[] chrLocusList = new String[chrData[0].size()];
            startArray = new int[chrData[1].size()];
            endArray = new int[chrData[2].size()];
            int[] origIndexArray = new int[locusCount];
            incompleteCount = false;
            for (int locusIndex = 0; locusIndex < locusCount; ++locusIndex) {
                String locus = (String)chrData[0].get(locusIndex);
                String start = (String)chrData[1].get(locusIndex);
                String end = (String)chrData[2].get(locusIndex);
                int origIndex = (Integer)chrData[3].get(locusIndex);
                chrLocusList[locusIndex] = locus;
                if (!(locus.equals("") || start.equals("") || end.equals(""))) {
                    startArray[locusIndex] = Integer.parseInt(start);
                    endArray[locusIndex] = Integer.parseInt(end);
                    origIndexArray[locusIndex] = origIndex;
                    continue;
                }
                startArray[locusIndex] = -1;
                endArray[locusIndex] = -1;
                origIndexArray[locusIndex] = origIndex;
                ++globalIncompleteCount;
            }
            data.addIntArray("idata-indices", origIndices);
            data.addIntArray("original-indices", origIndexArray);
            data.addMatrix("expression-matrix", matrix);
            data.addStringArray("locus-array", chrLocusList);
            data.addIntArray("start-array", startArray);
            data.addIntArray("end-array", endArray);
            this.logger.append("Start LEM Construction Operations (LEM.java)\n");
            this.logger.append("Working on Chromosome: " + chrName + "\n");
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("LEM");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            data = this.algorithm.execute(data);
            this.logger.append("Constructing LEM Viewer\n");
            LinearExpressionMapViewer viewer = this.createViewer(data, experiment, locusField);
            LinearExpressionGraphViewer graphViewer = this.createGraphViewer(data, experiment, locusField, chrName);
            if (!hasMultipleChr) {
                node = new DefaultMutableTreeNode(new LeafInfo("LEM Viewer", (IViewer)viewer));
                legNode = new DefaultMutableTreeNode(new LeafInfo("LEG Viewer", (IViewer)graphViewer));
                algNode.add(node);
                algNode.add(legNode);
                lemResultHash.put(chrName, algNode);
            } else {
                DefaultMutableTreeNode chrNode = new DefaultMutableTreeNode(new LeafInfo(chrName));
                node = new DefaultMutableTreeNode(new LeafInfo("LEM Viewer - " + chrName, (IViewer)viewer));
                chrNode.add(node);
                legNode = new DefaultMutableTreeNode(new LeafInfo("LEG Viewer - " + chrName, (IViewer)graphViewer));
                chrNode.add(legNode);
                lemResultHash.put(chrName, chrNode);
            }
            int[][] replicateArrays = data.getIntMatrix("replication-indices-matrix");
            int totalMapped = 0;
            for (int i4 = 0; i4 < replicateArrays.length; ++i4) {
                totalMapped += replicateArrays[i4].length;
                for (int j = 0; j < replicateArrays[i4].length; ++j) {
                    mappedSpots[replicateArrays[i4][j]] = true;
                }
            }
            locusCountsTable.put(chrName, new Integer(replicateArrays.length));
            locusCounts[chr] = replicateArrays.length;
            mappingDataTable.put(chrName, new Integer(totalMapped));
            mappingData[chr] = totalMapped;
            totalNumberOfMappedSpots += totalMapped;
        }
        if (hasMultipleChr) {
            chrKeys = new String[lemResultHash.size()];
            Enumeration e = lemResultHash.keys();
            int cnt = 0;
            while (e.hasMoreElements()) {
                chrKeys[cnt] = (String)e.nextElement();
                ++cnt;
            }
            Arrays.sort(chrKeys);
            for (int i5 = 0; i5 < chrKeys.length; ++i5) {
                algNode.add((DefaultMutableTreeNode)lemResultHash.get(chrKeys[i5]));
                locusCounts[i5] = (Integer)locusCountsTable.get(chrKeys[i5]);
                mappingData[i5] = (Integer)mappingDataTable.get(chrKeys[i5]);
            }
        }
        if ((unMappedTableNode = this.createTableOfUnmappedSpots(experiment, idata, origIndices, mappedSpots)) != null) {
            algNode.add(unMappedTableNode);
        }
        DefaultMutableTreeNode summaryNode = this.createSummaryNode(locusField, startField, endField, hasMultipleChr, hasMultipleChr ? chrField : null, dialog.useFileInput(), fileName, framework.getData().getFullExperiment().getNumberOfGenes(), experiment.getNumberOfGenes(), totalNumberOfMappedSpots, (String[])chrKeys, mappingData, locusCounts);
        algNode.add(summaryNode);
        this.logger.dispose();
        return algNode;
    }

    private LinearExpressionMapViewer createViewer(AlgorithmData data, Experiment experiment, String locusFieldName) {
        String[] sortedLociNames = data.getStringArray("sorted-loci-names");
        int[][] replicationMatrix = data.getIntMatrix("replication-indices-matrix");
        FloatMatrix condensedMatrix = data.getMatrix("condensed-matrix");
        int[] sortedIDataIndices = data.getIntArray("sorted-idata-indices");
        Experiment newExperiment = new Experiment(condensedMatrix, experiment.getColumnIndicesCopy(), sortedIDataIndices);
        int[] sortedStartCoordinates = data.getIntArray("sorted-start");
        int[] sortedEndCoordinates = data.getIntArray("sorted-end");
        int[] directionIntArray = data.getIntArray("direction-array");
        boolean[] isForward = new boolean[directionIntArray.length];
        for (int i = 0; i < directionIntArray.length; ++i) {
            isForward[i] = directionIntArray[i] == 1;
        }
        int[] strata = data.getIntArray("strata-array");
        LinearExpressionMapViewer viewer = new LinearExpressionMapViewer(experiment, newExperiment, sortedLociNames, sortedStartCoordinates, sortedEndCoordinates, replicationMatrix, isForward, strata, "Chromosome", locusFieldName);
        return viewer;
    }

    private LinearExpressionGraphViewer createGraphViewer(AlgorithmData data, Experiment experiment, String locusFieldName, String chrName) {
        String[] sortedLociNames = data.getStringArray("sorted-loci-names");
        int[][] replicationMatrix = data.getIntMatrix("replication-indices-matrix");
        FloatMatrix condensedMatrix = data.getMatrix("condensed-matrix");
        int[] sortedIDataIndices = data.getIntArray("sorted-idata-indices");
        Experiment newExperiment = new Experiment(condensedMatrix, experiment.getColumnIndicesCopy(), sortedIDataIndices);
        int[] sortedStartCoordinates = data.getIntArray("sorted-start");
        int[] sortedEndCoordinates = data.getIntArray("sorted-end");
        int[] directionIntArray = data.getIntArray("direction-array");
        boolean[] isForward = new boolean[directionIntArray.length];
        for (int i = 0; i < directionIntArray.length; ++i) {
            isForward[i] = directionIntArray[i] == 1;
        }
        int[] strata = data.getIntArray("strata-array");
        LinearExpressionGraphViewer viewer = new LinearExpressionGraphViewer(experiment, newExperiment, sortedLociNames, sortedStartCoordinates, sortedEndCoordinates, replicationMatrix, chrName, locusFieldName);
        return viewer;
    }

    private DefaultMutableTreeNode createSummaryNode(String locusField, String startField, String endField, boolean hasMultipleChr, String chrField, boolean useFileInput, String fileName, int totSpotCount, int lemSpotCount, int numberOfMappedSpots, String[] chrNames, int[] mappingCounts, int[] locusCounts) {
        LEMInfoViewer viewer = new LEMInfoViewer(locusField, startField, endField, hasMultipleChr, chrField, useFileInput, fileName, totSpotCount, lemSpotCount, numberOfMappedSpots, chrNames, mappingCounts, locusCounts);
        return new DefaultMutableTreeNode(new LeafInfo("Locus Mapping Summary", (IViewer)viewer));
    }

    private DefaultMutableTreeNode createTableOfUnmappedSpots(Experiment experiment, IData data, int[] origIndices, boolean[] mappedSpots) {
        int count = 0;
        for (int i = 0; i < mappedSpots.length; ++i) {
            if (mappedSpots[i]) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] cluster = new int[count];
        count = 0;
        for (int i = 0; i < mappedSpots.length; ++i) {
            if (mappedSpots[i]) continue;
            cluster[count] = origIndices[i];
            ++count;
        }
        int[][] clusters = new int[][]{cluster};
        ClusterTableViewer viewer = new ClusterTableViewer(experiment, (int[][])clusters, data);
        return new DefaultMutableTreeNode(new LeafInfo("Unmapped Spot Table", (IViewer)viewer, (Object)new Integer(0)));
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        String eventDescription;

        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String command = actionEvent.getActionCommand();
            if (command.equals("cancel-command")) {
                System.out.println("abort execution");
                LEMGUI.this.stop = true;
                if (LEMGUI.this.algorithm != null) {
                    LEMGUI.this.algorithm.abort();
                }
                LEMGUI.this.logger.dispose();
            }
        }

        public void valueChanged(AlgorithmEvent event) {
            if (event.getId() == 3) {
                LEMGUI.this.logger.append(event.getDescription());
            }
        }
    }
}

