/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.lem.LinearExpressionMapViewer;

public class LEMColorRangeSelector
extends AlgorithmDialog {
    private LinearExpressionMapViewer lem;
    private int result = 2;
    private JButton lowest;
    private JButton lower;
    private JButton higher;
    private JButton highest;
    private float limit1;
    private float limit2;
    private float limit3;
    private float limit4;
    private float midPoint;
    private Color origColor1;
    private Color origColor2;
    private Color origColor3;
    private Color origColor4;
    private float origLimit1;
    private float origLimit2;
    private float origLimit3;
    private float origLimit4;
    private float origMidPoint;
    private int buttonW = 100;
    private int buttonH = 40;
    private JTextField c1Field;
    private JTextField c2Field;
    private JTextField midField;
    private JTextField c3Field;
    private JTextField c4Field;
    private int fieldW = 80;
    private int fieldH = 30;

    public LEMColorRangeSelector(JFrame parent, LinearExpressionMapViewer lem, Color c1, Color c2, Color c3, Color c4, float lim1, float lim2, float mid, float lim3, float lim4) {
        super(parent, "LEM Bin Range and Color Selection", false);
        this.lem = lem;
        this.origColor1 = c1;
        this.origColor2 = c2;
        this.origColor3 = c3;
        this.origColor4 = c4;
        this.limit1 = this.origLimit1 = lim1;
        this.limit2 = this.origLimit2 = lim2;
        this.limit3 = this.origLimit3 = lim3;
        this.limit4 = this.origLimit4 = lim4;
        this.midPoint = this.origMidPoint = mid;
        ButtonListener listener = new ButtonListener();
        ParameterPanel panel = new ParameterPanel("Color and Range Settings");
        panel.setLayout(new GridBagLayout());
        Dimension buttonDim = new Dimension(this.buttonW, this.buttonH);
        this.lowest = this.createColorButton(c1, listener, buttonDim, "lowest");
        this.lower = this.createColorButton(c2, listener, buttonDim, "lower");
        this.higher = this.createColorButton(c3, listener, buttonDim, "higher");
        this.highest = this.createColorButton(c4, listener, buttonDim, "highest");
        JPanel midPanel = new JPanel();
        midPanel.setBackground(Color.white);
        midPanel.setPreferredSize(new Dimension(this.buttonW, this.buttonH));
        midPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        JPanel midPanel2 = new JPanel();
        midPanel2.setBackground(Color.white);
        midPanel2.setPreferredSize(new Dimension(this.buttonW, this.buttonH));
        midPanel2.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.lowest, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.lower, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)midPanel, new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)midPanel2, new GridBagConstraints(6, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.higher, new GridBagConstraints(8, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.highest, new GridBagConstraints(10, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBackground(Color.WHITE);
        this.c1Field = this.createField(this.limit1, listener);
        this.c2Field = this.createField(this.limit2, listener);
        this.midField = this.createField(this.midPoint, listener);
        this.c3Field = this.createField(this.limit3, listener);
        this.c4Field = this.createField(this.limit4, listener);
        textPanel.add((Component)this.createFillPanel(this.buttonW / 2, this.fieldH), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        textPanel.add((Component)this.c1Field, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.c2Field, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.midField, new GridBagConstraints(5, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.c3Field, new GridBagConstraints(7, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.c4Field, new GridBagConstraints(9, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.createFillPanel(this.buttonW / 2, this.fieldH), new GridBagConstraints(11, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new ArrowPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 5, 1, 5), 0, 0));
        panel.add((Component)textPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.addContent(panel);
        this.reconfigureButtons(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    private void reconfigureButtons(ButtonListener listener) {
        JButton previewButton = new JButton("Preview");
        previewButton.setBorder(BorderFactory.createBevelBorder(0));
        previewButton.setFocusPainted(false);
        previewButton.setActionCommand("preview-command");
        previewButton.addActionListener(listener);
        Dimension dim = new Dimension(65, 30);
        previewButton.setPreferredSize(dim);
        previewButton.setSize(dim);
        this.okButton.setText("Apply");
        Component[] comp = this.buttonPanel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            this.buttonPanel.remove(comp[i]);
        }
        this.buttonPanel.add(comp[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[1], new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 10, 2, 0), 0, 0));
        this.buttonPanel.add((Component)previewButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[2], new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[3], new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 0), 0, 0));
        this.buttonPanel.add(comp[4], new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Color getColor(int bin) {
        Color color = null;
        if (bin == 0) {
            color = this.lowest.getBackground();
        } else if (bin == 1) {
            color = this.lower.getBackground();
        } else if (bin == 2) {
            color = Color.white;
        } else if (bin == 3) {
            color = this.higher.getBackground();
        } else if (bin == 4) {
            color = this.highest.getBackground();
        }
        return color;
    }

    public float getCutoff(int index) {
        float limit = 0.0f;
        if (index == 0) {
            limit = Float.parseFloat(this.c1Field.getText());
        } else if (index == 1) {
            limit = Float.parseFloat(this.c2Field.getText());
        } else if (index == 2) {
            limit = Float.parseFloat(this.midField.getText());
        } else if (index == 3) {
            limit = Float.parseFloat(this.c3Field.getText());
        } else if (index == 4) {
            limit = Float.parseFloat(this.c4Field.getText());
        }
        return limit;
    }

    private boolean applySettings() {
        boolean valid = this.validateValues();
        if (valid) {
            this.lem.setBinLimitsAndColors(this.getCutoff(0), this.getCutoff(1), this.getCutoff(2), this.getCutoff(3), this.getCutoff(4), this.getColor(0), this.getColor(1), this.getColor(3), this.getColor(4));
        }
        return valid;
    }

    public boolean validateValues() {
        float v4;
        float v3;
        float v2;
        float v1;
        float v0;
        try {
            v0 = Float.parseFloat(this.c1Field.getText());
            v1 = Float.parseFloat(this.c2Field.getText());
            v2 = Float.parseFloat(this.midField.getText());
            v3 = Float.parseFloat(this.c3Field.getText());
            v4 = Float.parseFloat(this.c4Field.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "An entered value seems to be in an invalid format. Please try again.", "Number Format Error", 0);
            return false;
        }
        if (v0 <= v1 && v1 <= v2 && v2 <= v3 && v3 <= v4) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "The cutoff values should be in asscending value from left to right. Please try again.", "Cutoff Value Error", 0);
        return false;
    }

    private JButton createColorButton(Color color, ButtonListener listener, Dimension buttonDim, String buttonName) {
        JButton b = new JButton("<html><center>Select<br>Color</center></html>");
        b.setBackground(color);
        b.setFocusPainted(false);
        b.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        b.setPreferredSize(buttonDim);
        b.setSize(buttonDim);
        b.setActionCommand("color-button-hit-command");
        b.addActionListener(listener);
        return b;
    }

    private JTextField createField(float val, ButtonListener listener) {
        JTextField field = new JTextField();
        field.setText(String.valueOf(val));
        Dimension dim = new Dimension(this.fieldW, this.fieldH);
        field.setPreferredSize(dim);
        field.setSize(dim);
        field.setActionCommand("field-focus-command");
        field.addFocusListener(listener);
        return field;
    }

    private JPanel createFillPanel(int w, int h) {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        Dimension dim = new Dimension(w, h);
        panel.setPreferredSize(dim);
        panel.setSize(dim);
        return panel;
    }

    private void assignColor(JButton button) {
        Color color = button.getBackground();
        JColorChooser chooser = new JColorChooser(color);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[panels.length];
        int hsbIndex = 0;
        for (int i = 0; i < panels.length; ++i) {
            if (!panels[i].getClass().getName().equals("javax.swing.colorchooser.DefaultHSBChooserPanel")) continue;
            hsbIndex = i;
        }
        newPanels[0] = panels[hsbIndex];
        int cnt = 1;
        for (int i = 0; i < panels.length; ++i) {
            if (i == hsbIndex) continue;
            newPanels[cnt] = panels[i];
            ++cnt;
        }
        chooser.setChooserPanels(newPanels);
        ButtonListener listener = new ButtonListener(button, chooser);
        JDialog dialog = JColorChooser.createDialog(this, "Bin Color Selection", true, chooser, listener, new ButtonListener());
        dialog.show();
        button.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    private void resetControls() {
        this.lowest.setBackground(this.origColor1);
        this.lower.setBackground(this.origColor2);
        this.higher.setBackground(this.origColor3);
        this.highest.setBackground(this.origColor4);
        this.c1Field.setText(String.valueOf(this.origLimit1));
        this.c2Field.setText(String.valueOf(this.origLimit2));
        this.midField.setText(String.valueOf(this.origMidPoint));
        this.c3Field.setText(String.valueOf(this.origLimit3));
        this.c4Field.setText(String.valueOf(this.origLimit4));
    }

    public class ButtonListener
    implements ActionListener,
    FocusListener {
        JButton button;
        JColorChooser chooser;

        public ButtonListener() {
        }

        public ButtonListener(JButton button, JColorChooser chooser) {
            this.button = button;
            this.chooser = chooser;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (ae.getSource() instanceof JTextField) {
                LEMColorRangeSelector.this.repaint();
            }
            if (command.equals("OK")) {
                this.button.setBackground(this.chooser.getColor());
            } else if (!command.equals("cancel")) {
                if (command.equals("color-button-hit-command")) {
                    JButton sourceButton = (JButton)ae.getSource();
                    sourceButton.setBorder(BorderFactory.createLineBorder(Color.black, 3));
                    LEMColorRangeSelector.this.assignColor(sourceButton);
                } else if (command.equals("ok-command")) {
                    if (LEMColorRangeSelector.this.applySettings()) {
                        LEMColorRangeSelector.this.result = 0;
                        LEMColorRangeSelector.this.dispose();
                    }
                } else if (command.equals("cancel-command")) {
                    LEMColorRangeSelector.this.result = 2;
                    LEMColorRangeSelector.this.dispose();
                } else if (command.equals("reset-command")) {
                    LEMColorRangeSelector.this.resetControls();
                } else if (command.equals("preview-command")) {
                    LEMColorRangeSelector.this.applySettings();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(LEMColorRangeSelector.this, "LEM Bin Color and Limits Selection Dialog");
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            LEMColorRangeSelector.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            LEMColorRangeSelector.this.repaint();
        }
    }

    public class ArrowPanel
    extends JPanel {
        int[] x;
        int[] y;
        Point p;

        public ArrowPanel() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            Dimension dim = new Dimension(6 * LEMColorRangeSelector.this.buttonW, 60);
            this.setPreferredSize(dim);
            this.setSize(dim);
            this.x = new int[3];
            this.y = new int[3];
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.blue);
            Graphics2D g2 = (Graphics2D)g;
            this.y[0] = 0;
            this.y[1] = this.getHeight();
            this.y[2] = this.getHeight();
            this.p = LEMColorRangeSelector.this.lowest.getLocation();
            this.x[0] = this.p.x + LEMColorRangeSelector.this.buttonW;
            this.p = LEMColorRangeSelector.this.c1Field.getLocation();
            this.x[1] = this.p.x;
            this.x[2] = this.p.x + LEMColorRangeSelector.this.fieldW;
            if (LEMColorRangeSelector.this.c1Field.hasFocus()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            }
            g.fillPolygon(this.x, this.y, 3);
            this.p = LEMColorRangeSelector.this.lower.getLocation();
            this.x[0] = this.p.x + LEMColorRangeSelector.this.buttonW;
            this.p = LEMColorRangeSelector.this.c2Field.getLocation();
            this.x[1] = this.p.x;
            this.x[2] = this.p.x + LEMColorRangeSelector.this.fieldW;
            if (LEMColorRangeSelector.this.c2Field.hasFocus()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            }
            g.fillPolygon(this.x, this.y, 3);
            this.p = LEMColorRangeSelector.this.lower.getLocation();
            this.x[0] = this.p.x + 2 * LEMColorRangeSelector.this.buttonW;
            this.p = LEMColorRangeSelector.this.midField.getLocation();
            this.x[1] = this.p.x;
            this.x[2] = this.p.x + LEMColorRangeSelector.this.fieldW;
            if (LEMColorRangeSelector.this.midField.hasFocus()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            }
            g.fillPolygon(this.x, this.y, 3);
            this.p = LEMColorRangeSelector.this.higher.getLocation();
            this.x[0] = this.p.x;
            this.p = LEMColorRangeSelector.this.c3Field.getLocation();
            this.x[1] = this.p.x;
            this.x[2] = this.p.x + LEMColorRangeSelector.this.fieldW;
            if (LEMColorRangeSelector.this.c3Field.hasFocus()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            }
            g.fillPolygon(this.x, this.y, 3);
            this.p = LEMColorRangeSelector.this.highest.getLocation();
            this.x[0] = this.p.x;
            this.p = LEMColorRangeSelector.this.c4Field.getLocation();
            this.x[1] = this.p.x;
            this.x[2] = this.p.x + LEMColorRangeSelector.this.fieldW;
            if (LEMColorRangeSelector.this.c4Field.hasFocus()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            }
            g.fillPolygon(this.x, this.y, 3);
        }
    }
}

