/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.lem;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;

public class GraphScaleCustomizationDialog
extends AlgorithmDialog {
    private JTabbedPane pane;
    private YScalePanel yPanel;
    private GraphRenderingPanel graphRenderingPanel;
    private Hashtable props;
    private int result;
    public static final int YRANGE_OPTION_DISPLAY_MENU = 0;
    public static final int YRANGE_OPTION_CUSTOM_RANGE = 1;
    public static final int YRANGE_OPTION_AUTO_RANGE = 2;

    public GraphScaleCustomizationDialog(JFrame parent, boolean modal, Hashtable props) {
        super(parent, "Customize Graph", modal);
        this.props = props;
        this.result = 2;
        this.pane = new JTabbedPane();
        this.yPanel = new YScalePanel();
        this.graphRenderingPanel = new GraphRenderingPanel();
        this.pane.add("Y Range and X Axis Parameters", this.yPanel);
        this.pane.add("Graph Rendering Options", this.graphRenderingPanel);
        this.pane.setBackgroundAt(0, Color.white);
        this.addContent(this.pane);
        this.setActionListeners(new Listener());
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getYRangeMode() {
        int mode = this.yPanel.displaySettingRangeButton.isSelected() ? 0 : (this.yPanel.customRangeButton.isSelected() ? 1 : 2);
        return mode;
    }

    public float getYMin() {
        return Float.parseFloat(this.yPanel.minField.getText());
    }

    public float getYMax() {
        return Float.parseFloat(this.yPanel.maxField.getText());
    }

    public float getYTicInterval() {
        return Float.parseFloat(this.yPanel.ticIntervalField.getText());
    }

    public boolean showXAxisLine() {
        return this.yPanel.showXAxisBox.isSelected();
    }

    public float getXAxisCrossPoint() {
        return Float.parseFloat(this.yPanel.xAxisField.getText());
    }

    public Color getXAxisColor() {
        if (this.yPanel.xAxisColorBox.getSelectedItem() instanceof Color) {
            return (Color)this.yPanel.xAxisColorBox.getSelectedItem();
        }
        return this.yPanel.getCustomXAxisColor();
    }

    public BasicStroke getXAxisStyle() {
        return ((StrokePreview)this.yPanel.xAxisLineBox.getSelectedItem()).getBasicStroke();
    }

    public boolean isOffsetLinesModeSelected() {
        return this.graphRenderingPanel.isOffsetLinesModeSelected();
    }

    public float getOffsetMidpoint() {
        return this.graphRenderingPanel.getOffsetMidpoint();
    }

    public float getOffsetMin() {
        return this.graphRenderingPanel.getOffsetMin();
    }

    public float getOffsetMax() {
        return this.graphRenderingPanel.getOffsetMax();
    }

    public boolean getShowOverlay() {
        return this.graphRenderingPanel.getShowOverlay();
    }

    public boolean validateRange() {
        if (this.yPanel.customRangeButton.isSelected()) {
            float interval;
            float max;
            float min;
            int level = 0;
            try {
                min = Float.parseFloat(this.yPanel.minField.getText());
                ++level;
                max = Float.parseFloat(this.yPanel.maxField.getText());
                ++level;
                interval = Float.parseFloat(this.yPanel.ticIntervalField.getText());
                ++level;
            }
            catch (NumberFormatException nfe) {
                String msg = "Minimum Value entry is not a number.";
                if (level == 1) {
                    msg = "Maximum Value entry is not a number.";
                } else if (level == 2) {
                    msg = "Tick Interval Value entry is not a number.";
                }
                JOptionPane.showMessageDialog(this, msg, "Number Format Error", 0);
                return false;
            }
            if (min >= max) {
                String msg = "Min Value should be < Max Value.";
                JOptionPane.showMessageDialog(this, msg, "Value Error", 0);
                return false;
            }
            if (max - min < interval) {
                String msg = "The tick interval is larger than the y range.  Please make an appropriate change\n to either the range limits or tick interval.";
                JOptionPane.showMessageDialog(this, msg, "Value Error", 0);
                return false;
            }
        }
        return true;
    }

    public class Listener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("y-range-selection-command")) {
                GraphScaleCustomizationDialog.this.yPanel.updateForRangeModeSelection();
            } else if (command.equals("ok-command")) {
                if (!GraphScaleCustomizationDialog.this.validateRange()) {
                    return;
                }
                GraphScaleCustomizationDialog.this.result = 0;
                GraphScaleCustomizationDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                GraphScaleCustomizationDialog.this.result = 2;
                GraphScaleCustomizationDialog.this.dispose();
            } else if (command.equals("") || command.equals("")) {
                // empty if block
            }
        }
    }

    public class StrokePreview
    extends JLabel
    implements Comparable {
        private BasicStroke stroke;
        private boolean isSelected;

        public StrokePreview(BasicStroke stroke) {
            this.setOpaque(false);
            this.stroke = stroke;
            this.setPreferredSize(new Dimension(100, 20));
            this.setSize(100, 15);
            this.isSelected = false;
        }

        public BasicStroke getBasicStroke() {
            return this.stroke;
        }

        public void setSelected(boolean sel) {
            this.isSelected = sel;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            Stroke origStroke = g2.getStroke();
            g2.setStroke(this.stroke);
            g2.drawLine(3, this.getHeight() / 2, this.getWidth() - 3, this.getHeight() / 2);
            g2.setStroke(origStroke);
        }

        public int compareTo(Object o) {
            StrokePreview other = (StrokePreview)o;
            if (other.getBasicStroke().equals(this.stroke)) {
                return 0;
            }
            return 1;
        }
    }

    public class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        boolean isSelected;
        Color customColor = Color.lightGray;

        public MyCellRenderer() {
            this.setPreferredSize(new Dimension(20, 20));
            this.setSize(20, 20);
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public MyCellRenderer(Color color) {
            this.setPreferredSize(new Dimension(20, 20));
            this.setSize(20, 20);
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.customColor = color;
        }

        public void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Color) {
                this.setText("");
                this.setBackground((Color)value);
                return this;
            }
            if (value instanceof String) {
                this.setText("Custom Color");
                this.setBackground(this.customColor);
                return this;
            }
            return (Component)value;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }

        public Color getCustomColor() {
            return this.customColor;
        }

        public void setCustomColor(Color c) {
            this.customColor = c;
        }
    }

    public class ListListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox source = (JComboBox)e.getSource();
            if (source.getSelectedItem() instanceof Color) {
                source.setBackground((Color)source.getSelectedItem());
            } else {
                Color color = GraphScaleCustomizationDialog.this.yPanel.setCustomXAxisColor(GraphScaleCustomizationDialog.this.yPanel.getCustomXAxisColor());
                if (color != null) {
                    source.setBackground(color);
                }
            }
        }
    }

    public class StrokePreviewBox
    extends JComboBox {
        public StrokePreviewBox() {
            this.setBackground(Color.white);
            this.setRenderer(new MyCellRenderer());
            this.addItem(new StrokePreview(new BasicStroke(2.0f)));
            this.addItem(new StrokePreview(new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{5.0f, 5.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{2.0f, 2.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{20.0f, 10.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{20.0f, 5.0f, 5.0f, 5.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(1.0f)));
            this.addItem(new StrokePreview(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{5.0f, 5.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{2.0f, 2.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{20.0f, 10.0f}, 0.0f)));
            this.addItem(new StrokePreview(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{20.0f, 5.0f, 5.0f, 5.0f}, 0.0f)));
        }
    }

    public class GraphRenderingPanel
    extends JPanel {
        private JRadioButton offsetLineButton;
        private JRadioButton connectPointsButton;
        private JTextField midPointField;
        private JTextField maxField;
        private JTextField minField;
        private JCheckBox discreteOverlayBox;
        private GraphPreview preview;

        public GraphRenderingPanel() {
            super(new GridBagLayout());
            this.setBackground(Color.white);
            PreviewListener listener = new PreviewListener();
            ButtonGroup bg = new ButtonGroup();
            this.offsetLineButton = new JRadioButton("Offset Lines from Midpoint");
            this.offsetLineButton.setFocusPainted(false);
            this.offsetLineButton.setOpaque(false);
            this.offsetLineButton.addActionListener(listener);
            bg.add(this.offsetLineButton);
            this.minField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("offset-graph-min")).toString());
            this.midPointField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("offset-graph-midpoint")).toString());
            this.maxField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("offset-graph-max")).toString());
            this.connectPointsButton = new JRadioButton("Connect Points");
            this.connectPointsButton.setFocusPainted(false);
            this.connectPointsButton.setOpaque(false);
            this.connectPointsButton.addActionListener(listener);
            bg.add(this.connectPointsButton);
            this.discreteOverlayBox = new JCheckBox("Discrete Value Overlay");
            this.discreteOverlayBox.setOpaque(false);
            this.discreteOverlayBox.setFocusPainted(false);
            this.discreteOverlayBox.addActionListener(listener);
            this.offsetLineButton.setSelected((Boolean)GraphScaleCustomizationDialog.this.props.get("offset-lines-mode"));
            this.connectPointsButton.setSelected((Boolean)GraphScaleCustomizationDialog.this.props.get("offset-lines-mode") == false);
            this.discreteOverlayBox.setSelected((Boolean)GraphScaleCustomizationDialog.this.props.get("show-discrete-overlay"));
            this.preview = new GraphPreview(this.offsetLineButton.isSelected(), this.discreteOverlayBox.isSelected());
            this.add((Component)this.offsetLineButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("Lower Cutoff"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 15, 10, 10), 0, 0));
            this.add((Component)this.minField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
            this.add((Component)new JLabel("Neutral Point"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 10, 10), 0, 0));
            this.add((Component)this.midPointField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)new JLabel("Upper Cutoff"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 10, 10), 0, 0));
            this.add((Component)this.maxField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.discreteOverlayBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 20, 0), 0, 0));
            this.add((Component)this.connectPointsButton, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.preview, new GridBagConstraints(2, 0, 1, 6, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        }

        public boolean isOffsetLinesModeSelected() {
            return this.offsetLineButton.isSelected();
        }

        public float getOffsetMidpoint() {
            return Float.parseFloat(this.midPointField.getText());
        }

        public float getOffsetMax() {
            return Float.parseFloat(this.maxField.getText());
        }

        public float getOffsetMin() {
            return Float.parseFloat(this.minField.getText());
        }

        public boolean getShowOverlay() {
            return this.discreteOverlayBox.isSelected();
        }

        public class PreviewListener
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent ae) {
                GraphRenderingPanel.this.preview.enableOffsetMode(GraphRenderingPanel.this.offsetLineButton.isSelected());
                GraphRenderingPanel.this.preview.enableOverlay(GraphRenderingPanel.this.discreteOverlayBox.isSelected());
                GraphRenderingPanel.this.preview.repaint();
            }
        }

        public class GraphPreview
        extends ParameterPanel {
            float[] previewValues;
            boolean offsetMode;
            float min;
            float max;
            float mid;
            boolean discreteOverlay;

            public GraphPreview(boolean offsetMode, boolean discreteOverlay) {
                super("Preview");
                this.min = 0.3f;
                this.max = 0.8f;
                this.mid = 0.5f;
                this.offsetMode = offsetMode;
                this.discreteOverlay = discreteOverlay;
                this.previewValues = new float[10];
                this.previewValues[0] = 0.85f;
                this.previewValues[1] = 0.9f;
                this.previewValues[2] = 0.83f;
                this.previewValues[3] = 0.91f;
                this.previewValues[4] = 0.43f;
                this.previewValues[5] = 0.55f;
                this.previewValues[6] = 0.45f;
                this.previewValues[7] = 0.2f;
                this.previewValues[8] = 0.25f;
                this.previewValues[9] = 0.22f;
                this.setPreferredSize(new Dimension(200, 200));
            }

            public void enableOffsetMode(boolean isOffset) {
                this.offsetMode = isOffset;
            }

            public void enableOverlay(boolean enable) {
                this.discreteOverlay = enable;
            }

            @Override
            public void paint(Graphics g) {
                int yLoc;
                int i;
                super.paint(g);
                int w = this.getWidth();
                int h = this.getHeight();
                int xoffset = 25;
                int yoffset = 25;
                int x = xoffset;
                int y = yoffset;
                Graphics2D g2 = (Graphics2D)g;
                Composite defaultComp = g2.getComposite();
                int xInt = (w - xoffset) / (this.previewValues.length - 1);
                g.drawLine(xoffset / 2, h / 2 + yoffset, w - xoffset / 2, h / 2 + yoffset);
                int yLoc1 = 0;
                if (this.discreteOverlay) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                } else {
                    g2.setComposite(defaultComp);
                }
                if (this.offsetMode) {
                    for (i = 0; i < this.previewValues.length; ++i) {
                        yLoc = (int)((float)h * (1.0f - this.previewValues[i])) + yoffset;
                        if (this.previewValues[i] < this.min) {
                            g.setColor(Color.green);
                        } else if (this.previewValues[i] > this.max) {
                            g.setColor(Color.red);
                        }
                        g.drawLine(xInt * i + xoffset / 2, h / 2 + yoffset, xInt * i + xoffset / 2, yLoc);
                        g.setColor(Color.black);
                        g.fillOval(xInt * i + xoffset / 2 - 2, yLoc, 4, 4);
                    }
                } else {
                    for (i = 0; i < this.previewValues.length - 1; ++i) {
                        yLoc = (int)((float)h * (1.0f - this.previewValues[i])) + yoffset;
                        yLoc1 = (int)((float)h * (1.0f - this.previewValues[i + 1])) + yoffset;
                        g.setColor(Color.black);
                        g.drawLine(xInt * i + xoffset / 2, yLoc + 2, xInt * (i + 1) + xoffset / 2, yLoc1 + 2);
                        g.setColor(Color.blue);
                        g.fillOval(xInt * i + xoffset / 2 - 2, yLoc, 4, 4);
                    }
                    g.setColor(Color.blue);
                    g.fillOval(xInt * (this.previewValues.length - 1) + xoffset / 2 - 2, yLoc1, 4, 4);
                }
                if (this.discreteOverlay) {
                    g2.setComposite(defaultComp);
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.black);
                    int x1 = 0;
                    int x2 = 0;
                    float prevY = this.mid;
                    float currY = this.mid;
                    prevY = this.previewValues[0] >= this.max ? this.max : (this.previewValues[0] <= this.min ? this.min : this.mid);
                    for (int i2 = 1; i2 < this.previewValues.length; ++i2) {
                        currY = this.previewValues[i2] >= this.max ? this.max : (this.previewValues[i2] <= this.min ? this.min : this.mid);
                        x2 = xInt * i2 + xoffset / 2;
                        x1 = x2 - xInt;
                        if (currY == prevY) {
                            g.drawLine(x1, (int)((float)h * (1.0f - prevY)) + yoffset, x2, (int)((float)h * (1.0f - currY)) + yoffset);
                        } else if (prevY == this.mid) {
                            g.drawLine(x1, (int)((float)h * (1.0f - prevY)) + yoffset, x2, (int)((float)h * (1.0f - prevY)) + yoffset);
                            g.drawLine(x2, (int)((float)h * (1.0f - prevY)) + yoffset, x2, (int)((float)h * (1.0f - currY)) + yoffset);
                        } else if (currY == this.mid) {
                            g.drawLine(x1, (int)((float)h * (1.0f - prevY)) + yoffset, x1, (int)((float)h * (1.0f - this.mid)) + yoffset);
                            g.drawLine(x1, (int)((float)h * (1.0f - this.mid)) + yoffset, x2, (int)((float)h * (1.0f - this.mid)) + yoffset);
                        } else {
                            g.drawLine(x1, (int)((float)h * (1.0f - prevY)) + yoffset, x1, (int)((float)h * (1.0f - this.mid)) + yoffset);
                            g.drawLine(x1, (int)((float)h * (1.0f - this.mid)) + yoffset, x2, (int)((float)h * (1.0f - this.mid)) + yoffset);
                            g.drawLine(x2, (int)((float)h * (1.0f - this.mid)) + yoffset, x2, (int)((float)h * (1.0f - currY)) + yoffset);
                        }
                        prevY = currY;
                    }
                }
                g2.setComposite(defaultComp);
                g2.setStroke(new BasicStroke(1.0f));
            }
        }
    }

    public class YScalePanel
    extends JPanel {
        private JRadioButton displaySettingRangeButton;
        private JRadioButton customRangeButton;
        private JTextField minField;
        private JTextField maxField;
        private JTextField ticIntervalField;
        private JLabel minLabel;
        private JLabel maxLabel;
        private JLabel ticLabel;
        private JCheckBox showXAxisBox;
        private JLabel xAxisCrossesLabel;
        private JLabel lineLabel;
        private JLabel colorLabel;
        private JTextField xAxisField;
        private StrokePreviewBox xAxisLineBox;
        private JComboBox xAxisColorBox;
        private MyCellRenderer renderer;

        public YScalePanel() {
            super(new GridBagLayout());
            Listener listener = new Listener();
            ParameterPanel rangeOptionPanel = new ParameterPanel("Y Range Options");
            rangeOptionPanel.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            this.displaySettingRangeButton = new JRadioButton("External Display Menu Range Setting", true);
            this.displaySettingRangeButton.setOpaque(false);
            this.displaySettingRangeButton.setFocusPainted(false);
            this.displaySettingRangeButton.setActionCommand("y-range-selection-command");
            this.displaySettingRangeButton.addActionListener(listener);
            bg.add(this.displaySettingRangeButton);
            JSeparator sep1 = new JSeparator(0);
            sep1.setPreferredSize(new Dimension(250, 10));
            sep1.setSize(250, 10);
            this.customRangeButton = new JRadioButton("Custom Y Range");
            this.customRangeButton.setOpaque(false);
            this.customRangeButton.setFocusPainted(false);
            this.customRangeButton.setActionCommand("y-range-selection-command");
            this.customRangeButton.addActionListener(listener);
            bg.add(this.customRangeButton);
            Dimension fieldDim = new Dimension(60, 20);
            this.minLabel = new JLabel("Minimum Value");
            this.minField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("y-axis-min")).toString());
            this.minField.setPreferredSize(fieldDim);
            this.minField.setSize(fieldDim);
            this.maxLabel = new JLabel("Maximum Value");
            this.maxField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("y-axis-max")).toString());
            this.maxField.setPreferredSize(fieldDim);
            this.maxField.setSize(fieldDim);
            this.ticLabel = new JLabel("Tick Interval");
            this.ticIntervalField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("y-axis-tic-interval")).toString());
            this.ticIntervalField.setPreferredSize(fieldDim);
            this.ticIntervalField.setSize(fieldDim);
            rangeOptionPanel.add((Component)this.displaySettingRangeButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            rangeOptionPanel.add((Component)sep1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            rangeOptionPanel.add((Component)this.customRangeButton, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            rangeOptionPanel.add((Component)this.minLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 10, 5, 15), 0, 0));
            rangeOptionPanel.add((Component)this.minField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
            rangeOptionPanel.add((Component)this.maxLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 10, 5, 15), 0, 0));
            rangeOptionPanel.add((Component)this.maxField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 0), 0, 0));
            rangeOptionPanel.add((Component)this.ticLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 10, 10, 15), 0, 0));
            rangeOptionPanel.add((Component)this.ticIntervalField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 10, 0), 0, 0));
            ParameterPanel xAxisOptionPanel = new ParameterPanel("X Axis Display Options");
            xAxisOptionPanel.setLayout(new GridBagLayout());
            this.showXAxisBox = new JCheckBox("Show X Axis Line");
            this.showXAxisBox.setOpaque(false);
            this.showXAxisBox.setFocusPainted(false);
            this.showXAxisBox.setActionCommand("y-range-selection-command");
            this.showXAxisBox.addActionListener(listener);
            this.showXAxisBox.setSelected((Boolean)GraphScaleCustomizationDialog.this.props.get("show-x-axis"));
            this.xAxisCrossesLabel = new JLabel("X axis crosses at");
            this.xAxisCrossesLabel.setOpaque(false);
            this.xAxisField = new JTextField(((Float)GraphScaleCustomizationDialog.this.props.get("x-axis-cross-point")).toString());
            this.xAxisField.setPreferredSize(fieldDim);
            this.xAxisField.setSize(fieldDim);
            this.xAxisLineBox = new StrokePreviewBox();
            Dimension dim = new Dimension(80, 18);
            this.xAxisLineBox.setPreferredSize(dim);
            this.xAxisLineBox.setSize(dim);
            StrokePreview currStrokePreview = new StrokePreview((BasicStroke)GraphScaleCustomizationDialog.this.props.get("x-axis-stroke"));
            for (int i = 0; i < this.xAxisLineBox.getItemCount(); ++i) {
                if (((StrokePreview)this.xAxisLineBox.getItemAt(i)).compareTo(currStrokePreview) != 0) continue;
                this.xAxisLineBox.setSelectedIndex(i);
                break;
            }
            this.xAxisLineBox.setSelectedItem(new StrokePreview((BasicStroke)GraphScaleCustomizationDialog.this.props.get("x-axis-stroke")));
            ((StrokePreview)this.xAxisLineBox.getSelectedItem()).setSelected(true);
            Vector<Object> v = new Vector<Object>();
            v.add(Color.lightGray);
            v.add(new Color(150, 150, 250));
            v.add(Color.gray);
            v.add(Color.black);
            v.add("Customize");
            this.xAxisColorBox = new JComboBox(v);
            this.xAxisColorBox.setBackground((Color)this.xAxisColorBox.getSelectedItem());
            this.xAxisColorBox.setEditable(false);
            this.xAxisColorBox.setOpaque(true);
            Color currXAxisColor = (Color)GraphScaleCustomizationDialog.this.props.get("x-axis-color");
            this.xAxisColorBox.setBackground(currXAxisColor);
            if (currXAxisColor.equals(Color.gray) || currXAxisColor.equals(Color.black) || currXAxisColor.equals(new Color(150, 150, 250))) {
                this.xAxisColorBox.setSelectedItem(currXAxisColor);
                this.renderer = new MyCellRenderer();
            } else {
                this.xAxisColorBox.setSelectedIndex(3);
                this.renderer = new MyCellRenderer(currXAxisColor);
            }
            this.xAxisColorBox.setRenderer(this.renderer);
            this.xAxisColorBox.setPreferredSize(dim);
            this.xAxisColorBox.setSize(dim);
            this.xAxisColorBox.addActionListener(new ListListener());
            xAxisOptionPanel.add((Component)this.showXAxisBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            JPanel xCrossesPanel = new JPanel(new GridBagLayout());
            xCrossesPanel.setBackground(Color.white);
            Dimension panDim = new Dimension(200, 20);
            xCrossesPanel.setPreferredSize(panDim);
            xCrossesPanel.setSize(panDim);
            xCrossesPanel.add((Component)this.xAxisCrossesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            xCrossesPanel.add((Component)this.xAxisField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            xAxisOptionPanel.add((Component)xCrossesPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 10, 0), 0, 0));
            JPanel fillPanel = new JPanel();
            fillPanel.setPreferredSize(panDim);
            fillPanel.setSize(panDim);
            fillPanel.setBackground(Color.white);
            xAxisOptionPanel.add((Component)fillPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.lineLabel = new JLabel("Line Style");
            this.colorLabel = new JLabel("Line Color");
            xAxisOptionPanel.add((Component)this.lineLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 4, 10), 0, 0));
            xAxisOptionPanel.add((Component)this.colorLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 4, 10), 0, 0));
            xAxisOptionPanel.add((Component)this.xAxisLineBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            xAxisOptionPanel.add((Component)this.xAxisColorBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
            this.add((Component)rangeOptionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)xAxisOptionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            int rangeMode = (Integer)GraphScaleCustomizationDialog.this.props.get("y-range-mode");
            if (rangeMode == 0) {
                this.displaySettingRangeButton.setSelected(true);
            } else if (rangeMode == 1) {
                this.customRangeButton.setSelected(true);
            }
            this.updateForRangeModeSelection();
        }

        private void updateForRangeModeSelection() {
            this.minField.setEnabled(this.customRangeButton.isSelected());
            this.minLabel.setEnabled(this.customRangeButton.isSelected());
            this.maxField.setEnabled(this.customRangeButton.isSelected());
            this.maxLabel.setEnabled(this.customRangeButton.isSelected());
            this.ticIntervalField.setEnabled(this.customRangeButton.isSelected());
            this.ticLabel.setEnabled(this.customRangeButton.isSelected());
            this.xAxisCrossesLabel.setEnabled(this.showXAxisBox.isSelected());
            this.xAxisField.setEnabled(this.showXAxisBox.isSelected());
            this.colorLabel.setEnabled(this.showXAxisBox.isSelected());
            this.lineLabel.setEnabled(this.showXAxisBox.isSelected());
            this.xAxisLineBox.setEnabled(this.showXAxisBox.isSelected());
            this.xAxisColorBox.setEnabled(this.showXAxisBox.isSelected());
        }

        public Color setCustomXAxisColor(Color startColor) {
            Color color = JColorChooser.showDialog(this, "Custom X-Axis Color", startColor);
            if (color != null) {
                this.renderer.setCustomColor(color);
            }
            this.repaint();
            return color;
        }

        public Color getCustomXAxisColor() {
            return this.renderer.getCustomColor();
        }
    }
}

