/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KNNClassifyOrValidateDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton classifyButton;
    JRadioButton validateButton;

    public KNNClassifyOrValidateDialog(JFrame parentFrame, boolean modality) {
        super(parentFrame, "KNN classify or validate", modality);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        this.classifyButton = new JRadioButton("Classify", true);
        this.classifyButton.setBackground(Color.white);
        this.validateButton = new JRadioButton("Validate", false);
        this.validateButton.setBackground(Color.white);
        ButtonGroup classifyOrValidate = new ButtonGroup();
        classifyOrValidate.add(this.classifyButton);
        classifyOrValidate.add(this.validateButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        gridbag.setConstraints(this.classifyButton, constraints);
        pane.add(this.classifyButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        gridbag.setConstraints(this.validateButton, constraints);
        pane.add(this.validateButton);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean classify() {
        return this.classifyButton.isSelected();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = true;
                KNNClassifyOrValidateDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = false;
                KNNClassifyOrValidateDialog.this.classifyButton.setSelected(true);
                KNNClassifyOrValidateDialog.this.validateButton.setSelected(false);
            } else if (command.equals("cancel-command")) {
                KNNClassifyOrValidateDialog.this.okPressed = false;
                KNNClassifyOrValidateDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(KNNClassifyOrValidateDialog.this, "KNNC Mode Selection");
            }
        }
    }
}

