/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCSearchDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCSecondDialog;

public class KNNClassificationEditor
extends JDialog {
    IFramework framework;
    IData data;
    boolean classifyGenes;
    private boolean stopHere = true;
    private boolean nextPressed = false;
    private boolean incompatible = false;
    private boolean fileSaved = false;
    int numClasses;
    String[] fieldNames;
    int numGenes;
    int numExps;
    JTable knnClassTable;
    KNNClassTableModel kModel;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu toolsMenu;
    JMenu assignSubMenu;
    JMenu sortAscMenu;
    JMenu sortDescMenu;
    JMenuItem saveItem;
    JMenuItem closeItem;
    JMenuItem selectAllItem;
    JMenuItem searchItem;
    JMenuItem sortByClassItem;
    JMenuItem origOrderItem;
    JMenuItem[] classItem;
    JMenuItem[] labelsAscItem;
    JMenuItem[] labelsDescItem;
    JRadioButton saveButton;
    JRadioButton doNotSaveButton;
    JButton nextButton;
    JFrame mainFrame;
    KNNCSearchDialog searchDialog;
    Object[][] origData;

    public KNNClassificationEditor(IFramework framework, boolean classifyGenes, int numClasses) {
        super(framework.getFrame(), true);
        int i;
        this.setTitle("KNN Classification Editor");
        this.mainFrame = (JFrame)framework.getFrame();
        this.setBounds(0, 0, 550, 800);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(0);
        this.framework = framework;
        this.data = framework.getData();
        this.numGenes = this.data.getFeaturesSize();
        this.numExps = this.data.getFeaturesCount();
        this.fieldNames = this.data.getFieldNames();
        this.classifyGenes = classifyGenes;
        this.numClasses = numClasses;
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        JPanel tablePanel = new JPanel();
        GridBagLayout grid1 = new GridBagLayout();
        tablePanel.setLayout(grid1);
        this.kModel = new KNNClassTableModel();
        this.knnClassTable = new JTable(this.kModel);
        this.knnClassTable.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i2 = 0; i2 < this.kModel.getColumnCount(); ++i2) {
            column = this.knnClassTable.getColumnModel().getColumn(i2);
            column.setMinWidth(30);
        }
        this.knnClassTable.setColumnModel(new KNNClassTableColumnModel(this.knnClassTable.getColumnModel()));
        this.knnClassTable.getModel().addTableModelListener(new ClassSelectionListener());
        this.searchDialog = new KNNCSearchDialog(this, this.knnClassTable, numClasses, false);
        JScrollPane scroll = new JScrollPane(this.knnClassTable);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        grid1.setConstraints(scroll, constraints);
        tablePanel.add(scroll);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
        gridbag.setConstraints(tablePanel, constraints);
        pane.add(tablePanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EtchedBorder());
        bottomPanel.setBackground(Color.white);
        GridBagLayout grid2 = new GridBagLayout();
        bottomPanel.setLayout(grid2);
        this.saveButton = new JRadioButton("Save classification to file", true);
        this.saveButton.setBackground(Color.white);
        this.doNotSaveButton = new JRadioButton("Do not save classification to file", false);
        this.doNotSaveButton.setBackground(Color.white);
        ButtonGroup saveOrNot = new ButtonGroup();
        saveOrNot.add(this.saveButton);
        saveOrNot.add(this.doNotSaveButton);
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        fc.setDialogTitle("Save classification");
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (KNNClassificationEditor.this.doNotSaveButton.isSelected()) {
                    KNNClassificationEditor.this.dispose();
                    KNNClassificationEditor.this.stopHere = false;
                    KNNClassificationEditor.this.nextPressed = true;
                } else {
                    int returnVal = fc.showSaveDialog(KNNClassificationEditor.this);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        KNNClassificationEditor.this.saveToFile(file);
                        KNNClassificationEditor.this.dispose();
                        KNNCSecondDialog kSecDialog = new KNNCSecondDialog(KNNClassificationEditor.this.mainFrame, true);
                        kSecDialog.setVisible(true);
                        if (!kSecDialog.proceed()) {
                            KNNClassificationEditor.this.stopHere = true;
                        } else {
                            KNNClassificationEditor.this.stopHere = false;
                        }
                        KNNClassificationEditor.this.fileSaved = true;
                        KNNClassificationEditor.this.nextPressed = true;
                    }
                }
            }
        });
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 33);
        grid2.setConstraints(this.saveButton, constraints);
        bottomPanel.add(this.saveButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 33);
        grid2.setConstraints(this.doNotSaveButton, constraints);
        bottomPanel.add(this.doNotSaveButton);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 34);
        grid2.setConstraints(this.nextButton, constraints);
        bottomPanel.add(this.nextButton);
        constraints.fill = 1;
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 10);
        gridbag.setConstraints(bottomPanel, constraints);
        pane.add(bottomPanel);
        this.setContentPane(pane);
        if (classifyGenes) {
            this.labelsAscItem = new JMenuItem[this.fieldNames.length];
            this.labelsDescItem = new JMenuItem[this.fieldNames.length];
            for (i = 0; i < this.fieldNames.length; ++i) {
                this.labelsAscItem[i] = new JMenuItem(this.fieldNames[i]);
                this.labelsDescItem[i] = new JMenuItem(this.fieldNames[i]);
            }
        } else {
            this.labelsAscItem = new JMenuItem[1];
            this.labelsAscItem[0] = new JMenuItem("Sample Name");
            this.labelsDescItem = new JMenuItem[1];
            this.labelsDescItem[0] = new JMenuItem("Sample Name");
        }
        for (i = 0; i < this.labelsAscItem.length; ++i) {
            this.labelsAscItem[i].addActionListener(new SortListener(true, false));
            this.labelsDescItem[i].addActionListener(new SortListener(false, false));
        }
        this.classItem = new JMenuItem[numClasses + 1];
        for (i = 0; i < numClasses; ++i) {
            this.classItem[i] = new JMenuItem("Class " + (i + 1));
        }
        this.classItem[numClasses] = new JMenuItem("Neutral");
        for (i = 0; i < this.classItem.length; ++i) {
            this.classItem[i].addActionListener(new AssignListener());
        }
        this.editMenu = new JMenu("Edit");
        this.selectAllItem = new JMenuItem("Select all rows");
        this.selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KNNClassificationEditor.this.knnClassTable.selectAll();
            }
        });
        this.editMenu.add(this.selectAllItem);
        this.assignSubMenu = new JMenu("Assign selected rows to");
        for (i = 0; i < this.classItem.length; ++i) {
            this.assignSubMenu.add(this.classItem[i]);
        }
        this.editMenu.add(this.assignSubMenu);
        this.menuBar.add(this.editMenu);
        this.toolsMenu = new JMenu("Tools");
        this.searchItem = new JMenuItem("Search");
        this.searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KNNClassificationEditor.this.searchTable();
            }
        });
        this.toolsMenu.add(this.searchItem);
        this.sortAscMenu = new JMenu("Sort ascending by");
        for (i = 0; i < this.labelsAscItem.length; ++i) {
            this.sortAscMenu.add(this.labelsAscItem[i]);
        }
        this.toolsMenu.add(this.sortAscMenu);
        this.sortDescMenu = new JMenu("Sort descending by");
        for (i = 0; i < this.labelsDescItem.length; ++i) {
            this.sortDescMenu.add(this.labelsDescItem[i]);
        }
        this.toolsMenu.add(this.sortDescMenu);
        this.sortByClassItem = new JMenuItem("Sort by classification");
        this.sortByClassItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KNNClassificationEditor.this.sortByClassification();
            }
        });
        this.toolsMenu.add(this.sortByClassItem);
        this.origOrderItem = new JMenuItem("Restore original ordering");
        this.origOrderItem.addActionListener(new SortListener(true, true));
        this.toolsMenu.add(this.origOrderItem);
        this.menuBar.add(this.toolsMenu);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void showModal(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.showWarningMessage();
        super.setVisible(visible);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        if (originalOrder) {
            int j2;
            int i2;
            Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    sortedData[i2][j2] = this.origData[i2][j2];
                }
            }
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    this.kModel.setValueAt(sortedData[i2][j2], i2, j2);
                }
                this.validateTable(sortedData, i2);
            }
            return;
        }
        if (column < 0 || column > this.kModel.getColumnCount()) {
            return;
        }
        Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
        Object[] sortFields = new SortableField[this.kModel.getRowCount()];
        for (int i3 = 0; i3 < sortFields.length; ++i3) {
            int origDataRow = (Integer)this.kModel.getValueAt(i3, 0);
            sortFields[i3] = new SortableField(origDataRow, column);
        }
        Arrays.sort(sortFields);
        int[] sortedIndices = new int[sortFields.length];
        for (i = 0; i < sortedIndices.length; ++i) {
            sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.kModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.knnClassTable.removeRowSelectionInterval(0, this.knnClassTable.getRowCount() - 1);
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private void sortByClassification() {
        int j;
        int i;
        int i2;
        Vector[] classVectors = new Vector[this.numClasses + 1];
        for (i2 = 0; i2 < classVectors.length; ++i2) {
            classVectors[i2] = new Vector();
        }
        block1: for (i2 = 0; i2 < this.kModel.getRowCount(); ++i2) {
            for (int j2 = 1; j2 <= this.numClasses + 1; ++j2) {
                boolean b = (Boolean)this.kModel.getValueAt(i2, j2);
                if (!b) continue;
                classVectors[j2 - 1].add(new Integer(i2));
                continue block1;
            }
        }
        int[] sortedIndices = new int[this.kModel.getRowCount()];
        int counter = 0;
        for (int i3 = 0; i3 < classVectors.length; ++i3) {
            for (int j3 = 0; j3 < classVectors[i3].size(); ++j3) {
                sortedIndices[counter] = (Integer)classVectors[i3].get(j3);
                ++counter;
            }
        }
        Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[0].length; ++j) {
                sortedData[i][j] = this.kModel.getValueAt(sortedIndices[i], j);
            }
        }
        for (i = 0; i < this.kModel.getRowCount(); ++i) {
            for (j = 0; j < this.kModel.getColumnCount(); ++j) {
                this.kModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.knnClassTable.removeRowSelectionInterval(0, this.knnClassTable.getRowCount() - 1);
    }

    private void validateTable(Object[][] tabData, int row) {
        for (int i = 1; i <= this.numClasses + 1; ++i) {
            boolean check = (Boolean)tabData[row][i];
            if (!check) continue;
            this.kModel.setValueAt(new Boolean(true), row, i);
            break;
        }
    }

    private void searchTable() {
        this.searchDialog.setVisible(true);
        this.searchDialog.toFront();
        this.searchDialog.setLocation(this.getLocation().x + 100, this.getLocation().y + 100);
    }

    private void saveToFile(File file) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            Date currDate = new Date(System.currentTimeMillis());
            String dateString = currDate.toString();
            String userName = System.getProperty("user.name");
            pw.println("# Assignment File");
            pw.println("# User: " + userName + " Save Date: " + dateString);
            pw.println("#");
            pw.print("Module:\t");
            pw.println("KNN");
            for (int i = 1; i < this.numClasses + 1; ++i) {
                pw.print("Group " + i + " Label:\t");
                pw.println("Class " + i);
            }
            pw.println("#");
            pw.println("Index\tName\tGroup Assignment");
            int numRows = this.kModel.getRowCount();
            for (int sample = 0; sample < numRows; ++sample) {
                pw.print(String.valueOf(sample + 1) + "\t");
                pw.print(this.kModel.getValueAt(sample, this.numClasses + 2) + "\t");
                for (int j = 1; j <= this.numClasses; ++j) {
                    if (!((Boolean)this.kModel.getValueAt(sample, j)).booleanValue()) continue;
                    pw.println("Class " + j);
                    break;
                }
                if (!((Boolean)this.kModel.getValueAt(sample, this.numClasses + 1)).booleanValue()) continue;
                pw.println("Exclude");
            }
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void loadFromFile(File file) {
        try {
            Object[] optionst;
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            Vector<String> data = new Vector<String>();
            while ((line = br.readLine()) != null) {
                data.add(line.trim());
            }
            br.close();
            Vector<String> groupNames = new Vector<String>();
            Vector<Integer> sampleIndices = new Vector<Integer>();
            Vector<String> sampleNames = new Vector<String>();
            Vector<String> groupAssignments = new Vector<String>();
            for (int row = 0; row < data.size(); ++row) {
                line = (String)data.get(row);
                if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                String[] lineArray = line.split("\t");
                if (lineArray[0].startsWith("Module:")) {
                    if (lineArray[1].equals("KNN")) continue;
                    optionst = new Object[]{"Continue", "Cancel"};
                    if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                    return;
                }
                if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                    groupNames.add(lineArray[1]);
                    continue;
                }
                try {
                    Integer.parseInt(lineArray[0]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                sampleIndices.add(new Integer(lineArray[0]));
                sampleNames.add(lineArray[1]);
                groupAssignments.add(lineArray[2]);
            }
            int numRows = this.kModel.getRowCount();
            if (numRows != sampleNames.size()) {
                System.out.println(numRows + "  " + sampleNames.size());
                System.out.println(numRows + " s length " + sampleNames.size());
                JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + numRows + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                this.incompatible = true;
                return;
            }
            if (this.numClasses != groupNames.size()) {
                optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using " + groupNames.size() + " classes.\nWould you like MeV to attempt to load selections into " + this.numClasses + " classes?", "Class number warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
            }
            int fileSampleIndex = 0;
            int groupIndex = 0;
            for (int sample = 0; sample < numRows; ++sample) {
                boolean doIndex = false;
                for (int i = 0; i < numRows; ++i) {
                    if (i == sample || !((String)this.kModel.getValueAt(sample, this.numClasses + 2)).equals((String)this.kModel.getValueAt(i, this.numClasses + 2))) continue;
                    doIndex = true;
                }
                try {
                    fileSampleIndex = sampleNames.indexOf((String)this.kModel.getValueAt(sample, this.numClasses + 2));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fileSampleIndex = -1;
                }
                if (fileSampleIndex == -1) {
                    doIndex = true;
                }
                if (doIndex) {
                    this.setStateBasedOnIndex(groupAssignments, groupNames);
                    break;
                }
                String groupName = (String)groupAssignments.get(fileSampleIndex);
                groupIndex = groupNames.indexOf(groupName);
                if (groupIndex == -1 || groupIndex > this.numClasses) {
                    groupIndex = this.numClasses;
                }
                try {
                    this.kModel.setValueAt(new Boolean(true), sample, groupIndex + 1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.kModel.setValueAt(new Boolean(true), sample, this.numClasses + 1);
                }
            }
            this.showModal(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.incompatible = true;
            JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
        }
    }

    private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames) {
        Object[] optionst = new Object[]{"Continue", "Cancel"};
        if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
            return;
        }
        int numRows = this.kModel.getRowCount();
        for (int sample = 0; sample < numRows; ++sample) {
            try {
                this.kModel.setValueAt(new Boolean(true), sample, groupNames.indexOf(groupAssignments.get(sample) + 1));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.kModel.setValueAt(new Boolean(true), sample, this.numClasses + 1);
            }
        }
    }

    public Vector[] getClassification() {
        Vector<Integer> indicesVector = new Vector<Integer>();
        Vector<Integer> classVector = new Vector<Integer>();
        Vector[] vectArray = new Vector[2];
        for (int i = 0; i < this.kModel.getRowCount(); ++i) {
            if (((Boolean)this.kModel.getValueAt(i, this.numClasses + 1)).booleanValue()) continue;
            indicesVector.add((Integer)this.kModel.getValueAt(i, 0));
            classVector.add(new Integer(this.getClass(i)));
        }
        vectArray[0] = indicesVector;
        vectArray[1] = classVector;
        return vectArray;
    }

    public boolean isNextPressed() {
        return this.nextPressed;
    }

    private int getClass(int row) {
        int i;
        for (i = 1; i <= this.numClasses + 1 && !((Boolean)this.kModel.getValueAt(row, i)).booleanValue(); ++i) {
        }
        return i;
    }

    public boolean proceed() {
        return !this.stopHere;
    }

    public boolean fileIsIncompatible() {
        return this.incompatible;
    }

    public void showWarningMessage() {
        JTextArea area = new JTextArea();
        area.append("The editor displays all genes or expts in the data set loaded into MeV,");
        area.append("\nincluding those that have been removed from analysis by variance filtering");
        area.append("\nin the previous stage, or by applying cutoffs under the Adjust Data");
        area.append("\nmenu. If you designate such genes  or samples as classifiers,");
        area.append("\nthey will not be used for classification");
        area.setEditable(false);
        area.setBackground(Color.gray.brighter());
        JOptionPane.showMessageDialog(this, area, "Warning", 2);
    }

    public class SortListener
    implements ActionListener {
        boolean asc;
        boolean origOrd;

        public SortListener(boolean asc, boolean origOrd) {
            this.asc = asc;
            this.origOrd = origOrd;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int colToSort = KNNClassificationEditor.this.kModel.getColumnIndex(key);
                KNNClassificationEditor.this.sortByColumn(colToSort, this.asc, this.origOrd);
            }
        }
    }

    public class AssignListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int classCol = KNNClassificationEditor.this.kModel.getColumnIndex(key);
                int[] selectedRows = KNNClassificationEditor.this.knnClassTable.getSelectedRows();
                int[] selectedIndices = new int[selectedRows.length];
                for (int i = 0; i < selectedRows.length; ++i) {
                    KNNClassificationEditor.this.kModel.setValueAt(new Boolean(true), selectedRows[i], classCol);
                }
            }
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)KNNClassificationEditor.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClassSelectionListener
    implements TableModelListener {
        ClassSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tme) {
            int selectedCol = tme.getColumn();
            int selectedRow = tme.getFirstRow();
            if (selectedCol < 1 || selectedCol > KNNClassificationEditor.this.numClasses + 1) {
                return;
            }
            if (this.verifySelected(selectedRow, selectedCol)) {
                this.changeNeighbors(selectedRow, selectedCol);
            }
            int origDataRow = (Integer)KNNClassificationEditor.this.kModel.getValueAt(selectedRow, 0);
            KNNClassificationEditor.this.origData[origDataRow][selectedCol] = new Boolean(true);
            for (int i = 1; i <= KNNClassificationEditor.this.numClasses + 1; ++i) {
                if (i == selectedCol) continue;
                KNNClassificationEditor.this.origData[origDataRow][i] = new Boolean(false);
            }
        }

        private void changeNeighbors(int first, int col) {
            for (int i = 1; i <= KNNClassificationEditor.this.numClasses + 1; ++i) {
                if (i == col) continue;
                KNNClassificationEditor.this.knnClassTable.setValueAt(new Boolean(false), first, i);
            }
        }

        private boolean verifySelected(int row, int col) {
            boolean selVal = (Boolean)KNNClassificationEditor.this.knnClassTable.getValueAt(row, col);
            if (selVal) {
                return true;
            }
            Vector<Boolean> truthValues = new Vector<Boolean>();
            for (int i = 1; i <= KNNClassificationEditor.this.numClasses + 1; ++i) {
                if (i == col) continue;
                boolean value = (Boolean)KNNClassificationEditor.this.knnClassTable.getValueAt(row, i);
                truthValues.add(new Boolean(value));
            }
            boolean val1 = true;
            for (int i = 0; i < truthValues.size(); ++i) {
                boolean val2 = (Boolean)truthValues.get(i);
                if (!val2) continue;
                val1 = false;
                break;
            }
            if (val1) {
                KNNClassificationEditor.this.knnClassTable.setValueAt(new Boolean(true), row, col);
            }
            return false;
        }
    }

    class KNNClassTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public KNNClassTableColumnModel(TableColumnModel TCM) {
            this.tcm = TCM;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public TableColumn getColumn(int param) {
            return this.tcm.getColumn(param);
        }

        @Override
        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }

        @Override
        public int getColumnIndex(Object obj) {
            return this.tcm.getColumnIndex(obj);
        }

        @Override
        public int getColumnIndexAtX(int param) {
            return this.tcm.getColumnIndexAtX(param);
        }

        @Override
        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        @Override
        public void moveColumn(int from, int to) {
            if (from <= KNNClassificationEditor.this.numClasses + 1 || to <= KNNClassificationEditor.this.numClasses + 1) {
                return;
            }
            this.tcm.moveColumn(from, to);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            this.tcm.removeColumn(tableColumn);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void setColumnMargin(int param) {
            this.tcm.setColumnMargin(param);
        }

        @Override
        public void setColumnSelectionAllowed(boolean param) {
            this.tcm.setColumnSelectionAllowed(param);
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }
    }

    class KNNClassTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;
        int indexLastClass;

        public KNNClassTableModel() {
            int j;
            int i;
            this.indexLastClass = KNNClassificationEditor.this.numClasses;
            if (KNNClassificationEditor.this.classifyGenes) {
                this.columnNames = new String[KNNClassificationEditor.this.fieldNames.length + KNNClassificationEditor.this.numClasses + 2];
                this.columnNames[0] = "Index";
                for (i = 0; i < KNNClassificationEditor.this.numClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                this.columnNames[KNNClassificationEditor.this.numClasses + 1] = "Neutral";
                for (i = 0; i < KNNClassificationEditor.this.fieldNames.length; ++i) {
                    this.columnNames[KNNClassificationEditor.this.numClasses + 2 + i] = KNNClassificationEditor.this.fieldNames[i];
                }
                this.tableData = new Object[KNNClassificationEditor.this.numGenes][this.columnNames.length];
                for (i = 0; i < this.tableData.length; ++i) {
                    for (j = 0; j < this.columnNames.length; ++j) {
                        this.tableData[i][j] = j == 0 ? new Integer(i) : (j > 0 && j < KNNClassificationEditor.this.numClasses + 1 ? new Boolean(false) : (j == KNNClassificationEditor.this.numClasses + 1 ? new Boolean(true) : KNNClassificationEditor.this.data.getElementAttribute(i, j - (KNNClassificationEditor.this.numClasses + 2))));
                    }
                }
            } else {
                this.columnNames = new String[KNNClassificationEditor.this.numClasses + 3];
                this.columnNames[0] = "Index";
                for (i = 0; i < KNNClassificationEditor.this.numClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                this.columnNames[KNNClassificationEditor.this.numClasses + 1] = "Neutral";
                this.columnNames[KNNClassificationEditor.this.numClasses + 2] = "Sample Name";
                this.tableData = new Object[KNNClassificationEditor.this.numExps][this.columnNames.length];
                for (i = 0; i < this.tableData.length; ++i) {
                    for (j = 0; j < this.columnNames.length; ++j) {
                        if (j == 0) {
                            this.tableData[i][j] = new Integer(i);
                            continue;
                        }
                        if (j > 0 && j < KNNClassificationEditor.this.numClasses + 1) {
                            this.tableData[i][j] = new Boolean(false);
                            continue;
                        }
                        if (j == KNNClassificationEditor.this.numClasses + 1) {
                            this.tableData[i][j] = new Boolean(true);
                            continue;
                        }
                        if (j != KNNClassificationEditor.this.numClasses + 2) continue;
                        this.tableData[i][j] = KNNClassificationEditor.this.data.getFullSampleName(i);
                    }
                }
            }
            KNNClassificationEditor.this.origData = new Object[this.tableData.length][this.tableData[0].length];
            for (i = 0; i < this.tableData.length; ++i) {
                for (j = 0; j < this.tableData[0].length; ++j) {
                    KNNClassificationEditor.this.origData[i][j] = this.tableData[i][j];
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnIndex(String name) {
            int i;
            for (i = 0; i < this.columnNames.length && !this.columnNames[i].equals(name); ++i) {
            }
            if (i < this.columnNames.length) {
                return i;
            }
            return -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Integer.class;
            }
            if (c > 0 && c <= KNNClassificationEditor.this.numClasses + 1) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && col <= KNNClassificationEditor.this.numClasses + 1;
        }
    }

    class KNNClassifierTable
    extends JTable {
        KNNClassifierTable() {
        }
    }
}

