/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KNNCValidationInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202009020001L;
    private JComponent header;
    private JTextArea content;
    private int[] origNumInFiltTrgSetByClass;
    private int[] numberCorrectlyClassifiedByClass;
    private int[] numberIncorrectlyClassifiedByClass;

    public KNNCValidationInfoViewer(int[] origNumInFiltTrgSetByClass, int[] numberCorrectlyClassifiedByClass, int[] numberIncorrectlyClassifiedByClass) {
        this.origNumInFiltTrgSetByClass = origNumInFiltTrgSetByClass;
        this.numberCorrectlyClassifiedByClass = numberCorrectlyClassifiedByClass;
        this.numberIncorrectlyClassifiedByClass = numberIncorrectlyClassifiedByClass;
        this.header = this.createHeader();
        this.content = this.createContent();
        this.setMaxWidth(this.content, this.header);
    }

    public KNNCValidationInfoViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Leave one out cross-validation (LOOCV) statistics</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent() {
        JTextArea area = new JTextArea();
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < this.origNumInFiltTrgSetByClass.length; ++i) {
            sb.append("Class " + i + ":\n\t");
            sb.append("Original number* of training set elements in class = " + this.origNumInFiltTrgSetByClass[i] + "\n\t");
            sb.append("Number of training set elements correctly assigned to class by LOOCV = " + this.numberCorrectlyClassifiedByClass[i] + "\n\t");
            sb.append("Number of training set elements falsely assigned to class by LOOCV = " + this.numberIncorrectlyClassifiedByClass[i] + "\n");
        }
        sb.append("\n\n*Indicates number of training set elements in a given class after variance filtering, if applied.");
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }
}

