/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;

public class KNNCValidationFirstDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton genesButton;
    JRadioButton expsButton;
    JRadioButton createNewTrgSetButton;
    JRadioButton useExistTrgSetButton;
    JCheckBox useCorrelFilterBox;
    JTextField pValueField;
    JTextField numClassesField;
    JTextField numNeighborsField;
    JTextField numPermsField;
    JLabel corrLabel;
    JLabel numPermsLabel;
    HCLSelectionPanel hclOpsPanel;
    IFramework framework;
    Experiment experiment;
    KNNClassificationEditor knnEditor;
    int numExps;
    int numGenes;

    public KNNCValidationFirstDialog(JFrame parentFrame, boolean modality, IFramework framework_1) {
        super(parentFrame, "KNN Validation", modality);
        this.okButton.setText("Next >");
        this.setBounds(0, 0, 550, 550);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.framework = framework_1;
        this.experiment = this.framework.getData().getExperiment();
        this.numExps = this.experiment.getNumberOfSamples();
        this.numGenes = this.experiment.getNumberOfGenes();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridbag);
        this.useCorrelFilterBox = new JCheckBox("Use correlation filter", false);
        JPanel genesOrExpsPanel = new JPanel();
        genesOrExpsPanel.setBackground(Color.white);
        genesOrExpsPanel.setBorder(new TitledBorder("Classify genes or samples"));
        GridBagLayout grid1 = new GridBagLayout();
        genesOrExpsPanel.setLayout(grid1);
        this.genesButton = new JRadioButton("Classify genes", true);
        this.genesButton.setBackground(Color.white);
        this.expsButton = new JRadioButton("Classify samples", false);
        this.expsButton.setBackground(Color.white);
        ButtonGroup genesOrExpsGroup = new ButtonGroup();
        genesOrExpsGroup.add(this.genesButton);
        genesOrExpsGroup.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid1.setConstraints(this.genesButton, constraints);
        genesOrExpsPanel.add(this.genesButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid1.setConstraints(this.expsButton, constraints);
        genesOrExpsPanel.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 10);
        constraints.fill = 1;
        gridbag.setConstraints(genesOrExpsPanel, constraints);
        mainPanel.add(genesOrExpsPanel);
        constraints.fill = 0;
        JPanel correlPanel = new JPanel();
        correlPanel.setBackground(Color.white);
        correlPanel.setBorder(new TitledBorder("Correlation filter"));
        GridBagLayout grid2 = new GridBagLayout();
        correlPanel.setLayout(grid2);
        this.useCorrelFilterBox.setBackground(Color.white);
        this.corrLabel = new JLabel("          Cutoff p-value for correlation: ");
        this.corrLabel.setEnabled(false);
        this.numPermsLabel = new JLabel("          Number of permutations for correlation test: ");
        this.numPermsLabel.setEnabled(false);
        this.pValueField = new JTextField("0.01", 7);
        this.pValueField.setEnabled(false);
        this.pValueField.setBackground(Color.gray);
        this.numPermsField = new JTextField("1000", 7);
        this.numPermsField.setEnabled(false);
        this.numPermsField.setBackground(Color.gray);
        this.useCorrelFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    KNNCValidationFirstDialog.this.corrLabel.setEnabled(false);
                    KNNCValidationFirstDialog.this.numPermsLabel.setEnabled(false);
                    KNNCValidationFirstDialog.this.pValueField.setEnabled(false);
                    KNNCValidationFirstDialog.this.pValueField.setBackground(Color.gray);
                    KNNCValidationFirstDialog.this.numPermsField.setEnabled(false);
                    KNNCValidationFirstDialog.this.numPermsField.setBackground(Color.gray);
                } else {
                    KNNCValidationFirstDialog.this.corrLabel.setEnabled(true);
                    KNNCValidationFirstDialog.this.numPermsLabel.setEnabled(true);
                    KNNCValidationFirstDialog.this.pValueField.setEnabled(true);
                    KNNCValidationFirstDialog.this.pValueField.setBackground(Color.white);
                    KNNCValidationFirstDialog.this.numPermsField.setEnabled(true);
                    KNNCValidationFirstDialog.this.numPermsField.setBackground(Color.white);
                }
            }
        });
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 34);
        grid2.setConstraints(this.useCorrelFilterBox, constraints);
        correlPanel.add(this.useCorrelFilterBox);
        this.buildConstraints(constraints, 0, 1, 1, 1, 70, 33);
        grid2.setConstraints(this.corrLabel, constraints);
        correlPanel.add(this.corrLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
        grid2.setConstraints(this.pValueField, constraints);
        correlPanel.add(this.pValueField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 70, 33);
        grid2.setConstraints(this.numPermsLabel, constraints);
        correlPanel.add(this.numPermsLabel);
        this.buildConstraints(constraints, 1, 2, 1, 1, 30, 0);
        grid2.setConstraints(this.numPermsField, constraints);
        correlPanel.add(this.numPermsField);
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 25);
        constraints.fill = 1;
        gridbag.setConstraints(correlPanel, constraints);
        mainPanel.add(correlPanel);
        constraints.fill = 0;
        JPanel knnParamPanel = new JPanel();
        knnParamPanel.setBackground(Color.white);
        knnParamPanel.setBorder(new TitledBorder("KNN classification parameters"));
        GridBagLayout grid4 = new GridBagLayout();
        knnParamPanel.setLayout(grid4);
        JLabel numClassesLabel = new JLabel("          Number of classes");
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
        grid4.setConstraints(numClassesLabel, constraints);
        knnParamPanel.add(numClassesLabel);
        this.numClassesField = new JTextField("5", 7);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid4.setConstraints(this.numClassesField, constraints);
        knnParamPanel.add(this.numClassesField);
        JLabel numNeighborsLabel = new JLabel("          Number of neighbors");
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
        grid4.setConstraints(numNeighborsLabel, constraints);
        knnParamPanel.add(numNeighborsLabel);
        this.numNeighborsField = new JTextField("3", 7);
        this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
        grid4.setConstraints(this.numNeighborsField, constraints);
        knnParamPanel.add(this.numNeighborsField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 25);
        constraints.fill = 1;
        gridbag.setConstraints(knnParamPanel, constraints);
        mainPanel.add(knnParamPanel);
        constraints.fill = 0;
        JPanel makeTrainingSetPanel = new JPanel();
        makeTrainingSetPanel.setBackground(Color.white);
        makeTrainingSetPanel.setBorder(new TitledBorder("Create / import training set"));
        GridBagLayout grid5 = new GridBagLayout();
        makeTrainingSetPanel.setLayout(grid5);
        this.createNewTrgSetButton = new JRadioButton("Create new training set from data", true);
        this.createNewTrgSetButton.setBackground(Color.white);
        this.useExistTrgSetButton = new JRadioButton("Use previously created training set from file", false);
        this.useExistTrgSetButton.setBackground(Color.white);
        ButtonGroup newOrExisting = new ButtonGroup();
        newOrExisting.add(this.createNewTrgSetButton);
        newOrExisting.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        constraints.anchor = 10;
        grid5.setConstraints(this.createNewTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.createNewTrgSetButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
        grid5.setConstraints(this.useExistTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 0, 3, 1, 1, 100, 30);
        constraints.anchor = 17;
        constraints.fill = 1;
        gridbag.setConstraints(makeTrainingSetPanel, constraints);
        mainPanel.add(makeTrainingSetPanel);
        constraints.fill = 0;
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(constraints, 0, 4, 1, 1, 100, 10);
        constraints.fill = 1;
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        mainPanel.add(this.hclOpsPanel);
        this.addContent(mainPanel);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean classifyGenes() {
        return this.genesButton.isSelected();
    }

    public int getNumClasses() {
        String s = this.numClassesField.getText();
        return Integer.parseInt(s);
    }

    public boolean createNewTrgSet() {
        return this.createNewTrgSetButton.isSelected();
    }

    public boolean useCorrelFilter() {
        return this.useCorrelFilterBox.isSelected();
    }

    public double getCorrPValue() {
        return Double.parseDouble(this.pValueField.getText());
    }

    public int getNumPerms() {
        return Integer.parseInt(this.numPermsField.getText());
    }

    public int getNumNeighbors() {
        return Integer.parseInt(this.numNeighborsField.getText());
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                try {
                    int val3;
                    if (KNNCValidationFirstDialog.this.useCorrelFilterBox.isSelected()) {
                        double val2 = new Double(KNNCValidationFirstDialog.this.pValueField.getText());
                        if (val2 < 0.0 || val2 > 1.0) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Correlation p-value must be between 0 and 1", "Error!", 2);
                            return;
                        }
                        double validateNumPerms = new Double(KNNCValidationFirstDialog.this.numPermsField.getText());
                        if (validateNumPerms <= 0.0) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of permutations must be > 0", "Error!", 2);
                            return;
                        }
                    }
                    if (((val3 = new Integer(KNNCValidationFirstDialog.this.numClassesField.getText()).intValue()) <= 0 || val3 >= KNNCValidationFirstDialog.this.numGenes) && KNNCValidationFirstDialog.this.genesButton.isSelected()) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of classes must be > 0 and < " + KNNCValidationFirstDialog.this.numGenes, "Error!", 2);
                        return;
                    }
                    if ((val3 <= 0 || val3 >= KNNCValidationFirstDialog.this.numExps) && KNNCValidationFirstDialog.this.expsButton.isSelected()) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of classes must be > 0 and < " + KNNCValidationFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    int val4 = new Integer(KNNCValidationFirstDialog.this.numNeighborsField.getText());
                    if (KNNCValidationFirstDialog.this.genesButton.isSelected()) {
                        if (val4 <= 0 || val4 > KNNCValidationFirstDialog.this.numGenes) {
                            JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of neighbors must be > 0 and <= " + KNNCValidationFirstDialog.this.numGenes, "Error!", 2);
                            return;
                        }
                    } else if (val4 <= 0 || val4 > KNNCValidationFirstDialog.this.numExps) {
                        JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Number of neighbors must be > 0 and <= " + KNNCValidationFirstDialog.this.numExps, "Error!", 2);
                        return;
                    }
                    KNNCValidationFirstDialog.this.okPressed = true;
                    KNNCValidationFirstDialog.this.dispose();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(KNNCValidationFirstDialog.this, "Invalid format for at least one parameter", "Error!", 2);
                }
            } else if (command.equals("reset-command")) {
                KNNCValidationFirstDialog.this.okPressed = false;
                KNNCValidationFirstDialog.this.genesButton.setSelected(true);
                KNNCValidationFirstDialog.this.expsButton.setSelected(false);
                KNNCValidationFirstDialog.this.useCorrelFilterBox.setSelected(false);
                KNNCValidationFirstDialog.this.pValueField.setText("0.01");
                KNNCValidationFirstDialog.this.numPermsField.setText("1000");
                KNNCValidationFirstDialog.this.numClassesField.setText("5");
                KNNCValidationFirstDialog.this.numNeighborsField.setText("3");
                KNNCValidationFirstDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (command.equals("cancel-command")) {
                KNNCValidationFirstDialog.this.okPressed = false;
                KNNCValidationFirstDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(KNNCValidationFirstDialog.this, "KNNC Validation Parameter Selections");
            }
        }
    }
}

