/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;

public class KNNCSecondDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton stopButton;
    JRadioButton continueButton;

    public KNNCSecondDialog(JFrame parentFrame, boolean modality) {
        super(parentFrame, "KNN classify - continue with analysis?", modality);
        this.setBounds(0, 0, 500, 200);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        JPanel pane = new JPanel();
        pane.setBackground(Color.white);
        pane.setBorder(new EtchedBorder());
        pane.setLayout(gridbag);
        this.stopButton = new JRadioButton("Stop here, don't classify", true);
        this.stopButton.setBackground(Color.white);
        this.continueButton = new JRadioButton("Proceed with classification", false);
        this.continueButton.setBackground(Color.white);
        ButtonGroup stopOrContinue = new ButtonGroup();
        stopOrContinue.add(this.stopButton);
        stopOrContinue.add(this.continueButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        gridbag.setConstraints(this.stopButton, constraints);
        pane.add(this.stopButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
        gridbag.setConstraints(this.continueButton, constraints);
        pane.add(this.continueButton);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean proceed() {
        return this.continueButton.isSelected();
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                KNNCSecondDialog.this.okPressed = true;
                KNNCSecondDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                KNNCSecondDialog.this.okPressed = false;
                KNNCSecondDialog.this.stopButton.setSelected(true);
                KNNCSecondDialog.this.continueButton.setSelected(false);
            } else if (command.equals("cancel-command")) {
                KNNCSecondDialog.this.okPressed = false;
                KNNCSecondDialog.this.dispose();
            } else if (command.equals("info-command")) {
                // empty if block
            }
        }
    }
}

