/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;

public class KNNCInitDialog
extends AlgorithmDialog {
    boolean okPressed = false;
    JRadioButton genesButton;
    JRadioButton expsButton;
    JRadioButton createNewTrgSetButton;
    JRadioButton useExistTrgSetButton;
    JRadioButton trgSetFromCurrent;
    JRadioButton trgSetNotFromCurrent;
    JButton classEditorButton;
    JButton browseTrgFileButton;
    JButton previewTrgSetButton;
    JCheckBox useVarianceFilterBox;
    JCheckBox useCorrelFilterBox;
    JTextField numGenesField;
    JTextField pValueField;
    JTextField numClassesField;
    JTextField numNeighborsField;
    JTextField pathFileField;
    JComboBox annotSelectBox;
    JLabel varLabel;
    JLabel corrLabel;
    JLabel pathLabel;
    JLabel questionLabel;
    JPanel trgSetSpecPanel;
    JTabbedPane classifyOrValidatePane;
    HCLSelectionPanel hclOpsPanel;
    IFramework framework;
    Experiment experiment;
    KNNClassificationEditor knnEditor;
    int numExps;
    int numGenes;

    public KNNCInitDialog(JFrame parentFrame, boolean modality, IFramework framework_1) {
        super(parentFrame, "KNN Classification", modality);
        this.setBounds(0, 0, 550, 800);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.framework = framework_1;
        this.experiment = this.framework.getData().getExperiment();
        this.knnEditor = new KNNClassificationEditor(this.framework, true, 5);
        this.numExps = this.experiment.getNumberOfSamples();
        this.numGenes = this.experiment.getNumberOfGenes();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridbag);
        JPanel classifyPanel = new JPanel();
        GridBagLayout classGrid = new GridBagLayout();
        classifyPanel.setLayout(classGrid);
        JPanel genesOrExpsPanel = new JPanel();
        genesOrExpsPanel.setBackground(Color.white);
        genesOrExpsPanel.setBorder(new TitledBorder("Classify genes or samples"));
        GridBagLayout grid1 = new GridBagLayout();
        genesOrExpsPanel.setLayout(grid1);
        this.genesButton = new JRadioButton("Classify genes", true);
        this.genesButton.setBackground(Color.white);
        this.expsButton = new JRadioButton("Classify samples", false);
        this.expsButton.setBackground(Color.white);
        ButtonGroup genesOrExpsGroup = new ButtonGroup();
        genesOrExpsGroup.add(this.genesButton);
        genesOrExpsGroup.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
        grid1.setConstraints(this.genesButton, constraints);
        genesOrExpsPanel.add(this.genesButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid1.setConstraints(this.expsButton, constraints);
        genesOrExpsPanel.add(this.expsButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 10);
        constraints.fill = 1;
        classGrid.setConstraints(genesOrExpsPanel, constraints);
        classifyPanel.add(genesOrExpsPanel);
        constraints.fill = 0;
        JPanel variancePanel = new JPanel();
        variancePanel.setBackground(Color.white);
        variancePanel.setBorder(new TitledBorder("Variance filter"));
        GridBagLayout grid3 = new GridBagLayout();
        variancePanel.setLayout(grid3);
        this.useVarianceFilterBox = new JCheckBox("Use variance filter (if unchecked, use all vectors)", false);
        this.useVarianceFilterBox.setBackground(Color.white);
        this.varLabel = new JLabel("Use only the following number of highest-variance vectors: ");
        this.varLabel.setEnabled(false);
        this.numGenesField = new JTextField("1000", 7);
        this.numGenesField.setEnabled(false);
        this.numGenesField.setBackground(Color.gray);
        this.useVarianceFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    KNNCInitDialog.this.varLabel.setEnabled(false);
                    KNNCInitDialog.this.numGenesField.setEnabled(false);
                    KNNCInitDialog.this.numGenesField.setBackground(Color.gray);
                } else {
                    KNNCInitDialog.this.varLabel.setEnabled(true);
                    KNNCInitDialog.this.numGenesField.setEnabled(true);
                    KNNCInitDialog.this.numGenesField.setBackground(Color.white);
                }
            }
        });
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        grid3.setConstraints(this.useVarianceFilterBox, constraints);
        variancePanel.add(this.useVarianceFilterBox);
        this.buildConstraints(constraints, 0, 1, 1, 1, 70, 50);
        grid3.setConstraints(this.varLabel, constraints);
        variancePanel.add(this.varLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
        grid3.setConstraints(this.numGenesField, constraints);
        variancePanel.add(this.numGenesField);
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 10);
        constraints.fill = 1;
        classGrid.setConstraints(variancePanel, constraints);
        classifyPanel.add(variancePanel);
        constraints.fill = 0;
        JPanel correlPanel = new JPanel();
        correlPanel.setBackground(Color.white);
        correlPanel.setBorder(new TitledBorder("Correlation filter"));
        GridBagLayout grid2 = new GridBagLayout();
        correlPanel.setLayout(grid2);
        this.useCorrelFilterBox = new JCheckBox("Use correlation filter", false);
        this.useCorrelFilterBox.setBackground(Color.white);
        this.corrLabel = new JLabel("Cutoff p-value for correlation: ");
        this.corrLabel.setEnabled(false);
        this.pValueField = new JTextField("0.01", 7);
        this.pValueField.setEnabled(false);
        this.pValueField.setBackground(Color.gray);
        this.useCorrelFilterBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    KNNCInitDialog.this.corrLabel.setEnabled(false);
                    KNNCInitDialog.this.pValueField.setEnabled(false);
                    KNNCInitDialog.this.pValueField.setBackground(Color.gray);
                } else {
                    KNNCInitDialog.this.corrLabel.setEnabled(true);
                    KNNCInitDialog.this.pValueField.setEnabled(true);
                    KNNCInitDialog.this.pValueField.setBackground(Color.white);
                }
            }
        });
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 50);
        grid2.setConstraints(this.useCorrelFilterBox, constraints);
        correlPanel.add(this.useCorrelFilterBox);
        this.buildConstraints(constraints, 0, 1, 1, 1, 70, 50);
        grid2.setConstraints(this.corrLabel, constraints);
        correlPanel.add(this.corrLabel);
        this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
        grid2.setConstraints(this.pValueField, constraints);
        correlPanel.add(this.pValueField);
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 10);
        constraints.fill = 1;
        classGrid.setConstraints(correlPanel, constraints);
        classifyPanel.add(correlPanel);
        constraints.fill = 0;
        JPanel knnParamPanel = new JPanel();
        knnParamPanel.setBackground(Color.white);
        knnParamPanel.setBorder(new TitledBorder("KNN classification parameters"));
        GridBagLayout grid4 = new GridBagLayout();
        knnParamPanel.setLayout(grid4);
        JLabel numClassesLabel = new JLabel("Number of classes");
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
        grid4.setConstraints(numClassesLabel, constraints);
        knnParamPanel.add(numClassesLabel);
        this.numClassesField = new JTextField("5", 7);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid4.setConstraints(this.numClassesField, constraints);
        knnParamPanel.add(this.numClassesField);
        JLabel numNeighborsLabel = new JLabel("Number of neighbors");
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 50);
        grid4.setConstraints(numNeighborsLabel, constraints);
        knnParamPanel.add(numNeighborsLabel);
        this.numNeighborsField = new JTextField("3", 7);
        this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
        grid4.setConstraints(this.numNeighborsField, constraints);
        knnParamPanel.add(this.numNeighborsField);
        this.buildConstraints(constraints, 0, 3, 1, 1, 100, 10);
        constraints.fill = 1;
        classGrid.setConstraints(knnParamPanel, constraints);
        classifyPanel.add(knnParamPanel);
        constraints.fill = 0;
        JPanel makeTrainingSetPanel = new JPanel();
        makeTrainingSetPanel.setBackground(Color.white);
        makeTrainingSetPanel.setBorder(new TitledBorder("Create / import training set"));
        GridBagLayout grid5 = new GridBagLayout();
        makeTrainingSetPanel.setLayout(grid5);
        this.trgSetSpecPanel = new JPanel();
        this.trgSetSpecPanel.setBackground(Color.gray);
        this.trgSetSpecPanel.setBorder(new TitledBorder("Training file specifications"));
        GridBagLayout grid6 = new GridBagLayout();
        this.trgSetSpecPanel.setLayout(grid6);
        this.questionLabel = new JLabel("Was training file created from current data set?");
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 25);
        grid6.setConstraints(this.questionLabel, constraints);
        this.trgSetSpecPanel.add(this.questionLabel);
        String[] annotFields = new String[]{"field1", "field2", "field3", "field4"};
        this.annotSelectBox = new JComboBox<String>(annotFields);
        this.annotSelectBox.setEnabled(false);
        this.trgSetFromCurrent = new JRadioButton("Yes", true);
        this.trgSetFromCurrent.setBackground(Color.gray);
        this.trgSetNotFromCurrent = new JRadioButton("No - select annotation column of current data set to match to: ", false);
        this.trgSetNotFromCurrent.setBackground(Color.gray);
        this.trgSetFromCurrent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                } else {
                    KNNCInitDialog.this.annotSelectBox.setEnabled(true);
                }
            }
        });
        ButtonGroup currentOrNot = new ButtonGroup();
        currentOrNot.add(this.trgSetFromCurrent);
        currentOrNot.add(this.trgSetNotFromCurrent);
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 25);
        grid6.setConstraints(this.trgSetFromCurrent, constraints);
        this.trgSetSpecPanel.add(this.trgSetFromCurrent);
        this.buildConstraints(constraints, 0, 2, 1, 1, 80, 25);
        grid6.setConstraints(this.trgSetNotFromCurrent, constraints);
        this.trgSetSpecPanel.add(this.trgSetNotFromCurrent);
        this.buildConstraints(constraints, 1, 2, 1, 1, 20, 0);
        grid6.setConstraints(this.annotSelectBox, constraints);
        this.trgSetSpecPanel.add(this.annotSelectBox);
        this.previewTrgSetButton = new JButton("View / modify training set assignments from file");
        constraints.anchor = 10;
        this.buildConstraints(constraints, 0, 3, 1, 1, 100, 25);
        grid6.setConstraints(this.previewTrgSetButton, constraints);
        this.trgSetSpecPanel.add(this.previewTrgSetButton);
        this.createNewTrgSetButton = new JRadioButton("Create new training set from data   >>", true);
        this.createNewTrgSetButton.setBackground(Color.white);
        this.useExistTrgSetButton = new JRadioButton("Use previously created training set from file   >>", false);
        this.useExistTrgSetButton.setBackground(Color.white);
        this.classEditorButton = new JButton("Classificaton editor ...");
        this.classEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KNNCInitDialog.this.knnEditor = new KNNClassificationEditor(KNNCInitDialog.this.framework, KNNCInitDialog.this.classifyGenes(), KNNCInitDialog.this.getNumClasses());
                KNNCInitDialog.this.knnEditor.setVisible(true);
            }
        });
        this.browseTrgFileButton = new JButton("Browse files ...");
        this.pathLabel = new JLabel("Selected file: ");
        this.pathFileField = new JTextField(80);
        this.browseTrgFileButton.setEnabled(false);
        this.pathLabel.setEnabled(false);
        this.pathFileField.setEnabled(false);
        this.questionLabel.setEnabled(false);
        this.trgSetFromCurrent.setEnabled(false);
        this.trgSetNotFromCurrent.setEnabled(false);
        this.annotSelectBox.setEnabled(false);
        this.previewTrgSetButton.setEnabled(false);
        this.createNewTrgSetButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    KNNCInitDialog.this.trgSetSpecPanel.setBackground(Color.gray);
                    KNNCInitDialog.this.browseTrgFileButton.setEnabled(false);
                    KNNCInitDialog.this.pathLabel.setEnabled(false);
                    KNNCInitDialog.this.pathFileField.setEnabled(false);
                    KNNCInitDialog.this.questionLabel.setEnabled(false);
                    KNNCInitDialog.this.trgSetFromCurrent.setEnabled(false);
                    KNNCInitDialog.this.trgSetFromCurrent.setBackground(Color.gray);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setEnabled(false);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setBackground(Color.gray);
                    KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                    KNNCInitDialog.this.previewTrgSetButton.setEnabled(false);
                } else {
                    KNNCInitDialog.this.trgSetSpecPanel.setBackground(Color.white);
                    KNNCInitDialog.this.browseTrgFileButton.setEnabled(true);
                    KNNCInitDialog.this.pathLabel.setEnabled(true);
                    KNNCInitDialog.this.pathFileField.setEnabled(true);
                    KNNCInitDialog.this.questionLabel.setEnabled(true);
                    KNNCInitDialog.this.trgSetFromCurrent.setEnabled(true);
                    KNNCInitDialog.this.trgSetFromCurrent.setBackground(Color.white);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setEnabled(true);
                    KNNCInitDialog.this.trgSetNotFromCurrent.setBackground(Color.white);
                    if (KNNCInitDialog.this.trgSetFromCurrent.isSelected()) {
                        KNNCInitDialog.this.annotSelectBox.setEnabled(false);
                    } else {
                        KNNCInitDialog.this.annotSelectBox.setEnabled(true);
                    }
                    KNNCInitDialog.this.previewTrgSetButton.setEnabled(true);
                }
            }
        });
        this.useExistTrgSetButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    KNNCInitDialog.this.classEditorButton.setEnabled(false);
                } else {
                    KNNCInitDialog.this.classEditorButton.setEnabled(true);
                }
            }
        });
        ButtonGroup newOrExisting = new ButtonGroup();
        newOrExisting.add(this.createNewTrgSetButton);
        newOrExisting.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 0, 0, 1, 1, 50, 10);
        grid5.setConstraints(this.createNewTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.createNewTrgSetButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
        grid5.setConstraints(this.classEditorButton, constraints);
        makeTrainingSetPanel.add(this.classEditorButton);
        this.buildConstraints(constraints, 0, 1, 1, 1, 50, 10);
        grid5.setConstraints(this.useExistTrgSetButton, constraints);
        makeTrainingSetPanel.add(this.useExistTrgSetButton);
        this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
        grid5.setConstraints(this.browseTrgFileButton, constraints);
        makeTrainingSetPanel.add(this.browseTrgFileButton);
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 5);
        grid5.setConstraints(this.pathLabel, constraints);
        makeTrainingSetPanel.add(this.pathLabel);
        this.pathFileField.setBackground(Color.lightGray);
        this.pathFileField.setEditable(false);
        this.pathFileField.setText("No file currently selected");
        constraints.fill = 1;
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 3, 2, 1, 100, 5);
        grid5.setConstraints(this.pathFileField, constraints);
        makeTrainingSetPanel.add(this.pathFileField);
        constraints.fill = 0;
        this.buildConstraints(constraints, 0, 4, 2, 1, 100, 70);
        constraints.fill = 1;
        constraints.anchor = 13;
        grid5.setConstraints(this.trgSetSpecPanel, constraints);
        makeTrainingSetPanel.add(this.trgSetSpecPanel);
        constraints.fill = 0;
        constraints.anchor = 17;
        this.buildConstraints(constraints, 0, 4, 1, 1, 100, 50);
        constraints.fill = 1;
        classGrid.setConstraints(makeTrainingSetPanel, constraints);
        classifyPanel.add(makeTrainingSetPanel);
        constraints.fill = 0;
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(constraints, 0, 5, 1, 1, 100, 10);
        constraints.fill = 1;
        classGrid.setConstraints(this.hclOpsPanel, constraints);
        classifyPanel.add(this.hclOpsPanel);
        constraints.fill = 0;
        this.classifyOrValidatePane = new JTabbedPane();
        this.classifyOrValidatePane.add("Classify", classifyPanel);
        constraints.fill = 1;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.classifyOrValidatePane, constraints);
        mainPanel.add(this.classifyOrValidatePane);
        constraints.fill = 0;
        this.addContent(mainPanel);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean classifyGenes() {
        return this.genesButton.isSelected();
    }

    public int getNumClasses() {
        String s = this.numClassesField.getText();
        return Integer.parseInt(s);
    }

    public static void main(String[] args) {
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                KNNCInitDialog.this.okPressed = true;
                KNNCInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                KNNCInitDialog.this.okPressed = false;
                KNNCInitDialog.this.genesButton.setSelected(true);
                KNNCInitDialog.this.expsButton.setSelected(false);
                KNNCInitDialog.this.useVarianceFilterBox.setSelected(false);
                KNNCInitDialog.this.useCorrelFilterBox.setSelected(false);
                KNNCInitDialog.this.numClassesField.setText("5");
                KNNCInitDialog.this.numNeighborsField.setText("3");
                KNNCInitDialog.this.trgSetFromCurrent.setSelected(true);
                KNNCInitDialog.this.createNewTrgSetButton.setSelected(true);
                KNNCInitDialog.this.annotSelectBox.setSelectedIndex(0);
                KNNCInitDialog.this.hclOpsPanel.setHCLSelected(false);
            } else if (command.equals("cancel-command")) {
                KNNCInitDialog.this.okPressed = false;
                KNNCInitDialog.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(KNNCInitDialog.this, "KNNC Parameter Selections");
            }
        }
    }
}

