/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KNNCInfoViewer
extends ViewerAdapter
implements Serializable {
    public static final long serialVersionUID = 202009010001L;
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes;
    private int numClasses;

    public KNNCInfoViewer(int[][] clusters, int genes, int numClasses) {
        this.header = this.createHeader();
        this.clusterGenes = true;
        this.numClasses = numClasses;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public KNNCInfoViewer(JTextArea content, JComponent header) {
        this.content = content;
        this.header = header;
        this.setMaxWidth(content, header);
    }

    public KNNCInfoViewer(int[][] clusters, int genes, boolean clusterGenes, int numClasses) {
        this.header = this.createHeader();
        this.clusterGenes = clusterGenes;
        this.numClasses = numClasses;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.clusterGenes) {
            for (int counter = 2 * this.numClasses; counter < 3 * this.numClasses; ++counter) {
                sb.append("Class " + (counter + 1 - 2 * this.numClasses));
                sb.append("\t");
                sb.append("# of Genes in Class: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Genes in Class: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
            sb.append("Unclassified ");
            sb.append("\t");
            sb.append("# of Unclassified Genes : " + clusters[4 * this.numClasses].length);
            sb.append("\n\t");
            sb.append("% of Genes that are Unclassified: " + Math.round((float)clusters[4 * this.numClasses].length / (float)genes * 100.0f) + "%");
            sb.append("\n\n");
        } else {
            for (int counter = 2 * this.numClasses; counter < 3 * this.numClasses; ++counter) {
                sb.append("Class " + (counter + 1 - 2 * this.numClasses));
                sb.append("\t");
                sb.append("# of Experiments in Class: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Experiments in Class: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
            sb.append("Unclassified ");
            sb.append("\t");
            sb.append("# of Unclassified Experiments : " + clusters[4 * this.numClasses].length);
            sb.append("\n\t");
            sb.append("% of Experiments that are Unclassified: " + Math.round((float)clusters[4 * this.numClasses].length / (float)genes * 100.0f) + "%");
            sb.append("\n\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }
}

