/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.knnc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCFirstDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCStatusDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCValidationFirstDialog;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNCValidationInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.knnc.KNNClassifyOrValidateDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class KNNCGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private IData data;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private int k;
    private int usedNumNeibs;
    KNNClassificationEditor kcEditor;
    boolean validate;
    boolean classifyGenes;
    boolean useVarianceFilter;
    boolean useCorrelFilter;
    int numClasses;
    int numVarFilteredVectors;
    int numNeighbors;
    int numPerms;
    double correlPValue;
    Vector[] classificationVector;
    int[] classIndices;
    int[] classes;
    int[] origNumInFiltTrgSetByClass;
    int[] numberCorrectlyClassifiedByClass;
    int[] numberIncorrectlyClassifiedByClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        this.data = framework.getData();
        this.experiment = framework.getData().getExperiment();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        KNNClassifyOrValidateDialog kCOrVDialog = new KNNClassifyOrValidateDialog((JFrame)framework.getFrame(), true);
        kCOrVDialog.setVisible(true);
        boolean bl = this.validate = !kCOrVDialog.classify();
        if (!kCOrVDialog.isOkPressed()) {
            return null;
        }
        if (!this.validate) {
            KNNCStatusDialog kStatDialog = new KNNCStatusDialog((JFrame)framework.getFrame(), false);
            kStatDialog.setVisible(true);
            KNNCFirstDialog kDialog = new KNNCFirstDialog((JFrame)framework.getFrame(), true, framework);
            kDialog.setVisible(true);
            if (!kDialog.isOkPressed()) {
                kStatDialog.dispose();
                return null;
            }
            this.classifyGenes = kDialog.classifyGenes();
            this.numClasses = kDialog.getNumClasses();
            this.numNeighbors = kDialog.getNumNeighbors();
            this.useVarianceFilter = kDialog.useVarianceFilter();
            if (this.useVarianceFilter) {
                this.numVarFilteredVectors = kDialog.getNumVectors();
            }
            this.useCorrelFilter = kDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kDialog.getCorrPValue();
                this.numPerms = kDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(framework, this.classifyGenes, this.numClasses);
            if (kDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                int returnVal = fc.showOpenDialog(framework.getFrame());
                if (returnVal == 0) {
                    this.kcEditor.loadFromFile(fc.getSelectedFile());
                } else {
                    kStatDialog.dispose();
                    return null;
                }
            }
            if (this.kcEditor.fileIsIncompatible()) {
                kStatDialog.dispose();
                return null;
            }
            while (!this.kcEditor.isNextPressed()) {
            }
            if (!this.kcEditor.proceed()) {
                kStatDialog.dispose();
                return null;
            }
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (int i = 0; i < this.classIndices.length; ++i) {
                this.classIndices[i] = (Integer)this.classificationVector[0].get(i);
                this.classes[i] = (Integer)this.classificationVector[1].get(i);
            }
            boolean isHierarchicalTree = kDialog.drawTrees();
            IDistanceMenu menu = framework.getDistanceMenu();
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 1;
            }
            int hcl_method = 0;
            boolean hcl_samples = false;
            boolean hcl_genes = false;
            int hcl_function = 4;
            boolean hcl_absolute = false;
            if (isHierarchicalTree) {
                HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
                if (hcl_dialog.showModal() != 0) {
                    return null;
                }
                hcl_method = hcl_dialog.getMethod();
                hcl_samples = hcl_dialog.isClusterExperiments();
                hcl_genes = hcl_dialog.isClusterGenes();
                hcl_function = hcl_dialog.getDistanceMetric();
                hcl_absolute = hcl_dialog.getAbsoluteSelection();
            }
            Listener listener = new Listener();
            try {
                this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KNNC");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(framework.getFrame(), "KNN classification", listener);
                this.progress.show();
                AlgorithmData data = new AlgorithmData();
                data.addMatrix("experiment", this.experiment.getMatrix());
                data.addParam("distance-factor", String.valueOf(1.0f));
                data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
                data.addParam("distance-function", String.valueOf(function));
                data.addParam("validate", String.valueOf(this.validate));
                data.addParam("classifyGenes", String.valueOf(this.classifyGenes));
                if (this.classifyGenes) {
                    data.addMatrix("experiment", this.experiment.getMatrix());
                } else {
                    data.addMatrix("experiment", this.experiment.getMatrix().transpose());
                }
                data.addParam("useVarianceFilter", String.valueOf(this.useVarianceFilter));
                data.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
                data.addParam("numClasses", String.valueOf(this.numClasses));
                data.addParam("numNeighbors", String.valueOf(this.numNeighbors));
                if (this.useVarianceFilter) {
                    data.addParam("numVarFilteredVectors", String.valueOf(this.numVarFilteredVectors));
                }
                if (this.useCorrelFilter) {
                    data.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                    data.addParam("numPerms", String.valueOf(this.numPerms));
                }
                data.addIntArray("classIndices", this.classIndices);
                data.addIntArray("classes", this.classes);
                if (isHierarchicalTree) {
                    data.addParam("hierarchical-tree", String.valueOf(true));
                    data.addParam("method-linkage", String.valueOf(hcl_method));
                    data.addParam("calculate-genes", String.valueOf(hcl_genes));
                    data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                    data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                    data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
                }
                long start = System.currentTimeMillis();
                AlgorithmData result = this.algorithm.execute(data);
                long time = System.currentTimeMillis() - start;
                Cluster result_cluster = result.getCluster("cluster");
                NodeList nodeList = result_cluster.getNodeList();
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = result.getMatrix("clusters_means");
                this.variances = result.getMatrix("clusters_variances");
                this.numberCorrectlyClassifiedByClass = result.getIntArray("numberCorrectlyClassifiedByClass");
                this.numberIncorrectlyClassifiedByClass = result.getIntArray("numberIncorrectlyClassifiedByClass");
                this.origNumInFiltTrgSetByClass = result.getIntArray("origNumInFiltTrgSetByClass");
                GeneralInfo info = new GeneralInfo();
                info.time = time;
                info.hcl = isHierarchicalTree;
                info.hcl_genes = hcl_genes;
                info.hcl_samples = hcl_samples;
                info.hcl_method = hcl_method;
                info.numClasses = this.numClasses;
                info.numNeighbors = this.numNeighbors;
                info.usedVarFilter = this.useVarianceFilter;
                if (this.useVarianceFilter) {
                    info.numVarFiltered = this.numVarFilteredVectors;
                    info.postVarDataSetSize = result.getParams().getInt("postVarDataSetSize");
                    info.postVarClassSetSize = result.getParams().getInt("postVarClassSetSize");
                }
                info.usedCorrelFilter = this.useCorrelFilter;
                if (this.useCorrelFilter) {
                    info.correlPvalue = this.correlPValue;
                    info.numPerms = this.numPerms;
                    info.postCorrDataSetSize = result.getParams().getInt("postCorrDataSetSize");
                }
                info.usedNumNeibs = result.getParams().getInt("usedNumNeibs");
                info.origDataSetSize = result.getParams().getInt("origDataSetSize");
                info.origClassSetSize = result.getParams().getInt("origClassSetSize");
                DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
                return defaultMutableTreeNode;
            }
            finally {
                kStatDialog.dispose();
                if (this.algorithm != null) {
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
            }
        }
        KNNCStatusDialog kStatDialog = new KNNCStatusDialog((JFrame)framework.getFrame(), false);
        kStatDialog.setVisible(true);
        KNNCValidationFirstDialog kvDialog = new KNNCValidationFirstDialog((JFrame)framework.getFrame(), true, framework);
        kvDialog.setVisible(true);
        if (!kvDialog.isOkPressed()) {
            kStatDialog.dispose();
            return null;
        }
        this.classifyGenes = kvDialog.classifyGenes();
        this.numClasses = kvDialog.getNumClasses();
        this.numNeighbors = kvDialog.getNumNeighbors();
        this.useCorrelFilter = kvDialog.useCorrelFilter();
        if (this.useCorrelFilter) {
            this.correlPValue = kvDialog.getCorrPValue();
            this.numPerms = kvDialog.getNumPerms();
        }
        this.k = this.numClasses * 4 + 1;
        this.kcEditor = new KNNClassificationEditor(framework, this.classifyGenes, this.numClasses);
        if (kvDialog.createNewTrgSet()) {
            this.kcEditor.showModal(true);
        } else {
            JFileChooser fc = new JFileChooser(TMEV.getDataPath());
            int returnVal = fc.showOpenDialog(framework.getFrame());
            if (returnVal == 0) {
                this.kcEditor.loadFromFile(fc.getSelectedFile());
            } else {
                kStatDialog.dispose();
                return null;
            }
        }
        if (this.kcEditor.fileIsIncompatible()) {
            kStatDialog.dispose();
            return null;
        }
        while (!this.kcEditor.isNextPressed()) {
        }
        if (!this.kcEditor.proceed()) {
            kStatDialog.dispose();
            return null;
        }
        this.classificationVector = this.kcEditor.getClassification();
        this.classIndices = new int[this.classificationVector[0].size()];
        this.classes = new int[this.classificationVector[1].size()];
        for (int i = 0; i < this.classIndices.length; ++i) {
            this.classIndices[i] = (Integer)this.classificationVector[0].get(i);
            this.classes[i] = (Integer)this.classificationVector[1].get(i);
        }
        boolean isHierarchicalTree = kvDialog.drawTrees();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KNNC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "KNN classification", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("validate", String.valueOf(this.validate));
            data.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            if (this.classifyGenes) {
                data.addMatrix("experiment", this.experiment.getMatrix());
            } else {
                data.addMatrix("experiment", this.experiment.getMatrix().transpose());
            }
            data.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            data.addParam("numClasses", String.valueOf(this.numClasses));
            data.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useCorrelFilter) {
                data.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                data.addParam("numPerms", String.valueOf(this.numPerms));
            }
            data.addIntArray("classIndices", this.classIndices);
            data.addIntArray("classes", this.classes);
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.k = this.numClasses + 1;
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.numberCorrectlyClassifiedByClass = result.getIntArray("numberCorrectlyClassifiedByClass");
            this.numberIncorrectlyClassifiedByClass = result.getIntArray("numberIncorrectlyClassifiedByClass");
            this.origNumInFiltTrgSetByClass = result.getIntArray("origNumInFiltTrgSetByClass");
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            info.numClasses = this.numClasses;
            info.numNeighbors = this.numNeighbors;
            info.usedCorrelFilter = this.useCorrelFilter;
            if (this.useCorrelFilter) {
                info.correlPvalue = this.correlPValue;
                info.numPerms = this.numPerms;
            }
            info.usedNumNeibs = result.getParams().getInt("usedNumNeibs");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createValidationResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            kStatDialog.dispose();
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        AlgorithmData data = new AlgorithmData();
        this.data = framework.getData();
        this.experiment = framework.getData().getExperiment();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int number_of_genes = this.experiment.getNumberOfGenes();
        KNNClassifyOrValidateDialog kCOrVDialog = new KNNClassifyOrValidateDialog((JFrame)framework.getFrame(), true);
        kCOrVDialog.setVisible(true);
        boolean bl = this.validate = !kCOrVDialog.classify();
        if (!kCOrVDialog.isOkPressed()) {
            return null;
        }
        if (!this.validate) {
            KNNCStatusDialog kStatDialog = new KNNCStatusDialog((JFrame)framework.getFrame(), false);
            kStatDialog.setVisible(true);
            KNNCFirstDialog kDialog = new KNNCFirstDialog((JFrame)framework.getFrame(), true, framework);
            kDialog.setVisible(true);
            if (!kDialog.isOkPressed()) {
                kStatDialog.dispose();
                return null;
            }
            this.classifyGenes = kDialog.classifyGenes();
            this.numClasses = kDialog.getNumClasses();
            this.numNeighbors = kDialog.getNumNeighbors();
            this.useVarianceFilter = kDialog.useVarianceFilter();
            if (this.useVarianceFilter) {
                this.numVarFilteredVectors = kDialog.getNumVectors();
            }
            this.useCorrelFilter = kDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kDialog.getCorrPValue();
                this.numPerms = kDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(framework, this.classifyGenes, this.numClasses);
            if (kDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                int returnVal = fc.showOpenDialog(framework.getFrame());
                if (returnVal == 0) {
                    this.kcEditor.loadFromFile(fc.getSelectedFile());
                } else {
                    kStatDialog.dispose();
                    return null;
                }
            }
            this.kcEditor.dispose();
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (int i = 0; i < this.classIndices.length; ++i) {
                this.classIndices[i] = (Integer)this.classificationVector[0].get(i);
                this.classes[i] = (Integer)this.classificationVector[1].get(i);
            }
            boolean isHierarchicalTree = kDialog.drawTrees();
            IDistanceMenu menu = framework.getDistanceMenu();
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 1;
            }
            int hcl_method = 0;
            boolean hcl_samples = false;
            boolean hcl_genes = false;
            int hcl_function = 4;
            boolean hcl_absolute = false;
            if (isHierarchicalTree) {
                HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
                if (hcl_dialog.showModal() != 0) {
                    return null;
                }
                hcl_method = hcl_dialog.getMethod();
                hcl_samples = hcl_dialog.isClusterExperiments();
                hcl_genes = hcl_dialog.isClusterGenes();
                hcl_function = hcl_dialog.getDistanceMetric();
                hcl_absolute = hcl_dialog.getAbsoluteSelection();
            }
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("validate", String.valueOf(this.validate));
            data.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            data.addParam("useVarianceFilter", String.valueOf(this.useVarianceFilter));
            data.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            data.addParam("numClasses", String.valueOf(this.numClasses));
            data.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useVarianceFilter) {
                data.addParam("numVarFilteredVectors", String.valueOf(this.numVarFilteredVectors));
            }
            if (this.useCorrelFilter) {
                data.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                data.addParam("numPerms", String.valueOf(this.numPerms));
            }
            data.addIntArray("classIndices", this.classIndices);
            data.addIntArray("classes", this.classes);
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            data.addParam("name", "KNNC");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[4 * this.numClasses + 1];
            for (int i = 0; i < this.numClasses; ++i) {
                String str = String.valueOf(i + 1) + "  ";
                outputNodes[i] = "Used classifiers: Class " + str;
                outputNodes[this.numClasses + i] = "Unused classifiers: Class " + str;
                outputNodes[2 * this.numClasses + i] = "Classified: Class " + str;
                outputNodes[3 * this.numClasses + i] = "Used classifiers + classified: Class " + str;
            }
            outputNodes[4 * this.numClasses] = "Unclassified";
            data.addStringArray("output-nodes", outputNodes);
            kStatDialog.dispose();
        } else {
            KNNCStatusDialog kStatDialog = new KNNCStatusDialog((JFrame)framework.getFrame(), false);
            kStatDialog.setVisible(true);
            KNNCValidationFirstDialog kvDialog = new KNNCValidationFirstDialog((JFrame)framework.getFrame(), true, framework);
            kvDialog.setVisible(true);
            if (!kvDialog.isOkPressed()) {
                kStatDialog.dispose();
                return null;
            }
            this.classifyGenes = kvDialog.classifyGenes();
            this.numClasses = kvDialog.getNumClasses();
            this.numNeighbors = kvDialog.getNumNeighbors();
            this.useCorrelFilter = kvDialog.useCorrelFilter();
            if (this.useCorrelFilter) {
                this.correlPValue = kvDialog.getCorrPValue();
                this.numPerms = kvDialog.getNumPerms();
            }
            this.k = this.numClasses * 4 + 1;
            this.kcEditor = new KNNClassificationEditor(framework, this.classifyGenes, this.numClasses);
            if (kvDialog.createNewTrgSet()) {
                this.kcEditor.showModal(true);
            } else {
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                int returnVal = fc.showOpenDialog(framework.getFrame());
                if (returnVal == 0) {
                    this.kcEditor.loadFromFile(fc.getSelectedFile());
                } else {
                    kStatDialog.dispose();
                    return null;
                }
            }
            if (this.kcEditor.fileIsIncompatible()) {
                kStatDialog.dispose();
                return null;
            }
            while (!this.kcEditor.isNextPressed()) {
            }
            if (!this.kcEditor.proceed()) {
                kStatDialog.dispose();
                return null;
            }
            this.classificationVector = this.kcEditor.getClassification();
            this.classIndices = new int[this.classificationVector[0].size()];
            this.classes = new int[this.classificationVector[1].size()];
            for (int i = 0; i < this.classIndices.length; ++i) {
                this.classIndices[i] = (Integer)this.classificationVector[0].get(i);
                this.classes[i] = (Integer)this.classificationVector[1].get(i);
            }
            boolean isHierarchicalTree = kvDialog.drawTrees();
            IDistanceMenu menu = framework.getDistanceMenu();
            int function = menu.getDistanceFunction();
            if (function == 0) {
                function = 1;
            }
            int hcl_method = 0;
            boolean hcl_samples = false;
            boolean hcl_genes = false;
            int hcl_function = 4;
            boolean hcl_absolute = false;
            if (isHierarchicalTree) {
                HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
                if (hcl_dialog.showModal() != 0) {
                    return null;
                }
                hcl_method = hcl_dialog.getMethod();
                hcl_samples = hcl_dialog.isClusterExperiments();
                hcl_genes = hcl_dialog.isClusterGenes();
                hcl_function = hcl_dialog.getDistanceMetric();
                hcl_absolute = hcl_dialog.getAbsoluteSelection();
            }
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(menu.isAbsoluteDistance()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("validate", String.valueOf(this.validate));
            data.addParam("classifyGenes", String.valueOf(this.classifyGenes));
            data.addParam("useCorrelFilter", String.valueOf(this.useCorrelFilter));
            data.addParam("numClasses", String.valueOf(this.numClasses));
            data.addParam("numNeighbors", String.valueOf(this.numNeighbors));
            if (this.useCorrelFilter) {
                data.addParam("correlPValue", String.valueOf((float)this.correlPValue));
                data.addParam("numPerms", String.valueOf(this.numPerms));
            }
            data.addIntArray("classIndices", this.classIndices);
            data.addIntArray("classes", this.classes);
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            this.k = this.numClasses + 1;
            data.addParam("name", "KNNC");
            if (this.classifyGenes) {
                data.addParam("alg-type", "cluster-genes");
            } else {
                data.addParam("alg-type", "cluster-experiments");
            }
            data.addParam("output-class", "partition-output");
            String[] outputNodes = new String[this.numClasses + 1];
            for (int i = 0; i < this.numClasses; ++i) {
                outputNodes[i] = "Training Class " + String.valueOf(i + 1) + "  ";
            }
            outputNodes[this.numClasses] = "Not in Training Set  ";
            data.addStringArray("output-nodes", outputNodes);
            kStatDialog.dispose();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        AlgorithmParameters params = algData.getParams();
        Listener listener = new Listener();
        this.data = framework.getData();
        this.experiment = experiment;
        this.classifyGenes = params.getBoolean("classifyGenes");
        this.numClasses = params.getInt("numClasses");
        this.numNeighbors = params.getInt("numNeighbors");
        this.useCorrelFilter = params.getBoolean("useCorrelFilter");
        this.validate = params.getBoolean("validate");
        int number_of_samples = experiment.getNumberOfSamples();
        int number_of_genes = experiment.getNumberOfGenes();
        if (this.useCorrelFilter) {
            this.correlPValue = params.getFloat("correlPValue");
            this.numPerms = params.getInt("numPerms");
        }
        if (!this.validate) {
            this.useVarianceFilter = params.getBoolean("useVarianceFilter");
            if (this.useVarianceFilter) {
                this.numVarFilteredVectors = params.getInt("numVarFilteredVectors");
            }
            try {
                this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KNNC");
                this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
                this.progress = new Progress(framework.getFrame(), "KNN classification", listener);
                this.progress.show();
                if (this.classifyGenes) {
                    algData.addMatrix("experiment", experiment.getMatrix());
                } else {
                    algData.addMatrix("experiment", experiment.getMatrix().transpose());
                }
                long start = System.currentTimeMillis();
                AlgorithmData result = this.algorithm.execute(algData);
                long time = System.currentTimeMillis() - start;
                Cluster result_cluster = result.getCluster("cluster");
                NodeList nodeList = result_cluster.getNodeList();
                this.k = this.numClasses * 4 + 1;
                this.clusters = new int[this.k][];
                for (int i = 0; i < this.k; ++i) {
                    this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
                }
                this.means = result.getMatrix("clusters_means");
                this.variances = result.getMatrix("clusters_variances");
                this.numberCorrectlyClassifiedByClass = result.getIntArray("numberCorrectlyClassifiedByClass");
                this.numberIncorrectlyClassifiedByClass = result.getIntArray("numberIncorrectlyClassifiedByClass");
                this.origNumInFiltTrgSetByClass = result.getIntArray("origNumInFiltTrgSetByClass");
                GeneralInfo info = new GeneralInfo();
                info.time = time;
                info.hcl = params.getBoolean("hierarchical-tree");
                info.hcl_genes = params.getBoolean("calculate-genes");
                info.hcl_samples = params.getBoolean("calculate-experiments");
                if (info.hcl) {
                    info.hcl_method = params.getInt("method-linkage");
                }
                info.numClasses = this.numClasses;
                info.numNeighbors = this.numNeighbors;
                info.usedVarFilter = this.useVarianceFilter;
                if (this.useVarianceFilter) {
                    info.numVarFiltered = this.numVarFilteredVectors;
                    info.postVarDataSetSize = result.getParams().getInt("postVarDataSetSize");
                    info.postVarClassSetSize = result.getParams().getInt("postVarClassSetSize");
                }
                info.usedCorrelFilter = this.useCorrelFilter;
                if (this.useCorrelFilter) {
                    info.correlPvalue = this.correlPValue;
                    info.numPerms = this.numPerms;
                    info.postCorrDataSetSize = result.getParams().getInt("postCorrDataSetSize");
                }
                info.usedNumNeibs = result.getParams().getInt("usedNumNeibs");
                info.origDataSetSize = result.getParams().getInt("origDataSetSize");
                info.origClassSetSize = result.getParams().getInt("origClassSetSize");
                DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
                return defaultMutableTreeNode;
            }
            finally {
                if (this.algorithm != null) {
                    this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
                }
                if (this.progress != null) {
                    this.progress.dispose();
                }
            }
        }
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KNNC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "KNN classification", listener);
            this.progress.show();
            if (this.classifyGenes) {
                algData.addMatrix("experiment", experiment.getMatrix());
            } else {
                algData.addMatrix("experiment", experiment.getMatrix().transpose());
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.k = this.numClasses + 1;
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.numberCorrectlyClassifiedByClass = result.getIntArray("numberCorrectlyClassifiedByClass");
            this.numberIncorrectlyClassifiedByClass = result.getIntArray("numberIncorrectlyClassifiedByClass");
            this.origNumInFiltTrgSetByClass = result.getIntArray("origNumInFiltTrgSetByClass");
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            info.numClasses = this.numClasses;
            info.numNeighbors = this.numNeighbors;
            info.usedCorrelFilter = this.useCorrelFilter;
            if (this.useCorrelFilter) {
                info.correlPvalue = this.correlPValue;
                info.numPerms = this.numPerms;
            }
            info.usedNumNeibs = result.getParams().getInt("usedNumNeibs");
            DefaultMutableTreeNode defaultMutableTreeNode = this.createValidationResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createValidationResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.classifyGenes ? new DefaultMutableTreeNode("KNNC Validation - genes") : new DefaultMutableTreeNode("KNNC Validation - samples");
        this.addValidationExpressionImages(root);
        this.addValidationHierarchicalTrees(root, result_cluster, info);
        this.addValidationCentroidViews(root);
        this.addValidationTableViews(root);
        this.addValidationInfo(root);
        this.addValidationGeneralInfo(root, info);
        return root;
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.classifyGenes ? new DefaultMutableTreeNode("KNNC - genes") : new DefaultMutableTreeNode("KNNC - samples");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addValidationInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addValidationTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object tabViewer = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (int i = 1; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        node.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)tabViewer, (Object)new Integer(0))));
        root.add(node);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        DefaultMutableTreeNode[] nodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        Object tabViewer = this.classifyGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (i = 0; i < this.numClasses; ++i) {
            nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
            nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
            nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
            nodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        for (i = 0; i < nodeArray.length; ++i) {
            node.add(nodeArray[i]);
        }
        node.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)tabViewer, (Object)new Integer(4 * this.numClasses))));
        root.add(node);
    }

    private void addValidationExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = this.classifyGenes ? new KNNCExperimentViewer(this.experiment, this.clusters) : new KNNCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 1; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)expViewer, (Object)new Integer(i))));
        }
        node.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)expViewer, (Object)new Integer(0))));
        root.add(node);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        DefaultMutableTreeNode[] nodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        Object expViewer = this.classifyGenes ? new KNNCExperimentViewer(this.experiment, this.clusters) : new KNNCExperimentClusterViewer(this.experiment, this.clusters);
        for (i = 0; i < this.numClasses; ++i) {
            nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
            nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
            nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
            nodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)expViewer, (Object)new Integer(i))));
        }
        for (i = 0; i < nodeArray.length; ++i) {
            node.add(nodeArray[i]);
        }
        node.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)expViewer, (Object)new Integer(4 * this.numClasses))));
        root.add(node);
    }

    private void addValidationHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        int i;
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        if (!this.classifyGenes) {
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
            }
        }
        for (i = 1; i < nodeList.getSize(); ++i) {
            if (this.classifyGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), this.createHCLViewer(nodeList.getNode(i), info, null))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
        }
        if (this.classifyGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set", this.createHCLViewer(nodeList.getNode(0), info, null))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set", this.createHCLViewer(nodeList.getNode(0), info, (int[][])clusters), (Object)new Integer(0))));
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        int i;
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        DefaultMutableTreeNode[] nodeArray = new DefaultMutableTreeNode[]{new DefaultMutableTreeNode("Used classifiers"), new DefaultMutableTreeNode("Unused classifiers"), new DefaultMutableTreeNode("Classified"), new DefaultMutableTreeNode("Used classifiers + classified")};
        if (!this.classifyGenes) {
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
            }
        }
        if (this.classifyGenes) {
            for (i = 0; i < this.numClasses; ++i) {
                nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, null))));
            }
            for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
                nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, null))));
            }
            for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, null))));
            }
            for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
                nodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, null))));
            }
            for (i = 0; i < nodeArray.length; ++i) {
                node.add(nodeArray[i]);
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", this.createHCLViewer(nodeList.getNode(4 * this.numClasses), info, null))));
        } else {
            for (i = 0; i < this.numClasses; ++i) {
                nodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
            for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
                nodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
            for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                nodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
            for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
                nodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
            }
            for (i = 0; i < nodeArray.length; ++i) {
                node.add(nodeArray[i]);
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", this.createHCLViewer(nodeList.getNode(4 * this.numClasses), info, (int[][])clusters), (Object)new Integer(4 * this.numClasses))));
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : (samples_result = null);
        if (this.classifyGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.classifyGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Classes (#,%)", (IViewer)new KNNCInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.numClasses))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Classes (#,%)", (IViewer)new KNNCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), false, this.numClasses))));
        }
        root.add(node);
    }

    private void addValidationInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new LeafInfo("Validation Information", (IViewer)new KNNCValidationInfoViewer(this.origNumInFiltTrgSetByClass, this.numberCorrectlyClassifiedByClass, this.numberIncorrectlyClassifiedByClass)));
        root.add(node);
    }

    private void addValidationCentroidViews(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        int[][] shuffledClusters = new int[this.clusters.length][];
        for (int i2 = 0; i2 < this.clusters.length - 1; ++i2) {
            shuffledClusters[i2] = this.clusters[i2 + 1];
        }
        shuffledClusters[this.clusters.length - 1] = this.clusters[0];
        FloatMatrix shuffledMeans = new FloatMatrix(this.means.getRowDimension(), this.means.getColumnDimension());
        FloatMatrix shuffledVariances = new FloatMatrix(this.variances.getRowDimension(), this.variances.getColumnDimension());
        for (i = 0; i < this.clusters.length - 1; ++i) {
            shuffledMeans.A[i] = this.means.A[i + 1];
            shuffledVariances.A[i] = this.variances.A[i + 1];
        }
        shuffledMeans.A[this.clusters.length - 1] = this.means.A[0];
        shuffledVariances.A[this.clusters.length - 1] = this.variances.A[0];
        if (this.classifyGenes) {
            KNNCCentroidViewer centroidViewer = new KNNCCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (i = 1; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)centroidViewer, (Object)new CentroidUserObject(0, 1))));
            KNNCCentroidsViewer centroidsViewer = new KNNCCentroidsViewer(this.experiment, shuffledClusters);
            centroidsViewer.setMeans(shuffledMeans.A);
            centroidsViewer.setVariances(shuffledVariances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            KNNCExperimentCentroidViewer expCentroidViewer = new KNNCExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (i = 1; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(0, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Not in training set ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(0, 1))));
            KNNCExperimentCentroidsViewer expCentroidsViewer = new KNNCExperimentCentroidsViewer(this.experiment, shuffledClusters);
            expCentroidsViewer.setMeans(shuffledMeans.A);
            expCentroidsViewer.setVariances(shuffledVariances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        DefaultMutableTreeNode[] centroidNodeArray = new DefaultMutableTreeNode[4];
        DefaultMutableTreeNode[] expressionNodeArray = new DefaultMutableTreeNode[4];
        centroidNodeArray[0] = new DefaultMutableTreeNode("Used classifiers");
        centroidNodeArray[1] = new DefaultMutableTreeNode("Unused classifiers");
        centroidNodeArray[2] = new DefaultMutableTreeNode("Classified");
        centroidNodeArray[3] = new DefaultMutableTreeNode("Used classifiers + classified");
        expressionNodeArray[0] = new DefaultMutableTreeNode("Used classifiers");
        expressionNodeArray[1] = new DefaultMutableTreeNode("Unused classifiers");
        expressionNodeArray[2] = new DefaultMutableTreeNode("Classified");
        expressionNodeArray[3] = new DefaultMutableTreeNode("Used classifiers + classified");
        if (this.classifyGenes) {
            int i;
            KNNCCentroidViewer centroidViewer = new KNNCCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (i = 0; i < this.numClasses; ++i) {
                centroidNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
                centroidNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                centroidNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
                centroidNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            KNNCCentroidsViewer centroidsViewer = new KNNCCentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            for (int i2 = 0; i2 < centroidNodeArray.length; ++i2) {
                centroidNode.add(centroidNodeArray[i2]);
                expressionNode.add(expressionNodeArray[i2]);
            }
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)centroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)centroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 1))));
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            int i;
            KNNCExperimentCentroidViewer expCentroidViewer = new KNNCExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (i = 0; i < this.numClasses; ++i) {
                centroidNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[0].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = this.numClasses; i < 2 * this.numClasses; ++i) {
                centroidNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[1].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 2 * this.numClasses; i < 3 * this.numClasses; ++i) {
                centroidNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[2].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 2 * this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            for (i = 3 * this.numClasses; i < 4 * this.numClasses; ++i) {
                centroidNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNodeArray[3].add(new DefaultMutableTreeNode(new LeafInfo("Class " + String.valueOf(i + 1 - 3 * this.numClasses), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            KNNCExperimentCentroidsViewer expCentroidsViewer = new KNNCExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            for (int i3 = 0; i3 < centroidNodeArray.length; ++i3) {
                centroidNode.add(centroidNodeArray[i3]);
                expressionNode.add(expressionNodeArray[i3]);
            }
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unclassified ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(4 * this.numClasses, 1))));
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All ", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Original total data set size: " + info.origDataSetSize));
        node.add(new DefaultMutableTreeNode("Original training set size: " + info.origClassSetSize));
        node.add(new DefaultMutableTreeNode("Used variance filter: " + info.usedVarFilter));
        if (this.useVarianceFilter) {
            node.add(new DefaultMutableTreeNode("Total data set size after var. filtering: " + info.numVarFiltered));
            node.add(new DefaultMutableTreeNode("Var. filtered training set size: " + info.postVarClassSetSize));
            node.add(new DefaultMutableTreeNode("Size of set to classify after var. filtering: " + info.postVarDataSetSize));
        }
        node.add(new DefaultMutableTreeNode("Used correlation filter: " + info.usedCorrelFilter));
        if (this.useCorrelFilter) {
            node.add(new DefaultMutableTreeNode("Threshold p-value: " + info.correlPvalue));
            node.add(new DefaultMutableTreeNode("Number of permutations: " + info.numPerms));
            node.add(new DefaultMutableTreeNode("Size of set to classify after corr. filtering: " + info.postCorrDataSetSize));
        }
        node.add(new DefaultMutableTreeNode("Num. classes: " + info.numClasses));
        node.add(new DefaultMutableTreeNode("Input num. neighbors: " + info.numNeighbors));
        node.add(new DefaultMutableTreeNode("Num. neighbors used: " + info.usedNumNeibs));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        root.add(node);
    }

    private void addValidationGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Used correlation filter: " + info.usedCorrelFilter));
        if (this.useCorrelFilter) {
            node.add(new DefaultMutableTreeNode("Threshold p-value: " + info.correlPvalue));
            node.add(new DefaultMutableTreeNode("Number of permutations: " + info.numPerms));
        }
        node.add(new DefaultMutableTreeNode("Num. classes: " + info.numClasses));
        node.add(new DefaultMutableTreeNode("Input num. neighbors: " + info.numNeighbors));
        node.add(new DefaultMutableTreeNode("Num. neighbors used: " + info.usedNumNeibs));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        root.add(node);
    }

    private class GeneralInfo {
        public long time;
        public String function;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;
        private int numClasses;
        private int numNeighbors;
        private int numVarFiltered;
        private int numPerms;
        private int usedNumNeibs;
        private int postVarClassSetSize;
        private int postVarDataSetSize;
        private int postCorrDataSetSize;
        private int origDataSetSize;
        private int origClassSetSize;
        private boolean usedVarFilter;
        private boolean usedCorrelFilter;
        private double correlPvalue;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    KNNCGUI.this.progress.setUnits(event.getIntValue());
                    KNNCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    KNNCGUI.this.progress.setValue(event.getIntValue());
                    KNNCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                KNNCGUI.this.algorithm.abort();
                KNNCGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KNNCGUI.this.algorithm.abort();
            KNNCGUI.this.progress.dispose();
        }
    }
}

