/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KMCSupportDialog
extends AlgorithmDialog {
    SampleSelectionPanel sPanel;
    MeansOrMediansPanel mPanel;
    TopPanel tPanel;
    KMCParameterPanel kPanel;
    HCLSelectionPanel hclOpsPanel;
    DistanceMetricPanel metricPanel;
    boolean okPressed = false;

    public KMCSupportDialog(JFrame parentFrame, boolean modality, String globalMetricName, boolean globalAbsoluteSetting) {
        super(parentFrame, "KMS: K-Means/K-Medians Support", modality);
        this.setBounds(0, 0, 500, 550);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.sPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 10);
        gridbag.setConstraints(this.sPanel, constraints);
        pane.add(this.sPanel);
        this.metricPanel = new DistanceMetricPanel(globalMetricName, globalAbsoluteSetting, "Euclidean Distance", "KMCS", true, true);
        this.buildConstraints(constraints, 0, 1, 1, 1, 100, 10);
        gridbag.setConstraints(this.metricPanel, constraints);
        pane.add(this.metricPanel);
        this.mPanel = new MeansOrMediansPanel();
        this.buildConstraints(constraints, 0, 2, 1, 1, 100, 10);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.tPanel = new TopPanel();
        this.buildConstraints(constraints, 0, 3, 1, 1, 100, 30);
        gridbag.setConstraints(this.tPanel, constraints);
        pane.add(this.tPanel);
        this.kPanel = new KMCParameterPanel();
        this.buildConstraints(constraints, 0, 4, 1, 1, 0, 30);
        gridbag.setConstraints(this.kPanel, constraints);
        pane.add(this.kPanel);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.buildConstraints(constraints, 0, 5, 1, 1, 0, 10);
        gridbag.setConstraints(this.hclOpsPanel, constraints);
        pane.add(this.hclOpsPanel);
        this.addContent(pane);
        this.setActionListeners(new Listener());
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public int getNumReps() {
        String s1 = this.tPanel.numRepsInputField.getText();
        int numReps = Integer.parseInt(s1);
        return numReps;
    }

    public double getThresholdPercent() {
        String s1 = this.tPanel.thresholdInputField.getText();
        double thresholdPercent = Double.parseDouble(s1);
        return thresholdPercent;
    }

    public int getNumClusters() {
        String s1 = this.kPanel.numClustersInputField.getText();
        int numClusters = Integer.parseInt(s1);
        return numClusters;
    }

    public int getIterations() {
        String s1 = this.kPanel.numIterationsInputField.getText();
        int iterations = Integer.parseInt(s1);
        return iterations;
    }

    public boolean isDrawTrees() {
        boolean drawTrees = this.hclOpsPanel.isHCLSelected();
        return drawTrees;
    }

    public boolean meansChosen() {
        return this.mPanel.meansButton.isSelected();
    }

    public boolean isClusterGenes() {
        return this.sPanel.isClusterGenesSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.metricPanel.getAbsoluteSelection();
    }

    private void resetControls() {
        this.sPanel.setClusterGenesSelected(true);
        this.mPanel.meansButton.setSelected(true);
        this.tPanel.numRepsInputField.setText("10");
        this.tPanel.thresholdInputField.setText("80");
        this.kPanel.numClustersInputField.setText("10");
        this.kPanel.numIterationsInputField.setText("50");
        this.hclOpsPanel.setHCLSelected(false);
        this.metricPanel.reset();
    }

    private boolean validInput(int n, double p, int k, int i) {
        boolean valid = true;
        if (n < 1) {
            this.tPanel.numRepsInputField.requestFocus();
            this.tPanel.numRepsInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Number of repetitions must be > 0", "Input Error!", 0);
            valid = false;
        } else if (p <= 0.0 || p > 100.0) {
            this.tPanel.thresholdInputField.requestFocus();
            this.tPanel.thresholdInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Threshold % must be > 0 and <= 100", "Input Error!", 0);
            valid = false;
        } else if (k < 1) {
            this.kPanel.numClustersInputField.requestFocus();
            this.kPanel.numClustersInputField.selectAll();
            JOptionPane.showMessageDialog(this, "Number of clusters must be > 0", "Input Error!", 0);
            valid = false;
        } else if (i < 1) {
            JOptionPane.showMessageDialog(this, "Number of iterations must be > 0", "Input Error!", 0);
            this.kPanel.numIterationsInputField.requestFocus();
            this.kPanel.numIterationsInputField.selectAll();
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        KMCSupportDialog kSuppDialog = new KMCSupportDialog(dummyFrame, true, "Euclidean Distance", false);
        kSuppDialog.setVisible(true);
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                int i;
                int k;
                double p;
                int n;
                KMCSupportDialog.this.okPressed = true;
                int progress = 0;
                try {
                    n = Integer.parseInt(KMCSupportDialog.this.tPanel.numRepsInputField.getText());
                    ++progress;
                    p = Double.parseDouble(KMCSupportDialog.this.tPanel.thresholdInputField.getText());
                    ++progress;
                    k = Integer.parseInt(KMCSupportDialog.this.kPanel.numClustersInputField.getText());
                    ++progress;
                    i = Integer.parseInt(KMCSupportDialog.this.kPanel.numIterationsInputField.getText());
                    ++progress;
                }
                catch (NumberFormatException e1) {
                    switch (progress) {
                        case 0: {
                            KMCSupportDialog.this.tPanel.numRepsInputField.requestFocus();
                            KMCSupportDialog.this.tPanel.numRepsInputField.selectAll();
                            break;
                        }
                        case 1: {
                            KMCSupportDialog.this.tPanel.thresholdInputField.requestFocus();
                            KMCSupportDialog.this.tPanel.thresholdInputField.selectAll();
                            break;
                        }
                        case 2: {
                            KMCSupportDialog.this.kPanel.numClustersInputField.requestFocus();
                            KMCSupportDialog.this.kPanel.numClustersInputField.selectAll();
                            break;
                        }
                        case 3: {
                            KMCSupportDialog.this.kPanel.numIterationsInputField.requestFocus();
                            KMCSupportDialog.this.kPanel.numIterationsInputField.selectAll();
                        }
                    }
                    JOptionPane.showMessageDialog(KMCSupportDialog.this, "Entry format error.", "Error", 0);
                    return;
                }
                if (!KMCSupportDialog.this.validInput(n, p, k, i)) {
                    return;
                }
            } else if (command.equals("cancel-command")) {
                KMCSupportDialog.this.okPressed = false;
            } else {
                if (command.equals("reset-command")) {
                    KMCSupportDialog.this.resetControls();
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(KMCSupportDialog.this, "KMS Initialization Dialog");
                }
            }
            KMCSupportDialog.this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KMCSupportDialog.this.okPressed = false;
            KMCSupportDialog.this.dispose();
        }
    }

    class KMCParameterPanel
    extends JPanel {
        JTextField numClustersInputField;
        JTextField numIterationsInputField;

        KMCParameterPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Parameters for each K-Means / K-Medians run", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            JLabel numClustersLabel = new JLabel("Number of clusters ");
            KMCSupportDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            gridbag.setConstraints(numClustersLabel, constraints);
            this.add(numClustersLabel);
            this.numClustersInputField = new JTextField("10", 7);
            KMCSupportDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.numClustersInputField, constraints);
            this.add(this.numClustersInputField);
            JLabel iterationsLabel = new JLabel("Maximum number of iterations ");
            KMCSupportDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
            gridbag.setConstraints(iterationsLabel, constraints);
            this.add(iterationsLabel);
            this.numIterationsInputField = new JTextField("50", 7);
            KMCSupportDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 0);
            gridbag.setConstraints(this.numIterationsInputField, constraints);
            this.add(this.numIterationsInputField);
        }
    }

    class TopPanel
    extends JPanel {
        JTextField numRepsInputField;
        JTextField thresholdInputField;

        TopPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Parameters for K-Means / K-Medians repetitions", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            JLabel numRepsLabel = new JLabel("Number of k-means / k-medians runs ");
            KMCSupportDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 50);
            gridbag.setConstraints(numRepsLabel, constraints);
            this.add(numRepsLabel);
            this.numRepsInputField = new JTextField("10", 7);
            KMCSupportDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.numRepsInputField, constraints);
            this.add(this.numRepsInputField);
            JLabel thresholdLabel = new JLabel("Threshold % of occurrence in same cluster");
            KMCSupportDialog.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 50);
            gridbag.setConstraints(thresholdLabel, constraints);
            this.add(thresholdLabel);
            this.thresholdInputField = new JTextField("80", 7);
            KMCSupportDialog.this.buildConstraints(constraints, 1, 1, 1, 1, 0, 0);
            gridbag.setConstraints(this.thresholdInputField, constraints);
            this.add(this.thresholdInputField);
        }
    }

    class MeansOrMediansPanel
    extends JPanel {
        JRadioButton meansButton;
        JRadioButton mediansButton;

        MeansOrMediansPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Means or Medians", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            this.meansButton = new JRadioButton("Calculate means", true);
            this.meansButton.setBackground(Color.white);
            this.meansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.meansButton.setFocusPainted(false);
            this.meansButton.setHorizontalAlignment(0);
            this.mediansButton = new JRadioButton("Calculate medians", false);
            this.mediansButton.setBackground(Color.white);
            this.mediansButton.setForeground(UIManager.getColor("Label.foreground"));
            this.mediansButton.setFocusPainted(false);
            this.mediansButton.setHorizontalAlignment(0);
            ButtonGroup chooseMeansOrMedians = new ButtonGroup();
            chooseMeansOrMedians.add(this.meansButton);
            chooseMeansOrMedians.add(this.mediansButton);
            KMCSupportDialog.this.buildConstraints(constraints, 0, 0, 1, 1, 50, 100);
            gridbag.setConstraints(this.meansButton, constraints);
            this.add(this.meansButton);
            KMCSupportDialog.this.buildConstraints(constraints, 1, 0, 1, 1, 50, 0);
            gridbag.setConstraints(this.mediansButton, constraints);
            this.add(this.mediansButton);
        }
    }
}

