/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KMCSuppInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header;
    private JTextArea content;
    private boolean clusterGenes;
    private boolean unassignedExists;

    public KMCSuppInfoViewer(int[][] clusters, int genes) {
        this.header = this.createHeader();
        this.clusterGenes = true;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    public KMCSuppInfoViewer(JTextArea content, JComponent header, Boolean clusterGenes) {
        this.content = content;
        this.header = header;
        this.clusterGenes = clusterGenes;
        this.setMaxWidth(content, header);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.content, this.header, new Boolean(this.clusterGenes)});
    }

    public KMCSuppInfoViewer(int[][] clusters, int genes, boolean unassignedExists, boolean clusterGenes) {
        this.header = this.createHeader();
        this.unassignedExists = unassignedExists;
        this.clusterGenes = clusterGenes;
        this.content = this.createContent(clusters, genes);
        this.setMaxWidth(this.content, this.header);
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.clusterGenes) {
            if (!this.unassignedExists) {
                for (int counter = 0; counter < clusters.length; ++counter) {
                    sb.append("Cluster " + (counter + 1));
                    sb.append("\t");
                    sb.append("# of Genes in Cluster: " + clusters[counter].length);
                    sb.append("\n\t");
                    sb.append("% of Genes in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                }
            } else {
                int counter;
                for (counter = 0; counter < clusters.length - 1; ++counter) {
                    sb.append("Cluster " + (counter + 1));
                    sb.append("\t");
                    sb.append("# of Genes in Cluster: " + clusters[counter].length);
                    sb.append("\n\t");
                    sb.append("% of Genes in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                    sb.append("\n\n");
                }
                sb.append("Unassigned Genes ");
                sb.append("\n\t");
                sb.append("# of Unassighed Genes: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Genes Unassigned: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        } else if (!this.unassignedExists) {
            for (int counter = 0; counter < clusters.length; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t");
                sb.append("# of Experiments in Cluster: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Experiments in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
        } else {
            int counter;
            for (counter = 0; counter < clusters.length - 1; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t");
                sb.append("# of Experiments in Cluster: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Experiments in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\n");
            }
            sb.append("Unassigned Experiments ");
            sb.append("\n\t");
            sb.append("# of Unassiged Experiments: " + clusters[counter].length);
            sb.append("\n\t");
            sb.append("% of Experiments Unassigned: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
            sb.append("\n\n");
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

