/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmcs;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSuppInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmcs.KMCSupportDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class KMCSuppGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Experiment experiment;
    private int[][] clusters;
    private int k;
    private FloatMatrix means;
    private FloatMatrix variances;
    private IData data;
    private boolean unassignedExists;
    private boolean clusterGenes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        int numClusters = 10;
        int iterations = 50;
        this.data = framework.getData();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        KMCSupportDialog kmcsDialog = new KMCSupportDialog((JFrame)framework.getFrame(), true, menu.getFunctionName(function), menu.isAbsoluteDistance());
        kmcsDialog.setVisible(true);
        if (!kmcsDialog.isOkPressed()) {
            return null;
        }
        int numReps = 0;
        double thresholdPercent = 0.0;
        try {
            numClusters = kmcsDialog.getNumClusters();
            iterations = kmcsDialog.getIterations();
            numReps = kmcsDialog.getNumReps();
            thresholdPercent = kmcsDialog.getThresholdPercent();
            this.clusterGenes = kmcsDialog.isClusterGenes();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        boolean isHierarchicalTree = kmcsDialog.isDrawTrees();
        boolean calculateMeans = kmcsDialog.meansChosen();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = kmcsDialog.getDistanceMetric();
        boolean hcl_absolute = kmcsDialog.getAbsoluteSelection();
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(kmcsDialog.getDistanceMetric()), kmcsDialog.getAbsoluteSelection(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KMCS");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = this.experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            FloatMatrix matrix = this.experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            data.addMatrix("experiment", matrix);
            data.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
            data.addParam("distance-factor", String.valueOf(1.0f));
            function = kmcsDialog.getDistanceMetric();
            data.addParam("distance-absolute", String.valueOf(kmcsDialog.getAbsoluteSelection()));
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("number-of-desired-clusters", String.valueOf(numClusters));
            data.addParam("number-of-iterations", String.valueOf(iterations));
            data.addParam("number-of-repetitions", String.valueOf(numReps));
            data.addParam("threshold-percent", String.valueOf(thresholdPercent));
            data.addParam("calculate-means", String.valueOf(calculateMeans));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            this.k = resultMap.getInt("number-of-clusters");
            this.unassignedExists = resultMap.getBoolean("unassigned-genes-exist");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.unassignedExists ? this.k - 1 : this.k;
            info.userNumClusters = numClusters;
            info.meansOrMedians = calculateMeans ? "K-Means" : "K-Medians";
            info.iterations = iterations;
            info.time = time;
            info.numReps = numReps;
            info.thresholdPercent = thresholdPercent;
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        this.experiment = experiment;
        this.data = framework.getData();
        this.clusterGenes = algData.getParams().getBoolean("kmc-cluster-genes");
        boolean calculateMeans = algData.getParams().getBoolean("calculate-means");
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KMCS");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = experiment.getNumberOfGenes();
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            FloatMatrix matrix = experiment.getMatrix();
            if (!this.clusterGenes) {
                matrix = matrix.transpose();
            }
            algData.addMatrix("experiment", matrix);
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(algData);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            AlgorithmParameters resultMap = result.getParams();
            this.k = resultMap.getInt("number-of-clusters");
            this.unassignedExists = resultMap.getBoolean("unassigned-genes-exist");
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            AlgorithmParameters params = algData.getParams();
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.unassignedExists ? this.k - 1 : this.k;
            info.userNumClusters = params.getInt("number-of-desired-clusters");
            info.meansOrMedians = calculateMeans ? "K-Means" : "K-Medians";
            info.iterations = params.getInt("number-of-iterations");
            info.time = time;
            info.numReps = params.getInt("number-of-repetitions");
            info.thresholdPercent = params.getFloat("threshold-percent");
            int function = params.getInt("distance-function");
            info.function = framework.getDistanceMenu().getFunctionName(function);
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        int numClusters = 10;
        int iterations = 50;
        this.data = framework.getData();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        KMCSupportDialog kmcsDialog = new KMCSupportDialog((JFrame)framework.getFrame(), true, menu.getFunctionName(function), menu.isAbsoluteDistance());
        kmcsDialog.setVisible(true);
        if (!kmcsDialog.isOkPressed()) {
            return null;
        }
        int numReps = 0;
        double thresholdPercent = 0.0;
        try {
            numClusters = kmcsDialog.getNumClusters();
            iterations = kmcsDialog.getIterations();
            numReps = kmcsDialog.getNumReps();
            thresholdPercent = kmcsDialog.getThresholdPercent();
            this.clusterGenes = kmcsDialog.isClusterGenes();
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Invalid input parameters!", "Error", 0);
            return null;
        }
        boolean isHierarchicalTree = kmcsDialog.isDrawTrees();
        boolean calculateMeans = kmcsDialog.meansChosen();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = kmcsDialog.getDistanceMetric();
        boolean hcl_absolute = kmcsDialog.getAbsoluteSelection();
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(kmcsDialog.getDistanceMetric()), kmcsDialog.getAbsoluteSelection(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        int genes = this.experiment.getNumberOfGenes();
        AlgorithmData data = new AlgorithmData();
        data.addParam("kmc-cluster-genes", String.valueOf(this.clusterGenes));
        data.addParam("distance-factor", String.valueOf(1.0f));
        function = kmcsDialog.getDistanceMetric();
        data.addParam("distance-absolute", String.valueOf(kmcsDialog.getAbsoluteSelection()));
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("number-of-desired-clusters", String.valueOf(numClusters));
        data.addParam("number-of-iterations", String.valueOf(iterations));
        data.addParam("number-of-repetitions", String.valueOf(numReps));
        data.addParam("threshold-percent", String.valueOf(thresholdPercent));
        data.addParam("calculate-means", String.valueOf(calculateMeans));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "KMS");
        if (this.clusterGenes) {
            data.addParam("alg-type", "cluster-genes");
        } else {
            data.addParam("alg-type", "cluster-experiments");
        }
        if (this.clusterGenes) {
            data.addParam("output-class", "multi-gene-cluster-output");
        } else {
            data.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] outputNodes = new String[]{"Multi-cluster"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("KMS - genes") : new DefaultMutableTreeNode("KMS - samples");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object tabViewer = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        if (!this.unassignedExists) {
            for (int i = 0; i < this.clusters.length; ++i) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned ", (IViewer)tabViewer, (Object)new Integer(this.clusters.length - 1))));
        }
        root.add(node);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = this.clusterGenes ? new KMCSuppExperimentViewer(this.experiment, this.clusters) : new KMCSuppExperimentClusterViewer(this.experiment, this.clusters);
        if (!this.unassignedExists) {
            for (int i = 0; i < this.clusters.length; ++i) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
            }
        } else {
            for (int i = 0; i < this.clusters.length - 1; ++i) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
            }
            if (this.clusterGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)expViewer, (Object)new Integer(this.clusters.length - 1))));
            } else {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned experiments ", (IViewer)expViewer, (Object)new Integer(this.clusters.length - 1))));
            }
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        if (this.clusterGenes) {
            if (!this.unassignedExists) {
                for (int i = 0; i < nodeList.getSize(); ++i) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters))));
                }
            } else {
                for (int i = 0; i < nodeList.getSize() - 1; ++i) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters))));
                }
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), info, (int[][])clusters))));
            }
        } else {
            int i;
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
            }
            if (!this.unassignedExists) {
                for (i = 0; i < nodeList.getSize(); ++i) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
                }
            } else {
                for (i = 0; i < nodeList.getSize() - 1; ++i) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
                }
                node.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned experiments ", this.createHCLViewer(nodeList.getNode(nodeList.getSize() - 1), info, (int[][])clusters), (Object)new Integer(i))));
            }
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : (samples_result = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new KMCSuppInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.unassignedExists, this.clusterGenes))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new KMCSuppInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.unassignedExists, this.clusterGenes))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            KMCSuppCentroidViewer centroidViewer = new KMCSuppCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            if (!this.unassignedExists) {
                for (int i = 0; i < this.clusters.length; ++i) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
            } else {
                for (int i = 0; i < this.clusters.length - 1; ++i) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned genes ", (IViewer)centroidViewer, (Object)new CentroidUserObject(this.clusters.length - 1, 1))));
            }
            KMCSuppCentroidsViewer centroidsViewer = new KMCSuppCentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            KMCSuppExperimentCentroidViewer expCentroidViewer = new KMCSuppExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            if (!this.unassignedExists) {
                for (int i = 0; i < this.clusters.length; ++i) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
            } else {
                int i;
                for (i = 0; i < this.clusters.length - 1; ++i) {
                    centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                    expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
                }
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Unassigned Experiments ", (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            KMCSuppExperimentCentroidsViewer expCentroidsViewer = new KMCSuppExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("K-Means or K-Medians: " + info.meansOrMedians));
        node.add(new DefaultMutableTreeNode("Number of consensus clusters: " + String.valueOf(info.clusters)));
        node.add(new DefaultMutableTreeNode("Clusters per K-means / K-medians run: " + String.valueOf(info.userNumClusters)));
        node.add(new DefaultMutableTreeNode("Iterations per K-means / K-Medians run: " + String.valueOf(info.iterations)));
        node.add(new DefaultMutableTreeNode("Number of K-Means / K-Medians runs: " + String.valueOf(info.numReps)));
        node.add(new DefaultMutableTreeNode("Threshold co-occurrence %: " + String.valueOf(info.thresholdPercent)));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private class GeneralInfo {
        public int clusters;
        public String meansOrMedians;
        public int iterations;
        public int userNumClusters;
        public long time;
        public String function;
        public int numReps;
        public double thresholdPercent;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    KMCSuppGUI.this.progress.setUnits(event.getIntValue());
                    KMCSuppGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    KMCSuppGUI.this.progress.setValue(event.getIntValue());
                    KMCSuppGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                KMCSuppGUI.this.algorithm.abort();
                KMCSuppGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KMCSuppGUI.this.algorithm.abort();
            KMCSuppGUI.this.progress.dispose();
        }
    }
}

