/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class KMCInitDialog
extends AlgorithmDialog {
    private int result;
    private int k;
    private int iter;
    private JTextField textField1;
    private JTextField textField2;
    private JRadioButton calcMeans;
    private JRadioButton calcMedians;
    private ButtonGroup meanMedianGroup;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclPanel;
    private DistanceMetricPanel metricPanel;

    public KMCInitDialog(JFrame parent, int clusters, int iterations, String globalMetricName, boolean globalAbsoluteValue) {
        super(parent, "KMC: K-Means/K-Medians", true);
        this.k = clusters;
        this.iter = iterations;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.metricPanel = new DistanceMetricPanel(globalMetricName, globalAbsoluteValue, "Pearson Correlation", "KMC", true, true);
        this.meanMedianGroup = new ButtonGroup();
        this.calcMeans = new JRadioButton("Calculate K-Means", true);
        this.calcMeans.setFocusPainted(false);
        this.calcMeans.setBackground(Color.white);
        this.calcMeans.setForeground(UIManager.getColor("Label.foreground"));
        this.calcMedians = new JRadioButton("Calculate K-Medians", false);
        this.calcMedians.setFocusPainted(false);
        this.calcMedians.setBackground(Color.white);
        this.calcMedians.setForeground(UIManager.getColor("Label.foreground"));
        this.meanMedianGroup.add(this.calcMeans);
        this.meanMedianGroup.add(this.calcMedians);
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        parameters.add((Component)this.calcMeans, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 10), 0, 0));
        parameters.add((Component)this.calcMedians, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
        parameters.add((Component)new JLabel("Number of clusters"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        parameters.add((Component)new JLabel("Maximum iterations"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.textField1 = new JTextField(String.valueOf(clusters), 7);
        this.textField2 = new JTextField(String.valueOf(iterations), 7);
        parameters.add((Component)this.textField1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 0, 0), 0, 0));
        parameters.add((Component)this.textField2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 10, 5, 0), 0, 0));
        this.hclPanel = new HCLSelectionPanel();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBackground(Color.white);
        mainPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.metricPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)parameters, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.hclPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.setForeground(Color.white);
        controlPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        controlPanel.setBackground(Color.white);
        controlPanel.add((Component)mainPanel, "Center");
        this.addContent(controlPanel);
        this.okButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.resetButton.addActionListener(listener);
        this.infoButton.addActionListener(listener);
        this.validate();
        this.setSize(420, 410);
        this.setResizable(false);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusters() {
        return Integer.parseInt(this.textField1.getText());
    }

    public int getIterations() {
        return Integer.parseInt(this.textField2.getText());
    }

    public boolean isHierarchicalTree() {
        return this.hclPanel.isHCLSelected();
    }

    public boolean calculateMeans() {
        return this.calcMeans.isSelected();
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    private void onReset() {
        this.textField1.setText(String.valueOf(this.k));
        this.textField2.setText(String.valueOf(this.iter));
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclPanel.setHCLSelected(false);
        this.calcMeans.setSelected(true);
        this.metricPanel.reset();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public static void main(String[] args) {
        KMCInitDialog dlg = new KMCInitDialog(new JFrame(), 10, 50, "Pearson Correlation", true);
        dlg.showModal();
        System.exit(0);
    }

    @Override
    protected void disposeDialog() {
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == KMCInitDialog.this.okButton) {
                try {
                    int k = Integer.parseInt(KMCInitDialog.this.textField1.getText());
                    if (k < 1) {
                        KMCInitDialog.this.textField1.requestFocus();
                        KMCInitDialog.this.textField1.selectAll();
                        JOptionPane.showMessageDialog(KMCInitDialog.this, "Number of clusters must be greater than 0!", "Error", 0);
                        return;
                    }
                    int i = Integer.parseInt(KMCInitDialog.this.textField2.getText());
                    if (i < 1) {
                        KMCInitDialog.this.textField2.requestFocus();
                        KMCInitDialog.this.textField2.selectAll();
                        JOptionPane.showMessageDialog(KMCInitDialog.this, "Number of iterations must be greater than 0!", "Error", 0);
                        return;
                    }
                    KMCInitDialog.this.result = 0;
                }
                catch (NumberFormatException exception) {
                    JOptionPane.showMessageDialog(KMCInitDialog.this, "Entry format error.", "Error", 0);
                    KMCInitDialog.this.result = 2;
                    return;
                }
                KMCInitDialog.this.dispose();
            } else if (source == KMCInitDialog.this.cancelButton) {
                KMCInitDialog.this.result = 2;
                KMCInitDialog.this.dispose();
            } else if (source == KMCInitDialog.this.resetButton) {
                KMCInitDialog.this.onReset();
            } else if (source == KMCInitDialog.this.infoButton) {
                HelpWindow.launchBrowser(KMCInitDialog.this, "KMC Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KMCInitDialog.this.result = -1;
            KMCInitDialog.this.dispose();
        }
    }
}

