/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Expression;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tigr.microarray.mev.cluster.gui.impl.ViewerAdapter;

public class KMCInfoViewer
extends ViewerAdapter
implements Serializable {
    private JComponent header = this.createHeader();
    private JTextArea content;
    private boolean clusterGenes;

    public JTextArea getContent() {
        return this.content;
    }

    public KMCInfoViewer(int[][] clusters, int genes, int[] convIteration) {
        this.clusterGenes = true;
        this.content = this.createContent(clusters, genes, convIteration);
        this.setMaxWidth(this.content, this.header);
    }

    public KMCInfoViewer(int[][] clusters, int genes, int[] convIteration, boolean clusterGenes) {
        this.clusterGenes = clusterGenes;
        this.content = this.createContent(clusters, genes, convIteration);
        this.setMaxWidth(this.content, this.header);
    }

    public KMCInfoViewer(JTextArea content, Boolean clusterGenes) {
        this(content, (boolean)clusterGenes);
    }

    public KMCInfoViewer(JTextArea content, boolean clusterGenes) {
        this.content = content;
        this.clusterGenes = clusterGenes;
        this.setMaxWidth(content, this.header);
    }

    @Override
    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.getContentComponent(), new Boolean(this.clusterGenes)});
    }

    @Override
    public JComponent getContentComponent() {
        return this.content;
    }

    @Override
    public JComponent getHeaderComponent() {
        return this.header;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 10, 0);
        panel.add((Component)new JLabel("<html><body bgcolor='#FFFFFF'><font face='serif' size='5' color='#000080'><b>Cluster Information</b></font></body></html>"), gbc);
        return panel;
    }

    private JTextArea createContent(int[][] clusters, int genes, int[] convIter) {
        JTextArea area = new JTextArea(clusters.length * 3, 20);
        area.setEditable(false);
        area.setMargin(new Insets(0, 10, 0, 0));
        StringBuffer sb = new StringBuffer(clusters.length * 3 * 10);
        if (this.clusterGenes) {
            for (int counter = 0; counter < clusters.length; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t");
                sb.append("# of Genes in Cluster: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Genes in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\t");
                sb.append("Last Iteration with Gene Exchange: " + convIter[counter]);
                sb.append("\n\n");
            }
        } else {
            for (int counter = 0; counter < clusters.length; ++counter) {
                sb.append("Cluster " + (counter + 1));
                sb.append("\t");
                sb.append("# of Experiments in Cluster: " + clusters[counter].length);
                sb.append("\n\t");
                sb.append("% of Experiments in Cluster: " + Math.round((float)clusters[counter].length / (float)genes * 100.0f) + "%");
                sb.append("\n\t");
                sb.append("Last Iteration with Experiment Exchange: " + convIter[counter]);
                sb.append("\n\n");
            }
        }
        area.setText(sb.toString());
        area.setCaretPosition(0);
        return area;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    @Override
    public JComponent getRowHeaderComponent() {
        return null;
    }
}

