/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.kmc;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Monitor;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.kmc.KMCInitDialog;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class KMCGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private Monitor monitor;
    private Experiment experiment;
    private IData data;
    private int[][] clusters;
    private FloatMatrix means;
    private FloatMatrix variances;
    private boolean clusterGenes;
    private int[] convergenceIteration;
    private int k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        KMCInitDialog kmc_dialog;
        this.k = 10;
        int iterations = 50;
        boolean calcMeans = true;
        this.data = framework.getData();
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        if ((kmc_dialog = new KMCInitDialog((JFrame)framework.getFrame(), this.k, iterations, menu.getFunctionName(function), menu.isAbsoluteDistance())).showModal() != 0) {
            return null;
        }
        this.k = kmc_dialog.getClusters();
        iterations = kmc_dialog.getIterations();
        calcMeans = kmc_dialog.calculateMeans();
        this.clusterGenes = kmc_dialog.isClusterGenesSelected();
        if (this.k < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        if (iterations < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of iterations must be greater than 0!", "Error", 0);
            return null;
        }
        boolean isHierarchicalTree = kmc_dialog.isHierarchicalTree();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(kmc_dialog.getDistanceMetric()), kmc_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KMC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = this.experiment.getNumberOfGenes();
            this.monitor = new Monitor(framework.getFrame(), "Reallocations", 25, 100, 210.0 / (double)genes);
            this.monitor.setStepXFactor((int)Math.floor(245 / iterations));
            this.monitor.update(genes);
            this.monitor.show();
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            if (this.clusterGenes) {
                data.addMatrix("experiment", this.experiment.getMatrix());
                data.addParam("kmc-cluster-genes", String.valueOf(true));
            } else {
                data.addMatrix("experiment", this.experiment.getMatrix().transpose());
                data.addParam("kmc-cluster-genes", String.valueOf(false));
            }
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("distance-absolute", String.valueOf(kmc_dialog.isAbsoluteDistance()));
            function = kmc_dialog.getDistanceMetric();
            if (function == 0) {
                function = 1;
            }
            data.addParam("distance-function", String.valueOf(function));
            data.addParam("number-of-clusters", String.valueOf(this.k));
            data.addParam("number-of-iterations", String.valueOf(iterations));
            data.addParam("calculate-means", String.valueOf(calcMeans));
            if (isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.convergenceIteration = result.getIntArray("convergence-iterations");
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.k;
            info.converged = result.getParams().getBoolean("converged");
            info.iterations = result.getParams().getInt("iterations");
            info.calculate_means = calcMeans;
            info.time = time;
            info.function = menu.getFunctionName(function);
            info.hcl = isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        KMCInitDialog kmc_dialog;
        this.k = 10;
        int iterations = 50;
        boolean calcMeans = true;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        if ((kmc_dialog = new KMCInitDialog((JFrame)framework.getFrame(), this.k, iterations, menu.getFunctionName(menu.getDistanceFunction()), menu.isAbsoluteDistance())).showModal() != 0) {
            return null;
        }
        this.k = kmc_dialog.getClusters();
        iterations = kmc_dialog.getIterations();
        calcMeans = kmc_dialog.calculateMeans();
        this.clusterGenes = kmc_dialog.isClusterGenesSelected();
        if (this.k < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of clusters must be greater than 0!", "Error", 0);
            return null;
        }
        if (iterations < 1) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Number of iterations must be greater than 0!", "Error", 0);
            return null;
        }
        boolean isHierarchicalTree = kmc_dialog.isHierarchicalTree();
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        if (isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(kmc_dialog.getDistanceMetric()), kmc_dialog.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
        }
        this.experiment = framework.getData().getExperiment();
        Listener listener = new Listener();
        AlgorithmData data = new AlgorithmData();
        if (this.clusterGenes) {
            data.addParam("kmc-cluster-genes", String.valueOf(true));
        } else {
            data.addParam("kmc-cluster-genes", String.valueOf(false));
        }
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(kmc_dialog.isAbsoluteDistance()));
        function = kmc_dialog.getDistanceMetric();
        if (function == 0) {
            function = 1;
        }
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("number-of-clusters", String.valueOf(this.k));
        data.addParam("number-of-iterations", String.valueOf(iterations));
        data.addParam("calculate-means", String.valueOf(calcMeans));
        if (isHierarchicalTree) {
            data.addParam("hierarchical-tree", String.valueOf(true));
            data.addParam("method-linkage", String.valueOf(hcl_method));
            data.addParam("calculate-genes", String.valueOf(hcl_genes));
            data.addParam("calculate-experiments", String.valueOf(hcl_samples));
            data.addParam("hcl-distance-function", String.valueOf(hcl_function));
            data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
        }
        data.addParam("name", "KMC");
        if (this.clusterGenes) {
            data.addParam("alg-type", "cluster-genes");
        } else {
            data.addParam("alg-type", "cluster-experiments");
        }
        if (this.clusterGenes) {
            data.addParam("output-class", "multi-gene-cluster-output");
        } else {
            data.addParam("output-class", "multi-experiment-cluster-output");
        }
        String[] outputNodes = new String[]{"Multi-cluster"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        AlgorithmData data = algData;
        AlgorithmParameters params = data.getParams();
        this.k = params.getInt("number-of-clusters", 10);
        this.clusterGenes = params.getBoolean("kmc-cluster-genes");
        int iterations = params.getInt("number-of-iterations");
        if (this.clusterGenes) {
            data.addMatrix("experiment", experiment.getMatrix());
        } else {
            data.addMatrix("experiment", experiment.getMatrix().transpose());
        }
        this.data = framework.getData();
        this.experiment = experiment;
        Listener listener = new Listener();
        try {
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("KMC");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            int genes = experiment.getNumberOfGenes();
            this.monitor = new Monitor(framework.getFrame(), "Reallocations", 25, 100, 210.0 / (double)genes);
            this.monitor.setStepXFactor((int)Math.floor(245 / iterations));
            this.monitor.update(genes);
            this.monitor.show();
            this.progress = new Progress(framework.getFrame(), "Calculating clusters", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            Cluster result_cluster = result.getCluster("cluster");
            NodeList nodeList = result_cluster.getNodeList();
            this.clusters = new int[this.k][];
            for (int i = 0; i < this.k; ++i) {
                this.clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.convergenceIteration = result.getIntArray("convergence-iterations");
            GeneralInfo info = new GeneralInfo();
            info.clusters = this.k;
            info.converged = result.getParams().getBoolean("converged");
            info.iterations = result.getParams().getInt("iterations");
            info.calculate_means = params.getBoolean("calculate-means");
            info.time = time;
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            info.hcl = params.getBoolean("hierarchical-tree");
            info.hcl_genes = params.getBoolean("calculate-genes");
            info.hcl_samples = params.getBoolean("calculate-experiments");
            if (info.hcl) {
                info.hcl_method = params.getInt("method-linkage");
            } else {
                info.hcl_method = 0;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(result_cluster, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
            if (this.monitor != null) {
                this.monitor.dispose();
            }
        }
    }

    private DefaultMutableTreeNode createResultTree(Cluster result_cluster, GeneralInfo info) {
        DefaultMutableTreeNode root = this.clusterGenes ? new DefaultMutableTreeNode("KMC - genes") : new DefaultMutableTreeNode("KMC - samples");
        this.addResultNodes(root, result_cluster, info);
        return root;
    }

    private void addResultNodes(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        this.addExpressionImages(root);
        this.addHierarchicalTrees(root, result_cluster, info);
        this.addCentroidViews(root);
        this.addClusterTableViews(root);
        this.addClusterInfo(root);
        this.addGeneralInfo(root, info);
    }

    private void addExpressionImages(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = this.clusterGenes ? new KMCExperimentViewer(this.experiment, this.clusters) : new KMCExperimentClusterViewer(this.experiment, this.clusters);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addClusterTableViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Table views");
        Object tableViewer = this.clusterGenes ? new ClusterTableViewer(this.experiment, this.clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, this.clusters, this.data);
        for (int i = 0; i < this.clusters.length; ++i) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tableViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        int i;
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        Object clusters = null;
        if (!this.clusterGenes) {
            clusters = new int[this.k][];
            for (i = 0; i < this.k; ++i) {
                clusters[i] = nodeList.getNode(i).getFeaturesIndexes();
            }
            if (info.hcl_samples) {
                clusters = this.getOrderedIndices(nodeList, (int[][])clusters, info.hcl_genes);
            }
        }
        for (i = 0; i < nodeList.getSize(); ++i) {
            if (this.clusterGenes) {
                node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, null))));
                continue;
            }
            node.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), this.createHCLViewer(nodeList.getNode(i), info, (int[][])clusters), (Object)new Integer(i))));
        }
        root.add(node);
    }

    private IViewer createHCLViewer(Node clusterNode, GeneralInfo info, int[][] sampleClusters) {
        HCLTreeData samples_result;
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData hCLTreeData2 = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : (samples_result = null);
        if (this.clusterGenes) {
            return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
        }
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result, sampleClusters, true);
    }

    private HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    private int[][] getOrderedIndices(NodeList nodeList, int[][] sampleClusters, boolean calcGeneHCL) {
        for (int i = 0; i < sampleClusters.length; ++i) {
            if (sampleClusters[i].length <= 0) continue;
            HCLTreeData result = this.getResult(nodeList.getNode(i), calcGeneHCL ? 4 : 0);
            sampleClusters[i] = this.getSampleOrder(result, sampleClusters[i]);
        }
        return sampleClusters;
    }

    private int[] getSampleOrder(HCLTreeData result, int[] indices) {
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    private void addClusterInfo(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (this.clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new KMCInfoViewer(this.clusters, this.experiment.getNumberOfGenes(), this.convergenceIteration))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Samples in Clusters (#,%)", (IViewer)new KMCInfoViewer(this.clusters, this.experiment.getNumberOfSamples(), this.convergenceIteration, false))));
        }
        root.add(node);
    }

    private void addCentroidViews(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        if (this.clusterGenes) {
            KMCCentroidViewer centroidViewer = new KMCCentroidViewer(this.experiment, this.clusters);
            centroidViewer.setMeans(this.means.A);
            centroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            KMCCentroidsViewer centroidsViewer = new KMCCentroidsViewer(this.experiment, this.clusters);
            centroidsViewer.setMeans(this.means.A);
            centroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            KMCExperimentCentroidViewer expCentroidViewer = new KMCExperimentCentroidViewer(this.experiment, this.clusters);
            expCentroidViewer.setMeans(this.means.A);
            expCentroidViewer.setVariances(this.variances.A);
            for (int i = 0; i < this.clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            KMCExperimentCentroidsViewer expCentroidsViewer = new KMCExperimentCentroidsViewer(this.experiment, this.clusters);
            expCentroidsViewer.setMeans(this.means.A);
            expCentroidsViewer.setVariances(this.variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        if (info.calculate_means) {
            node.add(new DefaultMutableTreeNode("KMC mode: Calculated Means"));
        } else {
            node.add(new DefaultMutableTreeNode("KMC mode: Calculated Medians"));
        }
        node.add(new DefaultMutableTreeNode("Clusters: " + String.valueOf(info.clusters)));
        node.add(new DefaultMutableTreeNode("Converged: " + String.valueOf(info.converged)));
        node.add(new DefaultMutableTreeNode("Iterations: " + String.valueOf(info.iterations)));
        node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private class GeneralInfo {
        public int clusters;
        public boolean converged;
        public int iterations;
        public long time;
        public String function;
        public boolean calculate_means;
        private boolean hcl;
        private int hcl_method;
        private boolean hcl_genes;
        private boolean hcl_samples;

        private GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    KMCGUI.this.progress.setUnits(event.getIntValue());
                    KMCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    KMCGUI.this.progress.setValue(event.getIntValue());
                    KMCGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                    KMCGUI.this.monitor.dispose();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                KMCGUI.this.algorithm.abort();
                KMCGUI.this.progress.dispose();
                KMCGUI.this.monitor.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            KMCGUI.this.algorithm.abort();
            KMCGUI.this.progress.dispose();
            KMCGUI.this.monitor.dispose();
        }
    }
}

