/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class NexusFileOutputDialog
extends AlgorithmDialog {
    private int result = 2;
    private boolean isGeneTree = false;
    private JComboBox annBox;
    private JTextField fileField;
    private JCheckBox saveMatrixBox;
    private JTextField treeNameField;

    public NexusFileOutputDialog(Frame parent, String[] annotationKeys, int orientation, String fileType) {
        super(parent, fileType + " File Output Dialog", true);
        if (orientation == 0) {
            this.isGeneTree = true;
        }
        JLabel annSelectionLabel = this.isGeneTree ? new JLabel("Select a Gene Label:") : new JLabel("Select a Sample Label:");
        this.annBox = new JComboBox<String>(annotationKeys);
        this.annBox.setSelectedIndex(0);
        JLabel nameLabel = new JLabel("Tree Label  (no spaces please): ");
        this.treeNameField = new JTextField("default_mev_tree_label", 15);
        this.saveMatrixBox = new JCheckBox("Save Expression Matrix  (much larger file) ", false);
        this.saveMatrixBox.setOpaque(false);
        this.saveMatrixBox.setFocusPainted(false);
        JLabel fileLabel = new JLabel("Output File:");
        this.fileField = new JTextField(25);
        this.fileField.setMargin(new Insets(0, 3, 0, 3));
        this.fileField.setHorizontalAlignment(11);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "nexux_output.nex");
        JButton browseButton = new JButton("Select Output File");
        browseButton.setActionCommand("browse-command");
        browseButton.setFocusPainted(false);
        ParameterPanel panel = new ParameterPanel("Output Parameters");
        panel.setLayout(new GridBagLayout());
        JPanel annPanel = new JPanel(new GridBagLayout());
        annPanel.setBackground(Color.white);
        annPanel.add((Component)annSelectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 5, 0), 0, 0));
        annPanel.add((Component)this.annBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 10, 5, 20), 0, 0));
        panel.add((Component)annPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(5, 0, 0, 0), 0, 0));
        JSeparator sep1 = new JSeparator(0);
        sep1.setPreferredSize(new Dimension(200, 2));
        panel.add((Component)sep1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBackground(Color.white);
        panel2.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 20, 5, 0), 0, 0));
        panel2.add((Component)this.treeNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(10, 10, 5, 20), 0, 0));
        panel.add((Component)panel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSeparator sep2 = new JSeparator(0);
        sep2.setPreferredSize(new Dimension(200, 2));
        panel.add((Component)sep2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)fileLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)this.fileField, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 20, 15, 0), 0, 0));
        panel.add((Component)browseButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 15, 20), 0, 0));
        this.addContent(panel);
        Listener listener = new Listener();
        browseButton.addActionListener(listener);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private boolean validateOutputFile() {
        File outFile = new File(this.fileField.getText());
        File parent = outFile.getParentFile();
        return parent.exists() && parent.isDirectory();
    }

    private void resetControls() {
        this.annBox.setSelectedIndex(0);
        this.fileField.setText(TMEV.getFile((String)"data").getAbsolutePath() + System.getProperty("file.separator") + "newick_output.txt");
    }

    public File getOutputFile() {
        return new File(this.fileField.getText());
    }

    public String getAnnotationKey() {
        return (String)this.annBox.getSelectedItem();
    }

    public String getTreeLabel() {
        String label = this.treeNameField.getText();
        if (label.equals("")) {
            label = "default_tree_label";
        }
        return label.replace(' ', '_');
    }

    public boolean getSaveMatris() {
        return this.saveMatrixBox.isSelected();
    }

    public static void main(String[] args) {
        String[] names = new String[]{"TC", "GenBank", "Putative Role (Guess)"};
        NexusFileOutputDialog d = new NexusFileOutputDialog(new Frame(), names, 1, "Nexus");
        d.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (!NexusFileOutputDialog.this.validateOutputFile()) {
                    JOptionPane.showMessageDialog(NexusFileOutputDialog.this, "The directory specified for file output does not exist.<BR>Please select again.", "Newick Output File Error", 2);
                    return;
                }
                NexusFileOutputDialog.this.result = 0;
                NexusFileOutputDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                NexusFileOutputDialog.this.result = 2;
                NexusFileOutputDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    NexusFileOutputDialog.this.resetControls();
                    NexusFileOutputDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(NexusFileOutputDialog.this, "Nexus File Output Dialog");
                } else if (command.equals("browse-command")) {
                    String dataPath = TMEV.getDataPath();
                    File fileLoc = TMEV.getFile((String)"data/");
                    if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
                        fileLoc = TMEV.getFile((String)"data/");
                    }
                    JFileChooser chooser = new JFileChooser(fileLoc);
                    chooser.setFileSelectionMode(0);
                    if (chooser.showSaveDialog(NexusFileOutputDialog.this) == 0) {
                        NexusFileOutputDialog.this.fileField.setText(chooser.getSelectedFile().getAbsolutePath());
                        NexusFileOutputDialog.this.validate();
                    }
                    return;
                }
            }
            NexusFileOutputDialog.this.dispose();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            NexusFileOutputDialog.this.result = -1;
            NexusFileOutputDialog.this.dispose();
        }
    }
}

