/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.ClusterWrapper;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLAnnotationBar;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLClusterInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLColorBar;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLConfigDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentCentroidsViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.util.FloatMatrix;

public class HCLViewer
extends JPanel
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String DELETE_CLUSTER_CMD = "delete-cluster-cmd";
    protected static final String DELETE_ALL_CLUSTERS_CMD = "delete-all-clusters-cmd";
    protected static final String GENE_TREE_PROPERTIES_CMD = "gene-tree-properties-cmd";
    protected static final String SAMPLE_TREE_PROPERTIES_CMD = "sample-tree-properties-cmd";
    protected static final String ROTATE_NODE_CMD = "rotate-node-cmd";
    protected static final String SAVE_GENE_ORDER_CMD = "save-gene-order-cmd";
    protected static final String SAVE_EXP_ORDER_CMD = "save-exp-order-cmd";
    protected static final String SAVE_GENE_HEIGHT_CMD = "save-gene-height-cmd";
    protected static final String SAVE_EXP_HEIGHT_CMD = "save-exp-height-cmd";
    protected static final String SAVE_GENE_NEWICK_CMD = "save-gene-newick-cmd";
    protected static final String SAVE_SAMPLE_NEWICK_CMD = "save-sample-newick-cmd";
    protected static final String SAVE_GENE_NEXUS_CMD = "save-gene-nexus-cmd";
    protected static final String SAVE_SAMPLE_NEXUS_CMD = "save-sample-nexus-cmd";
    protected IViewer expViewer;
    protected HCLExperimentHeader header;
    protected HCLTree genesTree;
    protected HCLTree sampleTree;
    protected HCLColorBar colorBar;
    protected HCLAnnotationBar annotationBar;
    protected HCLTreeData genes_result;
    protected HCLTreeData samples_result;
    protected IData data;
    protected Experiment experiment;
    protected ArrayList<HCLCluster> clusters = new ArrayList();
    protected ArrayList<HCLCluster> experimentClusters = new ArrayList();
    protected int[][] sampleClusters;
    public HCLCluster selectedCluster;
    protected int[] genesOrder;
    protected int[] samplesOrder;
    protected boolean isExperimentCluster = false;
    protected boolean featureListIsEmpty = false;
    protected Dimension elementSize;
    protected int numberOfSamples;
    protected int offset = 0;
    protected int clusterIndex = 0;
    protected Listener listener;
    protected JPopupMenu popup;
    private int exptID = 0;
    protected int[] features;
    protected DefaultMutableTreeNode node;
    protected IFramework framework;
    protected Expression saveExpression = null;

    public HCLViewer(Experiment experiment, ClusterWrapper features, HCLTreeData genes_result, HCLTreeData samples_result) {
        this(experiment, features.getClusters()[0], genes_result, samples_result);
    }

    public HCLViewer(Experiment experiment, int[] features, HCLTreeData genes_result, HCLTreeData samples_result) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.features = features == null ? this.createDefaultFeatures(experiment) : features;
        this.expViewer = this.createExperimentViewer(experiment, features, genes_result, samples_result);
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, features.length);
        this.colorBar.addMouseListener(this.listener);
        this.genesOrder = this.createGenesOrder(experiment, features, genes_result);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (genes_result != null && genes_result.node_order != null && experiment.getNumberOfGenes() > 1 && genes_result.node_order.length > 1) {
            this.genesTree = new HCLTree(genes_result, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
            this.genes_result = genes_result;
        }
        if (samples_result != null && samples_result.node_order != null && experiment.getNumberOfSamples() > 1 && samples_result.node_order.length > 1) {
            this.sampleTree = new HCLTree(samples_result, 1);
            this.samplesOrder = this.createSamplesOrder(samples_result);
            if (genes_result == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
            this.samples_result = samples_result;
        }
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree, this.genesTree);
        this.header.addMouseListener(this.listener);
        this.isExperimentCluster = false;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.addComponents(null, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
        this.saveExpression = new Expression(this, this.getClass(), "new", new Object[]{experiment, ClusterWrapper.wrapClusters((int[][])new int[][]{features}), genes_result, samples_result});
    }

    public HCLViewer(Experiment e, int[] features, HCLTreeData genesResult, HCLTreeData samplesResult, int[][] sampleClusters, Boolean isExperimentCluster, HCLTree genesTree, HCLTree sampleTree, Integer offset, IViewer expViewer) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.offset = offset;
        this.expViewer = expViewer;
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.features = features;
        this.isExperimentCluster = isExperimentCluster;
        this.sampleClusters = sampleClusters;
        this.genes_result = genesResult;
        this.samples_result = samplesResult;
        this.genesTree = genesTree;
        this.sampleTree = sampleTree;
        if (genesTree != null) {
            this.offset = 0;
        } else {
            sampleTree.setHorizontalOffset(10);
        }
        this.setExperiment(e);
        HCLTreeData _genes_result = this.genes_result;
        HCLTreeData _samples_result = this.samples_result;
        if (this.genes_result == null) {
            _genes_result = new HCLTreeData();
        }
        if (this.samples_result == null) {
            _samples_result = new HCLTreeData();
        }
        this.saveExpression = new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])new int[][]{features}), _genes_result, _samples_result, ClusterWrapper.wrapClusters((int[][])sampleClusters), isExperimentCluster, genesTree, sampleTree, offset, expViewer});
    }

    public HCLViewer(Experiment e, ClusterWrapper features, HCLTreeData genesResult, HCLTreeData samplesResult, ClusterWrapper sampleClusters, boolean isExperimentCluster, HCLTree genesTree, HCLTree sampleTree, Integer offset, ExperimentViewer expViewer) {
        this(e, features.getClusters()[0], genesResult, samplesResult, sampleClusters.getClusters(), (Boolean)isExperimentCluster, genesTree, sampleTree, offset, (IViewer)expViewer);
    }

    public HCLViewer(Experiment experiment, ClusterWrapper features, HCLTreeData genes_result, HCLTreeData samples_result, ClusterWrapper sampleClusters, boolean isExperimentCluster) {
        this(experiment, features.getClusters()[0], genes_result, samples_result, sampleClusters.getClusters(), isExperimentCluster);
    }

    public HCLViewer(Experiment experiment, int[] features, HCLTreeData genes_result, HCLTreeData samples_result, int[][] sampleClusters, boolean isExperimentCluster) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        features = features == null ? this.createDefaultFeatures(experiment) : features;
        this.isExperimentCluster = isExperimentCluster;
        this.numberOfSamples = this.isExperimentCluster ? sampleClusters[0].length : experiment.getNumberOfSamples();
        this.genesOrder = this.createGenesOrder(experiment, this.createDefaultFeatures(experiment), genes_result);
        this.sampleClusters = sampleClusters;
        if (genes_result != null && genes_result.node_order != null && experiment.getNumberOfGenes() > 1 && genes_result.node_order.length > 1) {
            this.genesTree = new HCLTree(genes_result, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
            this.genes_result = genes_result;
        }
        if (samples_result != null && samples_result.node_order != null && experiment.getNumberOfSamples() > 1 && samples_result.node_order.length > 1) {
            this.sampleTree = new HCLTree(samples_result, 1);
            this.samplesOrder = this.createSamplesOrder(samples_result);
            if (genes_result == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
            this.samples_result = samples_result;
        }
        if (this.isExperimentCluster) {
            if (genes_result != null && experiment.getNumberOfGenes() > 1 && genes_result.node_order.length > 1) {
                this.offset = 0;
                this.expViewer = new ExperimentClusterViewer(experiment, sampleClusters, this.genesOrder, true, this.offset);
            } else {
                this.offset = 10;
                this.expViewer = new ExperimentClusterViewer(experiment, sampleClusters, this.genesOrder, true, this.offset);
            }
        } else {
            this.expViewer = this.createExperimentViewer(experiment, features, genes_result, samples_result);
        }
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree, this.genesTree);
        this.header.addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, features.length);
        this.colorBar.addMouseListener(this.listener);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        this.addComponents(null, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
        HCLTreeData _genes_result = this.genes_result;
        HCLTreeData _samples_result = this.samples_result;
        if (this.genes_result == null) {
            _genes_result = new HCLTreeData();
        }
        if (this.samples_result == null) {
            _samples_result = new HCLTreeData();
        }
        this.saveExpression = new Expression(this, this.getClass(), "new", new Object[]{experiment, ClusterWrapper.wrapClusters((int[][])new int[][]{features}), _genes_result, _samples_result, ClusterWrapper.wrapClusters((int[][])sampleClusters), isExperimentCluster});
    }

    public HCLViewer(Experiment experiment, int[] features, HCLTreeData genes_result, HCLTreeData samples_result, DefaultMutableTreeNode node) {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.node = node;
        features = features == null ? this.createDefaultFeatures(experiment) : features;
        this.expViewer = this.createExperimentViewer(experiment, features, genes_result, samples_result);
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.colorBar = new HCLColorBar(this.clusters, features.length);
        this.colorBar.addMouseListener(this.listener);
        this.genesOrder = this.createGenesOrder(experiment, features, genes_result);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (genes_result != null && experiment.getNumberOfGenes() > 1 && genes_result.node_order.length > 1) {
            this.genesTree = new HCLTree(genes_result, 0);
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
            this.genes_result = genes_result;
        }
        if (samples_result != null && experiment.getNumberOfSamples() > 1 && samples_result.node_order.length > 1) {
            this.sampleTree = new HCLTree(samples_result, 1);
            this.samplesOrder = this.createSamplesOrder(samples_result);
            if (genes_result == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
            this.samples_result = samples_result;
        }
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree, this.genesTree);
        this.header.addMouseListener(this.listener);
        this.isExperimentCluster = false;
        this.numberOfSamples = experiment.getNumberOfSamples();
        this.addComponents(null, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
        HCLTreeData _genes_result = this.genes_result;
        HCLTreeData _samples_result = this.samples_result;
        if (this.genes_result == null) {
            _genes_result = new HCLTreeData();
        }
        if (this.samples_result == null) {
            _samples_result = new HCLTreeData();
        }
        this.saveExpression = new Expression(this, this.getClass(), "new", new Object[]{this.experiment, ClusterWrapper.wrapClusters((int[][])new int[][]{this.createDefaultFeatures(this.experiment)}), _genes_result, _samples_result});
    }

    public Expression getExpression() {
        return this.saveExpression;
    }

    public void setExperiment(Experiment e) {
        this.experiment = e;
        this.exptID = e.getId();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.features = this.features == null ? this.createDefaultFeatures(this.experiment) : this.features;
        this.expViewer.getContentComponent().addMouseListener(this.listener);
        this.expViewer.setExperiment(this.experiment);
        this.colorBar = new HCLColorBar(this.clusters, this.features.length);
        this.colorBar.addMouseListener(this.listener);
        this.genesOrder = this.createGenesOrder(this.experiment, this.features, this.genes_result);
        this.annotationBar = new HCLAnnotationBar(this.genesOrder);
        this.annotationBar.addMouseListener(this.listener);
        if (this.genes_result != null && this.experiment.getNumberOfGenes() > 1 && this.genes_result.node_order.length > 1) {
            this.genesTree.addMouseListener(this.listener);
            this.genesTree.setListener(this.listener);
            this.genesTree.deselectAllNodes();
        }
        if (this.samples_result != null && this.experiment.getNumberOfSamples() > 1 && this.samples_result.node_order.length > 1) {
            this.samplesOrder = this.createSamplesOrder(this.samples_result);
            if (this.genes_result == null) {
                this.sampleTree.setHorizontalOffset(10);
            }
            this.sampleTree.addMouseListener(this.listener);
            this.sampleTree.setListener(this.listener);
            this.sampleTree.deselectAllNodes();
        }
        this.header = new HCLExperimentHeader(this.expViewer.getHeaderComponent(), this.sampleTree, this.genesTree);
        this.header.addMouseListener(this.listener);
        this.isExperimentCluster = false;
        this.numberOfSamples = this.experiment.getNumberOfSamples();
        this.addComponents(null, this.genesTree, this.expViewer.getContentComponent(), this.colorBar, this.annotationBar);
        this.popup = this.createJPopupMenu(this.listener);
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    protected void addComponents(JComponent sTree, JComponent gTree, JComponent exp, JComponent cBar, JComponent aBar) {
        int cols;
        int rows = sTree == null ? 1 : 2;
        int n = cols = gTree == null ? 3 : 4;
        if (sTree != null) {
            this.add((Component)sTree, new GridBagConstraints(cols - 3, rows - 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (gTree != null) {
            this.add((Component)gTree, new GridBagConstraints(cols - 4, rows - 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)exp, new GridBagConstraints(cols - 3, rows - 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected IViewer createExperimentViewer(Experiment experiment, int[] features, HCLTreeData genes_result, HCLTreeData samples_result) {
        ExperimentViewer viewer;
        int[][] clusters = this.createClusters(experiment, features, genes_result);
        int[] samples = this.getLeafOrder(samples_result, null);
        if (genes_result != null) {
            this.offset = 0;
            viewer = new ExperimentViewer(experiment, clusters, samples, true, this.offset);
        } else {
            this.offset = 10;
            viewer = new ExperimentViewer(experiment, clusters, samples, true, this.offset);
        }
        viewer.setEnableMoveable(false);
        return viewer;
    }

    protected int[] createDefaultFeatures(Experiment experiment) {
        int[] features = new int[experiment.getNumberOfGenes()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = i;
        }
        return features;
    }

    private int[][] createClusters(Experiment experiment, int[] features, HCLTreeData genes_result) {
        int[][] clusters = new int[1][features.length];
        clusters[0] = this.createGenesOrder(experiment, features, genes_result);
        return clusters;
    }

    protected int[] createSamplesOrder(HCLTreeData samples_result) {
        return this.createSamplesOrder(samples_result, null);
    }

    protected int[] createSamplesOrder(HCLTreeData samples_result, int[] indices) {
        return this.getLeafOrder(samples_result, indices);
    }

    protected int[] createGenesOrder(Experiment experiment, int[] features, HCLTreeData genes_result) {
        int[] order = this.getLeafOrder(genes_result, features);
        if (order == null) {
            order = features;
        }
        return order;
    }

    private int[] getLeafOrder(HCLTreeData result, int[] indices) {
        if (result == null || result.node_order == null || result.node_order.length < 2) {
            return null;
        }
        return this.getLeafOrder(result.node_order, result.child_1_array, result.child_2_array, indices);
    }

    private int[] getLeafOrder(int[] nodeOrder, int[] child1, int[] child2, int[] indices) {
        int[] leafOrder = new int[nodeOrder.length];
        Arrays.fill(leafOrder, -1);
        this.fillLeafOrder(leafOrder, child1, child2, 0, child1.length - 2, indices);
        return leafOrder;
    }

    private int fillLeafOrder(int[] leafOrder, int[] child1, int[] child2, int pos, int index, int[] indices) {
        if (child1[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child1[index], indices);
        }
        if (child2[index] != -1) {
            pos = this.fillLeafOrder(leafOrder, child1, child2, pos, child2[index], indices);
        } else {
            leafOrder[pos] = indices == null ? index : indices[index];
            ++pos;
        }
        return pos;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        this.expViewer.onSelected(framework);
        Object userObject = framework.getUserObject();
        int n = this.clusterIndex = userObject != null ? (Integer)userObject : 0;
        if (this.genesTree != null) {
            this.genesTree.onSelected(framework);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onSelected(framework);
        }
        this.annotationBar.onSelected(framework);
        this.colorBar.onSelected(framework);
        if (this.genesTree != null) {
            this.header.setHeaderPosition(this.genesTree.getWidth());
        }
        this.elementSize = framework.getDisplayMenu().getElementSize();
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        if (this.node == null) {
            this.node = (DefaultMutableTreeNode)framework.getCurrentNode().getParent();
        }
        this.verifyClusterExistence(this.data);
        this.updateTrees();
        this.refreshViewer();
        this.revalidateViewer();
    }

    protected int getCommonWidth() {
        int width = 0;
        if (this.genesTree != null) {
            width += this.genesTree.getWidth();
        }
        width = this.isExperimentCluster ? (width += ((ExperimentClusterViewer)this.expViewer).getWidth()) : (width += ((ExperimentViewer)this.expViewer).getWidth());
        width += this.colorBar.getWidth();
        return (width += this.annotationBar.getWidth()) + this.offset;
    }

    public void onDataChanged(IData data) {
        this.expViewer.onDataChanged(data);
        this.data = data;
        this.updateTrees();
        this.revalidateViewer();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.expViewer.onMenuChanged(menu);
        if (this.genesTree != null) {
            this.genesTree.onMenuChanged(menu);
        }
        if (this.sampleTree != null) {
            this.sampleTree.onMenuChanged(menu);
        }
        this.annotationBar.onMenuChanged(menu);
        this.colorBar.onMenuChanged(menu);
        this.elementSize = menu.getElementSize();
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.revalidateViewer();
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public BufferedImage getImage() {
        return null;
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, Listener listener) {
        JMenuItem menuItem = new JMenuItem("Store Cluster", GUIFactory.getIcon("new16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(STORE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Launch new session", GUIFactory.getIcon("launch_new_mav.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(LAUNCH_NEW_SESSION_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save cluster...", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(SAVE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete cluster", GUIFactory.getIcon("delete16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(DELETE_CLUSTER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Delete all clusters", GUIFactory.getIcon("delete16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(DELETE_ALL_CLUSTERS_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("GeneTree properties...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(this.genesTree != null);
        menuItem.setActionCommand(GENE_TREE_PROPERTIES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("SampleTree properties...", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(this.sampleTree != null);
        menuItem.setActionCommand(SAMPLE_TREE_PROPERTIES_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Rotate Selected Node", GUIFactory.getIcon("edit16.gif"));
        menuItem.setEnabled(false);
        menuItem.setActionCommand(ROTATE_NODE_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Save Gene Node Heights", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(this.genesTree != null);
        menuItem.setActionCommand(SAVE_GENE_HEIGHT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Gene Order", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(this.genesTree != null);
        menuItem.setActionCommand(SAVE_GENE_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Sample Node Heights", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(this.sampleTree != null);
        menuItem.setActionCommand(SAVE_EXP_HEIGHT_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Save Sample Order", GUIFactory.getIcon("save_as16.gif"));
        menuItem.setEnabled(this.sampleTree != null);
        menuItem.setActionCommand(SAVE_EXP_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        if (this.genesTree != null) {
            menuItem = new JMenuItem("Save Gene Tree To Newick File", GUIFactory.getIcon("save_as16.gif"));
            menuItem.setActionCommand(SAVE_GENE_NEWICK_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        if (this.sampleTree != null) {
            menuItem = new JMenuItem("Save Sample Tree to Newick File", GUIFactory.getIcon("save_as16.gif"));
            menuItem.setActionCommand(SAVE_SAMPLE_NEWICK_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        menu.addSeparator();
        if (this.sampleTree != null) {
            menuItem = new JMenuItem("Save Sample Tree to Nexus File", GUIFactory.getIcon("save_as16.gif"));
            menuItem.setActionCommand(SAVE_SAMPLE_NEXUS_CMD);
            menuItem.addActionListener(listener);
            menu.add(menuItem);
        }
        menuItem = new JMenuItem("Broadcast Matrix to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand("broadcast-matrix-to-gaggle");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Broadcast Gene List to Gaggle", GUIFactory.getIcon("gaggle_icon_16.gif"));
        menuItem.setActionCommand("broadcast-namelist-to-gaggle");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
    }

    public void broadcastClusterGaggle() {
        if (this.selectedCluster != null) {
            int[] cols;
            int[] rows;
            if (this.selectedCluster.isGeneCluster) {
                rows = this.getSubTreeElements();
                cols = this.getExperiment().getColumnIndicesCopy();
            } else {
                rows = this.getExperiment().getRows();
                cols = this.getSubTreeElements();
            }
            this.framework.broadcastGeneCluster(this.getExperiment(), rows, cols);
        } else {
            this.framework.broadcastGeneCluster(this.getExperiment(), this.getExperiment().getRows(), null);
        }
    }

    public void broadcastNamelistGaggle() {
        if (this.selectedCluster != null) {
            int[] rows = this.selectedCluster.isGeneCluster ? this.getSubTreeElements() : this.getExperiment().getRows();
            this.framework.broadcastNamelist(this.getExperiment(), rows);
        } else {
            this.framework.broadcastNamelist(this.getExperiment(), this.getExperiment().getRows());
        }
    }

    protected JMenuItem getJMenuItem(String command) {
        Component[] components = this.popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JMenuItem) || !((JMenuItem)components[i]).getActionCommand().equals(command)) continue;
            return (JMenuItem)components[i];
        }
        return null;
    }

    protected void setEnableMenuItem(String command, boolean enable) {
        JMenuItem item = this.getJMenuItem(command);
        if (item == null) {
            return;
        }
        item.setEnabled(enable);
    }

    protected void setSelectedCluster(HCLCluster cluster) {
        this.selectedCluster = cluster;
        if (this.isExperimentCluster) {
            if (cluster.isGeneCluster) {
                ((ExperimentClusterViewer)this.expViewer).selectRows(cluster.firstElem, cluster.lastElem);
            } else {
                ((ExperimentClusterViewer)this.expViewer).selectColumns(cluster.firstElem, cluster.lastElem);
            }
        } else if (cluster.isGeneCluster) {
            ((ExperimentViewer)this.expViewer).selectRows(cluster.firstElem, cluster.lastElem);
        } else {
            ((ExperimentViewer)this.expViewer).selectColumns(cluster.firstElem, cluster.lastElem);
        }
    }

    protected HCLCluster getCluster(HCLCluster selCluster) {
        int root = selCluster.root;
        if (selCluster.isGeneCluster) {
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster cluster = this.clusters.get(i);
                if (cluster.root != root) continue;
                return cluster;
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster cluster = this.experimentClusters.get(i);
                if (cluster.root != root) continue;
                return cluster;
            }
        }
        return null;
    }

    public void updateTrees() {
        if (this.genesTree != null && this.data.getColors().length == 0) {
            this.genesTree.deselectAllNodes();
            this.genesTree.resetNodeColors();
            this.clusters.clear();
        }
        if (this.sampleTree != null && this.data.getExperimentColors().length == 0) {
            this.sampleTree.deselectAllNodes();
            this.sampleTree.resetNodeColors();
            this.experimentClusters.clear();
        }
    }

    protected HCLCluster getExperimentCluster(int root) {
        for (int i = 0; i < this.experimentClusters.size(); ++i) {
            HCLCluster cluster = this.experimentClusters.get(i);
            if (cluster.root != root) continue;
            return cluster;
        }
        return null;
    }

    protected void removeCluster(HCLCluster oldCluster) {
        if (oldCluster.isGeneCluster) {
            int i = this.clusters.size();
            while (--i >= 0) {
                HCLCluster cluster = this.clusters.get(i);
                if (cluster.root != oldCluster.root) continue;
                this.clusters.remove(i);
                return;
            }
        } else {
            int i = this.experimentClusters.size();
            while (--i >= 0) {
                HCLCluster cluster = this.experimentClusters.get(i);
                if (cluster.root != oldCluster.root) continue;
                this.experimentClusters.remove(i);
                return;
            }
        }
    }

    protected boolean doesClusterExist() {
        if (this.selectedCluster == null) {
            return false;
        }
        return this.getCluster(this.selectedCluster) != null;
    }

    protected int getClustersCount() {
        return this.clusters.size() + this.experimentClusters.size();
    }

    private Frame getFrame() {
        return JOptionPane.getFrameForComponent(this);
    }

    public void onSetCluster() {
        Color newColor = Color.white;
        if (newColor == null || this.selectedCluster == null) {
            return;
        }
        HCLCluster cluster = this.getCluster(this.selectedCluster);
        if (cluster != null) {
            this.selectedCluster = cluster;
        } else if (this.selectedCluster.isGeneCluster) {
            this.clusters.add(this.selectedCluster);
        } else {
            this.experimentClusters.add(this.selectedCluster);
        }
        this.selectedCluster.color = newColor;
        this.selectedCluster.color = !this.isExperimentCluster ? (!this.selectedCluster.isGeneCluster ? ((ExperimentViewer)this.expViewer).setHCLClusterColor(this.getSubTreeElements(), this.selectedCluster.color, this.selectedCluster.isGeneCluster) : ((ExperimentViewer)this.expViewer).setHCLClusterColor(this.getArrayMappedToData(this.getSubTreeElements()), this.selectedCluster.color, this.selectedCluster.isGeneCluster)) : (!this.selectedCluster.isGeneCluster ? ((ExperimentClusterViewer)this.expViewer).setHCLClusterColor(this.getSubTreeElements(), this.selectedCluster.color, this.selectedCluster.isGeneCluster) : ((ExperimentClusterViewer)this.expViewer).setHCLClusterColor(this.getArrayMappedToData(this.getSubTreeElements()), this.selectedCluster.color, this.selectedCluster.isGeneCluster));
        this.removeSubTreeClusters(this.selectedCluster);
        if (this.selectedCluster.isGeneCluster) {
            this.colorBar.onClustersChanged(this.clusters);
        }
        this.refreshViewer();
        this.onDataChanged(this.data);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.revalidateViewer();
    }

    private void removeSubTreeClusters(HCLCluster parent) {
        if (parent.isGeneCluster) {
            for (int i = this.clusters.size() - 1; i >= 0; --i) {
                HCLCluster cluster = this.clusters.get(i);
                if (parent.equals(cluster) || !this.isSubTree(parent, cluster)) continue;
                this.removeCluster(cluster);
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster cluster = this.experimentClusters.get(i);
                if (parent == cluster || !this.isSubTree(parent, cluster)) continue;
                this.removeCluster(cluster);
            }
        }
    }

    private boolean isSubTree(HCLCluster parent, HCLCluster child) {
        if (parent.size < child.size) {
            return false;
        }
        return child.firstElem >= parent.firstElem && child.firstElem < parent.lastElem;
    }

    public void onSetClusterText() {
        HCLCluster cluster = this.getCluster(this.selectedCluster);
        if (cluster == null) {
            JOptionPane.showMessageDialog(this.getFrame(), "Not a cluster!", "Error", 0);
        } else {
            String text = JOptionPane.showInputDialog(this.getFrame(), (Object)"Cluster text");
            if (text != null && text.length() > 0) {
                cluster.text = text;
                this.colorBar.onClustersChanged(this.clusters);
                this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
                this.revalidateViewer();
            }
        }
    }

    public void verifyClusterExistence(IData data) {
        int i;
        HCLCluster currCluster;
        int i2;
        boolean[] clusterGone = new boolean[this.clusters.size()];
        boolean[] expClusterGone = new boolean[this.experimentClusters.size()];
        for (i2 = 0; i2 < this.clusters.size(); ++i2) {
            int geneIndex;
            currCluster = this.clusters.get(i2);
            if (currCluster.firstElem == currCluster.lastElem || data.getProbeColor(geneIndex = this.experiment.getGeneIndexMappedToData(this.genesOrder[currCluster.firstElem])) == currCluster.color) continue;
            clusterGone[i2] = true;
        }
        for (i2 = clusterGone.length - 1; i2 >= 0; --i2) {
            if (!clusterGone[i2]) continue;
            this.genesTree.setNodeColor(this.clusters.get((int)i2).root, null);
        }
        for (i = 0; i < this.experimentClusters.size(); ++i) {
            int expIndex;
            currCluster = this.experimentClusters.get(i);
            if (currCluster.firstElem == currCluster.lastElem || data.getExperimentColor(expIndex = this.isExperimentCluster ? this.experiment.getSampleIndex(this.sampleClusters[this.clusterIndex][currCluster.firstElem]) : this.experiment.getSampleIndex(this.samplesOrder[currCluster.firstElem])) == currCluster.color) continue;
            expClusterGone[i] = true;
        }
        for (i = expClusterGone.length - 1; i >= 0; --i) {
            if (!expClusterGone[i]) continue;
            this.sampleTree.setNodeColor(this.experimentClusters.get((int)i).root, null);
        }
    }

    private int[] getSubTreeElements() {
        return this.getSubTreeElements(this.selectedCluster);
    }

    private int[] getSubTreeElements(HCLCluster cluster) {
        int size = cluster.lastElem - cluster.firstElem + 1;
        int[] elements = new int[size];
        if (cluster.isGeneCluster) {
            for (int i = 0; i < size; ++i) {
                elements[i] = this.genesOrder[cluster.firstElem + i];
            }
        } else if (!this.isExperimentCluster) {
            for (int i = 0; i < size; ++i) {
                elements[i] = this.samplesOrder[cluster.firstElem + i];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                elements[i] = this.sampleClusters[this.clusterIndex][cluster.firstElem + i];
            }
        }
        return elements;
    }

    public void saveGenesOrder() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.genesOrder);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save data!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void saveExperimentOrder() {
        try {
            if (!this.isExperimentCluster) {
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.samplesOrder);
            } else {
                int[] elements = new int[this.sampleClusters[this.clusterIndex].length];
                for (int i = 0; i < this.sampleClusters[this.clusterIndex].length; ++i) {
                    elements[i] = this.sampleClusters[this.clusterIndex][i];
                }
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])elements);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save data!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void onSaveCluster() {
        if (this.selectedCluster == null) {
            return;
        }
        try {
            if (this.selectedCluster.isGeneCluster) {
                ExperimentUtil.saveExperiment((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.getSubTreeElements());
            } else {
                ExperimentUtil.saveExperimentCluster((Frame)this.getFrame(), (Experiment)this.experiment, (IData)this.data, (int[])this.getSubTreeElements());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Can not save cluster!", e.toString(), 0);
            e.printStackTrace();
        }
    }

    public void onDeleteCluster() {
        this.removeCluster(this.selectedCluster);
        this.colorBar.onClustersChanged(this.clusters);
        if (this.selectedCluster.isGeneCluster) {
            this.genesTree.setNodeColor(this.selectedCluster.root, null);
            this.data.setProbesColor(this.getArrayMappedToData(this.getSubTreeElements()), null);
            this.framework.removeSubCluster(this.getArrayMappedToData(this.getSubTreeElements()), this.experiment, 0);
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster cluster = this.clusters.get(i);
                this.data.setProbesColor(this.getArrayMappedToData(this.getSubTreeElements(cluster)), cluster.color);
                this.genesTree.setNodeColor(cluster.root, cluster.color);
            }
        } else {
            this.sampleTree.setNodeColor(this.selectedCluster.root, null);
            this.data.setExperimentColor(this.getSubTreeElements(), null);
            this.framework.removeSubCluster(this.getSubTreeElements(), this.experiment, 1);
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster cluster = this.experimentClusters.get(i);
                this.data.setExperimentColor(this.getSubTreeElements(cluster), cluster.color);
                this.sampleTree.setNodeColor(cluster.root, cluster.color);
            }
        }
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.onDataChanged(this.data);
        this.refreshViewer();
        this.revalidateViewer();
    }

    private void refreshViewer() {
        if (this.selectedCluster == null) {
            return;
        }
        if (this.selectedCluster.isGeneCluster) {
            for (int i = 0; i < this.clusters.size(); ++i) {
                HCLCluster cluster = this.clusters.get(i);
                this.genesTree.setNodeColor(cluster.root, cluster.color);
                this.genesTree.deselectAllNodes();
            }
        } else {
            for (int i = 0; i < this.experimentClusters.size(); ++i) {
                HCLCluster cluster = this.experimentClusters.get(i);
                this.sampleTree.setNodeColor(cluster.root, cluster.color);
                this.sampleTree.deselectAllNodes();
            }
        }
        if (this.isExperimentCluster) {
            ((ExperimentClusterViewer)this.expViewer).selectRows(-1, -1);
            ((ExperimentClusterViewer)this.expViewer).selectColumns(-1, -1);
        } else {
            ((ExperimentViewer)this.expViewer).selectRows(-1, -1);
            ((ExperimentViewer)this.expViewer).selectColumns(-1, -1);
        }
    }

    private int[] getArrayMappedToData(int[] clusterIndices) {
        if (clusterIndices == null || clusterIndices.length < 1) {
            return clusterIndices;
        }
        int[] dataIndices = new int[clusterIndices.length];
        for (int i = 0; i < clusterIndices.length; ++i) {
            dataIndices[i] = this.experiment.getGeneIndexMappedToData(clusterIndices[i]);
        }
        return dataIndices;
    }

    private void createAndAddClusterViews(HCLTree tree) {
        int k = tree.getNumberOfTerminalNodes();
        DefaultMutableTreeNode newNode = tree == this.genesTree ? new DefaultMutableTreeNode("Gene Tree Cut: " + String.valueOf(k) + " Clusters") : new DefaultMutableTreeNode("Sample Tree Cut: " + String.valueOf(k) + " Clusters");
        int[][] clusters = tree.getClusterRowIndices();
        if (tree == this.genesTree) {
            for (int i = 0; i < clusters.length; ++i) {
                for (int j = 0; j < clusters[i].length; ++j) {
                    clusters[i][j] = this.genesOrder[clusters[i][j]];
                }
            }
        } else {
            for (int i = 0; i < clusters.length; ++i) {
                for (int j = 0; j < clusters[i].length; ++j) {
                    clusters[i][j] = this.samplesOrder[clusters[i][j]];
                }
            }
        }
        this.addExpressionImages(newNode, clusters, tree == this.genesTree);
        this.addCentroidViews(newNode, clusters, tree == this.genesTree);
        this.addClusterTableViews(newNode, clusters, tree == this.genesTree);
        this.addClusterInfo(newNode, clusters, tree == this.genesTree, tree.getZeroThreshold());
        this.addGeneralInfo(newNode, tree.getZeroThreshold(), k, tree == this.genesTree);
        this.framework.addNode(this.node, newNode);
    }

    private void addClusterTableViews(DefaultMutableTreeNode node, int[][] clusters, boolean geneClusters) {
        DefaultMutableTreeNode tabNode = new DefaultMutableTreeNode("Table Views");
        Object tabViewer = geneClusters ? new ClusterTableViewer(this.experiment, clusters, this.data) : new ExperimentClusterTableViewer(this.experiment, clusters, this.data);
        for (int i = 0; i < clusters.length; ++i) {
            tabNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        node.add(tabNode);
    }

    private void addExpressionImages(DefaultMutableTreeNode node, int[][] clusters, boolean geneClusters) {
        DefaultMutableTreeNode expNode = new DefaultMutableTreeNode("Expression Images");
        Object expViewer = geneClusters ? new HCLExperimentViewer(this.experiment, clusters) : new HCLExperimentClusterViewer(this.experiment, clusters);
        for (int i = 0; i < clusters.length; ++i) {
            expNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expViewer, (Object)new Integer(i))));
        }
        node.add(expNode);
    }

    private void addCentroidViews(DefaultMutableTreeNode root, int[][] clusters, boolean clusterGenes) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode("Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode("Expression Graphs");
        FloatMatrix data = this.experiment.getMatrix();
        if (!clusterGenes) {
            data = data.transpose();
        }
        FloatMatrix means = this.getMeans(data, clusters);
        FloatMatrix variances = this.getVariances(data, means, clusters);
        if (clusterGenes) {
            HCLCentroidViewer centroidViewer = new HCLCentroidViewer(this.experiment, clusters);
            centroidViewer.setMeans(means.A);
            centroidViewer.setVariances(variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            HCLCentroidsViewer centroidsViewer = new HCLCentroidsViewer(this.experiment, clusters);
            centroidsViewer.setMeans(means.A);
            centroidsViewer.setVariances(variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)centroidsViewer, (Object)new Integer(1))));
        } else {
            HCLExperimentCentroidViewer expCentroidViewer = new HCLExperimentCentroidViewer(this.experiment, clusters);
            expCentroidViewer.setMeans(means.A);
            expCentroidViewer.setVariances(variances.A);
            for (int i = 0; i < clusters.length; ++i) {
                centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 0))));
                expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("Cluster " + String.valueOf(i + 1), (IViewer)expCentroidViewer, (Object)new CentroidUserObject(i, 1))));
            }
            HCLExperimentCentroidsViewer expCentroidsViewer = new HCLExperimentCentroidsViewer(this.experiment, clusters);
            expCentroidsViewer.setMeans(means.A);
            expCentroidsViewer.setVariances(variances.A);
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo("All Clusters", (IViewer)expCentroidsViewer, (Object)new Integer(1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    private FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    private float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    private float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }

    private void addClusterInfo(DefaultMutableTreeNode root, int[][] clusters, boolean clusterGenes, float zThr) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Cluster Information");
        if (clusterGenes) {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Genes in Clusters (#,%)", (IViewer)new HCLClusterInfoViewer(clusters, this.experiment.getNumberOfGenes(), zThr))));
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Sammples in Clusters (#,%)", (IViewer)new HCLClusterInfoViewer(clusters, this.experiment.getNumberOfSamples(), false, zThr))));
        }
        root.add(node);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, float zThr, int k, boolean isGeneTree) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Info");
        node.add(new DefaultMutableTreeNode("Cluster Type: " + (isGeneTree ? "Gene Clusters" : "Sample Clusters")));
        node.add(new DefaultMutableTreeNode("Distance Threshold: " + String.valueOf(zThr)));
        node.add(new DefaultMutableTreeNode("Number of Clusters: " + String.valueOf(k)));
        root.add(node);
    }

    public void onDeleteAllClusters() {
        this.refreshViewer();
        this.clusters.clear();
        this.experimentClusters.clear();
        this.colorBar.onClustersChanged(this.clusters);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        if (this.genesTree != null) {
            this.genesTree.resetNodeColors();
        }
        if (this.sampleTree != null) {
            this.sampleTree.resetNodeColors();
        }
        this.data.deleteColors();
        this.data.deleteExperimentColors();
        this.onDataChanged(this.data);
        this.revalidateViewer();
        this.repaint();
    }

    public void onGeneTreeProperties() {
        this.setTreeProperties(this.genesTree);
        this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
        this.header.setHeaderPosition(this.genesTree.getWidth());
        this.revalidateViewer();
    }

    public void onSampleTreeProperties() {
        this.setTreeProperties(this.sampleTree);
        this.revalidateViewer();
    }

    public void onRotateNode() {
        if (this.selectedCluster.isGeneCluster) {
            int i = this.genesTree.treeData.child_1_array[this.selectedCluster.getRoot()];
            this.genesTree.treeData.child_1_array[this.selectedCluster.getRoot()] = this.genesTree.treeData.child_2_array[this.selectedCluster.getRoot()];
            this.genesTree.treeData.child_2_array[this.selectedCluster.getRoot()] = i;
            this.genes_result = this.genesTree.treeData;
            this.genesTree.refreshPositions();
        } else {
            int i = this.sampleTree.treeData.child_1_array[this.selectedCluster.getRoot()];
            this.sampleTree.treeData.child_1_array[this.selectedCluster.getRoot()] = this.sampleTree.treeData.child_2_array[this.selectedCluster.getRoot()];
            this.sampleTree.treeData.child_2_array[this.selectedCluster.getRoot()] = i;
            this.samples_result = this.sampleTree.treeData;
            this.sampleTree.refreshPositions();
        }
        if (this.genesTree != null && this.experiment.getNumberOfGenes() > 1 && this.genesTree.treeData.node_order.length > 1) {
            this.genesOrder = this.createGenesOrder(this.experiment, this.features, this.genesTree.treeData);
            ((ExperimentViewer)this.expViewer).setGenesOrder(this.genesOrder);
        }
        if (this.sampleTree != null && this.experiment.getNumberOfSamples() > 1 && this.sampleTree.treeData.node_order.length > 1) {
            this.samplesOrder = this.createSamplesOrder(this.sampleTree.treeData);
            ((ExperimentHeader)((ExperimentViewer)this.expViewer).getHeaderComponent()).setSamplesOrder(this.samplesOrder);
            ((ExperimentViewer)this.expViewer).setSamplesOrder(this.samplesOrder);
        }
        this.expViewer.onDataChanged(this.data);
        this.onSelected(this.framework);
    }

    private void setTreeProperties(HCLTree tree) {
        Frame frame = JOptionPane.getFrameForComponent(this);
        HCLConfigDialog dialog = new HCLConfigDialog(frame, this, tree.getZeroThreshold(), tree.getMinDistance(), tree.getMaxDistance(), tree.getMinNodeDistance(), tree.getMaxNodeDistance(), tree);
        dialog.setTree(tree);
        if (dialog.showModal() == 0) {
            tree.setProperties(dialog.getZeroThreshold(), dialog.getMinDistance(), dialog.getMaxDistance());
            if (dialog.isCreateClusterViews()) {
                this.createAndAddClusterViews(tree);
            }
        }
    }

    public void valueChanged(HCLTree source, HCLCluster cluster) {
        this.setSelectedCluster(cluster);
    }

    public void revalidateViewer() {
        if (this.genesTree != null) {
            this.header.updateSize(this.getCommonWidth(), this.elementSize.width);
            this.header.setHeaderPosition(this.genesTree.getWidth());
        } else {
            this.header.setHeaderPosition(0);
        }
        this.revalidate();
    }

    public void launchNewSession() {
        if (this.selectedCluster == null) {
            return;
        }
        if (this.selectedCluster.isGeneCluster) {
            this.framework.launchNewMAV(this.getArrayMappedToData(this.getSubTreeElements()), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 0);
        } else {
            this.framework.launchNewMAV(this.getSubTreeElements(), this.experiment, "Multiple Experiment Viewer - Cluster Viewer", 1);
        }
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        int[][] leafClusters = new int[][]{(int[])(this.genesTree != null ? this.genesOrder : null), (int[])(this.sampleTree != null ? this.samplesOrder : null)};
        return leafClusters;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public int getViewerType() {
        return -1;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    HCLTreeListener,
    Serializable {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(HCLViewer.STORE_CLUSTER_CMD)) {
                HCLViewer.this.onSetCluster();
            } else if (command.equals(HCLViewer.LAUNCH_NEW_SESSION_CMD)) {
                HCLViewer.this.launchNewSession();
            }
            if (command.equals(HCLViewer.SAVE_CLUSTER_CMD)) {
                HCLViewer.this.onSaveCluster();
            } else if (command.equals(HCLViewer.DELETE_CLUSTER_CMD)) {
                HCLViewer.this.onDeleteCluster();
            } else if (command.equals(HCLViewer.DELETE_ALL_CLUSTERS_CMD)) {
                HCLViewer.this.onDeleteAllClusters();
            } else if (command.equals(HCLViewer.GENE_TREE_PROPERTIES_CMD)) {
                HCLViewer.this.onGeneTreeProperties();
            } else if (command.equals(HCLViewer.SAMPLE_TREE_PROPERTIES_CMD)) {
                HCLViewer.this.onSampleTreeProperties();
            } else if (command.equals(HCLViewer.ROTATE_NODE_CMD)) {
                HCLViewer.this.onRotateNode();
            } else if (command.equals(HCLViewer.SAVE_GENE_ORDER_CMD)) {
                HCLViewer.this.saveGenesOrder();
            } else if (command.equals(HCLViewer.SAVE_GENE_HEIGHT_CMD)) {
                HCLViewer.this.genesTree.saveGeneNodeHeights();
            } else if (command.equals(HCLViewer.SAVE_EXP_ORDER_CMD)) {
                HCLViewer.this.saveExperimentOrder();
            } else if (command.equals(HCLViewer.SAVE_EXP_HEIGHT_CMD)) {
                HCLViewer.this.sampleTree.saveExperimentNodeHeights();
            } else if (command.equals(HCLViewer.SAVE_GENE_NEWICK_CMD)) {
                HCLViewer.this.genesTree.saveAsNewickFile();
            } else if (command.equals(HCLViewer.SAVE_SAMPLE_NEWICK_CMD)) {
                HCLViewer.this.sampleTree.saveAsNewickFile();
            } else if (command.equals(HCLViewer.SAVE_GENE_NEXUS_CMD)) {
                HCLViewer.this.genesTree.saveAsNexusFile();
            } else if (command.equals(HCLViewer.SAVE_SAMPLE_NEXUS_CMD)) {
                HCLViewer.this.sampleTree.saveAsNexusFile();
            } else if (command.equals("broadcast-matrix-to-gaggle")) {
                HCLViewer.this.broadcastClusterGaggle();
            } else if (command.equals("broadcast-namelist-to-gaggle")) {
                HCLViewer.this.broadcastNamelistGaggle();
            }
        }

        @Override
        public void valueChanged(HCLTree source, HCLCluster cluster) {
            if (source == HCLViewer.this.sampleTree) {
                cluster.isGeneCluster = false;
            }
            HCLViewer.this.valueChanged(source, cluster);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.deselect(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            int node = HCLViewer.this.selectedCluster == null ? -1 : HCLViewer.this.selectedCluster.root;
            HCLViewer.this.setEnableMenuItem(HCLViewer.STORE_CLUSTER_CMD, node >= 0);
            HCLViewer.this.setEnableMenuItem(HCLViewer.LAUNCH_NEW_SESSION_CMD, node >= 0);
            HCLViewer.this.setEnableMenuItem(HCLViewer.ROTATE_NODE_CMD, node >= 0);
            HCLViewer.this.setEnableMenuItem(HCLViewer.DELETE_CLUSTER_CMD, HCLViewer.this.doesClusterExist());
            HCLViewer.this.setEnableMenuItem(HCLViewer.DELETE_ALL_CLUSTERS_CMD, HCLViewer.this.doesClusterExist());
            HCLViewer.this.setEnableMenuItem(HCLViewer.SAVE_CLUSTER_CMD, HCLViewer.this.selectedCluster != null && HCLViewer.this.selectedCluster.root != -1);
            HCLViewer.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        private void deselect(MouseEvent e) {
            HCLViewer.this.selectedCluster = null;
            Object source = e.getSource();
            if (source instanceof HCLTree) {
                if (source == HCLViewer.this.genesTree) {
                    if (HCLViewer.this.isExperimentCluster) {
                        ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
                    } else {
                        ((ExperimentViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
                    }
                    if (HCLViewer.this.sampleTree != null) {
                        HCLViewer.this.sampleTree.deselectAllNodes();
                    }
                } else {
                    if (HCLViewer.this.isExperimentCluster) {
                        ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                    } else {
                        ((ExperimentViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                    }
                    if (HCLViewer.this.genesTree != null) {
                        HCLViewer.this.genesTree.deselectAllNodes();
                    }
                }
                HCLViewer.this.repaint();
                return;
            }
            int x = e.getX();
            int y = e.getY();
            if (!(source instanceof HCLViewer) && source != HCLViewer.this.expViewer) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            } else if (source instanceof HCLViewer && HCLViewer.this.sampleTree != null && y < HCLViewer.this.sampleTree.getHeight()) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            } else if (source == HCLViewer.this.expViewer) {
                int numSamples = HCLViewer.this.numberOfSamples;
                if (source instanceof ExperimentClusterViewer) {
                    numSamples = ((ExperimentClusterViewer)HCLViewer.this.expViewer).getCurrentNumberOfExperiments();
                }
                if (x > HCLViewer.this.elementSize.width * numSamples + HCLViewer.this.offset || x < HCLViewer.this.offset) {
                    this.deselectAllNodes();
                    HCLViewer.this.repaint();
                }
            } else if ((source == HCLViewer.this.expViewer || source instanceof ExperimentClusterViewer) && x < HCLViewer.this.offset) {
                this.deselectAllNodes();
                HCLViewer.this.repaint();
            }
        }

        private void deselectAllNodes() {
            if (HCLViewer.this.genesTree != null) {
                HCLViewer.this.genesTree.deselectAllNodes();
            }
            if (HCLViewer.this.sampleTree != null) {
                HCLViewer.this.sampleTree.deselectAllNodes();
            }
            if (HCLViewer.this.isExperimentCluster) {
                ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                ((ExperimentClusterViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
            } else {
                ((ExperimentViewer)HCLViewer.this.expViewer).selectRows(-1, -1);
                ((ExperimentViewer)HCLViewer.this.expViewer).selectColumns(-1, -1);
            }
        }
    }
}

