/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeListener;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.NewickFileOutputDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.NexusFileOutputDialog;

public class HCLTree
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected HCLTreeListener treeListener;
    protected int orientation = 0;
    protected int min_pixels = 2;
    protected int max_pixels = 100;
    protected float zero_threshold = 0.05f;
    protected Color lineColor = new Color(0, 0, 128);
    protected Color belowThrColor = Color.lightGray;
    protected Color selectedLineColor = Color.magenta;
    protected boolean actualArms = false;
    protected boolean useAbsoluteHeight = true;
    public boolean showScale = true;
    protected IData data;
    protected HCLTreeData treeData;
    protected float minHeight;
    protected int stepSize;
    protected int[] pHeights;
    int[] nodeRaised;
    protected float[] positions;
    protected boolean[] selected;
    protected Color[] nodesColors;
    protected final int xOrigin = 10;
    protected int[] parentNodes;
    protected boolean[] terminalNodes;
    protected float maxHeight;
    protected boolean flatTree = false;
    protected int horizontalOffset = 0;
    protected IFramework framework;
    private int function;
    private float similarityFactor = 1.0f;
    private float nodeHeightOffset = 0.0f;

    public HCLTree(HCLTreeData treeData, int orientation) {
        this.setBackground(Color.white);
        this.treeData = treeData;
        this.function = treeData.getFunction();
        this.orientation = orientation;
        this.flatTree = this.flatTreeCheck(treeData.height);
        this.minHeight = this.getMinHeight(treeData.node_order, treeData.height);
        this.maxHeight = this.getMaxHeight(treeData.node_order, treeData.height);
        this.setNodeHeightOffset();
        if (this.function != 12) {
            for (int i = 0; i < treeData.height.length; ++i) {
                treeData.height[i] = treeData.height[i] + this.nodeHeightOffset;
            }
        }
        this.minHeight = this.getMinHeight(treeData.node_order, treeData.height);
        this.maxHeight = this.getMaxHeight(treeData.node_order, treeData.height);
        this.zero_threshold = this.minHeight;
        this.terminalNodes = new boolean[this.treeData.height.length];
        this.initializeParentNodeArray();
        this.pHeights = this.getPixelHeights(treeData.node_order, treeData.height);
        this.positions = this.getPositions(treeData.node_order, treeData.child_1_array, treeData.child_2_array);
        this.selected = new boolean[treeData.node_order.length * 2];
        this.nodesColors = new Color[treeData.node_order.length * 2];
        this.deselect(this.selected);
        if (treeData.node_order.length >= 1 && !this.flatTree) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[treeData.node_order[treeData.node_order.length - 2]] + 10, 0);
                    break;
                }
                case 1: {
                    this.setSizes(0, this.pHeights[treeData.node_order[treeData.node_order.length - 2]]);
                }
            }
        } else {
            this.setSizes(0, 0);
        }
        this.addMouseListener(new Listener());
    }

    private void setNodeHeightOffset() {
        switch (this.function) {
            case 1: {
                this.nodeHeightOffset = 1.0f;
                this.similarityFactor = -1.0f;
                break;
            }
            case 2: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
                break;
            }
            case 3: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
                break;
            }
            case 4: {
                this.nodeHeightOffset = 0.0f;
                this.similarityFactor = 1.0f;
                break;
            }
            case 5: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
                break;
            }
            case 6: {
                this.nodeHeightOffset = 1.0f;
                this.similarityFactor = -1.0f;
                break;
            }
            case 7: {
                this.nodeHeightOffset = 1.0f;
                this.similarityFactor = -1.0f;
                break;
            }
            case 8: {
                this.nodeHeightOffset = 0.0f;
                this.similarityFactor = 1.0f;
                break;
            }
            case 9: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
                break;
            }
            case 10: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
                break;
            }
            case 11: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = 1.0f;
                break;
            }
            case 12: {
                this.nodeHeightOffset = 1.0f;
                this.similarityFactor = -1.0f;
                break;
            }
            default: {
                this.nodeHeightOffset = -this.minHeight;
                this.similarityFactor = -1.0f;
            }
        }
    }

    public HCLTree(HCLTreeData treeData, Integer orientation) {
        this(treeData, (int)orientation);
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new HCLTreePersistenceDelegate();
    }

    public void setAbsoluteHeight(boolean abhght) {
        this.useAbsoluteHeight = abhght;
    }

    public void setListener(HCLTreeListener treeListener) {
        this.treeListener = treeListener;
    }

    public HCLTreeData getTreeData() {
        return this.treeData;
    }

    private void initializeParentNodeArray() {
        this.parentNodes = new int[this.treeData.height.length];
        for (int i = 0; i < this.treeData.node_order.length; ++i) {
            if (this.treeData.node_order[i] == -1) continue;
            this.parentNodes[this.treeData.node_order[i]] = this.findParent(i);
        }
    }

    private int findParent(int index) {
        int i;
        int node = this.treeData.node_order[index];
        for (i = 0; i < this.treeData.child_1_array.length; ++i) {
            if (this.treeData.child_1_array[i] != node) continue;
            return i;
        }
        for (i = 0; i < this.treeData.child_2_array.length; ++i) {
            if (this.treeData.child_2_array[i] != node) continue;
            return i;
        }
        return 0;
    }

    public void setProperties(float zeroThreshold, int minDistance, int maxDistance) {
        this.zero_threshold = zeroThreshold;
        this.min_pixels = minDistance;
        this.max_pixels = maxDistance;
        this.pHeights = this.getPixelHeights(this.treeData.node_order, this.treeData.height);
        if (this.treeData.node_order.length > 1) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10, this.getHeight());
                    break;
                }
                case 1: {
                    this.setSizes(this.getWidth(), this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]]);
                }
            }
        }
    }

    public void setZeroThreshold(float zeroThreshold) {
        this.zero_threshold = zeroThreshold;
    }

    public int[][] getClusterRowIndices() {
        int index = 0;
        int testCnt = 0;
        for (int i = 0; i < this.terminalNodes.length; ++i) {
            if (!this.terminalNodes[i]) continue;
            ++testCnt;
        }
        int[] terminals = new int[testCnt];
        int terminalCnt = 0;
        for (int i = 0; i < this.terminalNodes.length; ++i) {
            if (!this.terminalNodes[i]) continue;
            terminals[terminalCnt] = i;
            ++terminalCnt;
        }
        int[][] clusters = new int[terminals.length][];
        for (int i = 0; i < clusters.length; ++i) {
            int[] endPoints;
            index = terminals[i];
            if (index >= this.treeData.node_order.length) {
                endPoints = this.getSubTreeEndPointElements(index);
            } else {
                endPoints = new int[2];
                endPoints[1] = (int)this.positions[index];
                endPoints[0] = (int)this.positions[index];
            }
            int[] rows = new int[endPoints[1] - endPoints[0] + 1];
            for (int j = 0; j < rows.length; ++j) {
                rows[j] = endPoints[0] + j;
            }
            clusters[i] = rows;
        }
        return clusters;
    }

    public void setPixelHeightLimits(int minDistance, int maxDistance) {
        this.min_pixels = minDistance;
        this.max_pixels = maxDistance;
        this.pHeights = this.getPixelHeights(this.treeData.node_order, this.treeData.height);
        if (this.treeData.node_order.length > 1) {
            switch (this.orientation) {
                case 0: {
                    this.setSizes(this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10, this.getHeight());
                    break;
                }
                case 1: {
                    this.setSizes(this.getWidth(), this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]]);
                }
            }
        }
    }

    public void setHorizontalOffset(int offset) {
        this.horizontalOffset = offset;
    }

    public void setNodeColor(int node, Color color) {
        this.setSubTreeColor(node, color);
        this.repaint();
    }

    private void setSubTreeColor(int node, Color color) {
        this.nodesColors[node] = color;
        if (this.treeData.child_1_array[node] != -1) {
            this.setNodeColor(this.treeData.child_1_array[node], color);
        }
        if (this.treeData.child_2_array[node] != -1) {
            this.setNodeColor(this.treeData.child_2_array[node], color);
        }
    }

    public void resetNodeColors() {
        int i = this.nodesColors.length;
        while (--i >= 0) {
            this.nodesColors[i] = null;
        }
        this.repaint();
    }

    public float getZeroThreshold() {
        return this.zero_threshold;
    }

    public int getMinDistance() {
        return this.min_pixels;
    }

    public int getMaxDistance() {
        return this.max_pixels;
    }

    public float getMinNodeDistance() {
        return this.minHeight;
    }

    public float getMaxNodeDistance() {
        return this.maxHeight;
    }

    public int getNumberOfTerminalNodes() {
        int n = 0;
        int index = 0;
        float[] height = this.treeData.height;
        int[] nodeOrder = this.treeData.node_order;
        for (int i = 0; i < nodeOrder.length; ++i) {
            index = nodeOrder[i];
            if (index == -1 || height[index] < this.zero_threshold) continue;
            ++n;
        }
        return n + 1;
    }

    public boolean[] getTerminalNodes() {
        return this.terminalNodes;
    }

    private float getMinHeight(int[] nodeOrder, float[] height) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < nodeOrder.length - 1; ++i) {
            min = Math.min(min, height[nodeOrder[i]]);
        }
        return min;
    }

    private float getMaxHeight(int[] nodeOrder, float[] height) {
        float max = Float.MIN_VALUE;
        for (int i = 0; i < nodeOrder.length - 1; ++i) {
            max = Math.max(max, height[nodeOrder[i]]);
        }
        return max;
    }

    private boolean flatTreeCheck(float[] height) {
        if (height.length == 1) {
            return false;
        }
        for (int i = 0; i < height.length - 1; ++i) {
            if (height[i] == height[i + 1]) continue;
            return false;
        }
        return true;
    }

    private void deselect(boolean[] selected) {
        int i = selected.length;
        while (--i >= 0) {
            selected[i] = false;
        }
    }

    public void deselectAllNodes() {
        this.deselect(this.selected);
    }

    private float getScale() {
        return (float)this.max_pixels / this.maxHeight;
    }

    public void refreshPositions() {
        this.positions = this.getPositions(this.treeData.node_order, this.treeData.child_1_array, this.treeData.child_2_array);
    }

    private float[] getPositions(int[] nodeOrder, int[] child1, int[] child2) {
        float[] positions = new float[child1.length];
        Arrays.fill(positions, -1.0f);
        if (nodeOrder.length < 2) {
            return positions;
        }
        this.fillPositions(positions, child1, child2, 0, child1.length - 2);
        for (int i = 0; i < nodeOrder.length - 1; ++i) {
            int node = nodeOrder[i];
            positions[node] = (positions[child1[node]] + positions[child2[node]]) / 2.0f;
        }
        return positions;
    }

    private int fillPositions(float[] positions, int[] child1, int[] child2, int pos, int index) {
        if (child1[index] != -1) {
            pos = this.fillPositions(positions, child1, child2, pos, child1[index]);
        }
        if (child2[index] != -1) {
            pos = this.fillPositions(positions, child1, child2, pos, child2[index]);
        } else {
            positions[index] = pos;
            ++pos;
        }
        return pos;
    }

    private int[] getPixelHeights(int[] nodeOrder, float[] height) {
        float scale = this.getScale();
        int[] pHeights = new int[nodeOrder.length * 2];
        for (int i = 0; i < nodeOrder.length - 1; ++i) {
            int node = nodeOrder[i];
            int child_1 = this.treeData.child_1_array[node];
            int child_2 = this.treeData.child_2_array[node];
            pHeights[node] = !this.useAbsoluteHeight ? Math.max(pHeights[child_1], pHeights[child_2]) + Math.max(Math.min(Math.round(height[node] * scale), this.max_pixels), this.min_pixels) : Math.max(Math.min(Math.round(height[node] * scale), this.max_pixels), this.min_pixels);
        }
        return pHeights;
    }

    private int getNodeRaisedHeight(int index, int max) {
        int node = this.treeData.node_order[index];
        int heightChange = max - this.pHeights[node];
        int sum = 0;
        while (this.parentNodes[node] != 0) {
            int pn = this.parentNodes[node];
            sum += Math.min(this.pHeights[pn] - this.pHeights[this.treeData.child_1_array[pn]], this.pHeights[pn] - this.pHeights[this.treeData.child_2_array[pn]]);
            node = this.parentNodes[node];
        }
        return heightChange -= sum;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int distToScale;
        super.paint(g);
        if (this.treeData.node_order.length == 1) {
            g.setColor(Color.black);
            g.drawLine(0, 0, 10, 0);
        }
        for (int i2 = 0; i2 < this.terminalNodes.length; ++i2) {
            this.terminalNodes[i2] = false;
        }
        if (this.treeData.node_order.length < 2) {
            return;
        }
        int sign = 1;
        if (this.orientation == 1) {
            distToScale = this.stepSize * this.data.getExperiment().getNumberOfSamples() + this.horizontalOffset + 5;
            ((Graphics2D)g).rotate(-1.5707963267948966);
            sign = -1;
        } else {
            distToScale = 5;
        }
        int max_node_height = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        this.nodeRaised = new int[this.treeData.node_order.length - 1];
        if (this.actualArms) {
            for (i = 0; i < this.treeData.node_order.length - 1; ++i) {
                try {
                    this.nodeRaised[i] = this.getNodeRaisedHeight(i, max_node_height);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int child_1 = this.treeData.child_1_array[node];
            int child_2 = this.treeData.child_2_array[node];
            int child_1_x1 = (max_node_height - this.pHeights[node] - this.nodeRaised[i]) * sign;
            int child_1_x2 = (max_node_height - this.pHeights[child_1] - this.nodeRaised[i]) * sign;
            int child_1_y = (int)(this.positions[child_1] * (float)this.stepSize) + this.stepSize / 2;
            int child_2_x1 = (max_node_height - this.pHeights[node] - this.nodeRaised[i]) * sign;
            int child_2_x2 = (max_node_height - this.pHeights[child_2] - this.nodeRaised[i]) * sign;
            int child_2_y = (int)(this.positions[child_2] * (float)this.stepSize) + this.stepSize / 2;
            if (this.nodesColors[node] == null) {
                if (this.treeData.height[node] >= this.zero_threshold) {
                    g.setColor(this.lineColor);
                    this.terminalNodes[node] = false;
                    if (this.pHeights[child_1] == 0) {
                        this.terminalNodes[child_1] = true;
                    }
                    if (this.pHeights[child_2] == 0) {
                        this.terminalNodes[child_2] = true;
                    }
                } else {
                    g.setColor(this.belowThrColor);
                    this.terminalNodes[node] = false;
                    if (this.treeData.height[this.parentNodes[node]] >= this.zero_threshold) {
                        this.drawWedge(g, node, child_1_x1 + 10, child_2_x1 + 10, child_1_y, child_2_y);
                        this.terminalNodes[node] = true;
                        this.terminalNodes[child_1] = false;
                        this.terminalNodes[child_2] = false;
                    }
                }
            } else {
                g.setColor(this.nodesColors[node]);
                if (this.treeData.height[node] >= this.zero_threshold) {
                    this.terminalNodes[node] = false;
                    if (this.pHeights[child_1] == 0) {
                        this.terminalNodes[child_1] = true;
                    }
                    if (this.pHeights[child_2] == 0) {
                        this.terminalNodes[child_2] = true;
                    }
                } else {
                    this.terminalNodes[node] = false;
                    if (this.treeData.height[this.parentNodes[node]] > this.zero_threshold) {
                        this.drawWedge(g, node, child_1_x1 + 10, child_2_x1 + 10, child_1_y, child_2_y);
                        this.terminalNodes[node] = true;
                        this.terminalNodes[child_1] = false;
                        this.terminalNodes[child_2] = false;
                    }
                }
            }
            if (this.selected[node]) {
                g.setColor(this.selectedLineColor);
            }
            if (this.actualArms) {
                int maxx1;
                if (this.orientation == 0) {
                    maxx1 = Math.min(child_1_x2, child_2_x2);
                    g.drawLine(child_1_x1 + 10, child_1_y, maxx1 + 10, child_1_y);
                    g.drawLine(child_2_x1 + 10, child_2_y, maxx1 + 10, child_2_y);
                    g.drawLine(child_1_x1 + 10, child_1_y, child_2_x1 + 10, child_2_y);
                    continue;
                }
                maxx1 = Math.max(child_1_x2, child_2_x2);
                g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, maxx1, child_1_y + this.horizontalOffset);
                g.drawLine(child_2_x1, child_2_y + this.horizontalOffset, maxx1, child_2_y + this.horizontalOffset);
                g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_2_x1, child_2_y + this.horizontalOffset);
                continue;
            }
            if (this.orientation == 0) {
                g.drawLine(child_1_x1 + 10, child_1_y, child_1_x2 + 10, child_1_y);
                g.drawLine(child_2_x1 + 10, child_2_y, child_2_x2 + 10, child_2_y);
                g.drawLine(child_1_x1 + 10, child_1_y, child_2_x1 + 10, child_2_y);
                continue;
            }
            g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_1_x2, child_1_y + this.horizontalOffset);
            g.drawLine(child_2_x1, child_2_y + this.horizontalOffset, child_2_x2, child_2_y + this.horizontalOffset);
            g.drawLine(child_1_x1, child_1_y + this.horizontalOffset, child_2_x1, child_2_y + this.horizontalOffset);
        }
        if (this.showScale && this.function != 0 && this.orientation != 0) {
            g.setColor(Color.black);
            g.drawLine(0, distToScale, -(this.max_pixels - 1), distToScale);
            g.drawLine(0, distToScale, 0, distToScale + 5);
            g.drawLine(-(this.max_pixels - 1) / 2, distToScale, -(this.max_pixels - 1) / 2, distToScale + 5);
            g.drawLine(-(this.max_pixels - 1), distToScale, -(this.max_pixels - 1), distToScale + 5);
            ((Graphics2D)g).rotate(1.5707963267948966);
            g.drawString(this.getMaxHeightDisplay(), distToScale + 10, 10);
            g.drawString(this.getMidHeightDisplay(), distToScale + 10, (this.max_pixels - 1) / 2 + 4);
            g.drawString(this.getMinHeightDisplay(), distToScale + 10, this.max_pixels - 1);
            ((Graphics2D)g).rotate(-1.5707963267948966);
        }
    }

    public String getMinHeightDisplay() {
        return String.valueOf(this.nodeHeightOffset);
    }

    public String getMidHeightDisplay() {
        return String.valueOf((this.similarityFactor * (this.maxHeight - this.nodeHeightOffset) + this.nodeHeightOffset) / 2.0f);
    }

    public String getMaxHeightDisplay() {
        return String.valueOf(this.similarityFactor * (this.maxHeight - this.nodeHeightOffset));
    }

    public void drawWedge(Graphics g, int node, int x1, int x2, int y1, int y2) {
        int[] xs = new int[3];
        int[] ys = new int[3];
        int k = node;
        int k1 = node;
        while (this.treeData.child_1_array[k] != -1) {
            k = this.treeData.child_1_array[k];
        }
        while (this.treeData.child_2_array[k1] != -1) {
            k1 = this.treeData.child_2_array[k1];
        }
        if (this.orientation == 0) {
            ys[0] = (y2 - y1) / 2 + y1;
            ys[1] = (int)(this.positions[k] * (float)this.stepSize) + this.stepSize / 2;
            ys[2] = (int)(this.positions[k1] * (float)this.stepSize) + this.stepSize / 2;
            xs[0] = x1;
            xs[1] = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10;
            xs[2] = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]] + 10;
        } else {
            ys[0] = (y2 - y1) / 2 + y1 + this.horizontalOffset;
            ys[1] = (int)(this.positions[k] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            ys[2] = (int)(this.positions[k1] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            xs[0] = x1 - 10;
            xs[1] = -1 * this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
            xs[2] = -1 * this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        }
        Color color = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
        g.setColor(Color.blue);
        g.fillPolygon(new Polygon(xs, ys, 3));
        g.setColor(color);
        g2.setComposite(composite);
    }

    public void paintSubTree(Graphics g) {
        super.paint(g);
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        this.updateSize(framework.getDisplayMenu().getElementSize());
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.updateSize(menu.getElementSize());
    }

    protected void updateSize(Dimension elementSize) {
        switch (this.orientation) {
            case 0: {
                if (this.flatTree || this.stepSize == elementSize.height) {
                    return;
                }
                this.stepSize = elementSize.height;
                this.setSizes(this.getPreferredSize().width, this.stepSize * this.treeData.node_order.length);
                break;
            }
            case 1: {
                if (this.flatTree || this.stepSize == elementSize.width) {
                    return;
                }
                this.stepSize = elementSize.width;
                this.setSizes(this.stepSize * this.treeData.node_order.length, this.getPreferredSize().height);
            }
        }
    }

    public void setSizes(int width, int height) {
        if (this.orientation == 0) {
            this.setSize(width, height);
            this.setPreferredSize(new Dimension(width, height));
        } else {
            int scaleLabel = 100;
            this.setSize(this.stepSize * this.treeData.node_order.length + scaleLabel, height);
            this.setPreferredSize(new Dimension(this.stepSize * this.treeData.node_order.length + scaleLabel, height));
        }
    }

    private int[] getSubTreeEndPointElements(int node) {
        int[] endPoints = new int[]{(int)this.positions[node], (int)this.positions[node]};
        int ptr = node;
        while (this.treeData.child_1_array[ptr] != -1) {
            ptr = this.treeData.child_1_array[ptr];
        }
        endPoints[0] = (int)this.positions[ptr];
        ptr = node;
        while (this.treeData.child_2_array[ptr] != -1) {
            ptr = this.treeData.child_2_array[ptr];
        }
        endPoints[1] = (int)this.positions[ptr];
        return endPoints;
    }

    private void selectNode(int x, int y) {
        this.deselect(this.selected);
        HCLCluster cluster = new HCLCluster(this.findNode(x, y), Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.selectNode(cluster, cluster.root);
        this.fireEvent(cluster);
        this.repaint();
    }

    private void selectNode(HCLCluster cluster, int node) {
        if (node == -1) {
            cluster.firstElem = -1;
            cluster.lastElem = -1;
            return;
        }
        this.selected[node] = true;
        if (this.treeData.child_1_array[node] != -1) {
            this.selectNode(cluster, this.treeData.child_1_array[node]);
        } else {
            if (this.positions[node] < (float)cluster.firstElem) {
                cluster.firstElem = (int)this.positions[node];
            }
            if (this.positions[node] > (float)cluster.lastElem) {
                cluster.lastElem = (int)this.positions[node];
            }
            cluster.setFinalSize();
        }
        if (this.treeData.child_2_array[node] != -1) {
            this.selectNode(cluster, this.treeData.child_2_array[node]);
        }
    }

    private int findNode(int x, int y) {
        if (this.orientation == 0) {
            x -= 10;
        }
        int max_node_height = this.pHeights[this.treeData.node_order[this.treeData.node_order.length - 2]];
        block4: for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int child_1 = this.treeData.child_1_array[node];
            int child_2 = this.treeData.child_2_array[node];
            int child_1_x1 = max_node_height - this.pHeights[node] - this.nodeRaised[i];
            int child_1_y = (int)(this.positions[child_1] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            int child_2_x1 = max_node_height - this.pHeights[node] - this.nodeRaised[i];
            int child_2_y = (int)(this.positions[child_2] * (float)this.stepSize) + this.stepSize / 2 + this.horizontalOffset;
            switch (this.orientation) {
                case 0: {
                    if (child_1_y >= y || child_2_y <= y || x <= child_1_x1) continue block4;
                    return node;
                }
                case 1: {
                    if (child_1_y >= x || child_2_y <= x || y <= child_1_x1) continue block4;
                    return node;
                }
            }
        }
        return -1;
    }

    public void saveGeneNodeHeights() {
        JFileChooser fc;
        int ret;
        File file = null;
        String dataPath = TMEV.getDataPath();
        File fileLoc = TMEV.getFile((String)"data/");
        if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
            fileLoc = TMEV.getFile((String)"data/");
        }
        if ((ret = (fc = new JFileChooser(fileLoc)).showSaveDialog(new JFrame())) == 0) {
            file = fc.getSelectedFile();
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
                String line = "Node_" + String.valueOf(i) + "\t";
                int child1 = this.treeData.child_1_array[this.treeData.node_order[i]];
                int child2 = this.treeData.child_2_array[this.treeData.node_order[i]];
                line = child1 < this.treeData.height.length / 2 ? line + "Gene_" + String.valueOf(child1 + 1) + "\t" : line + "Node_" + String.valueOf(child1 - this.treeData.height.length / 2) + "\t";
                line = child2 < this.treeData.height.length / 2 ? line + "Gene_" + String.valueOf(child2 + 1) + "\t" : line + "Node_" + String.valueOf(child2 - this.treeData.height.length / 2) + "\t";
                line = line + String.valueOf(this.treeData.height[this.treeData.node_order[i]]);
                out.println(line);
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error saving node height file.", "Error", 2);
            ioe.printStackTrace();
        }
    }

    public void saveExperimentNodeHeights() {
        JFileChooser fc;
        int ret;
        File file = null;
        String dataPath = TMEV.getDataPath();
        File fileLoc = TMEV.getFile((String)"data/");
        if (dataPath != null && !(fileLoc = new File(dataPath)).exists()) {
            fileLoc = TMEV.getFile((String)"data/");
        }
        if ((ret = (fc = new JFileChooser(fileLoc)).showSaveDialog(new JFrame())) == 0) {
            file = fc.getSelectedFile();
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
                String line = "Node_" + String.valueOf(i) + "\t";
                int child1 = this.treeData.child_1_array[this.treeData.node_order[i]];
                int child2 = this.treeData.child_2_array[this.treeData.node_order[i]];
                line = child1 < this.treeData.height.length / 2 ? line + "Exp_" + String.valueOf(child1 + 1) + "\t" : line + "Node_" + String.valueOf(child1 - this.treeData.height.length / 2) + "\t";
                line = child2 < this.treeData.height.length / 2 ? line + "Exp_" + String.valueOf(child2 + 1) + "\t" : line + "Node_" + String.valueOf(child2 - this.treeData.height.length / 2) + "\t";
                line = line + String.valueOf(this.treeData.height[this.treeData.node_order[i]]);
                out.println(line);
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error saving node height file.", "Error", 2);
            ioe.printStackTrace();
        }
    }

    public void saveAsNexusFile() {
        String[] annKeys;
        if (this.orientation == 0) {
            annKeys = this.data.getFieldNames();
        } else {
            Vector annKeyVector = this.data.getSampleAnnotationFieldNames();
            annKeys = new String[annKeyVector.size()];
            for (int i = 0; i < annKeys.length; ++i) {
                annKeys[i] = (String)annKeyVector.elementAt(i);
            }
        }
        NexusFileOutputDialog dialog = new NexusFileOutputDialog(this.framework.getFrame(), annKeys, this.orientation, "Nexus");
        if (dialog.showModal() == 0) {
            String treeLabel = dialog.getTreeLabel();
            boolean saveMatrix = dialog.getSaveMatris();
            String nexusString = this.orientation == 0 ? this.generateNexusStringForGeneTree(dialog.getAnnotationKey()) : this.generateNexusStringForSampleTree(dialog.getAnnotationKey(), saveMatrix, treeLabel);
            this.saveNexusString(nexusString, dialog.getOutputFile());
        }
    }

    public void saveAsNewickFile() {
        String[] annKeys;
        if (this.orientation == 0) {
            annKeys = this.data.getFieldNames();
        } else {
            Vector annKeyVector = this.data.getSampleAnnotationFieldNames();
            annKeys = new String[annKeyVector.size()];
            for (int i = 0; i < annKeys.length; ++i) {
                annKeys[i] = (String)annKeyVector.elementAt(i);
            }
        }
        NewickFileOutputDialog dialog = new NewickFileOutputDialog(this.framework.getFrame(), annKeys, this.orientation, "Newick");
        if (dialog.showModal() == 0) {
            String newickString = this.orientation == 0 ? this.generateNewickStringForGeneTree(dialog.getAnnotationKey()) : this.generateNewickStringForSampleTree(dialog.getAnnotationKey());
            this.saveNewickString(newickString, dialog.getOutputFile());
        }
    }

    private void saveNexusString(String s, File outputFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            bw.write(s);
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving Newick file: " + outputFile.getAbsolutePath() + ".<BR>" + "Please check that file location is valid and permissions are open.", "IO Error Saving Newick File", 0);
        }
    }

    private void saveNewickString(String s, File outputFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            bw.write(s);
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving Newick file: " + outputFile.getAbsolutePath() + ".<BR>" + "Please check that file location is valid and permissions are open.", "IO Error Saving Newick File", 0);
        }
    }

    private String generateNewickStringForSampleTree(String annotationKey) {
        String s = new String("");
        Hashtable<String, String> treeHash = new Hashtable<String, String>();
        String nodeName = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int leftChild = this.treeData.child_1_array[node];
            int rightChild = this.treeData.child_2_array[node];
            float leftHeight = this.treeData.height[leftChild];
            float rightHeight = this.treeData.height[rightChild];
            int parent = this.parentNodes[node];
            if (leftChild < this.treeData.height.length / 2) {
                s = this.data.getSampleAnnotation(leftChild, annotationKey) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(leftChild), s);
            }
            if (rightChild < this.treeData.height.length / 2) {
                s = this.data.getSampleAnnotation(rightChild, annotationKey) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(rightChild), s);
            }
            if (!treeHash.containsKey(String.valueOf(leftChild)) || !treeHash.containsKey(String.valueOf(rightChild))) continue;
            s = "(" + treeHash.get(String.valueOf(leftChild)) + "," + treeHash.get(String.valueOf(rightChild)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[node]] / 2.0f);
            treeHash.put(String.valueOf(node), s);
            treeHash.remove(String.valueOf(leftChild));
            treeHash.remove(String.valueOf(rightChild));
        }
        return s + ";";
    }

    private String generateNexusStringForSampleTree(String annotationKey, boolean saveMatrix, String treeLabel) {
        String s = new String("");
        String[] leafNames = new String[this.data.getExperiment().getNumberOfSamples()];
        Hashtable<String, String> treeHash = new Hashtable<String, String>();
        String nodeName = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int leftChild = this.treeData.child_1_array[node];
            int rightChild = this.treeData.child_2_array[node];
            float leftHeight = this.treeData.height[leftChild];
            float rightHeight = this.treeData.height[rightChild];
            int parent = this.parentNodes[node];
            if (leftChild < this.treeData.height.length / 2) {
                s = String.valueOf(leftChild + 1) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(leftChild + 1), String.valueOf(leftChild + 1));
                leafNames[leftChild] = this.data.getSampleName(leftChild);
            }
            if (rightChild < this.treeData.height.length / 2) {
                s = String.valueOf(rightChild + 1) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(rightChild + 1), String.valueOf(rightChild + 1));
                leafNames[rightChild] = this.data.getSampleName(rightChild);
            }
            if (!treeHash.containsKey(String.valueOf(leftChild + 1)) || !treeHash.containsKey(String.valueOf(rightChild + 1))) continue;
            s = "(" + treeHash.get(String.valueOf(leftChild + 1)) + "," + treeHash.get(String.valueOf(rightChild + 1)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[node]] / 2.0f);
            treeHash.put(String.valueOf(node + 1), s);
            treeHash.remove(String.valueOf(leftChild + 1));
            treeHash.remove(String.valueOf(rightChild + 1));
        }
        String lineSep = System.getProperty("line.separator");
        String str = "";
        str = str + "#NEXUS" + lineSep + "Begin trees;" + lineSep + "Translate" + lineSep;
        for (int i = 0; i < leafNames.length; ++i) {
            str = str + "\t" + String.valueOf(i + 1) + "\t" + leafNames[i].replace(' ', '_') + (i < leafNames.length - 1 ? "," : "") + lineSep;
        }
        str = str + ";" + lineSep + lineSep;
        str = str + "tree " + treeLabel.replace(' ', '_') + " = [&U] ";
        return str + s + ";" + lineSep + "End;";
    }

    private String generateNewickStringForGeneTree(String annotationKey) {
        String[] fieldNames = this.data.getFieldNames();
        int attIndex = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equals(annotationKey)) continue;
            attIndex = i;
            break;
        }
        String s = new String("");
        Hashtable<String, String> treeHash = new Hashtable<String, String>();
        String nodeName = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int leftChild = this.treeData.child_1_array[node];
            int rightChild = this.treeData.child_2_array[node];
            float leftHeight = this.treeData.height[leftChild];
            float rightHeight = this.treeData.height[rightChild];
            int parent = this.parentNodes[node];
            if (leftChild < this.treeData.height.length / 2) {
                s = this.data.getElementAttribute(leftChild, attIndex) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(leftChild), s);
            }
            if (rightChild < this.treeData.height.length / 2) {
                s = this.data.getElementAttribute(rightChild, attIndex) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(rightChild), s);
            }
            if (!treeHash.containsKey(String.valueOf(leftChild)) || !treeHash.containsKey(String.valueOf(rightChild))) continue;
            s = "(" + treeHash.get(String.valueOf(leftChild)) + "," + treeHash.get(String.valueOf(rightChild)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[node]] / 2.0f);
            treeHash.put(String.valueOf(node), s);
            treeHash.remove(String.valueOf(leftChild));
            treeHash.remove(String.valueOf(rightChild));
        }
        return s + ";";
    }

    private String generateNexusStringForGeneTree(String annotationKey) {
        String[] fieldNames = this.data.getFieldNames();
        int attIndex = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldNames[i].equals(annotationKey)) continue;
            attIndex = i;
            break;
        }
        String s = new String("");
        String[] leafNames = new String[this.data.getExperiment().getNumberOfGenes()];
        Hashtable<String, String> treeHash = new Hashtable<String, String>();
        String nodeName = "";
        for (int i = 0; i < this.treeData.node_order.length - 1; ++i) {
            int node = this.treeData.node_order[i];
            int leftChild = this.treeData.child_1_array[node];
            int rightChild = this.treeData.child_2_array[node];
            float leftHeight = this.treeData.height[leftChild];
            float rightHeight = this.treeData.height[rightChild];
            int parent = this.parentNodes[node];
            if (leftChild < this.treeData.height.length / 2) {
                s = String.valueOf(leftChild + 1) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(leftChild + 1), String.valueOf(leftChild + 1));
                leafNames[leftChild] = this.data.getElementAttribute(leftChild, attIndex);
            }
            if (rightChild < this.treeData.height.length / 2) {
                s = String.valueOf(rightChild + 1) + ":" + String.valueOf(this.treeData.height[node] / 2.0f);
                treeHash.put(String.valueOf(rightChild + 1), String.valueOf(rightChild + 1));
                leafNames[rightChild] = this.data.getElementAttribute(rightChild, attIndex);
            }
            if (!treeHash.containsKey(String.valueOf(leftChild + 1)) || !treeHash.containsKey(String.valueOf(rightChild + 1))) continue;
            s = "(" + treeHash.get(String.valueOf(leftChild + 1)) + "," + treeHash.get(String.valueOf(rightChild + 1)) + "):" + String.valueOf(this.treeData.height[this.parentNodes[node]] / 2.0f);
            treeHash.put(String.valueOf(node + 1), s);
            treeHash.remove(String.valueOf(leftChild + 1));
            treeHash.remove(String.valueOf(rightChild + 1));
        }
        String lineSep = System.getProperty("line.sep");
        String str = "";
        for (int i = 0; i < leafNames.length; ++i) {
            str = str + String.valueOf(i + 1) + "\t" + lineSep;
        }
        str = str + lineSep + lineSep;
        return str + s + ";";
    }

    private void fireEvent(HCLCluster cluster) {
        if (this.treeListener != null) {
            this.treeListener.valueChanged(this, cluster);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    private static class HCLTreePersistenceDelegate
    extends PersistenceDelegate {
        private HCLTreePersistenceDelegate() {
        }

        @Override
        public Expression instantiate(Object oldInstance, Encoder encoder) {
            HCLTree aTree = (HCLTree)oldInstance;
            return new Expression(aTree, aTree.getClass(), "new", new Object[]{aTree.treeData, new Integer(aTree.orientation)});
        }
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            HCLTree.this.selectNode(e.getX(), e.getY());
        }
    }
}

