/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterValidationGenerator;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class HCLInitDialog
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    private int result;
    private JCheckBox genes_box;
    private JCheckBox cluster_box;
    private JCheckBox gene_ordering_box;
    private JCheckBox sample_ordering_box;
    private JRadioButton ALC;
    private JRadioButton CLC;
    private JRadioButton SLC;
    private DistanceMetricPanel metricPanel;
    private String globalMetricName;
    private boolean globalAbsoluteDistance;
    private ClusterValidationGenerator validationGenerator;

    public HCLInitDialog(Frame parent, String globalMetricName, boolean globalAbsoluteDistance, boolean showDistancePanel) {
        this(parent, globalMetricName, globalAbsoluteDistance, showDistancePanel, null, null);
    }

    public HCLInitDialog(Frame parent, String globalMetricName, boolean globalAbsoluteDistance, boolean showDistancePanel, String bioCAnnotation) {
        this(parent, globalMetricName, globalAbsoluteDistance, showDistancePanel, null, bioCAnnotation);
    }

    public HCLInitDialog(Frame parent, String globalMetricName, boolean globalAbsoluteDistance, boolean showDistancePanel, ClusterRepository repository, String bioCAnnotation) {
        super(parent, "HCL: Hierarchical Clustering", true);
        this.setResizable(false);
        this.globalMetricName = globalMetricName;
        this.globalAbsoluteDistance = globalAbsoluteDistance;
        Listener listener = new Listener();
        this.addWindowListener(listener);
        ParameterPanel sampleSelectionPanel = new ParameterPanel("Tree Selection");
        sampleSelectionPanel.setLayout(new GridBagLayout());
        ParameterPanel orderingSelectionPanel = new ParameterPanel("Ordering Optimization");
        orderingSelectionPanel.setLayout(new GridBagLayout());
        this.genes_box = new JCheckBox("Gene Tree");
        this.genes_box.setSelected(true);
        this.genes_box.setFocusPainted(false);
        this.genes_box.setBackground(Color.white);
        this.genes_box.setForeground(UIManager.getColor("Label.foreground"));
        this.genes_box.addItemListener(listener);
        this.cluster_box = new JCheckBox("Sample Tree");
        this.cluster_box.setSelected(true);
        this.cluster_box.setFocusPainted(false);
        this.cluster_box.setBackground(Color.white);
        this.cluster_box.setForeground(UIManager.getColor("Label.foreground"));
        this.cluster_box.addItemListener(listener);
        this.gene_ordering_box = new JCheckBox("Optimize Gene Leaf Order");
        this.gene_ordering_box.setSelected(false);
        this.gene_ordering_box.setFocusPainted(false);
        this.gene_ordering_box.setBackground(Color.white);
        this.gene_ordering_box.setForeground(UIManager.getColor("Label.foreground"));
        this.gene_ordering_box.addItemListener(listener);
        this.sample_ordering_box = new JCheckBox("Optimize Sample Leaf Order");
        this.sample_ordering_box.setSelected(false);
        this.sample_ordering_box.setFocusPainted(false);
        this.sample_ordering_box.setBackground(Color.white);
        this.sample_ordering_box.setForeground(UIManager.getColor("Label.foreground"));
        this.sample_ordering_box.addItemListener(listener);
        JLabel optimizationWarning = new JLabel("(Leaf ordering optimization will increase the calculation time)");
        sampleSelectionPanel.add((Component)this.genes_box, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 111), 0, 0));
        sampleSelectionPanel.add((Component)this.cluster_box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 5, 86), 0, 0));
        orderingSelectionPanel.add((Component)this.gene_ordering_box, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 25), 0, 0));
        orderingSelectionPanel.add((Component)this.sample_ordering_box, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        orderingSelectionPanel.add((Component)optimizationWarning, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 0, 0), 0, 0));
        this.metricPanel = new DistanceMetricPanel(globalMetricName, globalAbsoluteDistance, "Pearson Correlation", "HCL", true, true);
        ParameterPanel linkageMethodPanel = new ParameterPanel("Linkage Method Selection");
        linkageMethodPanel.setLayout(new GridBagLayout());
        this.ALC = new JRadioButton("Average linkage clustering");
        this.ALC.setBackground(Color.white);
        this.ALC.setFocusPainted(false);
        this.ALC.setForeground(UIManager.getColor("Label.foreground"));
        this.ALC.setMnemonic(65);
        this.ALC.setSelected(true);
        this.CLC = new JRadioButton("Complete linkage clustering");
        this.CLC.setBackground(Color.white);
        this.CLC.setFocusPainted(false);
        this.CLC.setForeground(UIManager.getColor("Label.foreground"));
        this.CLC.setMnemonic(67);
        this.SLC = new JRadioButton("Single linkage clustering");
        this.SLC.setBackground(Color.white);
        this.SLC.setFocusPainted(false);
        this.SLC.setForeground(UIManager.getColor("Label.foreground"));
        this.SLC.setMnemonic(83);
        linkageMethodPanel.add((Component)this.ALC, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        linkageMethodPanel.add((Component)this.CLC, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        linkageMethodPanel.add((Component)this.SLC, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.ALC);
        group.add(this.CLC);
        group.add(this.SLC);
        this.validationGenerator = new ClusterValidationGenerator((AlgorithmDialog)this, repository, bioCAnnotation, "Validation");
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        parameterPanel.setBackground(Color.white);
        parameterPanel.add((Component)sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)orderingSelectionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (showDistancePanel) {
            parameterPanel.add((Component)this.metricPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            parameterPanel.add((Component)linkageMethodPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            parameterPanel.add((Component)this.validationGenerator.getClusterValidationPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            parameterPanel.add((Component)linkageMethodPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            parameterPanel.add((Component)this.validationGenerator.getClusterValidationPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.addContent(parameterPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.ALC.setSelected(true);
        this.genes_box.setSelected(true);
        this.cluster_box.setSelected(true);
        this.gene_ordering_box.setSelected(false);
        this.sample_ordering_box.setSelected(false);
        this.metricPanel.reset();
    }

    public boolean isClusterGenes() {
        return this.genes_box.isSelected();
    }

    public boolean isClusterExperiments() {
        return this.cluster_box.isSelected();
    }

    public boolean isGeneOrdering() {
        return this.gene_ordering_box.isSelected();
    }

    public boolean isSampleOrdering() {
        return this.sample_ordering_box.isSelected();
    }

    public int getMethod() {
        if (this.ALC.isSelected()) {
            return 0;
        }
        if (this.CLC.isSelected()) {
            return 1;
        }
        return -1;
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean getAbsoluteSelection() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        HCLInitDialog dialog = new HCLInitDialog(frame, "Euclidean Distance", false, true, null);
        dialog.setVisible(true);
        System.exit(0);
    }

    @Override
    protected void disposeDialog() {
    }

    public ClusterValidationGenerator getValidationPanel() {
        return this.validationGenerator;
    }

    private class Listener
    extends DialogListener
    implements ItemListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                if (!HCLInitDialog.this.validationGenerator.validateParameters()) {
                    return;
                }
                HCLInitDialog.this.result = 0;
                HCLInitDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                HCLInitDialog.this.result = 2;
                HCLInitDialog.this.dispose();
            } else {
                if (command.equals("reset-command")) {
                    HCLInitDialog.this.resetControls();
                    HCLInitDialog.this.result = 2;
                    return;
                }
                if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(HCLInitDialog.this, "HCL Initialization Dialog");
                }
            }
            HCLInitDialog.this.dispose();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            HCLInitDialog.this.okButton.setEnabled(HCLInitDialog.this.genes_box.isSelected() || HCLInitDialog.this.cluster_box.isSelected());
            if (!HCLInitDialog.this.genes_box.isSelected()) {
                HCLInitDialog.this.gene_ordering_box.setEnabled(false);
                HCLInitDialog.this.gene_ordering_box.setSelected(false);
            }
            if (!HCLInitDialog.this.cluster_box.isSelected()) {
                HCLInitDialog.this.sample_ordering_box.setEnabled(false);
                HCLInitDialog.this.sample_ordering_box.setSelected(false);
            }
            if (HCLInitDialog.this.genes_box.isSelected()) {
                HCLInitDialog.this.gene_ordering_box.setEnabled(true);
            }
            if (HCLInitDialog.this.cluster_box.isSelected()) {
                HCLInitDialog.this.sample_ordering_box.setEnabled(true);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            HCLInitDialog.this.result = -1;
            HCLInitDialog.this.dispose();
        }
    }
}

