/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLNodeHeightGraph;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class HCLGUI
implements IClusterGUI,
IScriptGUI {
    private Algorithm algorithm;
    private Progress progress;
    private boolean isSampOrdered = false;
    private boolean isGeneOrdered = false;
    private boolean isClusterValidation = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        HCLInitDialog dialog;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        if ((dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true, framework.getClusterRepository(0), framework.getData().getChipAnnotation().getChipType())).showModal() != 0) {
            return null;
        }
        int method = dialog.getMethod();
        function = dialog.getDistanceMetric();
        this.isClusterValidation = dialog.getValidationPanel().isValidate();
        Listener listener = new Listener();
        try {
            DefaultMutableTreeNode resultNode;
            int i;
            Experiment experiment = framework.getData().getExperiment();
            AlgorithmFactory factory = framework.getAlgorithmFactory();
            int number_of_samples = experiment.getNumberOfSamples();
            int[] columnIndices = experiment.getColumnIndicesCopy();
            ArrayList<String> sampleLabels = new ArrayList<String>();
            ArrayList<String> geneLabels = new ArrayList<String>();
            for (i = 0; i < number_of_samples; ++i) {
                sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
            }
            for (i = 0; i < experiment.getNumberOfGenes(); ++i) {
                geneLabels.add(framework.getData().getElementAnnotation(i, "PROBE_ID")[0]);
            }
            this.algorithm = factory.getAlgorithm("HCL");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            AlgorithmData data = new AlgorithmData();
            data.addStringArray("geneLabels", geneLabels.toArray(new String[geneLabels.size()]));
            data.addStringArray("sampleLabels", sampleLabels.toArray(new String[sampleLabels.size()]));
            data.addMatrix("experiment", experiment.getMatrix());
            data.addParam("hcl-distance-function", String.valueOf(function));
            data.addParam("distance-factor", String.valueOf(1.0f));
            data.addParam("hcl-distance-absolute", String.valueOf(dialog.getAbsoluteSelection()));
            data.addParam("method-linkage", String.valueOf(method));
            this.progress = new Progress(framework.getFrame(), "", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData genes_result = null;
            if (dialog.isClusterGenes()) {
                this.progress.setTitle("Clustering by Genes");
                data.addParam("calculate-genes", String.valueOf(true));
                data.addParam("optimize-gene-ordering", String.valueOf(false));
                if (dialog.isGeneOrdering()) {
                    this.isGeneOrdered = true;
                    data.addParam("optimize-gene-ordering", String.valueOf(true));
                }
                genes_result = this.algorithm.execute(data);
                this.validate(genes_result);
            }
            AlgorithmData samples_result = null;
            if (dialog.isClusterExperiments()) {
                this.progress.setTitle("Clustering by Samples");
                data.addParam("calculate-genes", String.valueOf(false));
                data.addParam("optimize-sample-ordering", String.valueOf(false));
                if (dialog.isSampleOrdering()) {
                    this.isSampOrdered = true;
                    data.addParam("optimize-sample-ordering", String.valueOf(true));
                }
                samples_result = this.algorithm.execute(data);
                this.validate(samples_result);
            }
            AlgorithmData validationData = new AlgorithmData();
            if (this.isClusterValidation) {
                this.progress.setIndeterminate(true);
                this.progress.setIndeterminantString("This process may take awhile...");
                this.progress.setDescription("Performing Cluster Validation");
                this.progress.setTitle("Hierarchical Clustering");
                validationData.addMatrix("experiment", experiment.getMatrix());
                validationData.addStringArray("geneLabels", geneLabels.toArray(new String[geneLabels.size()]));
                validationData.addStringArray("sampleLabels", sampleLabels.toArray(new String[sampleLabels.size()]));
                dialog.getValidationPanel().addValidationParameters(validationData);
                ExperimentUtil.performValidation((AlgorithmData)validationData);
            }
            if (validationData.getResultNode("validation-node") == null) {
                System.out.println("result node is null");
            } else {
                System.out.println("result node is not null");
            }
            long time = System.currentTimeMillis() - start;
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.method = method;
            info.function = menu.getFunctionName(function);
            DefaultMutableTreeNode defaultMutableTreeNode = resultNode = this.createResultTree(experiment, genes_result, samples_result, validationData, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        HCLInitDialog dialog;
        IDistanceMenu menu = framework.getDistanceMenu();
        int function = menu.getDistanceFunction();
        if (function == 0) {
            function = 1;
        }
        if ((dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true, framework.getData().getChipAnnotation().getChipType())).showModal() != 0) {
            return null;
        }
        int method = dialog.getMethod();
        function = dialog.getDistanceMetric();
        AlgorithmData data = new AlgorithmData();
        data.addParam("distance-function", String.valueOf(function));
        data.addParam("distance-factor", String.valueOf(1.0f));
        data.addParam("distance-absolute", String.valueOf(dialog.getAbsoluteSelection()));
        data.addParam("method-linkage", String.valueOf(method));
        if (dialog.isClusterGenes()) {
            data.addParam("calculate-genes", String.valueOf(true));
        }
        if (dialog.isClusterExperiments()) {
            data.addParam("calculate-experiments", String.valueOf(true));
        }
        if (dialog.isGeneOrdering()) {
            data.addParam("optimize-gene-ordering", String.valueOf(true));
        }
        if (dialog.isSampleOrdering()) {
            data.addParam("optimize-sample-ordering", String.valueOf(true));
        }
        data.addParam("name", "HCL");
        data.addParam("alg-type", "cluster");
        data.addParam("output-class", "single-output");
        String[] outputNodes = new String[]{"Single Ordered Output"};
        data.addStringArray("output-nodes", outputNodes);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        Listener listener = new Listener();
        try {
            algData.addMatrix("experiment", experiment.getMatrix());
            AlgorithmParameters params = algData.getParams();
            boolean clusterGenes = params.getBoolean("calculate-genes");
            boolean clusterExperiments = params.getBoolean("calculate-experiments");
            AlgorithmFactory factory = framework.getAlgorithmFactory();
            this.algorithm = factory.getAlgorithm("HCL");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "", listener);
            this.progress.show();
            long start = System.currentTimeMillis();
            AlgorithmData genes_result = null;
            if (clusterGenes) {
                this.progress.setTitle("Clustering by Genes");
                algData.addParam("calculate-genes", String.valueOf(true));
                genes_result = this.algorithm.execute(algData);
                this.validate(genes_result);
            }
            AlgorithmData samples_result = null;
            if (clusterExperiments) {
                this.progress.setTitle("Clustering by Samples");
                algData.addParam("calculate-genes", String.valueOf(false));
                samples_result = this.algorithm.execute(algData);
                this.validate(samples_result);
            }
            long time = System.currentTimeMillis() - start;
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.method = params.getInt("method-linkage");
            info.function = framework.getDistanceMenu().getFunctionName(params.getInt("distance-function"));
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(experiment, genes_result, samples_result, null, info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, AlgorithmData validationData, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("HCL");
        root.add(new DefaultMutableTreeNode(new LeafInfo("HCL Tree", this.createHCLViewer(experiment, genes_result, samples_result, root))));
        if (genes_result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("Gene Node Height Plot", (IViewer)new HCLNodeHeightGraph(this.getHCLTreeData(genes_result), true))));
        }
        if (samples_result != null) {
            root.add(new DefaultMutableTreeNode(new LeafInfo("Sample Node Height Plot", (IViewer)new HCLNodeHeightGraph(this.getHCLTreeData(samples_result), false))));
        }
        this.addGeneralInfo(root, info);
        if (this.isClusterValidation) {
            root.add(validationData.getResultNode("validation-node"));
        }
        return root;
    }

    private HCLTreeData getHCLTreeData(AlgorithmData result) {
        if (result == null) {
            return null;
        }
        HCLTreeData data = new HCLTreeData();
        data.child_1_array = result.getIntArray("child-1-array");
        data.child_2_array = result.getIntArray("child-2-array");
        data.node_order = result.getIntArray("node-order");
        data.height = result.getMatrix("height").getRowPackedCopy();
        data.setFunction(result.getParams().getInt("function"));
        return data;
    }

    private IViewer createHCLViewer(Experiment experiment, AlgorithmData genes_result, AlgorithmData samples_result, DefaultMutableTreeNode root) {
        return new HCLViewer(experiment, null, this.getHCLTreeData(genes_result), this.getHCLTreeData(samples_result), root);
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Linkage Method: " + info.getMethodName()));
        node.add(new DefaultMutableTreeNode("Leaf Order Optimization: " + this.isOrdered()));
        node.add(new DefaultMutableTreeNode("Time: " + String.valueOf(info.time) + " ms"));
        node.add(new DefaultMutableTreeNode(info.function));
        root.add(node);
    }

    private String isOrdered() {
        if (this.isSampOrdered) {
            if (this.isGeneOrdered) {
                return "Samples, Genes";
            }
            return "Samples";
        }
        if (this.isGeneOrdered) {
            return "Genes";
        }
        return "None";
    }

    public static void printResult(AlgorithmData result) {
        FloatMatrix similarity = result.getMatrix("similarity-matrix");
        similarity.print(5, 2);
        int[] parent = result.getIntArray("parent-array");
        int[] child1 = result.getIntArray("child-1-array");
        int[] child2 = result.getIntArray("child-2-array");
        int[] nodeOrder = result.getIntArray("node-order");
        int[] nodeHeight = result.getIntArray("node-height");
        int[] numberOfChildren = result.getIntArray("number-of-children");
        float[] height = result.getMatrix("height").getRowPackedCopy();
    }

    public static class GeneralInfo {
        public long time;
        public int method;
        public String function;
        private static String[] methods = new String[]{"average linkage", "complete linkage", "single linkage"};

        public String getMethodName() {
            return GeneralInfo.getMethodName(this.method);
        }

        public static String getMethodName(int method) {
            method = method == -1 ? 2 : method;
            return methods[method];
        }
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    HCLGUI.this.progress.setUnits(event.getIntValue());
                    HCLGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    HCLGUI.this.progress.setValue(event.getIntValue());
                    HCLGUI.this.progress.setDescription(event.getDescription());
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                HCLGUI.this.algorithm.abort();
                HCLGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            HCLGUI.this.algorithm.abort();
            HCLGUI.this.progress.dispose();
        }
    }
}

