/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.helpers.IExperimentHeader;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTree;

public class HCLExperimentHeader
extends JPanel {
    private JComponent expHeader;
    private JComponent sampleTree;
    private int headerOffset = 0;
    private HCLTree geneTree;

    public HCLExperimentHeader() {
    }

    public JComponent getHeader() {
        return this.expHeader;
    }

    public void setHeader(JComponent header) {
        this.expHeader = header;
    }

    public HCLExperimentHeader(JComponent expHeader) {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.expHeader = expHeader;
        this.add(this.expHeader);
    }

    public HCLExperimentHeader(JComponent expHeader, JPanel sampleTree) {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.expHeader = expHeader;
        this.add((Component)this.expHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (sampleTree != null) {
            this.sampleTree = sampleTree;
            this.add((Component)this.sampleTree, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public HCLExperimentHeader(JComponent expHeader, JPanel sampleTree, HCLTree geneTree) {
        this(expHeader, sampleTree);
        this.geneTree = geneTree;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.geneTree != null && this.geneTree.showScale) {
            g.setColor(Color.black);
            g.drawLine(10, this.getHeight() - 5, this.headerOffset - 1, this.getHeight() - 5);
            g.drawLine(10, this.getHeight() - 5, 10, this.getHeight() - 10);
            g.drawLine(this.headerOffset / 2 + 5, this.getHeight() - 5, this.headerOffset / 2 + 5, this.getHeight() - 10);
            g.drawLine(this.headerOffset - 1, this.getHeight() - 5, this.headerOffset - 1, this.getHeight() - 10);
            ((Graphics2D)g).rotate(4.71238898038469);
            g.drawString(this.geneTree.getMinHeightDisplay(), -(this.getHeight() - 15), this.headerOffset - 1);
            g.drawString(this.geneTree.getMidHeightDisplay(), -(this.getHeight() - 15), this.headerOffset / 2 + 9);
            g.drawString(this.geneTree.getMaxHeightDisplay(), -(this.getHeight() - 15), 20);
            ((Graphics2D)g).rotate(-4.71238898038469);
        }
    }

    public void setHeaderPosition(int position) {
        this.headerOffset = position;
        this.expHeader.setLocation(position, 0);
        if (this.sampleTree != null) {
            this.sampleTree.setLocation(position, this.getHeight() - this.sampleTree.getHeight());
        }
    }

    public void updateSize(int newWidth, int elementWidth) {
        int sampleTreeSpace = 0;
        if (this.sampleTree != null) {
            sampleTreeSpace = this.sampleTree.getHeight();
        }
        ((IExperimentHeader)this.expHeader).updateSizes(newWidth, elementWidth);
        this.setSizes(newWidth, this.expHeader.getHeight() + sampleTreeSpace);
    }

    private void setSizes(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        if (this.expHeader != null) {
            this.expHeader.addMouseListener(listener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.expHeader.removeMouseListener(listener);
    }

    public void setUseDoubleGradient(boolean useDouble) {
        ((IExperimentHeader)this.expHeader).setUseDoubleGradient(useDouble);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.expHeader);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.expHeader = (JComponent)ois.readObject();
        if (this.expHeader == null) {
            System.out.println("NULL HEADER");
        }
    }
}

