/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;

public class HCLColorBar
extends JPanel {
    private static final int BAR_WIDTH = 10;
    private ArrayList clusters;
    private int featuresSize;
    private boolean isAntiAliasing = true;
    private int elementHeight = 5;

    public HCLColorBar(ArrayList clusters, int featuresSize) {
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 20));
        this.clusters = clusters;
        this.featuresSize = featuresSize;
    }

    public HCLColorBar() {
        this.setBackground(Color.white);
        this.setFont(new Font("monospaced", 0, 20));
    }

    public ArrayList getClusters() {
        return this.clusters;
    }

    public int getFeaturesSize() {
        return this.featuresSize;
    }

    public void setClusters(ArrayList a) {
        this.clusters = a;
    }

    public void setFeaturesSize(int fs) {
        this.featuresSize = fs;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isAntiAliasing) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int x = 10;
        int COUNT_CLUSTERS = this.clusters.size();
        for (int i = 0; i < COUNT_CLUSTERS; ++i) {
            HCLCluster cluster = (HCLCluster)this.clusters.get(i);
            int y = cluster.firstElem * this.elementHeight + this.elementHeight / 2;
            int size = (cluster.lastElem - cluster.firstElem) * this.elementHeight;
            g.setColor(cluster.color);
            g.fillRect(x, y, x + 10, size);
            if (cluster.text == null) continue;
            g.drawString(cluster.text, x + 10 + 10, y + size / 2 + 7);
        }
    }

    public void onSelected(IFramework framework) {
        IDisplayMenu menu = framework.getDisplayMenu();
        this.isAntiAliasing = menu.isAntiAliasing();
        this.setElementHeight(menu.getElementSize().height);
        this.updateSize();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        if (this.elementHeight == menu.getElementSize().height && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = menu.isAntiAliasing();
        this.setElementHeight(menu.getElementSize().height);
        this.updateSize();
    }

    public void onClustersChanged(ArrayList clusters) {
        this.clusters = clusters;
        this.updateSize();
        this.repaint();
    }

    private void setElementHeight(int height) {
        this.elementHeight = height;
    }

    private void updateSize() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        int width = 30 + this.getMaxWidth(g);
        int height = this.elementHeight * this.featuresSize + 1;
        this.setSizes(width, height);
    }

    private int getMaxWidth(Graphics2D g) {
        if (g == null || this.clusters == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        int size = this.clusters.size();
        for (int i = 0; i < size; ++i) {
            HCLCluster cluster = (HCLCluster)this.clusters.get(i);
            if (cluster == null) continue;
            String str = cluster.text == null ? "" : cluster.text;
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }

    private void setSizes(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }
}

