/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.hcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class HCLAnnotationBar
extends JPanel {
    private IData data;
    private int[] rowsOrder;
    private boolean isAntiAliasing = true;
    private int elementHeight = 5;
    private int maxUniqueIDWidth;
    private int maxGeneNameWidth;

    public HCLAnnotationBar(int[] rowsOrder) {
        this.rowsOrder = rowsOrder;
        this.setBackground(Color.white);
        this.setSizes(10, 10);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isAntiAliasing) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle bounds = g.getClipBounds();
        int top = this.getTopIndex(bounds.y);
        int bottom = this.getBottomIndex(bounds.y + bounds.height, this.rowsOrder.length);
        g.setColor(Color.black);
        int uniqX = 10;
        int nameX = uniqX + 10 + this.maxUniqueIDWidth;
        for (int row = top; row < bottom; ++row) {
            int annY = (row + 1) * this.elementHeight;
            g.drawString(this.data.getUniqueId(this.rowsOrder[row]), uniqX, annY);
            g.drawString(this.data.getGeneName(this.rowsOrder[row]), nameX, annY);
        }
    }

    private int getTopIndex(int top) {
        if (top < 0) {
            return 0;
        }
        return top / this.elementHeight;
    }

    private int getBottomIndex(int bottom, int limit) {
        if (bottom < 0) {
            return 0;
        }
        int result = bottom / this.elementHeight + 1;
        return result > limit ? limit : result;
    }

    public void onSelected(IFramework framework) {
        this.data = framework.getData();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.isAntiAliasing = menu.isAntiAliasing();
        this.setElementHeight(menu.getElementSize().height);
        this.updateSize();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        if (this.elementHeight == menu.getElementSize().height && this.isAntiAliasing == menu.isAntiAliasing()) {
            return;
        }
        this.isAntiAliasing = menu.isAntiAliasing();
        this.setElementHeight(menu.getElementSize().height);
        this.updateSize();
    }

    private void setElementHeight(int height) {
        this.elementHeight = height;
        this.setFont(new Font("monospaced", 0, height));
    }

    private void updateSize() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.maxGeneNameWidth = this.getMaxWidth(g, true);
        this.maxUniqueIDWidth = this.getMaxWidth(g, false);
        int width = 20 + this.maxGeneNameWidth + this.maxUniqueIDWidth;
        int height = this.elementHeight * this.rowsOrder.length + 1;
        this.setSizes(width, height);
    }

    private int getMaxWidth(Graphics2D g, boolean genename) {
        if (g == null || this.data == null) {
            return 0;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fm = g.getFontMetrics();
        int max = 0;
        int size = this.data.getFeaturesSize();
        for (int i = 0; i < size; ++i) {
            String str = genename ? this.data.getGeneName(i) : this.data.getUniqueId(i);
            max = Math.max(max, fm.stringWidth(str));
        }
        return max;
    }

    private void setSizes(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }
}

