/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsh;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class GSHInitDialog
extends AlgorithmDialog {
    private int result;
    private JTextField textField1;
    private JTextField textField2;
    private JTextField textField3;
    private SampleSelectionPanel sampleSelectionPanel;
    private HCLSelectionPanel hclOpsPanel;

    public GSHInitDialog(Frame parent, int clusters, int fm, int st) {
        super(parent, "GSH: Gene Shaving", true);
        Listener listener = new Listener();
        this.addWindowListener(listener);
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        ParameterPanel parameters = new ParameterPanel();
        parameters.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        parameters.add((Component)new JLabel("Number of clusters"), gbc);
        gbc.gridy = 1;
        parameters.add((Component)new JLabel("Number of permuted matrices"), gbc);
        gbc.gridy = 2;
        parameters.add((Component)new JLabel("Number of permutations/matrix"), gbc);
        gbc.gridwidth = 2;
        this.textField1 = new JTextField(String.valueOf(clusters), 5);
        this.textField2 = new JTextField(String.valueOf(fm), 5);
        this.textField3 = new JTextField(String.valueOf(st), 5);
        gbc.insets = new Insets(0, 10, 10, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        parameters.add((Component)this.textField1, gbc);
        gbc.gridy = 1;
        parameters.add((Component)this.textField2, gbc);
        gbc.gridy = 2;
        parameters.add((Component)this.textField3, gbc);
        this.hclOpsPanel = new HCLSelectionPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setBackground(Color.white);
        contentPanel.add((Component)this.sampleSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)parameters, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)this.hclOpsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(contentPanel);
        this.setActionListeners(listener);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public int getClusters() {
        return Integer.parseInt(this.textField1.getText());
    }

    public boolean isClusterGenesSelected() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public int getFM() {
        return Integer.parseInt(this.textField2.getText());
    }

    public int getST() {
        return Integer.parseInt(this.textField2.getText());
    }

    public boolean isHierarchicalTree() {
        return this.hclOpsPanel.isHCLSelected();
    }

    private void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.textField1.setText("10");
        this.textField2.setText("20");
        this.textField3.setText("5");
    }

    private boolean validInput(int k, int p, int s) {
        boolean valid = true;
        if (k < 1) {
            JOptionPane.showMessageDialog(this, "Number of clusters must be > 0", "Input Error!", 0);
            this.textField1.requestFocus();
            this.textField1.selectAll();
            valid = false;
        } else if (p <= 0) {
            JOptionPane.showMessageDialog(this, "Number of permuted matricies must be > 0", "Input Error!", 0);
            this.textField2.requestFocus();
            this.textField2.selectAll();
            valid = false;
        } else if (s < 0) {
            JOptionPane.showMessageDialog(this, "Number permutations must be >= 0", "Input Error!", 0);
            this.textField3.requestFocus();
            this.textField3.selectAll();
            valid = false;
        }
        return valid;
    }

    public static void main(String[] args) {
        GSHInitDialog dlg = new GSHInitDialog(new Frame(), 0, 0, 0);
        dlg.showModal();
        System.exit(0);
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("ok-command")) {
                int s;
                int p;
                int k;
                int progress = 0;
                try {
                    k = Integer.parseInt(GSHInitDialog.this.textField1.getText());
                    ++progress;
                    p = Integer.parseInt(GSHInitDialog.this.textField2.getText());
                    ++progress;
                    s = Integer.parseInt(GSHInitDialog.this.textField3.getText());
                    ++progress;
                    GSHInitDialog.this.result = 0;
                }
                catch (NumberFormatException nfe) {
                    if (progress == 0) {
                        GSHInitDialog.this.textField1.requestFocus();
                        GSHInitDialog.this.textField1.selectAll();
                    } else if (progress == 1) {
                        GSHInitDialog.this.textField2.requestFocus();
                        GSHInitDialog.this.textField2.selectAll();
                    } else if (progress == 2) {
                        GSHInitDialog.this.textField3.requestFocus();
                        GSHInitDialog.this.textField3.selectAll();
                    }
                    JOptionPane.showMessageDialog(GSHInitDialog.this, "Number format error.", "Number Format Error", 0);
                    GSHInitDialog.this.result = 2;
                    return;
                }
                if (GSHInitDialog.this.validInput(k, p, s)) {
                    GSHInitDialog.this.dispose();
                } else {
                    GSHInitDialog.this.result = 2;
                }
            } else if (command.equals("cancel-command")) {
                GSHInitDialog.this.result = 2;
                GSHInitDialog.this.dispose();
            } else if (command.equals("reset-command")) {
                GSHInitDialog.this.resetControls();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(GSHInitDialog.this, "GSH Initialization Dialog");
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            GSHInitDialog.this.result = -1;
            GSHInitDialog.this.dispose();
        }
    }
}

