/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class TestStatisticViewer
extends JPanel
implements IViewer {
    private LinkedHashMap<String, Float> sortedTestStats = new LinkedHashMap();
    private Object[] genes;
    private Object[] testStats;
    private boolean isAntiAliasing = false;
    private static final Color bColor = new Color(0, 0, 128);
    private DecimalFormat coordinateFormat;
    private FontMetrics metrics;
    private float stepsY;
    private float minYVal;
    private float maxYValue;
    private boolean referenceLinesOn = true;
    private int xOldEvent;
    private int yOldEvent;
    private boolean mouseInside = false;
    private boolean showCoordinates = true;
    private JPopupMenu popup;
    private EventListener eventListener;

    public TestStatisticViewer(LinkedHashMap<String, Float> linkedHashMap) {
        this.sortedTestStats = linkedHashMap;
        this.genes = new String[this.sortedTestStats.keySet().size()];
        this.testStats = new Float[this.genes.length];
        this.genes = this.sortedTestStats.keySet().toArray();
        this.testStats = this.sortedTestStats.values().toArray();
        this.setBackground(Color.WHITE);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
        this.eventListener = new Listener();
        this.addMouseMotionListener((MouseMotionListener)this.eventListener);
        this.addMouseListener((MouseListener)this.eventListener);
    }

    public float getmaxYValue() {
        float f = Float.MIN_VALUE;
        Iterator<String> iterator = this.sortedTestStats.keySet().iterator();
        while (iterator.hasNext()) {
            float f2 = this.sortedTestStats.get(iterator.next()).floatValue();
            if (Float.isNaN(f2)) continue;
            f = Math.max(f2, f);
        }
        return f;
    }

    public void setCurrentMaxYValue(float f) {
        if (!Float.isNaN(f)) {
            this.maxYValue = f;
        }
    }

    public float getCurrentMaxYValue() {
        return this.maxYValue;
    }

    public float getMinYValue() {
        float f = Float.MAX_VALUE;
        Iterator<String> iterator = this.sortedTestStats.keySet().iterator();
        while (iterator.hasNext()) {
            float f2 = this.sortedTestStats.get(iterator.next()).floatValue();
            if (Float.isNaN(f2)) continue;
            f = Math.min(f2, f);
        }
        return f;
    }

    public void setCurrentMinYValue(float f) {
        if (!Float.isNaN(f)) {
            this.minYVal = f;
        }
    }

    public float getCurrentMinYValue() {
        return this.minYVal;
    }

    public int getMaxXValue() {
        return this.sortedTestStats.size();
    }

    public void setStepsY(float f) {
        this.stepsY = f;
    }

    public float getStepsY() {
        return this.stepsY;
    }

    public FontMetrics getFontMetric() {
        return this.metrics;
    }

    public void setFontMetric(FontMetrics fontMetrics) {
        this.metrics = fontMetrics;
    }

    public JComponent getContentComponent() {
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        super.paint(graphics2D);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.setFontMetric(fontMetrics);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (rectangle.width < 5 || rectangle.height < 5) {
            return;
        }
        float f = -1.0f;
        float f2 = Math.max(Math.abs(this.getmaxYValue()), Math.abs(this.getMinYValue()));
        float f3 = this.getMinYValue();
        if (f2 <= 0.0f || f2 < 1.0f) {
            f2 = Math.max(1.0f, Math.abs(f2));
            f3 = this.stepsY = f2 / 5.0f;
            this.setCurrentMaxYValue(f2);
            this.setCurrentMinYValue(f3);
        } else {
            this.stepsY = this.getMinYValue() < 0.0f ? (f2 - f3) / 5.0f : (f2 + f3) / 5.0f;
            this.setCurrentMaxYValue(f2);
            this.setCurrentMinYValue(f3);
        }
        this.setStepsY(this.stepsY);
        Rectangle rectangle2 = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        if (n5 + rectangle2.width > this.getWidth()) {
            n4 = n5 + rectangle2.width - this.getWidth();
            rectangle2 = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - this.getMaximumStringWidth() - n4 - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        }
        n4 = rectangle2.width;
        int n7 = rectangle2.height;
        int n8 = n6 + Math.round((float)n7 / 2.0f);
        int n9 = this.getMaxXValue();
        float f4 = (float)n7 / (2.0f * f2);
        float f5 = (float)n4 / (float)n9;
        graphics2D.setStroke(new BasicStroke(2.0f));
        String string = "Genes";
        String string2 = "Test Statistic";
        Font font = new Font("Dialog", 0, 12);
        graphics2D.setFont(font);
        graphics2D.drawString(string, this.getWidth() / 2, this.getHeight());
        graphics2D.rotate(-1.5707963267948966, n5 - this.getMaximumStringWidth() - 18, n8);
        graphics2D.drawString(string2, n5 - this.getMaximumStringWidth() - 18, n8);
        graphics2D.rotate(1.5707963267948966, n5 - this.getMaximumStringWidth() - 18, n8);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n5, n6, n4, n7);
        graphics2D.setColor(Color.GREEN);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.drawLine(n5, n8, n5 + n4, n8);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
        for (int i = 1; i <= this.getMaxXValue(); ++i) {
            graphics2D.drawLine(n5 + Math.round((float)i * f5), n6 + n7 - 5, n5 + Math.round((float)i * f5), n6 + n7);
            graphics2D.drawLine(n5 + Math.round((float)i * f5), n6, n5 + Math.round((float)i * f5), n6 + 5);
        }
        for (float f6 = this.stepsY; f6 <= f2; f6 += this.stepsY) {
            graphics2D.drawLine(n5, n8 - Math.round(f6 * f4), n5 + 5, n8 - Math.round(f6 * f4));
            graphics2D.drawLine(n5, n8 + Math.round(f6 * f4), n5 + 5, n8 + Math.round(f6 * f4));
        }
        graphics2D.rotate(-1.5707963267948966);
        int n10 = this.getNamesWidth(fontMetrics);
        for (int i = 1; i < n9 + 1; ++i) {
            graphics2D.drawString((String)this.genes[i - 1], -n7 - n6 - 10 - n10, n5 + Math.round((float)i * f5) + 3);
        }
        graphics2D.rotate(1.5707963267948966);
        graphics2D.setColor(bColor);
        int n11 = this.getMaximumStringWidth();
        for (float f7 = this.stepsY; f7 < f2 + 1.0f + this.stepsY; f7 += this.stepsY) {
            String string3 = this.coordinateFormat.format(f7);
            graphics2D.drawString(string3, n5 - 10 - n11, n8 + 5 - Math.round(f7 * f4));
            string3 = this.coordinateFormat.format(-f7);
            graphics2D.drawString(string3, n5 - 10 - n11, n8 + 5 + Math.round(f7 * f4));
        }
        graphics2D.drawString(this.getMaxXValue() + " Genes", n5 + 10, n6 + 20);
        Iterator<String> iterator = this.sortedTestStats.keySet().iterator();
        graphics2D.setColor(new Color(255, 140, 0));
        graphics2D.setStroke(new BasicStroke(6.0f));
        for (n3 = 1; n3 < n9 + 1; ++n3) {
            int n12;
            int n13;
            int n14;
            int n15;
            float f8 = Float.valueOf(this.sortedTestStats.get(iterator.next()).floatValue()).floatValue();
            if (n3 == 1) {
                f = f8;
            }
            n2 = n5 + Math.round((float)n3 * f5) + 3;
            if (f8 < 0.0f) {
                n15 = n8 - Math.round(f8 * f4);
                graphics2D.setStroke(new BasicStroke(6.0f));
                graphics2D.drawLine(n2, n15, n2, n15);
                if (n3 == 1) continue;
                n14 = n5 + Math.round((float)(n3 - 1) * f5) + 3;
                n13 = n8 - Math.round(f * f4);
                n12 = n5 + Math.round((float)n3 * f5) + 3;
                n = n15;
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.drawLine(n14, n13, n12, n);
                f = f8;
                continue;
            }
            if (!(f8 >= 0.0f)) continue;
            n15 = n8 - Math.round(f8 * f4);
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.drawLine(n2, n15, n2, n15);
            if (n3 == 1) continue;
            n14 = n5 + Math.round((float)(n3 - 1) * f5) + 3;
            n13 = n8 - Math.round(f * f4);
            n12 = n5 + Math.round((float)n3 * f5) + 3;
            n = n15;
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawLine(n14, n13, n12, n);
            f = f8;
        }
        if (this.referenceLinesOn) {
            n3 = this.getXOldEvent();
            int n16 = this.getYOldEvent();
            double d = 0.0;
            double d2 = 0.0;
            int n17 = n = n3 <= n4 + n5 && n3 >= n5 && n16 <= n6 + n7 && n16 >= n6 ? 1 : 0;
            if (n != 0) {
                this.setCursor(1);
                d = Math.round((float)(n3 - n5) / f5) - 1;
                d2 = (this.getCurrentMinYValue() - (float)n16) / f4 + this.getCurrentMinYValue();
                if (this.showCoordinates) {
                    n2 = fontMetrics.stringWidth(this.coordinateFormat.format(d) + ", " + this.coordinateFormat.format(d2));
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    if ((int)d < this.genes.length + 1 && (int)d >= 0) {
                        graphics2D.setColor(Color.blue);
                        graphics2D.setComposite(composite);
                        graphics2D.setColor(bColor);
                        graphics2D.drawString("Gene: " + this.genes[(int)d], n3, n16 - 20);
                        graphics2D.drawString("Test stat:" + this.testStats[(int)d].toString(), n3, n16);
                    }
                }
            } else {
                this.setCursor(0);
            }
        }
    }

    public int getMaximumStringWidth() {
        int n = Integer.MIN_VALUE;
        float f = this.getStepsY();
        for (float f2 = this.getMinYValue(); f2 <= this.getmaxYValue(); f2 += f) {
            String string = this.coordinateFormat.format(f2);
            int n2 = this.metrics.stringWidth(string);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.metrics.stringWidth(string = this.coordinateFormat.format(-f2))) <= n) continue;
            n = n2;
        }
        return n;
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    protected int getNamesWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 1; i <= this.getMaxXValue(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth((String)this.genes[i - 1]));
        }
        return n;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.sortedTestStats});
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
    }

    public void setExperiment(Experiment experiment) {
    }

    public void setExperimentID(int n) {
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setXOldEvent(int n) {
        this.xOldEvent = n;
    }

    public int getXOldEvent() {
        return this.xOldEvent;
    }

    public void setYOldEvent(int n) {
        this.yOldEvent = n;
    }

    public int getYOldEvent() {
        return this.yOldEvent;
    }

    private class Listener
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Reference Lines") {
                TestStatisticViewer.this.referenceLinesOn = !TestStatisticViewer.this.referenceLinesOn;
                TestStatisticViewer.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            TestStatisticViewer.this.setXOldEvent(n);
            TestStatisticViewer.this.setYOldEvent(n2);
            TestStatisticViewer.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 4) {
                TestStatisticViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TestStatisticViewer.this.setXOldEvent(-1);
            TestStatisticViewer.this.setYOldEvent(-1);
            TestStatisticViewer.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

