/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.GSEAURLLinkDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.TableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class TestStatisticTableViewer
extends TableViewer {
    private static final String SAVE_TABLE_COMMAND = "save_table_command";
    private static final String STORE_CLUSTER_COMMAND = "store_cluster_command";
    private static final String LINK_TO_URL_COMMAND = "link-to-url-command";
    private static final String CLEAR_ALL_COMMAND = "clear-all-cmd";
    private static final String SELECT_ALL_COMMAND = "select-all-cmd";
    private DefaultMutableTreeNode gseaRoot;
    private JPopupMenu menu = this.createPopupMenu();
    private int[][] clusters;
    private JMenuItem urlMenuItem;
    int xColumn;

    public TestStatisticTableViewer(String[] stringArray, Object[][] objectArray) {
        super(stringArray, objectArray);
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new Listener());
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.headerNames, this.data});
    }

    protected JPopupMenu createPopupMenu() {
        Listener listener = new Listener();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Store Selection as Cluster");
        jMenuItem.setActionCommand(STORE_CLUSTER_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(SAVE_TABLE_COMMAND);
        jMenuItem.setActionCommand(SAVE_TABLE_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon("TableViewerResult.gif"));
        jMenuItem.setActionCommand(SELECT_ALL_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon("TableViewerResult.gif"));
        jMenuItem.setActionCommand(CLEAR_ALL_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.urlMenuItem = new JMenuItem("Link to URL");
        this.urlMenuItem.setActionCommand(LINK_TO_URL_COMMAND);
        this.urlMenuItem.addActionListener(listener);
        jPopupMenu.add(this.urlMenuItem);
        return jPopupMenu;
    }

    public void onSelected(IFramework iFramework) {
        super.onSelected(iFramework);
        if (this.gseaRoot == null) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iFramework.getCurrentNode().getParent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof String && ((String)object).indexOf("GSEA") != -1) {
                    this.gseaRoot = defaultMutableTreeNode;
                }
            }
            catch (Exception exception) {
                System.out.println("selection exception");
                exception.printStackTrace();
            }
        }
    }

    private void linkToURL2() {
        JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(this.table);
        this.xColumn = this.table.getSelectedColumn();
        String string = this.table.getColumnName(this.xColumn);
        String string2 = (String)this.table.getValueAt(this.table.getSelectedRow(), this.xColumn);
        File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
        GSEAURLLinkDialog gSEAURLLinkDialog = new GSEAURLLinkDialog(jFrame, false, string2, this.table.getSelectedRow(), string, file);
        gSEAURLLinkDialog.setVisible(true);
    }

    protected void onStoreSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((TableViewer.DefaultViewerTableModel)this.model).getRow(nArray[i]);
        }
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String string = "";
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                int n = nArray.length;
                int n2 = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        printWriter.print((String)this.table.getValueAt(nArray[i], j) + "\t");
                    }
                    printWriter.print("\n");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + string, "Output Error", 2);
            }
        }
    }

    protected void onSaveTable() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String string = "";
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                int n = this.table.getRowCount();
                int n2 = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        printWriter.print((String)this.table.getValueAt(i, j) + "\t");
                    }
                    printWriter.print("\n");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + string, "Output Error", 2);
            }
        }
    }

    protected int[] getGeneIndices(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += this.clusters[nArray[i]].length;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.clusters[nArray[i]].length; ++j) {
                nArray2[n2] = this.clusters[nArray[i]][j];
                ++n2;
            }
        }
        return nArray2;
    }

    protected void validateMenuOptions() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
    }

    protected class Listener
    extends MouseAdapter
    implements ActionListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(TestStatisticTableViewer.LINK_TO_URL_COMMAND)) {
                TestStatisticTableViewer.this.linkToURL2();
            } else if (string.equals(TestStatisticTableViewer.STORE_CLUSTER_COMMAND)) {
                TestStatisticTableViewer.this.onStoreSelectedRows();
            } else if (string.equals(TestStatisticTableViewer.SAVE_TABLE_COMMAND)) {
                TestStatisticTableViewer.this.onSaveTable();
            } else if (string.equals(TestStatisticTableViewer.CLEAR_ALL_COMMAND)) {
                TestStatisticTableViewer.this.table.clearSelection();
            } else if (string.equals(TestStatisticTableViewer.SELECT_ALL_COMMAND)) {
                TestStatisticTableViewer.this.table.selectAll();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (TestStatisticTableViewer.this.table.getSelectedRowCount() != 1) {
                    TestStatisticTableViewer.this.urlMenuItem.setEnabled(false);
                } else {
                    TestStatisticTableViewer.this.urlMenuItem.setEnabled(true);
                }
                TestStatisticTableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TestStatisticTableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

