/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.tigr.microarray.mev.file.GBA;

public class ProcessDisplayPanel
extends JPanel {
    private GBA gba = new GBA();
    private boolean isTextDisplay;
    private String[] stepTitles;
    private JTextPane processPane;

    public ProcessDisplayPanel(boolean bl, String[] stringArray) {
        this.setBackground(Color.white);
        this.isTextDisplay = bl;
        this.stepTitles = stringArray;
        this.constructPanel();
    }

    private void constructPanel() {
        this.setLayout(new GridBagLayout());
        this.processPane = new JTextPane();
        this.processPane.setEditable(false);
        this.processPane.setContentType("text/html");
        this.processPane.setOpaque(false);
        this.processPane.setMargin(new Insets(10, 10, 10, 10));
        Document document = this.processPane.getDocument();
        String string = "<html><font face=\"MS Sans Serif\"><b><u>Process Outline</u></b><br><br>";
        try {
            document.insertString(document.getLength(), string, null);
            for (int i = 0; i < this.stepTitles.length; ++i) {
                string = string + String.valueOf(i + 1);
                string = string + ".) ";
                string = string + this.stepTitles[i] + "<br><br>";
            }
            string = string + "</font></html>";
            this.processPane.setText(string);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.setHighlight(0);
        this.add((Component)this.processPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setHighlight(int n) {
        try {
            Highlighter highlighter;
            Document document = this.processPane.getDocument();
            String string = document.getText(0, document.getLength());
            int n2 = string.indexOf(n + 1 + ".)");
            int n3 = string.indexOf(".", n2 + 2) + 1;
            if (n3 < 0) {
                n3 = string.length();
            }
            if (n2 > -1 && (highlighter = this.processPane.getHighlighter()) != null) {
                highlighter.removeAllHighlights();
                highlighter.addHighlight(n2, n3, new MyHighlightPainter(new Color(200, 200, 255)));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        GradientPaint gradientPaint = new GradientPaint(0.0f, this.getHeight() / 2, new Color(210, 210, 255), this.getWidth() / 4, this.getHeight() / 2, Color.white, false);
        ((Graphics2D)graphics).setPaint(gradientPaint);
        graphics.fillRect(0, 0, this.getWidth() / 2, this.getHeight());
        gradientPaint = new GradientPaint(this.getWidth(), this.getHeight() / 2, new Color(210, 210, 255), this.getWidth() * 3 / 4, this.getHeight() / 2, Color.white, false);
        ((Graphics2D)graphics).setPaint(gradientPaint);
        graphics.fillRect(this.getWidth() / 2, 0, this.getWidth(), this.getHeight());
        this.processPane.paint(graphics);
    }

    public static void main(String[] stringArray) {
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

