/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.GeneAnnotationImportDialog;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.annotation.AnnotationFieldConstants;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSet;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSetList;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAConstants;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAInitWizard;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SelectMultiFilesDialog;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.microarray.util.FileLoaderUtility;
import org.tigr.util.swing.GeneMatrixFileFilter;
import org.tigr.util.swing.GeneMatrixTransposeFileFilter;
import org.tigr.util.swing.TXTFileFilter;

public class ParameterPanel
extends JPanel
implements IWizardParameterPanel {
    private static final long serialVersionUID = 1L;
    private JPanel parameterPanel;
    private JLabel probe2GeneLabel;
    private JComboBox choiceBox;
    private JLabel minGeneLabel;
    private JTextField geneNumber;
    private JLabel SDCutoffLabel;
    private JTextField sdTextField;
    private JLabel permutationLabel;
    private JTextField permutationTextField;
    private IFramework fwork;
    private GBA gba;
    private JPanel genesetPanel;
    private JPanel choicePanel;
    private JPanel fileSelectionPanel;
    private JPanel buttonPanel;
    private JPanel listPanel;
    private JPanel selectFilePanel;
    private JPanel identifierSelectionPanel;
    private JLabel selectFile;
    private JLabel availableLabel;
    private JLabel selectedLabel;
    private JList availableList;
    private JList selectedList;
    private JButton addButton;
    private JButton addAllButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private JScrollPane availableScrollPane;
    private JScrollPane selectedScrollPane;
    private JLabel errorMessageLabel;
    private JTextField pathTextField;
    private JButton browseOrDownload = new JButton("");
    private JLabel geneIdentifierLabel;
    private JComboBox geneIdentifierBox;
    private JComboBox geneSetSelectionBox;
    private JLabel genesetSelectionLabel;
    private String genesetFilePath;
    private String fileFilter = new String();
    private FileResourceManager frm;
    private JPanel annotationPanel;
    private AnnotationDownloadHandler adh;
    private AlgorithmData algData;
    private GSEAInitWizard gseaInitWizard;
    private boolean filesLoaded = false;
    private JPanel genesetPanel2;
    private boolean browseOnce;

    public ParameterPanel(AlgorithmData algorithmData, JFrame jFrame, IFramework iFramework, GSEAInitWizard gSEAInitWizard) {
        this.algData = algorithmData;
        this.fwork = iFramework;
        this.gseaInitWizard = gSEAInitWizard;
        this.initializePanel();
        this.initialize(GSEAConstants.MAX_PROBE, Integer.toString(5), "0.6", Integer.toString(1000));
    }

    public void initializePanel() {
        int n;
        this.setPreferredSize(new Dimension(650, 700));
        this.setSize(new Dimension(650, 700));
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.gba = new GBA();
        String[] stringArray = new String[]{"Max Probe", "Median Probe", "Standard Deviation"};
        this.probe2GeneLabel = new JLabel();
        this.probe2GeneLabel.setText("Select a method to collapse probes: ");
        this.probe2GeneLabel.setHorizontalTextPosition(2);
        this.choiceBox = new JComboBox<String>(stringArray);
        this.choiceBox.addActionListener(new Listener());
        this.SDCutoffLabel = new JLabel();
        this.SDCutoffLabel.setText("Select a Standard Deviation cutoff: ");
        this.SDCutoffLabel.setHorizontalTextPosition(2);
        this.SDCutoffLabel.setVisible(false);
        this.sdTextField = new JTextField();
        this.sdTextField.setPreferredSize(new Dimension(120, 30));
        this.sdTextField.setMinimumSize(new Dimension(120, 30));
        this.sdTextField.setEditable(true);
        this.sdTextField.setVisible(false);
        this.sdTextField.setActionCommand("standard-deviation");
        this.minGeneLabel = new JLabel();
        this.minGeneLabel.setText("Minimum number of genes per gene set: ");
        this.minGeneLabel.setHorizontalTextPosition(2);
        this.geneNumber = new JTextField();
        this.geneNumber.setPreferredSize(new Dimension(120, 30));
        this.geneNumber.setMinimumSize(new Dimension(120, 30));
        this.geneNumber.setEditable(true);
        this.geneNumber.setActionCommand("gene-number");
        this.permutationLabel = new JLabel();
        this.permutationLabel.setText("Enter number of permutations: ");
        this.permutationLabel.setHorizontalTextPosition(2);
        this.permutationTextField = new JTextField();
        this.permutationTextField.setPreferredSize(new Dimension(120, 30));
        this.permutationTextField.setMinimumSize(new Dimension(120, 30));
        this.permutationTextField.setEditable(true);
        this.permutationTextField.setActionCommand("permutations");
        this.parameterPanel = new JPanel();
        this.parameterPanel.setBackground(Color.WHITE);
        this.parameterPanel.setLayout(new GridBagLayout());
        this.parameterPanel.setBorder(new TitledBorder(new EtchedBorder(), "Step 1", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.parameterPanel, (Component)this.probe2GeneLabel, 0, 0, 1, 1, 1, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.choiceBox, 2, 0, -1, 1, 0, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.SDCutoffLabel, 0, 4, 2, 1, 1, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.sdTextField, 2, 4, -1, 1, 0, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.minGeneLabel, 0, 7, 2, 1, 1, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.geneNumber, 2, 7, -1, 1, 0, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.permutationLabel, 0, 8, 2, 1, 1, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.permutationTextField, 2, 8, -1, 1, 0, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.genesetPanel = new JPanel();
        this.genesetPanel.setBackground(Color.WHITE);
        this.genesetPanel.setLayout(new GridBagLayout());
        this.genesetPanel.setBorder(new TitledBorder(new EtchedBorder(), "Step 2", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.genesetPanel2 = new JPanel();
        this.genesetPanel2.setBackground(Color.WHITE);
        this.genesetPanel2.setLayout(new GridBagLayout());
        this.genesetPanel2.setBorder(new TitledBorder(new EtchedBorder(), "Step 3", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.choicePanel = new JPanel();
        this.choicePanel.setBackground(Color.white);
        this.choicePanel.setLayout(new GridBagLayout());
        this.genesetSelectionLabel = new JLabel("Import Gene List:  ");
        this.genesetSelectionLabel.setForeground(Color.red);
        String[] stringArray2 = new String[]{"-Gene List Location-", "Load local geneset file/files", "Download from MSigDB", "Download from GeneSigDB"};
        this.geneSetSelectionBox = new JComboBox<String>(stringArray2);
        this.geneSetSelectionBox.addActionListener(new Listener());
        this.createDownloadPanel("Select the directory containing your gene sets", "init", "browse");
        this.gba.add((Container)this.choicePanel, (Component)this.genesetSelectionLabel, 0, 0, 1, 1, 1, 0, 2, 13, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.choicePanel, (Component)this.geneSetSelectionBox, 1, 0, 1, 1, 1, 0, 2, 13, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.choicePanel, (Component)this.browseOrDownload, 2, 0, 1, 1, 1, 0, 2, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.identifierSelectionPanel = new JPanel();
        this.identifierSelectionPanel.setLayout(new GridBagLayout());
        this.identifierSelectionPanel.setBackground(Color.white);
        this.geneIdentifierLabel = new JLabel("Select the identifier used to annotate genes in selected gene set(s):  ");
        this.geneIdentifierLabel.setForeground(Color.red);
        Field[] fieldArray = AnnotationFieldConstants.class.getFields();
        String[] stringArray3 = new String[fieldArray.length + 1];
        stringArray3[0] = "-Annotation Type-";
        try {
            for (n = 0; n < fieldArray.length; ++n) {
                stringArray3[n + 1] = (String)fieldArray[n].get(new AnnotationFieldConstants());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.geneIdentifierBox = new JComboBox<String>(stringArray3);
        this.geneIdentifierBox.addActionListener(new Listener());
        this.gba.add((Container)this.identifierSelectionPanel, (Component)this.geneIdentifierLabel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.identifierSelectionPanel, (Component)this.geneIdentifierBox, 0, 1, 1, 1, 0, 0, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.choicePanel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.fileSelectionPanel, 0, 1, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel2, (Component)this.identifierSelectionPanel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.annotationPanel = new JPanel();
        this.annotationPanel.setLayout(new GridBagLayout());
        this.annotationPanel.setBorder(new EtchedBorder());
        this.adh = new AnnotationDownloadHandler(this.fwork);
        n = 1;
        if (this.fwork.getData().isAnnotationLoaded()) {
            n = 0;
            this.annotationPanel.setVisible(false);
            this.adh.setOptionalMessage("Annotation is already loaded for array " + this.fwork.getData().getChipAnnotation().getChipType());
            this.adh.setAnnFilePath(this.fwork.getData().getChipAnnotation().getAnnFileName());
        }
        this.adh.addListener((ActionListener)new Listener());
        this.annotationPanel = this.adh.getAnnotationLoaderPanel(this.gba);
        this.annotationPanel.setBackground(Color.white);
        this.annotationPanel.setBorder(new TitledBorder(new EtchedBorder(), "Step 4", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.adh.setDownloadEnabled(!this.fwork.getData().isAnnotationLoaded());
        this.gba.add((Container)this, (Component)this.parameterPanel, 0, 0, 1, 1, 1, 1, 1, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this, (Component)this.genesetPanel, 0, 1, 1, 1, 100, 100, 1, 13, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this, (Component)this.genesetPanel2, 0, 2, 1, 1, 100, 100, 1, 13, new Insets(2, 2, 2, 2), 0, 0);
        if (n != 0) {
            this.gba.add((Container)this, (Component)this.annotationPanel, 0, 3, 1, 1, 1, 1, 1, 13, new Insets(2, 2, 2, 2), 0, 0);
        }
        this.revalidate();
        this.gseaInitWizard.setParamSufficient(false);
        this.listPanel.setVisible(false);
        this.listPanel.setEnabled(false);
    }

    public void initialize(String string, String string2, String string3, String string4) {
        this.choiceBox.setSelectedItem(string);
        this.geneNumber.setText(string2);
        this.sdTextField.setText(string3);
        this.permutationTextField.setText(string4);
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("probe_value");
        this.algData.getParams().getMap().remove("gene-number");
        this.algData.getParams().getMap().remove("standard-deviation-cutoff");
        this.algData.getParams().getMap().remove("permutations");
    }

    @Override
    public void onDisplayed() {
    }

    public void createDownloadPanel(String string, String string2, String string3) {
        this.fileSelectionPanel = new JPanel();
        this.fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileSelectionPanel.setBackground(Color.white);
        this.selectFilePanel = new JPanel();
        this.selectFilePanel.setLayout(new GridBagLayout());
        this.selectFilePanel.setBackground(Color.white);
        this.selectFile = new JLabel(string);
        this.pathTextField = new JTextField();
        if (string3.equalsIgnoreCase("msigdb_download")) {
            this.pathTextField.setEditable(true);
        }
        this.pathTextField.setFont(new Font("monospaced", 1, 12));
        this.pathTextField.setPreferredSize(new Dimension(200, 20));
        this.browseOrDownload.setName(string2);
        this.browseOrDownload.setText(string2);
        this.browseOrDownload.setActionCommand(string3);
        this.browseOrDownload.setSize(new Dimension(100, 30));
        this.browseOrDownload.setPreferredSize(new Dimension(100, 30));
        this.browseOnce = false;
        this.browseOrDownload.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ParameterPanel.this.browseOnce) {
                    return;
                }
                ParameterPanel.this.browseOnce = true;
                if (actionEvent.getActionCommand().equalsIgnoreCase("browse")) {
                    ParameterPanel.this.onBrowse();
                    ParameterPanel.this.listPanel.setEnabled(true);
                } else if (actionEvent.getActionCommand().equalsIgnoreCase("msigdb_download")) {
                    if (ParameterPanel.this.pathTextField.getText().length() > 0) {
                        ParameterPanel.this.errorMessageLabel.setText("");
                        ParameterPanel.this.BROADDownloads(ParameterPanel.this.pathTextField.getText());
                        ParameterPanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                        ParameterPanel.this.geneIdentifierBox.setEnabled(false);
                        ParameterPanel.this.filesLoaded = true;
                        ParameterPanel.this.browseOrDownload.setEnabled(false);
                        ParameterPanel.this.geneSetSelectionBox.setEnabled(false);
                        ParameterPanel.this.genesetSelectionLabel.setForeground(Color.black);
                    } else {
                        String string = "<html><font color=red>Please enter your registered MSigDB email address<br> </font></html>";
                        ParameterPanel.this.errorMessageLabel.setText(string);
                    }
                } else if (actionEvent.getActionCommand().equalsIgnoreCase("genesigdb_download")) {
                    ParameterPanel.this.GeneSigDBDownloads();
                    ParameterPanel.this.filesLoaded = true;
                    ParameterPanel.this.browseOrDownload.setEnabled(false);
                    ParameterPanel.this.geneSetSelectionBox.setEnabled(false);
                    ParameterPanel.this.genesetSelectionLabel.setForeground(Color.black);
                    ParameterPanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                    ParameterPanel.this.geneIdentifierBox.setEnabled(false);
                }
                ParameterPanel.this.gseaInitWizard.setParamSufficient(ParameterPanel.this.checkParamSufficient());
            }
        });
        if (string2.equals("init")) {
            this.browseOrDownload.setVisible(false);
        } else {
            this.browseOrDownload.setVisible(true);
        }
        this.gba.add((Container)this.selectFilePanel, (Component)this.selectFile, 0, 0, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.selectFilePanel, (Component)this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 13, new Insets(5, 5, 5, 5), 0, 0);
        if (string2.equalsIgnoreCase("Download")) {
            this.errorMessageLabel = new JLabel();
            this.gba.add((Container)this.selectFilePanel, (Component)this.errorMessageLabel, 0, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        }
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBackground(Color.white);
        this.availableLabel = new JLabel("Available");
        this.selectedLabel = new JLabel("Selected");
        this.availableList = new JList(new DefaultListModel());
        this.availableList.setName("availableList");
        this.selectedList = new JList(new DefaultListModel());
        this.selectedList.setName("selectedList");
        this.availableScrollPane = new JScrollPane(this.availableList);
        this.availableScrollPane.setPreferredSize(new Dimension(100, 90));
        this.selectedScrollPane = new JScrollPane(this.selectedList);
        this.selectedScrollPane.setPreferredSize(new Dimension(100, 90));
        this.addButton = new JButton("Add");
        this.addButton.setPreferredSize(new Dimension(100, 20));
        this.addButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterPanel.this.onAdd("availableList");
            }
        });
        this.addAllButton = new JButton("Add All");
        this.addAllButton.setPreferredSize(new Dimension(100, 20));
        this.addAllButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterPanel.this.onAddAll("availableList");
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setPreferredSize(new Dimension(100, 20));
        this.removeButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterPanel.this.onRemove("selectedList");
            }
        });
        this.removeAllButton = new JButton("Remove All");
        this.removeAllButton.setPreferredSize(new Dimension(100, 20));
        this.removeAllButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterPanel.this.onRemoveAll("selectedList");
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBackground(Color.white);
        this.gba.add((Container)this.buttonPanel, (Component)this.addButton, 0, 0, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.addAllButton, 0, 1, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.removeButton, 0, 2, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.removeAllButton, 0, 3, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.availableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.availableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.buttonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.selectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.selectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.fileSelectionPanel, (Component)this.selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.selectFilePanel.setVisible(false);
        this.gba.add((Container)this.fileSelectionPanel, (Component)this.listPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.fileSelectionPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.revalidate();
    }

    @Override
    public void populateAlgorithmData() {
        if (this.choiceBox.getSelectedItem() != null) {
            if (this.choiceBox.getSelectedItem().equals("Max Probe")) {
                this.algData.addParam("probe_value", GSEAConstants.MAX_PROBE);
            }
            if (this.choiceBox.getSelectedItem().equals("Median Probe")) {
                this.algData.addParam("probe_value", GSEAConstants.MEDIAN_PROBE);
            }
            if (this.choiceBox.getSelectedItem().equals("Standard Deviation")) {
                this.algData.addParam("probe_value", GSEAConstants.SD);
                this.algData.addParam("standard-deviation-cutoff", this.sdTextField.getText());
            }
        } else {
            this.algData.addParam("probe_value", GSEAConstants.MAX_PROBE);
            this.algData.addParam("standard-deviation-cutoff", "NA");
        }
        if (this.geneNumber.getText().length() != 0) {
            this.algData.addParam("gene-number", this.geneNumber.getText());
        } else {
            this.algData.addParam("gene-number", "");
        }
        if (this.permutationTextField.getText().length() != 0) {
            this.algData.addParam("permutations", this.permutationTextField.getText());
        } else {
            this.algData.addParam("permutations", "");
        }
        if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
            this.algData.addParam("gene-set-directory", this.pathTextField.getText());
        } else if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
            this.algData.addParam("gene-set-directory", this.genesetFilePath);
        } else if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
            this.algData.addParam("gene-set-directory", this.genesetFilePath);
        } else {
            this.algData.addParam("gene-set-directory", "");
        }
        if (this.getFileFilter().equalsIgnoreCase("") && ((String)this.geneIdentifierBox.getSelectedItem()).equalsIgnoreCase("")) {
            this.algData.addParam("gene-identifier", "");
        } else if (this.getFileFilter().equalsIgnoreCase("Gene Matrix and Gene Matrix Transpose (*.gmt, *.gmx)")) {
            this.algData.addParam("gene-identifier", "GENE_SYMBOL");
        } else {
            this.algData.addParam("gene-identifier", (String)this.geneIdentifierBox.getSelectedItem());
        }
        this.algData.addStringArray("gene-set-files", this.getAllSelectedItems());
        if (this.adh.isAnnotationSelected()) {
            this.algData.addParam("annotation-file", this.adh.getAnnFilePath());
        } else if (this.fwork.getData().isAnnotationLoaded()) {
            this.algData.addParam("annotation-file", this.fwork.getData().getChipAnnotation().getAnnFileName());
        } else {
            this.algData.addParam("annotation-file", "");
        }
    }

    private void updateLabel(String string) {
        this.choiceBox.setSelectedItem(string);
    }

    public JPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public void setParameterPanel(JPanel jPanel) {
        this.parameterPanel = jPanel;
    }

    public void onAdd(String string) {
        int n;
        int[] nArray = this.availableList.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        for (n = nArray.length - 1; n >= 0; --n) {
            Object e = ((DefaultListModel)this.availableList.getModel()).getElementAt(nArray[n]);
            objectArray[n] = e;
        }
        for (n = 0; n < nArray.length; ++n) {
            ((DefaultListModel)this.selectedList.getModel()).addElement(objectArray[n]);
        }
    }

    public void onAddAll(String string) {
        int n = ((DefaultListModel)this.availableList.getModel()).size();
        for (int i = 0; i < n; ++i) {
            Object e = ((DefaultListModel)this.availableList.getModel()).getElementAt(i);
            ((DefaultListModel)this.selectedList.getModel()).addElement(e);
        }
    }

    public void onRemove(String string) {
        int[] nArray = this.selectedList.getSelectedIndices();
        for (int i = nArray.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.selectedList.getModel()).remove(nArray[i]);
        }
    }

    public void onRemoveAll(String string) {
        ((DefaultListModel)this.selectedList.getModel()).removeAllElements();
    }

    public void processAnnotationFile() {
        try {
            String[] stringArray = this.fwork.getData().getFieldNames();
            AnnotationFileReader annotationFileReader = AnnotationFileReader.createAnnotationFileReader((File)this.getAnnotationFile());
            GeneAnnotationImportDialog geneAnnotationImportDialog = new GeneAnnotationImportDialog(new JFrame(), stringArray, annotationFileReader.getAvailableAnnotations());
            if (geneAnnotationImportDialog.showModal() == 0) {
                ((MultipleArrayData)this.fwork.getData()).addResourcererGeneAnnotation(geneAnnotationImportDialog.getDataAnnotationKey(), annotationFileReader.getAffyAnnotation());
                this.fwork.getData().setChipAnnotation(annotationFileReader.getAffyChipAnnotation());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fwork.getData().setAnnotationLoaded(true);
    }

    public String[] getAllSelectedItems() {
        String[] stringArray = new String[this.selectedList.getModel().getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((File)this.selectedList.getModel().getElementAt(i)).getName();
        }
        return stringArray;
    }

    public void onBrowse() {
        FileLoaderUtility fileLoaderUtility = new FileLoaderUtility();
        Vector vector = new Vector();
        JFileChooser jFileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.addChoosableFileFilter((FileFilter)new TXTFileFilter());
        jFileChooser.addChoosableFileFilter((FileFilter)new GeneMatrixFileFilter());
        jFileChooser.addChoosableFileFilter((FileFilter)new GeneMatrixTransposeFileFilter());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            ((DefaultListModel)this.availableList.getModel()).clear();
            ((DefaultListModel)this.selectedList.getModel()).clear();
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            vector = fileLoaderUtility.getFileNameList(file.getAbsolutePath());
            this.pathTextField.setText(string);
            if (jFileChooser.getFileFilter().getDescription().equalsIgnoreCase("Gene Matrix Files (*.gmx)") || jFileChooser.getFileFilter().getDescription().equalsIgnoreCase("Gene Matrix Transpose File(*.gmt)")) {
                this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                this.geneIdentifierBox.setEnabled(false);
            } else {
                this.geneIdentifierBox.setSelectedItem(this.geneIdentifierBox.getItemAt(0));
                this.geneIdentifierBox.setEnabled(true);
            }
            if (vector.size() == 0) {
                this.pathTextField.setText("No files of type " + jFileChooser.getFileFilter().getDescription() + "were found");
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                boolean bl = jFileChooser.getFileFilter().accept((File)e);
                if (!bl) continue;
                this.filesLoaded = true;
                this.pathTextField.setText(string);
                String string2 = jFileChooser.getName((File)e);
                this.setFileFilter(jFileChooser.getFileFilter().getDescription());
                ((DefaultListModel)this.availableList.getModel()).addElement(new File(string2));
            }
            if (((DefaultListModel)this.availableList.getModel()).getSize() == 0) {
                String string3 = "<html><font color=red>No files matching the selected filter<br> " + jFileChooser.getFileFilter().getDescription() + "<br>" + "were found!!</font></html>";
                ((DefaultListModel)this.availableList.getModel()).add(0, string3);
            }
        }
    }

    private void setFileFilter(String string) {
        this.fileFilter = string;
    }

    private String getFileFilter() {
        if (this.fileFilter.length() > 0) {
            return this.fileFilter;
        }
        return "";
    }

    private File getAnnotationFile() {
        return new File(this.adh.getAnnFilePath());
    }

    private void GeneSigDBDownloads() {
        try {
            this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            GeneSigDbGeneSets geneSigDbGeneSets = new GeneSigDbGeneSets();
            File file = this.frm.getSupportFile((ISupportFileDefinition)geneSigDbGeneSets, true);
            if (geneSigDbGeneSets.isValid(file)) {
                this.genesetFilePath = file.getParent();
                this.pathTextField.setText(this.genesetFilePath);
                ((DefaultListModel)this.selectedList.getModel()).addElement(new File(file.getName()));
            }
        }
        catch (SupportFileAccessError supportFileAccessError) {
            System.out.println("Could not download GeneSigDbGeneSets file.");
        }
        catch (RepositoryInitializationError repositoryInitializationError) {
            repositoryInitializationError.printStackTrace();
        }
    }

    private void BROADDownloads(String string) {
        try {
            this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            File file = this.frm.getSupportFile((ISupportFileDefinition)new BroadGeneSetList(), true);
            try {
                ArrayList<String> arrayList = BroadGeneSetList.getFileNames(file);
                String string2 = string;
                String[] stringArray = new String[arrayList.size()];
                int n = 0;
                ArrayList<BroadGeneSet> arrayList2 = new ArrayList<BroadGeneSet>();
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stringArray[n] = iterator.next();
                    ++n;
                }
                SelectMultiFilesDialog selectMultiFilesDialog = new SelectMultiFilesDialog(new JFrame(), "Select files to download", new BroadGeneSetList().getURL().getHost(), stringArray);
                selectMultiFilesDialog.setVisible(true);
                int[] nArray = selectMultiFilesDialog.getSelectedFilesIndices();
                String[] stringArray2 = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray2[i] = arrayList.get(nArray[i]);
                    arrayList2.add(new BroadGeneSet(stringArray2[i], string2));
                }
                Hashtable hashtable = this.frm.getSupportFiles(arrayList2, true);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    File file2;
                    ISupportFileDefinition iSupportFileDefinition = (ISupportFileDefinition)enumeration.nextElement();
                    if (iSupportFileDefinition.isValid(file2 = (File)hashtable.get(iSupportFileDefinition))) {
                        this.genesetFilePath = file2.getParent();
                        ((DefaultListModel)this.selectedList.getModel()).addElement(new File(file2.getName()));
                        continue;
                    }
                    System.out.println("support file not downloaded " + file2.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (SupportFileAccessError supportFileAccessError) {
            supportFileAccessError.printStackTrace();
        }
        catch (RepositoryInitializationError repositoryInitializationError) {
            repositoryInitializationError.printStackTrace();
        }
    }

    private boolean checkParamSufficient() {
        return this.geneIdentifierBox.getSelectedIndex() != 0 && this.filesLoaded;
    }

    public static void main(String[] stringArray) {
        new ParameterPanel(null, null, null, null);
    }

    public GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        return gridBagConstraints;
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (actionEvent.getSource().equals(ParameterPanel.this.choiceBox)) {
                ParameterPanel.this.updateLabel((String)ParameterPanel.this.choiceBox.getSelectedItem());
                if (((String)ParameterPanel.this.choiceBox.getSelectedItem()).equalsIgnoreCase("Standard Deviation")) {
                    ParameterPanel.this.SDCutoffLabel.setVisible(true);
                    ParameterPanel.this.sdTextField.setVisible(true);
                } else {
                    ParameterPanel.this.SDCutoffLabel.setVisible(false);
                    ParameterPanel.this.sdTextField.setVisible(false);
                }
            } else if (string.equalsIgnoreCase("gene-number")) {
                ParameterPanel.this.geneNumber.setText(ParameterPanel.this.geneNumber.getText());
            } else if (string.equalsIgnoreCase("standard-deviation")) {
                ParameterPanel.this.sdTextField.setText(ParameterPanel.this.sdTextField.getText());
            } else if (string.equalsIgnoreCase("permutations")) {
                ParameterPanel.this.permutationTextField.setText(ParameterPanel.this.permutationTextField.getText());
            } else if (string.equalsIgnoreCase("got-annotation-file")) {
                ParameterPanel.this.processAnnotationFile();
            } else if (actionEvent.getSource().equals(ParameterPanel.this.geneIdentifierBox)) {
                if (ParameterPanel.this.geneIdentifierBox.getSelectedIndex() != 0) {
                    ParameterPanel.this.geneIdentifierLabel.setForeground(Color.black);
                } else {
                    ParameterPanel.this.geneIdentifierLabel.setForeground(Color.red);
                }
                ParameterPanel.this.gseaInitWizard.setParamSufficient(ParameterPanel.this.checkParamSufficient());
            } else if (actionEvent.getSource().equals(ParameterPanel.this.geneSetSelectionBox)) {
                ParameterPanel.this.updateLabel((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem());
                if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.createDownloadPanel("Please enter your MSigDB registration email address:", "Download", "msigdb_download");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel2, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.pathTextField.setEditable(true);
                    ParameterPanel.this.listPanel.setVisible(false);
                    ParameterPanel.this.selectFilePanel.setVisible(true);
                    ParameterPanel.this.revalidate();
                } else if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.createDownloadPanel("Select the directory containing your gene sets", "Browse", "browse");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel2, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.pathTextField.setEditable(true);
                    ParameterPanel.this.listPanel.setVisible(true);
                    ParameterPanel.this.selectFilePanel.setVisible(true);
                    ParameterPanel.this.revalidate();
                } else if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.createDownloadPanel("Gene set file download location", "Download", "genesigdb_download");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel2, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 0, 13, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.pathTextField.setEditable(false);
                    ParameterPanel.this.listPanel.setVisible(false);
                    ParameterPanel.this.selectFilePanel.setVisible(true);
                    ParameterPanel.this.revalidate();
                }
            }
        }
    }
}

