/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.graph.GraphBar;
import org.tigr.graph.GraphElement;
import org.tigr.graph.GraphLine;
import org.tigr.graph.GraphPoint;
import org.tigr.graph.GraphTick;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.DoubleArray;
import org.tigr.util.awt.ActionInfoEvent;
import org.tigr.util.awt.ActionInfoListener;
import org.tigr.util.awt.BoundariesDialog;
import org.tigr.util.awt.PValueCutoff;

public class PValueGraphViewer
extends JPanel
implements IViewer {
    private GraphPoint gp;
    private GraphLine gl;
    private GraphTick gt;
    private String title;
    private String xLabel;
    private String yLabel;
    private String subTitle;
    private EventListener eventListener;
    private Vector graphElements;
    private double graphstartx;
    private double graphstopx;
    private double graphstarty;
    private double graphstopy;
    private LinkedHashMap pValueMapping;
    private Object[] pValueArray;
    private Object[] geneSetNames;
    protected int preXSpacing;
    protected int postXSpacing;
    protected int preYSpacing;
    protected int postYSpacing;
    protected int startx;
    protected int starty;
    protected int stopx;
    protected int stopy;
    protected double xAxisValue = 0.0;
    protected double yAxisValue = 0.0;
    protected int pointSize;
    protected Font tickFont;
    protected Font labelFont;
    protected Font titleFont;
    protected int tickFontHeight;
    protected int tickFontWidth;
    protected int labelFontHeight;
    protected int labelFontWidth;
    protected int titleFontHeight;
    protected int titleFontWidth;
    public static final int GRAPH_POINTS_SEPERATE = 3000;
    public static final int GRAPH_POINTS_CONNECT = 3001;
    public static final int SYSTEM_QUADRANT1_ONLY = 1000;
    public static final int SYSTEM_QUADRANT12_ONLY = 1001;
    public static final int SYSTEM_ALL_QUADRANTS = 1002;
    public static final int SYSTEM_BOUNDS = 1100;
    protected boolean referenceLinesOn = true;
    protected JPopupMenu popup;
    protected boolean showCoordinates = true;
    protected DecimalFormat coordinateFormat;
    protected int xOldEvent;
    protected int yOldEvent;
    public boolean mouseInside = false;
    private Dimension elementSize = new Dimension(20, 20);
    private Insets insets = new Insets(0, 10, 0, 0);
    private int contentWidth = 0;
    static int test = 0;

    public PValueGraphViewer(String string, String string2, String string3, DoubleArray doubleArray, String[] stringArray) {
        this.xLabel = string2;
        this.yLabel = string3;
        this.title = string;
        this.pValueMapping = null;
        this.geneSetNames = stringArray;
        this.pValueArray = doubleArray.toObjectArray();
        this.graphstartx = 0.0;
        this.graphstopx = this.geneSetNames.length;
        this.graphstarty = 0.0;
        this.graphstopy = 1.0;
        this.eventListener = new EventListener();
        this.addMouseMotionListener(this.eventListener);
        this.addMouseListener(this.eventListener);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
        this.initComponents();
        this.initializePopupMenu();
    }

    public PValueGraphViewer(String string, String string2, String string3, LinkedHashMap linkedHashMap) {
        this.xLabel = string2;
        this.yLabel = string3;
        this.title = string;
        this.pValueMapping = linkedHashMap;
        this.geneSetNames = this.pValueMapping.keySet().toArray();
        this.pValueArray = this.pValueMapping.values().toArray();
        this.graphstartx = 0.0;
        this.graphstopx = this.geneSetNames.length;
        this.graphstarty = 0.0;
        this.graphstopy = 1.0;
        this.eventListener = new EventListener();
        this.addMouseMotionListener(this.eventListener);
        this.addMouseListener(this.eventListener);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
        this.initComponents();
        this.initializePopupMenu();
    }

    private void initComponents() {
        this.setBackground(Color.white);
        super.setBackground(Color.white);
        this.setTickFont("SansSerif", 1, 10);
        this.setLabelFont("SansSerif", 1, 12);
        this.setTitleFont("SansSerif", 1, 16);
        this.setTitle(this.title);
        this.setXLabel(this.xLabel);
        this.setYLabel(this.yLabel);
        this.graphElements = new Vector();
    }

    protected void initializePopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Set Bounds");
        jMenuItem.setActionCommand("Set Boundaries");
        jMenuItem.addActionListener(this.eventListener);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        jMenuItem = new JMenuItem("Reference Lines");
        jMenuItem.setActionCommand("Reference Lines");
        jMenuItem.addActionListener(this.eventListener);
        this.popup.add(jMenuItem);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.preXSpacing = this.getLeftMargin(graphics2D);
        this.postYSpacing = this.getBottomMargin(graphics2D);
        this.postXSpacing = 20;
        this.preYSpacing = 50;
        this.gl = new GraphLine(0.0, 0.0, this.graphstopx, 0.0, Color.BLACK);
        this.graphElements.add(this.gl);
        this.gl = new GraphLine(0.0, 0.0, 0.0, this.graphstopy, Color.BLACK);
        this.graphElements.add(this.gl);
        this.gl = new GraphLine(this.graphstartx, 0.05, this.graphstopx, 0.05, Color.black);
        this.graphElements.add(this.gl);
        int n = 0;
        while ((double)n < this.graphstopx) {
            this.gp = new GraphPoint((double)(n + 1), ((Float)this.pValueArray[n]).doubleValue(), Color.blue, 3);
            this.graphElements.add(this.gp);
            ++n;
        }
        for (double d = this.graphstarty; d < this.graphstopy; d += 0.05) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            this.gt = new GraphTick(d, 8, Color.black, 1, 0, numberFormat.format(d), Color.black);
            this.graphElements.add(this.gt);
        }
        int n2 = 0;
        while ((double)n2 < this.graphstopx) {
            this.gt = new GraphTick((double)(n2 + 1), 8, Color.black, 0, 0, (String)this.geneSetNames[n2], Color.black);
            this.graphElements.add(this.gt);
            ++n2;
        }
        this.drawSystem(graphics2D, 1100);
        for (n2 = 0; n2 < this.graphElements.size(); ++n2) {
            GraphElement graphElement = (GraphElement)this.graphElements.elementAt(n2);
            if (graphElement instanceof GraphPoint) {
                this.drawPoint(graphics2D, (GraphPoint)graphElement);
                continue;
            }
            if (graphElement instanceof GraphBar) {
                this.drawBar(graphics2D, (GraphBar)graphElement);
                continue;
            }
            if (graphElement instanceof GraphTick) {
                this.drawTick(graphics2D, (GraphTick)graphElement);
                continue;
            }
            if (!(graphElement instanceof GraphLine)) continue;
            this.drawLine(graphics2D, (GraphLine)graphElement);
        }
        if (this.referenceLinesOn) {
            boolean bl;
            n2 = this.getXOldEvent();
            int n3 = this.getYOldEvent();
            double d = 0.0;
            double d2 = 0.0;
            boolean bl2 = bl = n2 <= this.convertX(this.graphstopx) && n2 >= this.convertX(this.graphstartx) && n3 >= this.convertY(this.graphstopy) && n3 <= this.convertY(this.graphstarty);
            if (bl) {
                this.setCursor(1);
                d = (double)(n2 - this.convertX(this.graphstartx)) / this.getXScale() + this.graphstartx;
                d2 = (double)(this.convertY(this.graphstarty) - n3) / this.getYScale() + this.graphstarty;
                graphics2D.setColor(Color.magenta);
                graphics2D.drawLine(n2, this.convertY(this.graphstarty), n2, this.convertY(this.graphstopy));
                graphics2D.drawLine(this.convertX(this.graphstartx), n3, this.convertX(this.graphstopx), n3);
                if (this.showCoordinates) {
                    int n4 = fontMetrics.stringWidth(this.coordinateFormat.format(d) + ", " + this.coordinateFormat.format(d2));
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    graphics2D.setColor(Color.blue);
                    graphics2D.fillRect(n2, n3 - 15, n4 + 20, 25);
                    graphics2D.setComposite(composite);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawString("Geneset: " + (String)this.geneSetNames[(int)d] + ", " + "Pvalue:" + this.pValueArray[(int)d], n2 + 5, n3 - 3);
                }
            } else {
                this.setCursor(0);
            }
        }
        this.drawXLabel(graphics2D, this.xLabel, Color.black);
        this.drawYLabel(graphics2D, this.yLabel, Color.black);
        this.drawTitle(graphics2D, this.title, Color.black);
    }

    private int getBottomMargin(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        for (int i = 0; i < this.geneSetNames.length; ++i) {
            String string = (String)this.geneSetNames[i];
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private int getLeftMargin(Graphics graphics) {
        if (graphics == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return fontMetrics.stringWidth(this.getYLabel());
    }

    public void setSubTitle(String string) {
        this.subTitle = string;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void setXAxisValue(double d) {
        this.xAxisValue = d;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setYAxisValue(double d) {
        this.yAxisValue = d;
    }

    public double getYAxisValue() {
        return this.yAxisValue;
    }

    public void toggleReferenceLines() {
        this.referenceLinesOn = !this.referenceLinesOn;
    }

    public void setShowCoordinates(boolean bl) {
        this.showCoordinates = bl;
    }

    public void drawSystem(Graphics2D graphics2D, int n) {
        switch (n) {
            case 1000: {
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                break;
            }
            case 1001: {
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.stopx - this.postXSpacing, this.stopy - this.postYSpacing);
                graphics2D.drawLine(this.startx + this.preXSpacing, this.stopy - this.postYSpacing, this.startx + this.preXSpacing, this.starty + this.preYSpacing);
                graphics2D.drawLine((this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.stopy - this.postYSpacing, (this.stopx - this.postXSpacing - this.startx + this.preXSpacing) / 2, this.starty + this.preYSpacing);
                break;
            }
            case 1100: {
                this.drawLine(graphics2D, new GraphPoint(this.graphstartx, this.xAxisValue), new GraphPoint(this.graphstopx, this.xAxisValue), Color.black);
                this.drawLine(graphics2D, new GraphPoint(this.yAxisValue, this.graphstarty), new GraphPoint(this.yAxisValue, this.graphstopy), Color.black);
                break;
            }
        }
    }

    public void drawTitle(Graphics2D graphics2D, String string, Color color) {
        if (this.subTitle == null) {
            this.drawString(graphics2D, string, this.getSize().width / 2 - string.length() * this.titleFontWidth / 2, this.titleFontHeight * 2, color, this.titleFont);
        } else {
            this.drawString(graphics2D, string, this.getSize().width / 2 - string.length() * this.titleFontWidth / 2, (int)((double)this.titleFontHeight * 1.5), color, this.titleFont);
            this.drawString(graphics2D, this.subTitle, this.getSize().width / 2 - this.subTitle.length() * this.titleFontWidth / 2, this.titleFontHeight * 3, color, this.titleFont);
        }
    }

    public void drawXLabel(Graphics2D graphics2D, String string, Color color) {
        this.drawString(graphics2D, string, this.getSize().width / 2 - string.length() * this.labelFontWidth / 2, this.convertY(this.graphstarty) + this.postYSpacing - this.labelFontHeight, color, this.labelFont);
    }

    public void drawYLabel(Graphics2D graphics2D, String string, Color color) {
        graphics2D.rotate(-1.5707963267948966);
        this.drawString(graphics2D, string, this.startx - this.postYSpacing + this.preXSpacing - this.getSize().height / 2 - string.length() * this.labelFontWidth / 2, this.labelFontHeight, color, this.labelFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawPoint(Graphics2D graphics2D, GraphPoint graphPoint) {
        this.drawPointAt(graphics2D, graphPoint.getX(), graphPoint.getY(), graphPoint.getColor(), graphPoint.getPointSize());
    }

    public void drawPointAt(Graphics2D graphics2D, double d, double d2, Color color, int n) {
        if (!(d < this.graphstartx || d > this.graphstopx || d2 < this.graphstarty || d2 > this.graphstopy)) {
            this.fillRect(graphics2D, this.convertX(d) - n / 2, this.convertY(d2) - n / 2, n, n, color);
        }
    }

    public void drawPoints(Graphics2D graphics2D, Vector vector, int n) {
        GraphPoint graphPoint = null;
        switch (n) {
            case 3000: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint2 = (GraphPoint)vector.elementAt(i);
                    this.drawPoint(graphics2D, graphPoint2);
                }
                break;
            }
            case 3001: {
                for (int i = 0; i < vector.size(); ++i) {
                    GraphPoint graphPoint3 = (GraphPoint)vector.elementAt(i);
                    if (i == 0) {
                        graphPoint = graphPoint3;
                    }
                    this.drawLine(graphics2D, graphPoint, graphPoint3, Color.black);
                    this.drawPoint(graphics2D, graphPoint);
                    this.drawPoint(graphics2D, graphPoint3);
                    graphPoint = graphPoint3;
                }
                break;
            }
        }
    }

    public void drawLine(Graphics2D graphics2D, GraphLine graphLine) {
        if (!(graphLine.getX1() < this.graphstartx || graphLine.getX1() > this.graphstopx || graphLine.getY1() < this.graphstarty || graphLine.getY1() > this.graphstopy || graphLine.getX2() < this.graphstartx || graphLine.getX2() > this.graphstopx || graphLine.getY2() < this.graphstarty || graphLine.getY2() > this.graphstopy)) {
            this.drawLine(graphics2D, this.convertX(graphLine.getX1()), this.convertY(graphLine.getY1()), this.convertX(graphLine.getX2()), this.convertY(graphLine.getY2()), graphLine.getColor());
        }
    }

    public void drawLine(Graphics2D graphics2D, GraphPoint graphPoint, GraphPoint graphPoint2, Color color) {
        this.drawLine(graphics2D, this.convertX(graphPoint.getX()), this.convertY(graphPoint.getY()), this.convertX(graphPoint2.getX()), this.convertY(graphPoint2.getY()), color);
    }

    public void drawBar(Graphics2D graphics2D, GraphBar graphBar) {
        if (graphBar.getStyle() == 0) {
            this.drawVerticalHistogramBar(graphics2D, graphBar.getLower(), graphBar.getUpper(), graphBar.getValue(), graphBar.getColor(), graphBar.getStyle());
        } else if (graphBar.getStyle() == 1) {
            // empty if block
        }
    }

    public void drawVerticalHistogramBar(Graphics2D graphics2D, double d, double d2, double d3, Color color, int n) {
        if (!(d < this.graphstartx || d > this.graphstopx || d2 < this.graphstartx || d2 > this.graphstopx || d3 < this.graphstarty || d3 > this.graphstopy)) {
            if (n == 1) {
                this.drawRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()), (int)(d3 * this.getYScale()) - 1, color);
            } else if (n == 0) {
                this.fillRect(graphics2D, this.convertX(d), this.convertY(d3), (int)((d2 - d) * this.getXScale()) + 1, (int)(d3 * this.getYScale()) + 1, color);
            }
        }
    }

    public void drawTick(Graphics2D graphics2D, GraphTick graphTick) {
        if (graphTick.getOrientation() == 0) {
            if (graphTick.getLabel() != "") {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawVerticalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        } else if (graphTick.getOrientation() == 1) {
            if (graphTick.getLabel() != "") {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor(), graphTick.getLabel(), graphTick.getLabelColor());
            } else {
                this.drawHorizontalTick(graphics2D, graphTick.getLocation(), graphTick.getHeight(), graphTick.getAlignment(), graphTick.getColor());
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (!(d < this.graphstartx) && !(d > this.graphstopx) && n <= this.postYSpacing) {
            switch (n2) {
                case 0: {
                    this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue) - n / 2, this.convertX(d), this.convertY(this.xAxisValue) + n / 2, color);
                    break;
                }
                case 1: {
                    this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) - n, color);
                    break;
                }
                case 5: {
                    this.drawLine(graphics2D, this.convertX(d), this.convertY(this.xAxisValue), this.convertX(d), this.convertY(this.xAxisValue) + n, color);
                }
            }
        }
    }

    public void drawVerticalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawVerticalTick(graphics2D, d, n, n2, color);
        graphics2D.rotate(-1.5707963267948966);
        this.drawString(graphics2D, string, -this.getSize().height + this.postYSpacing - string.length() * this.tickFontWidth - n, this.convertX(d) + this.tickFontHeight / 2, color2, this.tickFont);
        graphics2D.rotate(1.5707963267948966);
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color) {
        if (!(d < this.graphstarty) && !(d > this.graphstopy) && n <= this.preXSpacing) {
            switch (n2) {
                case 0: {
                    this.drawLine(graphics2D, this.convertX(this.yAxisValue) - n / 2, this.convertY(d), this.convertX(this.yAxisValue) + n / 2, this.convertY(d), color);
                    break;
                }
                case 3: {
                    this.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) + n, this.convertY(d), color);
                    break;
                }
                case 7: {
                    this.drawLine(graphics2D, this.convertX(this.yAxisValue), this.convertY(d), this.convertX(this.yAxisValue) - n, this.convertY(d), color);
                }
            }
        }
    }

    public void drawHorizontalTick(Graphics2D graphics2D, double d, int n, int n2, Color color, String string, Color color2) {
        this.drawHorizontalTick(graphics2D, d, n, n2, color);
        this.drawString(graphics2D, string, this.startx + this.preXSpacing - n - string.length() * this.tickFontWidth, this.convertY(d) + this.tickFontHeight / 2, color2, this.tickFont);
    }

    public void setTickFont(String string, int n, int n2) {
        this.tickFont = new Font(string, n, n2);
        this.tickFontWidth = (int)(0.6 * (double)n2);
        this.tickFontHeight = n2;
    }

    public void setLabelFont(String string, int n, int n2) {
        this.labelFont = new Font(string, n, n2);
        this.labelFontWidth = (int)(0.6 * (double)n2);
        this.labelFontHeight = n2;
    }

    public void setTitleFont(String string, int n, int n2) {
        this.titleFont = new Font(string, n, n2);
        this.titleFontWidth = (int)(0.6 * (double)n2);
        this.titleFontHeight = n2;
    }

    protected double getXScale() {
        return (double)(this.getSize().width - this.preXSpacing - this.postXSpacing) / (this.graphstopx - this.graphstartx);
    }

    protected double getYScale() {
        return (double)(this.getSize().height - this.preYSpacing - this.postYSpacing) / (this.graphstopy - this.graphstarty);
    }

    protected int convertX(double d) {
        return (int)((d - this.graphstartx) * this.getXScale() + (double)this.preXSpacing);
    }

    protected int convertY(double d) {
        return (int)((this.graphstopy - d) * this.getYScale() + (double)this.preYSpacing);
    }

    public void drawPoint(Graphics2D graphics2D, Point point, Color color) {
        this.drawPoint(graphics2D, point.x, point.y, color);
    }

    public void drawPoint(Graphics2D graphics2D, int n, int n2, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n, n2);
    }

    public void drawPoint(Graphics2D graphics2D, Point point) {
        this.drawPoint(graphics2D, point, this.getBackground());
    }

    public void drawPoint(Graphics2D graphics2D, int n, int n2) {
        this.drawPoint(graphics2D, n, n2, this.getBackground());
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawLine(graphics2D, n, n2, n3, n4, this.getBackground());
    }

    public final void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawRect(n, n2, n3, n4);
    }

    public final void fillRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setColor(color);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    public void drawString(Graphics2D graphics2D, String string, int n, int n2, Color color, Font font) {
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
    }

    public void drawString(Graphics2D graphics2D, String string, int n, int n2, Color color) {
        graphics2D.setColor(color);
        graphics2D.drawString(string, n, n2);
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        double[] dArray = new double[this.pValueArray.length];
        for (int i = 0; i < this.pValueArray.length; ++i) {
            dArray[i] = new Double(((Float)this.pValueArray[i]).floatValue());
        }
        return new Expression(this, this.getClass(), "new", new Object[]{this.title, this.xLabel, this.yLabel, new DoubleArray(dArray), this.geneSetNames});
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
        this.repaint();
    }

    public void setExperiment(Experiment experiment) {
    }

    public void setExperimentID(int n) {
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setXOldEvent(int n) {
        this.xOldEvent = n;
    }

    public int getXOldEvent() {
        return this.xOldEvent;
    }

    public void setYOldEvent(int n) {
        this.yOldEvent = n;
    }

    public int getYOldEvent() {
        return this.yOldEvent;
    }

    private class EventListener
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    Serializable {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PValueGraphViewer.this.popup.setVisible(false);
            if (actionEvent.getActionCommand() == "Set Boundaries") {
                BoundariesDialog boundariesDialog = new BoundariesDialog(new JFrame(), PValueGraphViewer.this.graphstartx, PValueGraphViewer.this.graphstopx, PValueGraphViewer.this.graphstarty, PValueGraphViewer.this.graphstopy);
                boundariesDialog.addActionInfoListener(new ActionInfoListener(){

                    public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                        Hashtable hashtable = actionInfoEvent.getHashtable();
                        PValueGraphViewer.this.graphstartx = Double.parseDouble((String)hashtable.get("lowerx"));
                        PValueGraphViewer.this.graphstopx = Double.parseDouble((String)hashtable.get("upperx"));
                        PValueGraphViewer.this.graphstarty = Double.parseDouble((String)hashtable.get("lowery"));
                        PValueGraphViewer.this.graphstopy = Double.parseDouble((String)hashtable.get("uppery"));
                        PValueGraphViewer.this.setXAxisValue(PValueGraphViewer.this.graphstarty);
                        PValueGraphViewer.this.setYAxisValue(PValueGraphViewer.this.graphstartx);
                        PValueGraphViewer.this.repaint();
                    }
                });
                boundariesDialog.show();
            } else if (actionEvent.getActionCommand() == "Reference Lines") {
                PValueGraphViewer.this.referenceLinesOn = !PValueGraphViewer.this.referenceLinesOn;
                PValueGraphViewer.this.repaint();
            } else if (actionEvent.getActionCommand() == "p-value cutoff") {
                PValueCutoff pValueCutoff = new PValueCutoff(new JFrame(), 0.05);
                pValueCutoff.addActionInfoListener(new ActionInfoListener(){

                    public void actionInfoPerformed(ActionInfoEvent actionInfoEvent) {
                        Hashtable hashtable = actionInfoEvent.getHashtable();
                        String string = (String)hashtable.get("option");
                        double d = (Double)hashtable.get(string);
                        int n = Arrays.binarySearch(PValueGraphViewer.this.pValueArray, d, null);
                        if (string.equalsIgnoreCase("greater")) {
                            PValueGraphViewer.this.graphstopx = PValueGraphViewer.this.pValueArray.length - n + 1;
                        } else {
                            PValueGraphViewer.this.graphstopx = n + 1;
                        }
                        PValueGraphViewer.this.repaint();
                    }
                });
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 4) {
                PValueGraphViewer.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            PValueGraphViewer.this.setXOldEvent(-1);
            PValueGraphViewer.this.setYOldEvent(-1);
            PValueGraphViewer.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PValueGraphViewer.this.setXOldEvent(n);
            PValueGraphViewer.this.setYOldEvent(n2);
            PValueGraphViewer.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

