/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class LeadingEdgeSubsetViewer
extends JPanel
implements IViewer {
    private LinkedHashMap<String, Float> sorted;
    private float maxIncrementalSum;
    private int peakGeneIndex;
    private DecimalFormat coordinateFormat;
    private FontMetrics metrics;
    private float stepsY;
    private float minYVal;
    private float maxYValue;
    private boolean isAntiAliasing = false;
    private Color bColor = Color.BLACK;
    private float[] incrementalSum;
    private boolean referenceLinesOn = true;
    private int xOldEvent;
    private int yOldEvent;
    private boolean mouseInside = false;
    private boolean showCoordinates = true;
    private EventListener eventListener;
    private Object[] genes;

    public LeadingEdgeSubsetViewer(LinkedHashMap<String, Float> linkedHashMap) {
        this.sorted = linkedHashMap;
        this.genes = new String[linkedHashMap.keySet().size()];
        this.genes = linkedHashMap.keySet().toArray();
        new LinkedHashMap();
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
        this.incrementalSum = new float[this.sorted.keySet().size()];
        this.incrementalSum = this.getIncrementalSubsetSum();
        this.setBackground(Color.WHITE);
        this.eventListener = new Listener();
        this.addMouseMotionListener((MouseMotionListener)this.eventListener);
        this.addMouseListener((MouseListener)this.eventListener);
    }

    public float[] getIncrementalSubsetSum() {
        float f = Float.MIN_VALUE;
        Iterator<String> iterator = this.sorted.keySet().iterator();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (int i = 0; i < this.sorted.size(); ++i) {
            String string = iterator.next();
            float f2 = Float.parseFloat(this.coordinateFormat.format(this.sorted.get(string).floatValue()).replace(",", ""));
            arrayList.add(Float.valueOf(f2));
            float f3 = 0.0f;
            for (int j = 0; j < arrayList.size(); ++j) {
                f3 += ((Float)arrayList.get(j)).floatValue();
            }
            this.incrementalSum[i] = Float.parseFloat(this.coordinateFormat.format((double)f3 / Math.sqrt(i + 1)).replace(",", ""));
            if (this.incrementalSum[i] != Math.max(f, this.incrementalSum[i])) continue;
            f = this.incrementalSum[i];
            this.setPeakGeneIndex(i);
        }
        this.setMaximumIncrementalSum(f);
        return this.incrementalSum;
    }

    public void setMaximumIncrementalSum(float f) {
        this.maxIncrementalSum = f;
    }

    public float getMaximumIncrementalSum() {
        return this.maxIncrementalSum;
    }

    public void setPeakGeneIndex(int n) {
        this.peakGeneIndex = n;
    }

    public int getPeakGeneIndex() {
        return this.peakGeneIndex;
    }

    public float getmaxYValue() {
        float f = this.getMaximumIncrementalSum();
        return f;
    }

    public void setCurrentMaxYValue(float f) {
        if (!Float.isNaN(f)) {
            this.maxYValue = f;
        }
    }

    public float getCurrentMaxYValue() {
        return this.maxYValue;
    }

    public float getMinYValue() {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.incrementalSum.length; ++i) {
            float f2 = this.incrementalSum[i];
            if (Float.isNaN(f2)) continue;
            f = Math.min(f2, f);
        }
        return f;
    }

    public void setCurrentMinYValue(float f) {
        if (!Float.isNaN(f)) {
            this.minYVal = f;
        }
    }

    public float getCurrentMinYValue() {
        return this.minYVal;
    }

    public int getMaxXValue() {
        return this.sorted.size();
    }

    public void setStepsY(float f) {
        this.stepsY = f;
    }

    public float getStepsY() {
        return this.stepsY;
    }

    public FontMetrics getFontMetric() {
        return this.metrics;
    }

    public void setFontMetric(FontMetrics fontMetrics) {
        this.metrics = fontMetrics;
    }

    @Override
    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(40, 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        this.paint((Graphics2D)graphics, rectangle);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.paint(graphics2D);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.setFontMetric(fontMetrics);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (rectangle.width < 5 || rectangle.height < 5) {
            return;
        }
        float f = this.getmaxYValue();
        float f2 = this.getMinYValue();
        float[] fArray = new float[]{10.0f};
        BasicStroke basicStroke = new BasicStroke(3.0f, 0, 0, 10.0f, fArray, 0.0f);
        this.setCurrentMaxYValue(f);
        this.setCurrentMinYValue(f2);
        this.stepsY = f / 5.0f;
        this.setStepsY(this.stepsY);
        Rectangle rectangle2 = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        int n6 = rectangle2.x;
        int n7 = rectangle2.y;
        if (n6 + rectangle2.width > this.getWidth()) {
            n5 = n6 + rectangle2.width - this.getWidth();
            rectangle2 = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - this.getMaximumStringWidth() - n5 - 80, this.getHeight() - 40 - this.getNamesWidth(fontMetrics));
        }
        n5 = rectangle2.width;
        int n8 = rectangle2.height;
        int n9 = this.getMaxXValue();
        int n10 = 0;
        int n11 = 0;
        float f3 = n8 / 5;
        float f4 = (float)n5 / (float)n9;
        graphics2D.setStroke(new BasicStroke(2.0f));
        String string = "Genes ranked by test statistic";
        String string2 = "J G  Statistic  for  incremental  subsets";
        Font font = new Font("Dialog", 0, 12);
        graphics2D.setFont(font);
        graphics2D.drawString(string, this.getWidth() / 2, this.getHeight());
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n6, n7, n5, n8);
        graphics2D.rotate(-1.5707963267948966, n6 - this.getMaximumStringWidth() - 18, n7 + n8 / 2);
        graphics2D.drawString(string2, n6 - this.getMaximumStringWidth() - 18, n8 / 2 + n7);
        graphics2D.rotate(1.5707963267948966, n6 - this.getMaximumStringWidth() - 18, n8 / 2 + n7);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
        int n12 = (int)((float)(n7 + n8) - f3);
        int n13 = this.getMaximumStringWidth();
        for (float f5 = this.getStepsY(); f5 < this.getCurrentMaxYValue() + this.getStepsY(); f5 += this.getStepsY()) {
            graphics2D.drawLine(n6, n12, n6 + 5, n12);
            graphics2D.drawString(this.coordinateFormat.format(f5), n6 - 10 - n13, n12);
            if ((n12 -= (int)f3) >= n7 || f5 != this.getCurrentMaxYValue()) continue;
            n12 = n7;
        }
        graphics2D.drawString(this.getMaxXValue() + " Genes", n6 + 10, n7 + 20);
        if (n9 <= 80) {
            for (n4 = 1; n4 <= this.getMaxXValue(); ++n4) {
                graphics2D.drawLine(n6 + Math.round((float)n4 * f4), n7 + n8 - 5, n6 + Math.round((float)n4 * f4), n7 + n8);
            }
        } else {
            n4 = n9 / 5;
            n3 = n9 / n4;
            for (n2 = 1; n2 < n9 + 1; n2 += n3) {
                graphics2D.drawLine(n6 + Math.round((float)n2 * f4), n7 + n8 - 5, n6 + Math.round((float)n2 * f4), n7 + n8);
            }
        }
        graphics2D.rotate(-1.5707963267948966);
        n4 = this.getNamesWidth(fontMetrics);
        if (n9 <= 80) {
            for (n3 = 1; n3 < n9 + 1; ++n3) {
                graphics2D.drawString((String)this.genes[n3 - 1], -n8 - n7 - 10 - n4, n6 + Math.round((float)n3 * f4) + 3);
            }
        } else {
            n3 = n9 / 5;
            n2 = n9 / n3;
            for (n = 1; n < n9 + 1; n += n2) {
                graphics2D.drawString((String)this.genes[n - 1], -n8 - n7 - 10 - n4, n6 + Math.round((float)n * f4) + 3);
            }
        }
        graphics2D.rotate(1.5707963267948966);
        for (n3 = 1; n3 < n9 + 1; ++n3) {
            float f6 = this.incrementalSum[n3 - 1];
            n = n6 + Math.round((float)n3 * f4) + 3;
            int n14 = (int)((float)(n7 + n8) - f3);
            int n15 = 0;
            graphics2D.setColor(new Color(128, 0, 128));
            graphics2D.setStroke(new BasicStroke(6.0f));
            for (float f7 = this.getStepsY(); f7 <= this.getmaxYValue() + this.getStepsY(); f7 += this.getStepsY()) {
                String string3 = this.coordinateFormat.format(f7);
                float f8 = Float.parseFloat(string3);
                float f9 = Float.parseFloat(this.coordinateFormat.format(this.getStepsY()));
                if (f6 < this.getStepsY()) {
                    n14 = n7 + n8;
                    graphics2D.drawLine(n, n14, n, n14);
                    break;
                }
                if (f6 < f8 && f6 > f8 - f9) {
                    float f10 = (10.0f * Math.abs(f8) - 10.0f * Math.abs(f6)) / f9;
                    n14 = (int)((float)n14 - f3 * (float)n15);
                    n14 = Math.round((float)n14 + f10 * 10.0f);
                    graphics2D.drawLine(n, n14, n, n14);
                    break;
                }
                if (f6 == f8) {
                    if (f6 == this.getStepsY()) {
                        n14 = (int)((float)(n7 + n8) - f3);
                        graphics2D.drawLine(n, n14, n, n14);
                        break;
                    }
                    n14 = (int)((float)n14 - f3 * (float)n15);
                    graphics2D.drawLine(n, n14, n, n14);
                    break;
                }
                if (n15 >= 4) continue;
                ++n15;
            }
            if (n3 == 1) {
                n10 = n14;
                n11 = n;
            } else {
                graphics2D.setColor(new Color(128, 0, 128));
                graphics2D.setStroke(new BasicStroke(6.0f));
                graphics2D.drawLine(n11, n10, n, n14);
                n11 = n;
                n10 = n14;
            }
            if (n3 != this.getPeakGeneIndex() + 1) continue;
            graphics2D.setColor(Color.RED);
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(n, n14, n, n7 + n8);
        }
        if (this.referenceLinesOn) {
            boolean bl;
            n3 = this.getXOldEvent();
            n2 = this.getYOldEvent();
            double d = 0.0;
            double d2 = 0.0;
            boolean bl2 = bl = n3 <= n5 + n6 && n3 >= n6 && n2 <= n7 + n8 && n2 >= n7;
            if (bl) {
                this.setCursor(1);
                d = Math.round((float)(n3 - n6) / f4) - 1;
                d2 = (this.getCurrentMinYValue() - (float)n2) / f3 + this.getCurrentMinYValue();
                if (this.showCoordinates) {
                    n = fontMetrics.stringWidth(this.coordinateFormat.format(d) + ", " + this.coordinateFormat.format(d2));
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    if ((int)d < this.genes.length + 1 && (int)d >= 0) {
                        graphics2D.setColor(Color.blue);
                        graphics2D.setComposite(composite);
                        graphics2D.setColor(this.bColor);
                        graphics2D.drawString("Gene: " + this.genes[(int)d], n3, n2 - 20);
                        graphics2D.drawString("Test stat:" + Float.toString(this.incrementalSum[(int)d]), n3, n2);
                    }
                }
            } else {
                this.setCursor(0);
            }
        }
    }

    protected int getNamesWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 1; i <= this.getMaxXValue(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth((String)this.genes[i - 1]));
        }
        return n;
    }

    public int getMaximumStringWidth() {
        int n = Integer.MIN_VALUE;
        float f = this.getStepsY();
        for (float f2 = this.getMinYValue(); f2 <= this.getmaxYValue(); f2 += f) {
            String string = this.coordinateFormat.format(f2);
            int n2 = this.metrics.stringWidth(string);
            if (n2 > n) {
                n = n2;
            }
            if ((n2 = this.metrics.stringWidth(string = this.coordinateFormat.format(-f2))) <= n) continue;
            n = n2;
        }
        return n;
    }

    public String[][] getLeadingEdgeGenes() {
        String[][] stringArray = new String[this.getPeakGeneIndex() + 1][2];
        Iterator<String> iterator = this.sorted.keySet().iterator();
        for (int i = 0; i < this.getPeakGeneIndex() + 1; ++i) {
            stringArray[i][0] = iterator.next();
            stringArray[i][1] = Float.toString(this.incrementalSum[i]);
        }
        return stringArray;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.sorted});
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
    }

    public void onSelected(IFramework iFramework) {
    }

    public void setExperiment(Experiment experiment) {
    }

    public void setExperimentID(int n) {
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public void setXOldEvent(int n) {
        this.xOldEvent = n;
    }

    public int getXOldEvent() {
        return this.xOldEvent;
    }

    public void setYOldEvent(int n) {
        this.yOldEvent = n;
    }

    public int getYOldEvent() {
        return this.yOldEvent;
    }

    private class Listener
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Reference Lines") {
                LeadingEdgeSubsetViewer.this.referenceLinesOn = !LeadingEdgeSubsetViewer.this.referenceLinesOn;
                LeadingEdgeSubsetViewer.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            LeadingEdgeSubsetViewer.this.setXOldEvent(n);
            LeadingEdgeSubsetViewer.this.setYOldEvent(n2);
            LeadingEdgeSubsetViewer.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 4) {
                // empty if block
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            LeadingEdgeSubsetViewer.this.setXOldEvent(-1);
            LeadingEdgeSubsetViewer.this.setYOldEvent(-1);
            LeadingEdgeSubsetViewer.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

