/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.helpers.IExperimentHeader;

public class GenesetMembershipHeader
extends JPanel
implements IExperimentHeader {
    private ArrayList<String> gene_set = new ArrayList();
    private static final int RECT_HEIGHT = 15;
    private static final int COLOR_BAR_HEIGHT = 15;
    private int elementWidth;
    private Insets insets = new Insets(0, 10, 0, 0);
    private int headerWidth = 0;
    private boolean headerDrag = false;
    private boolean isShift = false;
    private boolean enableMoveable = true;
    private int startShift = 0;
    private int endShift = 0;
    private int startShiftMove = 0;
    private int endShiftMove = 0;
    private float maxValue = 1.0f;
    private float minValue = -1.0f;
    private float midValue = 0.0f;

    public GenesetMembershipHeader(ArrayList<String> arrayList) {
        this.setGene_set(arrayList);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public void updateSizes(int n, int n2) {
        this.setElementWidth(n2);
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = 0;
        int n4 = this.gene_set.size();
        for (int i = 0; i < n4; ++i) {
            String string = this.gene_set.get(i);
            n3 = Math.max(n3, fontMetrics.stringWidth(string));
        }
        this.setBackground(Color.white);
        this.setSize(this.headerWidth, n3 += 15 + fontMetrics.getHeight() + 10);
        this.setPreferredSize(new Dimension(this.headerWidth, n3));
        this.drawHeader(graphics2D);
    }

    public void setHeaderWidth(int n) {
        this.headerWidth = n;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.gene_set.size() < 1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawHeader(graphics2D);
    }

    private void drawHeader(Graphics2D graphics2D) {
        int n = this.gene_set.size();
        if (n == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getDescent();
        graphics2D.setColor(Color.black);
        int n3 = -this.getSize().height + 5;
        graphics2D.rotate(-1.5707963267948966);
        for (int i = 0; i < n; ++i) {
            String string = this.gene_set.get(i);
            graphics2D.drawString(string, n3, n2 + this.elementWidth * i + this.elementWidth / 2 + this.insets.left);
        }
    }

    private void setElementWidth(int n) {
        this.elementWidth = n;
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    public JComponent getContentComponent() {
        return this;
    }

    public void setAntiAliasing(boolean bl) {
    }

    public void setClusterIndex(int n) {
    }

    public void setData(IData iData) {
    }

    public void setLeftInset(int n) {
    }

    public void setNegAndPosColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
    }

    public void setUseDoubleGradient(boolean bl) {
    }

    public void setValues(float f, float f2) {
        this.maxValue = f2;
        this.minValue = f;
    }

    public void setValues(float f, float f2, float f3) {
        this.maxValue = f3;
        this.minValue = f;
        this.midValue = f2;
    }

    private int findColumn(int n) {
        int n2 = this.gene_set.size() * this.elementWidth;
        if (n < this.insets.left) {
            return -1;
        }
        if (n > n2 + this.insets.left) {
            return -1;
        }
        return (n - this.insets.left) / this.elementWidth;
    }

    private int findRow(int n) {
        int n2 = 0;
        if (n >= this.getSize().height || n < n2) {
            return -1;
        }
        return (n - n2) / 15;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.getGene_set().size() - 1;
    }

    private boolean isLegalRow(int n) {
        return true;
    }

    public ArrayList<String> getGene_set() {
        return this.gene_set;
    }

    public void setGene_set(ArrayList<String> arrayList) {
        this.gene_set = arrayList;
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            GenesetMembershipHeader.this.repaint();
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            if (mouseEvent.isShiftDown()) {
                return;
            }
            int n = GenesetMembershipHeader.this.findColumn(mouseEvent.getX());
            int n2 = GenesetMembershipHeader.this.findRow(mouseEvent.getY());
            if (n == -1) {
                return;
            }
            if (GenesetMembershipHeader.this.isShift && GenesetMembershipHeader.this.enableMoveable) {
                GenesetMembershipHeader.this.endShiftMove = n;
                if (GenesetMembershipHeader.this.startShiftMove - GenesetMembershipHeader.this.endShiftMove > Math.min(GenesetMembershipHeader.this.startShift, GenesetMembershipHeader.this.endShift)) {
                    GenesetMembershipHeader.this.endShiftMove = GenesetMembershipHeader.this.startShiftMove - Math.min(GenesetMembershipHeader.this.startShift, GenesetMembershipHeader.this.endShift);
                }
                if (GenesetMembershipHeader.this.endShiftMove - GenesetMembershipHeader.this.startShiftMove > GenesetMembershipHeader.this.getGene_set().size() - Math.max(GenesetMembershipHeader.this.startShift, GenesetMembershipHeader.this.endShift) - 1) {
                    GenesetMembershipHeader.this.endShiftMove = GenesetMembershipHeader.this.startShiftMove + GenesetMembershipHeader.this.getGene_set().size() - Math.max(GenesetMembershipHeader.this.startShift, GenesetMembershipHeader.this.endShift) - 1;
                }
                return;
            }
            if (!GenesetMembershipHeader.this.enableMoveable) {
                // empty if block
            }
            if (!GenesetMembershipHeader.this.isLegalPosition(n2, n)) {
                GenesetMembershipHeader.this.headerDrag = false;
                return;
            }
            if (!GenesetMembershipHeader.this.headerDrag) {
                return;
            }
            if (n >= GenesetMembershipHeader.this.getGene_set().size()) {
                GenesetMembershipHeader.this.headerDrag = false;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

