/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.Geneset;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.GSEAExperiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAInfoDisplay;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GenesetMembershipHeader;
import org.tigr.util.FloatMatrix;

public class GenesetMembership
extends JPanel
implements IViewer {
    private ArrayList<String> unique_genes = new ArrayList();
    private ArrayList<String> gene_sets = new ArrayList();
    private ArrayList<String> sampleNames = new ArrayList();
    private Geneset[] gSets;
    private GSEAExperiment experimentObject;
    private FloatMatrix experimentMatrix;
    private GenesetMembershipHeader header;
    private int contentWidth = 0;
    private int[] columns;
    private FontMetrics metrics;
    private Dimension elementSize = new Dimension(20, 10);
    public static Color missingColor = new Color(105, 105, 105);
    public static Color maskColor = new Color(255, 255, 255, 128);
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private int firstSelectedColumn = -1;
    private int lastSelectedColumn = -1;
    private Insets insets = new Insets(0, 10, 0, 0);
    private boolean isDrawBorders = true;
    private boolean useDoubleGradient = true;
    private boolean isAntiAliasing = true;
    private static final float INITIAL_MAX_VALUE = 0.5f;
    private static final float INITIAL_MIN_VALUE = -0.5f;
    private float maxValue = 0.5f;
    private float minValue = -0.5f;
    private float midValue = 0.0f;
    private int width = 0;
    private int height = 0;
    private Graphics2D graphics;
    private Font font;

    public GenesetMembership(ArrayList<String> arrayList, ArrayList<String> arrayList2, Geneset[] genesetArray) {
        this.font = new Font("monospaced", 0, this.elementSize.height);
        this.setUnique_genes(arrayList);
        this.setGene_sets(arrayList2);
        this.setSampleNames(arrayList2);
        this.experimentMatrix = new FloatMatrix(this.unique_genes.size(), this.gene_sets.size() + 1, Float.NaN);
        this.gSets = genesetArray;
        this.createExperimentObject();
        this.header = new GenesetMembershipHeader(this.getSampleNames());
        this.addMouseListener(new Listener());
        this.addMouseMotionListener(new Listener());
        this.setBackground(Color.white);
    }

    public void createExperimentObject() {
        int n = this.unique_genes.size();
        int n2 = this.gene_sets.size();
        int n3 = 0;
        int n4 = 1;
        for (n3 = 0; n3 < n2; ++n3) {
            ArrayList arrayList = new ArrayList();
            arrayList = this.gSets[n3].getGenesinGeneset();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                string = string.trim();
                for (int j = 0; j < n; ++j) {
                    String string2 = this.unique_genes.get(j);
                    if (!(string2 = string2.trim()).equals(string)) continue;
                    this.experimentMatrix.set(j, 0, this.gSets[n3].getGeneSetElement(i).getTestStat());
                    this.experimentMatrix.set(j, n4, this.gSets[n3].getGeneSetElement(i).getTestStat());
                }
            }
            ++n4;
        }
        this.experimentObject = new GSEAExperiment(this.experimentMatrix, this.createColumns(this.gene_sets.size() + 1));
    }

    protected int getNamesWidth(FontMetrics fontMetrics) {
        int n = 0;
        for (int i = 0; i < this.gene_sets.size(); ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.gene_sets.get(i)));
        }
        return n;
    }

    protected int getGeneNamesWidth(Graphics2D graphics2D) {
        int n = 0;
        this.metrics = graphics2D.getFontMetrics();
        for (int i = 0; i < this.unique_genes.size(); ++i) {
            n = Math.max(n, this.metrics.stringWidth(this.unique_genes.get(i)));
        }
        return n;
    }

    public int getCurrentWidth() {
        return this.width;
    }

    public void setCurrentWidth(int n) {
        this.width = n;
    }

    public int getCurrentHeight() {
        return this.height;
    }

    public void setCurrentHeight(int n) {
        this.height = n;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        graphics.setFont(this.font);
        this.graphics = (Graphics2D)graphics;
        Rectangle rectangle = this.graphics.getClipBounds();
        int n3 = this.getTopIndex(rectangle.y);
        int n4 = this.getBottomIndex(rectangle.y + rectangle.height, this.getUnique_genes().size());
        int n5 = this.getLeftIndex(rectangle.x);
        int n6 = this.getRightIndex(rectangle.x + rectangle.width, this.getGene_sets().size() + 1);
        if (this.elementSize.getHeight() < 1.0) {
            return;
        }
        int n7 = this.getGene_sets().size();
        for (n2 = n5; n2 < n6; ++n2) {
            for (n = n3; n < n4; ++n) {
                this.fillRectAt(this.graphics, n, n2);
            }
        }
        this.graphics.setFont(this.font);
        this.graphics.setStroke(new BasicStroke(2.0f));
        this.graphics.setColor(Color.black);
        if (n6 >= n7) {
            n2 = this.elementSize.width * n7 + this.elementSize.width * 2;
            n = n3;
            for (int i = 0; i < this.unique_genes.size(); ++i) {
                String string = this.getUnique_genes().get(i);
                int n8 = (n + 1) * this.elementSize.height;
                this.graphics.drawString(string, n2 + this.insets.left, n8 - 1);
                if (n >= n4) continue;
                ++n;
            }
        }
    }

    private void fillRectAt(Graphics graphics, int n, int n2) {
        if (n2 > this.experimentObject.getNumberOfSamples() - 1 || n > this.experimentObject.getNumberOfGenes() - 1) {
            return;
        }
        int n3 = n2 * this.elementSize.width + this.insets.left;
        int n4 = n * this.elementSize.height;
        boolean bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        bl = bl || this.firstSelectedColumn >= 0 && this.lastSelectedColumn >= 0 && (n2 < this.firstSelectedColumn || n2 > this.lastSelectedColumn);
        graphics.setColor(this.getColor(this.experimentObject.get(n, n2)));
        graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n3, n4, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        if (n2 >= this.experimentObject.getNumberOfSamples()) {
            return;
        }
        graphics.drawRect(n2 * this.elementSize.width + this.insets.left, n * this.elementSize.height, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private Color getColor(float f) {
        int n;
        if (Float.isNaN(f)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float f2 = f < this.midValue ? this.minValue : this.maxValue;
            int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
            if (n2 < 0) {
                n2 = -n2;
            }
            n2 = n2 > 255 ? 255 : n2;
            n = f < this.midValue ? this.negColorImage.getRGB(255 - n2, 0) : this.posColorImage.getRGB(n2, 0);
        } else {
            float f3 = this.maxValue - this.minValue;
            int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
            n = this.posColorImage.getRGB(n3, 0);
        }
        return new Color(n);
    }

    private void updateSize() {
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = this.elementSize.width * this.getGene_sets().size() + 1 + this.insets.left;
        this.contentWidth = n += 20 + this.getGeneNamesWidth(graphics2D);
        int n2 = this.elementSize.height * this.getUnique_genes().size() + 1;
        this.setSize(n, n2);
        if (this.header.getSize().width < n) {
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
        } else {
            this.setSize(new Dimension(this.header.getSize().width, this.getSize().height));
            this.setPreferredSize(new Dimension(this.header.getSize().width, this.getSize().height));
        }
        this.header.setHeaderWidth(n);
    }

    public int[][] createSpotIndices(int n) {
        int[][] nArray = new int[1][n];
        for (int i = 0; i < n; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    public int[] createColumns(int n) {
        this.columns = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columns[i] = i;
        }
        return this.columns;
    }

    public FontMetrics getFontMetric() {
        return this.metrics;
    }

    public void setFontMetric(FontMetrics fontMetrics) {
        this.metrics = fontMetrics;
    }

    private int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < this.insets.left) {
            return 0;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int findColumn(int n) {
        int n2 = this.experimentObject.getNumberOfSamples() * this.elementSize.width;
        if (n < this.insets.left) {
            return -1;
        }
        if (n >= n2 + this.insets.left && n < n2 + this.insets.left + this.elementSize.width + 10) {
            return (n - this.insets.left - 5) / this.elementSize.width;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int findRow(int n) {
        int n2 = this.unique_genes.size() * this.elementSize.height;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.height;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.experimentObject.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.unique_genes.size() - 1;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public Experiment getExperiment() {
        return this.experimentObject;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.unique_genes, this.gene_sets, this.gSets});
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData iData) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.updateSize();
        if (this.elementSize.equals(iDisplayMenu.getElementSize()) && this.isAntiAliasing == iDisplayMenu.isAntiAliasing()) {
            return;
        }
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
        this.updateSize();
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
    }

    private void setElementSize(Dimension dimension) {
        this.elementSize = new Dimension(dimension);
    }

    private void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    public void onSelected(IFramework iFramework) {
        this.updateSize();
        this.header.updateSizes(this.header.getSize().width, this.elementSize.width);
    }

    public void setExperiment(Experiment experiment) {
    }

    public void setExperimentID(int n) {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public ArrayList<String> getUnique_genes() {
        return this.unique_genes;
    }

    public void setUnique_genes(ArrayList<String> arrayList) {
        this.unique_genes = arrayList;
    }

    public void setGene_sets(ArrayList<String> arrayList) {
        this.gene_sets = arrayList;
    }

    public ArrayList<String> getGene_sets() {
        return this.gene_sets;
    }

    public int getContentWidth() {
        this.updateSize();
        return this.contentWidth;
    }

    public ArrayList<String> getSampleNames() {
        return this.sampleNames;
    }

    public void setSampleNames(ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size() + 1; ++i) {
            if (i == 0) {
                this.sampleNames.add(i, "Test Statistic");
                continue;
            }
            this.sampleNames.add(i, arrayList.get(i - 1));
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private int oldRow = -1;
        private int oldColumn = -1;
        GSEAInfoDisplay display;

        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = GenesetMembership.this.findColumn(mouseEvent.getX());
            int n2 = GenesetMembership.this.findRow(mouseEvent.getY());
            if (GenesetMembership.this.isLegalPosition(n2, n) && n < GenesetMembership.this.experimentObject.getNumberOfSamples()) {
                this.display = n == 0 ? new GSEAInfoDisplay(null, "Geneset Membership Info Dialog", false, "NA", GenesetMembership.this.getUnique_genes().get(n2), Float.toString(GenesetMembership.this.experimentObject.get(n2, n))) : new GSEAInfoDisplay(null, "Geneset Membership Info Dialog", false, GenesetMembership.this.getGene_sets().get(n - 1), GenesetMembership.this.getUnique_genes().get(n2), Float.toString(GenesetMembership.this.experimentObject.get(n2, n)));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private void setOldPosition(int n, int n2) {
            this.oldColumn = n2;
            this.oldRow = n;
        }

        private boolean isCurrentPosition(int n, int n2) {
            return n == this.oldRow && n2 == this.oldColumn;
        }
    }
}

