/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.GSEAExperiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.GSEAURLLinkDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.TableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.QSort;

public class GSEATableViewer
extends TableViewer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SAVE_PVALUES_TABLE_COMMAND = "save_pvalues_table_command";
    private static final String STORE_CLUSTER_COMMAND = "store_cluster_command";
    private static final String LINK_TO_URL_COMMAND = "link-to-url-command";
    private static final String CLEAR_ALL_COMMAND = "clear-all-cmd";
    private static final String SELECT_ALL_COMMAND = "select-all-cmd";
    private static final String LAUNCH_EXPRESSION_GRAPH_COMMAND = "launch-expression-graph-command";
    private static final String LAUNCH_CENTROID_GRAPH_COMMAND = "launch-centroid-graph-command";
    private static final String LAUNCH_EXPRESSION_IMAGE_COMMAND = "launch-expression-image-command";
    private static final String LAUNCH_TEST_STATISTIC_GRAPH_COMMAND = "launch-test-statistic-graph-command";
    private static final String LAUNCH_LEADING_EDGE_STATISTIC_GRAPH_COMMAND = "launch-leading-edge-statistic-graph-command";
    protected DefaultMutableTreeNode gseaRoot;
    protected JPopupMenu menu;
    protected GSEAExperiment experiment;
    protected int[][] clusters;
    protected boolean clusterAnalysis;
    protected boolean haveAccessionNumbers;
    private JMenuItem urlMenuItem;
    int xColumn;
    private int[] sortedIndices;
    private int[] indices;
    private boolean[] sortedAscending;

    public GSEATableViewer(String[] stringArray, Object[][] objectArray, DefaultMutableTreeNode defaultMutableTreeNode, GSEAExperiment gSEAExperiment) {
        super(stringArray, objectArray);
        int n;
        this.indices = new int[objectArray.length];
        this.sortedIndices = new int[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            this.indices[n] = n;
            this.sortedIndices[n] = n;
        }
        this.xColumn = -1;
        this.setNumerical(0, true);
        this.gseaRoot = defaultMutableTreeNode;
        this.menu = this.createPopupMenu();
        this.experiment = gSEAExperiment;
        this.table.setRowSelectionAllowed(true);
        this.sortedAscending = new boolean[this.table.getModel().getColumnCount()];
        for (n = 0; n < this.sortedAscending.length; ++n) {
            this.sortedAscending[n] = false;
        }
        this.table.addMouseListener(new Listener());
        this.addMouseListenerToHeaderInTable(this.table);
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public GSEATableViewer(String[] stringArray, Object[][] objectArray) {
        super(stringArray, objectArray);
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.headerNames, this.data});
    }

    protected JPopupMenu createPopupMenu() {
        Listener listener = new Listener();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Store Selection as Cluster");
        jMenuItem.setActionCommand(STORE_CLUSTER_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu("Open Viewer");
        jMenuItem = new JMenuItem("Expression Image");
        jMenuItem.setActionCommand(LAUNCH_EXPRESSION_IMAGE_COMMAND);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Centroid Graph");
        jMenuItem.setActionCommand(LAUNCH_CENTROID_GRAPH_COMMAND);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Expression Graph");
        jMenuItem.setActionCommand(LAUNCH_EXPRESSION_GRAPH_COMMAND);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Leading Edge Graph");
        jMenuItem.setActionCommand(LAUNCH_LEADING_EDGE_STATISTIC_GRAPH_COMMAND);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Test Statistic Graph");
        jMenuItem.setActionCommand(LAUNCH_TEST_STATISTIC_GRAPH_COMMAND);
        jMenuItem.addActionListener(listener);
        jMenu.add(jMenuItem);
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Save pValues Table");
        jMenuItem.setActionCommand(SAVE_PVALUES_TABLE_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon("TableViewerResult.gif"));
        jMenuItem.setActionCommand(SELECT_ALL_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon("TableViewerResult.gif"));
        jMenuItem.setActionCommand(CLEAR_ALL_COMMAND);
        jMenuItem.addActionListener(listener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.urlMenuItem = new JMenuItem("Link to URL");
        this.urlMenuItem.setActionCommand(LINK_TO_URL_COMMAND);
        this.urlMenuItem.addActionListener(listener);
        jPopupMenu.add(this.urlMenuItem);
        return jPopupMenu;
    }

    protected void onOpenViewer(String string) {
        int n = this.table.getSelectedRow();
        if (n == -1 || this.gseaRoot == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.gseaRoot.getChildAt(3);
        n = new Integer((String)this.table.getValueAt(n, 0)) - 1;
        if (defaultMutableTreeNode.getChildCount() < n) {
            return;
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        if (string.equals("expression image")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        } else if (string.equals("centroid graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        } else if (string.equals("expression graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(2);
        } else if (string.equals("Test statistics graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(3);
        } else if (string.equals("leading edge graph")) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(5);
        }
        if (this.framework != null) {
            this.framework.setTreeNode(defaultMutableTreeNode);
        }
    }

    public void onSelected(IFramework iFramework) {
        super.onSelected(iFramework);
        if (this.gseaRoot == null) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iFramework.getCurrentNode().getParent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof String && ((String)object).indexOf("GSEA") != -1) {
                    this.gseaRoot = defaultMutableTreeNode;
                }
            }
            catch (Exception exception) {
                System.out.println("selection exception");
                exception.printStackTrace();
            }
        }
    }

    private void linkToURL2() {
        JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(this.table);
        this.xColumn = this.table.getSelectedColumn();
        String string = this.table.getColumnName(this.xColumn);
        String string2 = (String)this.table.getValueAt(this.table.getSelectedRow(), this.xColumn);
        File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
        GSEAURLLinkDialog gSEAURLLinkDialog = new GSEAURLLinkDialog(jFrame, false, string2, this.table.getSelectedRow(), string, file);
        gSEAURLLinkDialog.setVisible(true);
    }

    protected void onStoreSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((TableViewer.DefaultViewerTableModel)this.model).getRow(nArray[i]);
        }
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String string = "";
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                int n = nArray.length;
                int n2 = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        printWriter.print((String)this.table.getValueAt(nArray[i], j) + "\t");
                    }
                    printWriter.print("\n");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + string, "Output Error", 2);
            }
        }
    }

    protected void onSavepValuesTable() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String string = "";
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                int n = this.table.getRowCount();
                int n2 = this.table.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        printWriter.print((String)this.table.getValueAt(i, j) + "\t");
                    }
                    printWriter.print("\n");
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + string, "Output Error", 2);
            }
        }
    }

    protected int[] getGeneIndices(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += this.clusters[nArray[i]].length;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.clusters[nArray[i]].length; ++j) {
                nArray2[n2] = this.clusters[nArray[i]][j];
                ++n2;
            }
        }
        return nArray2;
    }

    protected int[] mapExperimentIndicesToGeneData(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experiment.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    protected void validateMenuOptions() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return;
        }
    }

    public int[] getCluster() {
        return this.indices;
    }

    public int[] getSortedCluster() {
        return this.sortedIndices;
    }

    public void sortInOrigOrder() {
        int n;
        for (n = 0; n < this.getSortedCluster().length; ++n) {
            this.sortedIndices[n] = this.getCluster()[n];
        }
        this.table.repaint();
        this.table.clearSelection();
        for (n = 0; n < this.table.getModel().getColumnCount(); ++n) {
            this.sortedAscending[n] = false;
        }
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 2;
                    boolean bl = n3 != 0;
                    GSEATableViewer.this.sortByColumn(n2, !GSEATableViewer.this.sortedAscending[n2], bl);
                    boolean bl2 = ((GSEATableViewer)GSEATableViewer.this).sortedAscending[n2] = !GSEATableViewer.this.sortedAscending[n2];
                    if (bl) {
                        for (int i = 0; i < GSEATableViewer.this.table.getModel().getColumnCount(); ++i) {
                            ((GSEATableViewer)GSEATableViewer.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void sortByColumn(int n, boolean bl, boolean bl2) {
        Object[] objectArray;
        if (bl2) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedIndices[i] = this.getCluster()[i];
            }
            this.table.repaint();
            this.table.clearSelection();
            return;
        }
        int[] nArray = new int[this.getCluster().length];
        int n2 = GSEATableViewer.getObjectType(this.data[0][n]);
        if (n2 == 12 || n2 == 11 || n2 == 10) {
            objectArray = new double[this.getCluster().length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (n2 == 12) {
                    objectArray[i] = (Double)this.data[this.getCluster()[i]][n];
                    continue;
                }
                if (n2 == 11) {
                    objectArray[i] = ((Float)this.data[this.getCluster()[i]][n]).doubleValue();
                    continue;
                }
                if (n2 != 10) continue;
                objectArray[i] = ((Integer)this.data[this.getCluster()[i]][n]).doubleValue();
            }
            QSort qSort = new QSort(objectArray);
            int[] nArray2 = qSort.getOrigIndx();
            for (int i = 0; i < nArray2.length; ++i) {
                nArray[i] = this.getCluster()[nArray2[i]];
            }
        } else if (n2 == 13) {
            int n3;
            objectArray = new SortableField[this.getCluster().length];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                int n4 = this.getCluster()[n3];
                String string = (String)this.data[this.getCluster()[n3]][n];
                objectArray[n3] = (double)new SortableField(n4, string);
            }
            Arrays.sort(objectArray);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                nArray[n3] = objectArray[n3].getIndex();
            }
        }
        if (!bl) {
            nArray = this.reverse(nArray);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedIndices[i] = nArray[i];
        }
        this.table.repaint();
        this.table.removeRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private static int getObjectType(Object object) {
        int n = -1;
        if (object instanceof Boolean) {
            return 14;
        }
        if (object instanceof Double) {
            return 12;
        }
        if (object instanceof Float) {
            return 11;
        }
        if (object instanceof Integer) {
            return 10;
        }
        if (object instanceof String) {
            return 13;
        }
        return n;
    }

    protected class Listener
    extends MouseAdapter
    implements ActionListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(GSEATableViewer.LINK_TO_URL_COMMAND)) {
                GSEATableViewer.this.linkToURL2();
            } else if (string.equals(GSEATableViewer.STORE_CLUSTER_COMMAND)) {
                GSEATableViewer.this.onStoreSelectedRows();
            } else if (string.equals(GSEATableViewer.SAVE_PVALUES_TABLE_COMMAND)) {
                GSEATableViewer.this.onSavepValuesTable();
            } else if (string.equals(GSEATableViewer.CLEAR_ALL_COMMAND)) {
                GSEATableViewer.this.table.clearSelection();
            } else if (string.equals(GSEATableViewer.SELECT_ALL_COMMAND)) {
                GSEATableViewer.this.table.selectAll();
            } else if (string.equals(GSEATableViewer.LAUNCH_EXPRESSION_IMAGE_COMMAND)) {
                GSEATableViewer.this.onOpenViewer("expression image");
            } else if (string.equals(GSEATableViewer.LAUNCH_CENTROID_GRAPH_COMMAND)) {
                GSEATableViewer.this.onOpenViewer("centroid graph");
            } else if (string.equals(GSEATableViewer.LAUNCH_EXPRESSION_GRAPH_COMMAND)) {
                GSEATableViewer.this.onOpenViewer("expression graph");
            } else if (string.equals(GSEATableViewer.LAUNCH_LEADING_EDGE_STATISTIC_GRAPH_COMMAND)) {
                GSEATableViewer.this.onOpenViewer("leading edge graph");
            } else if (string.equals(GSEATableViewer.LAUNCH_TEST_STATISTIC_GRAPH_COMMAND)) {
                GSEATableViewer.this.onOpenViewer("Test statistics graph");
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (GSEATableViewer.this.table.getSelectedRowCount() != 1) {
                    GSEATableViewer.this.urlMenuItem.setEnabled(false);
                } else {
                    GSEATableViewer.this.urlMenuItem.setEnabled(true);
                }
                GSEATableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                GSEATableViewer.this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int n, String string) {
            this.index = n;
            this.field = string;
        }

        public int compareTo(Object object) {
            SortableField sortableField = (SortableField)object;
            return this.field.compareTo(sortableField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }
}

