/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.GSEAWizard;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.DataPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.ParameterPanel;

public class GSEAInitWizard
extends GSEAWizard {
    private static final long serialVersionUID = 1L;
    private DataPanel dataPanel;
    private IWizardParameterPanel parameterPanel;
    private IWizardParameterPanel currentPanel;

    public GSEAInitWizard(IData iData, JFrame jFrame, String string, boolean bl, AlgorithmData algorithmData, String[] stringArray, int n, JPanel jPanel, ClusterRepository clusterRepository, IFramework iFramework) {
        super(jFrame, string, bl, algorithmData, stringArray, n, jPanel);
        this.dataPanel = new DataPanel(iData, algorithmData, jFrame, clusterRepository, iFramework, this);
        this.currentPanel = this.dataPanel;
        super.setInitialPanel(this.dataPanel);
        this.parameterPanel = new ParameterPanel(algorithmData, jFrame, iFramework, this);
    }

    @Override
    protected IWizardParameterPanel prepareAndDeliverNextParameterPanel(AlgorithmData algorithmData, int n) {
        IWizardParameterPanel iWizardParameterPanel = null;
        this.currentPanel.populateAlgorithmData();
        if (n == 0) {
            if (algorithmData.getIntMatrix("factor-assignments") != null) {
                this.currentPanel = iWizardParameterPanel = this.parameterPanel;
                this.setPreferredSize(new Dimension(650, 700));
            } else {
                String string = new String();
                string = "<html>You have to specify factor levels and sample group assignments before you can proceed further <br></html>";
                JOptionPane.showMessageDialog(null, string, "Error", 1);
            }
        }
        if (n == 1) {
            // empty if block
        }
        return iWizardParameterPanel;
    }

    @Override
    protected IWizardParameterPanel prepareAndDeliverPreviousParameterPanel(AlgorithmData algorithmData, int n) {
        DataPanel dataPanel = null;
        this.currentPanel.clearValuesFromAlgorithmData();
        this.setPreferredSize(new Dimension(800, 850));
        if (n == 1) {
            dataPanel = this.dataPanel;
            this.currentPanel = dataPanel;
            this.dataPanel.gseaInitWizard.setParamSufficient(this.dataPanel.validateSampleSelection());
        }
        return dataPanel;
    }

    @Override
    protected boolean nextStep() {
        if (!super.nextStep() && super.showModal() == 0) {
            this.dispose();
        }
        return true;
    }

    public IWizardParameterPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public void setParameterPanel(IWizardParameterPanel iWizardParameterPanel) {
        this.parameterPanel = iWizardParameterPanel;
    }

    public DataPanel getDataPanel() {
        return this.dataPanel;
    }
}

