/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.InfoDisplay;
import org.tigr.util.awt.ActionInfoDialog;
import org.tigr.util.awt.GBA;

public class GSEAInfoDisplay
extends ActionInfoDialog {
    private String geneSetName;
    private String geneName;
    private String testStats;
    private EventListener listener = new EventListener();

    public GSEAInfoDisplay(JFrame jFrame, String string, boolean bl, String string2, String string3, String string4) {
        super(jFrame, string, bl);
        this.setGeneName(string3);
        this.setGeneSetName(string2);
        this.setTestStats(string4);
        this.init();
    }

    private void init() {
        Font font = new Font("Arial", 0, 10);
        JLabel jLabel = new JLabel(new ImageIcon(InfoDisplay.class.getResource("/org/tigr/images/spot.gif")));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setFont(font);
        jEditorPane.setBackground(new Color(Integer.parseInt("FFFFCC", 16)));
        jEditorPane.setEditable(false);
        jEditorPane.setMargin(new Insets(10, 15, 10, 10));
        jEditorPane.setText(this.createMessage());
        jEditorPane.setCaretPosition(0);
        JButton jButton = new JButton("Close Spot Information");
        jButton.setActionCommand("close");
        jButton.addActionListener(this.listener);
        this.contentPane.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 30);
        jScrollPane.getViewport().setBackground(Color.white);
        GBA gBA = new GBA();
        gBA.add(this.contentPane, (Component)jScrollPane, 0, 0, 3, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.contentPane, (Component)jButton, 0, 3, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.pack();
        this.setSize(600, 500);
        this.setResizable(true);
        this.setTitle("Spot Information");
        this.setLocation(300, 100);
        this.setVisible(true);
    }

    private String createMessage() {
        String string = "<html><body bgcolor=\"#FFFFCC\"><basefont face =\"monospaced\"><font size=4><p>Gene set membership plot shows the overlap of genes and genesets. Each row represents a gene present in the expression data.First column contains the (sorted) test statistic computed for each gene. All following columns show individual genesets.Gray colored cell is indicative of the gene not being present in that geneset and test statistic for such a gene will be NA</p> ";
        if (this.getGeneSetName().equalsIgnoreCase("NA")) {
            string = string + "<table cellpadding=4 valign=top><th colspan=2 align=left valign=center><font size=6>Gene and Teststatistic</font></th>";
            string = string + "<tr><td><i>GeneName</i></td><td>" + this.getGeneName() + "</td></tr>";
            string = string + "<tr><td><i>Test statistics</i></td><td>" + this.getTestStats() + "</td></tr>";
            string = string + "</table>";
            string = string + "</basefont></font></body></html>";
        } else if (this.getTestStats().equalsIgnoreCase(Float.toString(Float.NaN))) {
            string = string + "<table cellpadding=4 valign=top><th colspan=2 align=left valign=center><font size=6>Geneset and Genes</font></th>";
            string = string + "<tr><td><i>Geneset</i></td><td>" + this.getGeneSetName() + "</td></tr>" + "<tr><td><i>Gene</i></td><td>" + this.getGeneName() + "</td></tr>";
            string = string + "<tr><td><i>Test statistics</i></td><td>NA</td></tr>";
            string = string + "<tr><td><i>Status</i></td><td>Gene not present in this geneset</td></tr>";
            string = string + "</table>";
            string = string + "</basefont></font></body></html>";
        } else {
            string = string + "<table cellpadding=4 valign=top><th colspan=2 align=left valign=center><font size=6>Geneset and Genes</font></th>";
            string = string + "<tr><td><i>Geneset</i></td><td>" + this.getGeneSetName() + "</td></tr>" + "<tr><td><i>Gene</i></td><td>" + this.getGeneName() + "</td></tr>";
            string = string + "<tr><td><i>Test statistics</i></td><td>" + this.getTestStats() + "</td></tr>";
            string = string + "<tr><td><i>Status</i></td><td>Gene is present in this geneset</td></tr>";
            string = string + "</table>";
            string = string + "</basefont></font></body></html>";
        }
        return string;
    }

    public String getGeneSetName() {
        return this.geneSetName;
    }

    public void setGeneSetName(String string) {
        this.geneSetName = string;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String string) {
        this.geneName = string;
    }

    public String getTestStats() {
        return this.testStats;
    }

    public void setTestStats(String string) {
        this.testStats = string;
    }

    private class EventListener
    implements ActionListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close")) {
                GSEAInfoDisplay.this.setVisible(false);
                GSEAInfoDisplay.this.dispose();
            }
        }
    }
}

