/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.gsea;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GSEAUtils;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneDataElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneSetElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.Geneset;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.ProbetoGene;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.ReadGeneSet;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.GSEAExperiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Logger;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEACentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAConstants;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAInitWizard;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEATableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GenesetMembership;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.LeadingEdgeSubsetViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.LeadingEdgeTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.PValueGraphViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.StepsPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.TestStatisticTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.TestStatisticViewer;
import org.tigr.util.FloatMatrix;

public class GSEAGUI
implements IClusterGUI {
    private Algorithm gsea;
    private Experiment experiment;
    private IData idata;
    private Logger logger;
    private Listener listener;
    private String[][] geneToProbeMapping;
    int max_columns;
    private AlgorithmData algData = new AlgorithmData();
    private HashMap<String, LinkedHashMap<String, Float>> orderedTestStats = new HashMap();
    private HashMap<String, LinkedHashMap<String, Float>> descendingSortedTStats = new HashMap();
    private Geneset[] geneset = null;
    private IGeneData[] gData = null;
    private ArrayList<String> sorted_gene_names = new ArrayList();
    private boolean stop = false;

    public DefaultMutableTreeNode execute(IFramework iFramework) throws AlgorithmException {
        this.experiment = iFramework.getData().getExperiment();
        this.idata = iFramework.getData();
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Geneset[] genesetArray = null;
        this.algData.addMatrix("matrix", floatMatrix);
        JFrame jFrame = (JFrame)iFramework.getFrame();
        String[] stringArray = new String[]{"Data Selection.", "Parameter Selection.", "Execute."};
        GSEAInitWizard gSEAInitWizard = new GSEAInitWizard(this.idata, jFrame, "GSEA Initialization", true, this.algData, stringArray, 1, new StepsPanel(), iFramework.getClusterRepository(1), iFramework);
        gSEAInitWizard.setVisible(true);
        this.listener = new Listener();
        this.logger = new Logger(iFramework.getFrame(), "Gene Set Enrichment Analysis", this.listener);
        if (gSEAInitWizard.showModal() == 0) {
            FloatMatrix floatMatrix2;
            AlgorithmData algorithmData;
            this.logger.show();
            String string = this.algData.getParams().getString("gene-set-directory");
            String string2 = this.checkFileNameExtension(string);
            String string3 = this.algData.getParams().getString("probe_value");
            int n = Integer.parseInt(this.algData.getParams().getString("gene-number"));
            String string4 = this.algData.getParams().getString("standard-deviation-cutoff");
            ProbetoGene probetoGene = new ProbetoGene(this.algData, this.idata);
            this.logger.append("Collapsing probes to genes \n");
            if (this.stop) {
                return null;
            }
            this.gData = probetoGene.convertProbeToGene(this.algData.getParams().getString("gene-identifier"), string3, string4);
            probetoGene.returnGSEAExperiment();
            Vector vector = this.algData.getVector("Unique-Genes-in-Expressionset");
            this.logger.append("Reading gene set files \n");
            if (this.stop) {
                return null;
            }
            ReadGeneSet readGeneSet = new ReadGeneSet(string2, string);
            try {
                genesetArray = readGeneSet.readMultipleFiles(this.algData.getStringArray("gene-set-files"), string);
                algorithmData = readGeneSet.removeGenesNotinExpressionData(genesetArray, vector);
                this.logger.append("Creating Association Matrix \n");
                if (this.stop) {
                    return null;
                }
                floatMatrix2 = readGeneSet.createAssociationMatrix((Geneset[])algorithmData, vector, n);
                this.algData.addGeneMatrix("association-matrix", floatMatrix2);
                this.geneset = new Geneset[((AlgorithmData)algorithmData).length - readGeneSet.getExcludedGeneSets().size()];
                this.logger.append("Removing gene sets that do not pass the minimum genes criteria \n");
                this.geneset = readGeneSet.removeGenesetsWithoutMinimumGenes(readGeneSet.getExcludedGeneSets(), (Geneset[])algorithmData);
                this.algData.addVector("gene-set-names", new GSEAUtils().getGeneSetNames(this.geneset));
                this.algData.addVector("excluded-gene-sets", readGeneSet.getExcludedGeneSets());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.gsea = iFramework.getAlgorithmFactory().getAlgorithm("GSEA");
            this.gsea.addAlgorithmListener((AlgorithmListener)this.listener);
            this.logger.append("Algorithm execution begins... \n");
            algorithmData = this.gsea.execute(this.algData);
            this.logger.append("Algorithm execution ends...\n");
            if (this.stop) {
                return null;
            }
            this.logger.append("Generating Viewers...\n");
            floatMatrix2 = new GSEAUtils();
            this.geneset = floatMatrix2.populateTestStatistic(this.gData, this.geneset, this.algData.getGeneMatrix("lmPerGene-coefficients"));
            this.orderedTestStats = floatMatrix2.getSortedTestStats(this.geneset);
            this.sorted_gene_names = floatMatrix2.getSorted_gene_names();
            this.descendingSortedTStats = floatMatrix2.getDescendingSortedTestStats(this.geneset);
            this.geneToProbeMapping = ((GeneData)this.gData[0]).getProbetoGeneMapping(this.gData);
            this.max_columns = ((GeneData)this.gData[0]).get_max_num_probes_mapping_to_gene();
            defaultMutableTreeNode = algorithmData.getMappings("over-enriched") == null ? this.createEmptyResultNode(algorithmData) : this.createResultNode(algorithmData, this.idata, null);
            this.logger.append("Generating Viewers ends...\n");
            this.logger.dispose();
            return defaultMutableTreeNode;
        }
        return null;
    }

    protected DefaultMutableTreeNode createEmptyResultNode(AlgorithmData algorithmData) {
        return this.createEmptyResultNode(algorithmData, "GSEA");
    }

    protected DefaultMutableTreeNode createEmptyResultNode(AlgorithmData algorithmData, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("No results found"));
        this.addGeneralInfo(defaultMutableTreeNode, algorithmData);
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createResultNode(AlgorithmData algorithmData, IData iData, GSEAExperiment gSEAExperiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        defaultMutableTreeNode = new DefaultMutableTreeNode("GSEA");
        this.addPValueGraphImage(defaultMutableTreeNode, algorithmData);
        this.addGenesetMembershipPlot(defaultMutableTreeNode, algorithmData);
        this.addTableViews(defaultMutableTreeNode, algorithmData, gSEAExperiment, iData);
        this.addResultImages(defaultMutableTreeNode, algorithmData, this.experiment);
        return defaultMutableTreeNode;
    }

    private void addGenesetMembershipPlot(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        Object[] objectArray = algorithmData.getMappings("over-enriched").keySet().toArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add((String)objectArray[i]);
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Geneset Membership Plot", (IViewer)new GenesetMembership(this.sorted_gene_names, arrayList, this.geneset))));
    }

    private void addPValueGraphImage(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        LinkedHashMap linkedHashMap = algorithmData.getMappings("over-enriched");
        PValueGraphViewer pValueGraphViewer = new PValueGraphViewer("P Value graph", "Genesets", "p-Values", linkedHashMap);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new LeafInfo("Geneset p-value graph", (IViewer)pValueGraphViewer)));
    }

    private void addResultImages(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData, Experiment experiment) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Gene Set Results");
        String[] stringArray = new String[]{"Gene set", "Incremental J-G score"};
        String[] stringArray2 = new String[]{"Gene set", "Test Statistic"};
        GSEAUtils gSEAUtils = new GSEAUtils();
        Object[] objectArray = algorithmData.getMappings("over-enriched").keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = new int[1][];
            object = this.GenesettoProbeMapping(this.gData, this.geneset, (String)objectArray[i]);
            FloatMatrix floatMatrix = gSEAUtils.getMeans(experiment.getMatrix(), (int[][])object);
            FloatMatrix floatMatrix2 = gSEAUtils.getVariances(experiment.getMatrix(), floatMatrix, (int[][])object);
            GSEACentroidViewer gSEACentroidViewer = new GSEACentroidViewer(experiment, (int[][])object);
            gSEACentroidViewer.setMeans(floatMatrix.A);
            gSEACentroidViewer.setVariances(floatMatrix2.A);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Set " + (i + 1) + ": " + (String)objectArray[i]);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)new GSEAExperimentViewer(experiment, (int[][])object))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Centroid Graph", (IViewer)gSEACentroidViewer, (Object)new CentroidUserObject(new Integer(0).intValue(), 0))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Expression Graph", (IViewer)gSEACentroidViewer, (Object)new CentroidUserObject(new Integer(0).intValue(), 1))));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Test statistics graph", (IViewer)new TestStatisticViewer(this.getOrderedTestStats().get((String)objectArray[i])))));
            TestStatisticTableViewer testStatisticTableViewer = new TestStatisticTableViewer(stringArray2, this.getOrderedTestStatasStringArray(this.getOrderedTestStats().get((String)objectArray[i])));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Test statistics table view", (IViewer)testStatisticTableViewer)));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Leading Edge Graph", (IViewer)new LeadingEdgeSubsetViewer(this.getDescendingSortedTStats().get((String)objectArray[i])))));
            Object[][] objectArray2 = new LeadingEdgeSubsetViewer(this.getDescendingSortedTStats().get((String)objectArray[i])).getLeadingEdgeGenes();
            LeadingEdgeTableViewer leadingEdgeTableViewer = new LeadingEdgeTableViewer(stringArray, objectArray2);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new LeafInfo("Leading edge genes", (IViewer)leadingEdgeTableViewer)));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("General Information");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Analysis Options");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Selected Annotation and Geneset Files");
        String string = algorithmData.getParams().getString("annotation-file");
        defaultMutableTreeNode4.add(new DefaultMutableTreeNode("Annotation file selected: " + string));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Geneset Files");
        String[] stringArray = this.algData.getStringArray("gene-set-files");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("File: " + stringArray[i]));
            }
        }
        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        AlgorithmParameters algorithmParameters = this.algData.getParams();
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Algorithm Parameters");
        defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Probe to Gene collapse mode:" + algorithmParameters.getString("probe_value")));
        if (algorithmParameters.getString("probe_value").equals(GSEAConstants.SD)) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Standard Deviation Cutoff:" + algorithmParameters.getString("standard-deviation-cutoff")));
        }
        defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Minimum number of genes that must be presen in a geneset: " + algorithmParameters.getString("gene-number")));
        defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Number of permutations: " + algorithmParameters.getString("permutations")));
        defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Identifier used to annotate genes in the geneset: " + algorithmParameters.getString("gene-identifier")));
        String[] stringArray2 = this.algData.getStringArray("factor-names");
        for (int i = 0; i < stringArray2.length; ++i) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("Factorname:" + stringArray2[i]));
        }
        int[] nArray = this.algData.getIntArray("factor-levels");
        for (int i = 0; i < nArray.length; ++i) {
            defaultMutableTreeNode6.add(new DefaultMutableTreeNode("FactorLevel:" + nArray[i]));
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode6);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public HashMap<String, LinkedHashMap<String, Float>> getOrderedTestStats() {
        return this.orderedTestStats;
    }

    public String[][] getOrderedTestStatasStringArray(LinkedHashMap<String, Float> linkedHashMap) {
        String[][] stringArray = new String[linkedHashMap.size()][2];
        Iterator<String> iterator = linkedHashMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            stringArray[n][0] = string = iterator.next();
            stringArray[n][1] = Float.toString(linkedHashMap.get(string).floatValue());
            ++n;
        }
        return stringArray;
    }

    public HashMap<String, LinkedHashMap<String, Float>> getDescendingSortedTStats() {
        return this.descendingSortedTStats;
    }

    private int[][] GenesettoProbeMapping(IGeneData[] iGeneDataArray, Geneset[] genesetArray, String string) {
        int n;
        int n2 = 0;
        boolean bl = false;
        Object object = new int[1][];
        for (n = 0; n < genesetArray.length; ++n) {
            if (!genesetArray[n].getGeneSetName().equalsIgnoreCase(string)) continue;
            n2 = n;
            break;
        }
        ArrayList arrayList = genesetArray[n2].getGenesetElements();
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < arrayList.size(); ++n) {
            GeneSetElement geneSetElement = (GeneSetElement)arrayList.get(n);
            String string2 = geneSetElement.getGene();
            GeneDataElement geneDataElement = (GeneDataElement)((GeneData)iGeneDataArray[0]).getGeneDataElement(string2);
            for (int i = 0; i < geneDataElement.getProbePosition().size(); ++i) {
                vector.add((Integer)geneDataElement.getProbePosition().get(i));
            }
        }
        int[] nArray = new int[vector.size()];
        object = new int[1][vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[0][i] = (Integer)vector.get(i);
        }
        return object;
    }

    private void addTableViews(DefaultMutableTreeNode defaultMutableTreeNode, AlgorithmData algorithmData, GSEAExperiment gSEAExperiment, IData iData) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Results");
        LinkedHashMap linkedHashMap = algorithmData.getMappings("over-enriched");
        LinkedHashMap linkedHashMap2 = algorithmData.getMappings("under-enriched");
        Object[][] objectArray = new String[linkedHashMap.size()][4];
        Object[] objectArray2 = linkedHashMap.keySet().toArray();
        for (int i = 0; i < linkedHashMap.size(); ++i) {
            objectArray[i][0] = Integer.toString(i + 1);
            objectArray[i][1] = (String)objectArray2[i];
            objectArray[i][2] = ((Float)linkedHashMap2.get(objectArray2[i])).toString();
            objectArray[i][3] = ((Float)linkedHashMap.get(objectArray2[i])).toString();
        }
        String[] stringArray = new String[]{"Index", "Gene Set", "Lower-pValues (Under-Enriched)", "Upper-pValues (Over-Enriched)"};
        GSEATableViewer gSEATableViewer = new GSEATableViewer(stringArray, objectArray, defaultMutableTreeNode, gSEAExperiment);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Included Gene Sets", (IViewer)gSEATableViewer, (Object)new Integer(0))));
        Vector vector = algorithmData.getVector("excluded-gene-sets");
        Object[][] objectArray3 = new String[vector.size()][1];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray3[i][0] = (String)vector.get(i);
        }
        String[] stringArray2 = new String[]{"Excluded Gene Sets"};
        gSEATableViewer = new GSEATableViewer(stringArray2, objectArray3);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Excluded Gene Sets", (IViewer)gSEATableViewer, (Object)new Integer(0))));
        String[] stringArray3 = new String[this.max_columns + 1];
        stringArray3[0] = "Gene";
        for (n = 0; n < this.max_columns; ++n) {
            stringArray3[n + 1] = "Probes";
        }
        for (n = 0; n < this.geneToProbeMapping.length; ++n) {
            for (int i = 0; i < this.geneToProbeMapping[n].length; ++i) {
                if (this.geneToProbeMapping[n][i] != null && !this.geneToProbeMapping[n][i].equals("null")) continue;
                this.geneToProbeMapping[n][i] = "";
            }
        }
        gSEATableViewer = new GSEATableViewer(stringArray3, this.geneToProbeMapping);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new LeafInfo("Probe to Gene Mapping", (IViewer)gSEATableViewer, (Object)new Integer(0))));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public String checkFileNameExtension(String string) {
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        return string2;
    }

    public static void main(String[] stringArray) {
    }

    private class Listener
    extends DialogListener
    implements AlgorithmListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                GSEAGUI.this.stop = true;
                if (GSEAGUI.this.gsea != null) {
                    GSEAGUI.this.gsea.abort();
                }
                GSEAGUI.this.logger.dispose();
            }
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GSEAGUI.this.gsea.abort();
        }
    }
}

